'*************************************************************************************************
'
'     Author: Charles Williams CIS:100334,677
'
'     Created: 20/01/96
'
'     Revised:
'
'     Description of Module: COLOUR.BAS will convert all the controls on your
'     Form to the current Windows colour scheme. To use it, simply make the
'     following call from the Form_Load procedure: Form_Colour Me
'
'     Syntax: Form_Colour Form-name
'
'*************************************************************************************************

Declare Function GetSysColor Lib "User" (ByVal nIndex%) As Long

Global Const COLOR_ACTIVEBORDER = 10        'Active window border.
Global Const COLOR_ACTIVECAPTION = 2        'Active window title.
Global Const COLOR_APPWORKSPACE = 12        'Background color of multiple document interface (MDI) applications.
Global Const COLOR_BACKGROUND = 1           'Desktop.
Global Const COLOR_BTNFACE = 15             'Face shading on push buttons.
Global Const COLOR_BTNHIGHLIGHT = 20        'Selected button in a control.
Global Const COLOR_BTNSHADOW = 16           'Edge shading on push buttons.
Global Const COLOR_BTNTEXT = 18             'Text on push buttons.
Global Const COLOR_CAPTIONTEXT = 9          'Text in title bar, size button, scroll-bar arrow button.
Global Const COLOR_GRAYTEXT = 17            'Grayed (dimmed) text. This color is zero if the current display driver does not support a solid gray color.
Global Const COLOR_HIGHLIGHT = 13           'Background of selected item in a control.
Global Const COLOR_HIGHLIGHTTEXT = 14       'Text of selected item in a control.
Global Const COLOR_INACTIVEBORDER = 11      'Inactive window border.
Global Const COLOR_INACTIVECAPTION = 3      'Inactive window title.
Global Const COLOR_INACTIVECAPTIONTEXT = 19 'Color of text in an inactive title.
Global Const COLOR_MENU = 4                 'Menu background.
Global Const COLOR_MENUTEXT = 7             'Text in menus.
Global Const COLOR_SCROLLBAR = 0            'Scroll-bar gray area.
Global Const COLOR_WINDOW = 5               'Window background.
Global Const COLOR_WINDOWFRAME = 6          'Window frame.
Global Const COLOR_WINDOWTEXT = 8           'Text in windows.

Sub Colour_CheckBox (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_ComboBox (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_CommandButton (Ctrl As Control)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_Control (Ctrl As Control)
    If TypeOf Ctrl Is CheckBox Then
        Colour_CheckBox Ctrl
    ElseIf TypeOf Ctrl Is ComboBox Then
        Colour_ComboBox Ctrl
    ElseIf TypeOf Ctrl Is CommandButton Then
        Colour_CommandButton Ctrl
    ElseIf TypeOf Ctrl Is Data Then
        Colour_Data Ctrl
    ElseIf TypeOf Ctrl Is DirListBox Then
        Colour_DirListBox Ctrl
    ElseIf TypeOf Ctrl Is DriveListBox Then
        Colour_DriveListBox Ctrl
    ElseIf TypeOf Ctrl Is FileListBox Then
        Colour_FileListBox Ctrl
    ElseIf TypeOf Ctrl Is Frame Then
        Colour_Frame Ctrl
    ElseIf TypeOf Ctrl Is Label Then
        Colour_Label Ctrl
    ElseIf TypeOf Ctrl Is Line Then
        Colour_Line Ctrl
    ElseIf TypeOf Ctrl Is ListBox Then
        Colour_ListBox Ctrl
    ElseIf TypeOf Ctrl Is OptionButton Then
        Colour_OptionButton Ctrl
    ElseIf TypeOf Ctrl Is PictureBox Then
        Colour_PictureBox Ctrl
    ElseIf TypeOf Ctrl Is Shape Then
        Colour_Shape Ctrl
    'ElseIf TypeOf Ctrl Is SSCheck Then
        'Colour_SSCheck Ctrl
    'ElseIf TypeOf Ctrl Is SSCommand Then
        'Colour_SSCommand Ctrl
    'ElseIf TypeOf Ctrl Is SSFrame Then
        'Colour_SSFrame Ctrl
    'ElseIf TypeOf Ctrl Is SSRibbon Then
        'Colour_SSRibbon Ctrl
    'ElseIf TypeOf Ctrl Is SSOption Then
        'Colour_SSOption Ctrl
    'ElseIf TypeOf Ctrl Is SSPanel Then
        'Colour_SSPanel Ctrl
    ElseIf TypeOf Ctrl Is TextBox Then
        Colour_TextBox Ctrl
    'ElseIf Add more controls in the list if needed...
    End If
    'Colour Form...
    If TypeOf Ctrl.Parent Is Form Then
        Colour_Form Ctrl.Parent
    End If
End Sub

Sub Colour_Data (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_CAPTIONTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_ACTIVECAPTION)
End Sub

Sub Colour_DirListBox (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_DriveListBox (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_FileListBox (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_Form (Ctrl As Form)
    Ctrl.FillColor = GetSysColor(COLOR_CAPTIONTEXT)
'    Ctrl.ForeColor = getsyscolor(COLOR_WINDOWTEXT)
'    Ctrl.BackColor = getsyscolor(COLOR_WINDOW)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_Frame (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_Label (Ctrl As Control)
'    Ctrl.ForeColor = getsyscolor(COLOR_WINDOWTEXT)
'    Ctrl.BackColor = getsyscolor(COLOR_WINDOW)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_Line (Ctrl As Control)
'    Alter this for your own needs...
'    Ctrl.BorderColor = GetSysColor(COLOR_ACTIVEBORDER)
End Sub

Sub Colour_ListBox (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_OptionButton (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_PictureBox (Ctrl As Control)
    Ctrl.FillColor = GetSysColor(COLOR_CAPTIONTEXT)
'    Ctrl.ForeColor = getsyscolor(COLOR_WINDOWTEXT)
'    Ctrl.BackColor = getsyscolor(COLOR_WINDOW)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_Shape (Ctrl As Control)
    Ctrl.FillColor = GetSysColor(COLOR_CAPTIONTEXT)
    Ctrl.BorderColor = GetSysColor(COLOR_BTNSHADOW)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_SSCheck (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
End Sub

Sub Colour_SSCommand (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
End Sub

Sub Colour_SSFrame (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    If GetSysColor(COLOR_BTNSHADOW) = &H808080 Then
        'Ctrl.ShadowColor = 0 'Dark Grey
    Else
        'Ctrl.ShadowColor = 1 'Black
    End If
End Sub

Sub Colour_SSOption (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
End Sub

Sub Colour_SSPanel (Ctrl As Control)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    'Ctrl.FloodColor = GetSysColor(COLOR_ACTIVECAPTION)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
    If GetSysColor(COLOR_BTNSHADOW) = &H808080 Then
        'Ctrl.ShadowColor = 0 'Dark Grey
    Else
        'Ctrl.ShadowColor = 1 'Black
    End If
End Sub

Sub Colour_SSRibbon (Ctrl As Control)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Colour_TextBox (Ctrl As Control)
'    Ctrl.ForeColor = getsyscolor(COLOR_WINDOWTEXT)
'    Ctrl.BackColor = getsyscolor(COLOR_WINDOW)
    Ctrl.ForeColor = GetSysColor(COLOR_BTNTEXT)
    Ctrl.BackColor = GetSysColor(COLOR_BTNFACE)
End Sub

Sub Form_Colour (Frm As Form)
    For i = 0 To (Frm.Controls.Count - 1)
        Colour_Control Frm.Controls(i)
    Next
End Sub

