<%@ LANGUAGE="VBSCRIPT" %>

<% 
'--- Module: MFORMRESPDB.ASP
'---
'--- Intermediate file upload form processing. The sample uploads to a database.
'---
'--- Items of Note:
'--- 1) Instead of using Response.Form, we use upl.Form, which behaves identically
'--- 2) In the simple example, we did not have to refer to particular form element
'---    when referencing the uploaded file. Here, because there are multiple form
'---    elements, it is recommended that the form element containing the file be
'---    explicitly referenced, i.e.
'---
'---    Simple example:       upl.SaveAs "myfile.tst"
'---    Intermediate example: upl.Form("FILE1").SaveAs "myfile.tst"
'---
'--- The simple form will still work, but will default to the first TYPE="FILE"
'--- element on the form. When using multiple form elements, it is better to
'--- be explicit just in case you eventually add multiple TYPE="FILE" tags. 
'--- See the SA-FileUp documentation for more information.
'---
'--- Copyright (c) 1997, Software Artisans, Inc.
'--- Mail: info@softartisans.com   http://www.softartisans.com
%>

<HTML>
<HEAD>
<META HTTP-EQUIV="Content-Type" content="text/html; charset=iso-8859-1">
<TITLE>Intermediate File Upload Results</TITLE>
</HEAD>
<BODY BGCOLOR="#ffffff">
<%
'---
'--- Instanciate SA-FileUp
'---
Set upl = Server.CreateObject("SoftArtisans.FileUp")
'---
'--- Set the default path to store uploaded files. This step is not
'--- strictly necessary, but performance is better if you specify it.
'---
upl.Path = "c:\temp"
%>
<%  If Not IsObject(upl.Form("FILE1")) Then %>
The form contains a tag named "FILE1" which is not of TYPE="FILE". Please
check your form definition.
<% elseif upl.Form("FILE1").IsEmpty Then %>
<%
'--- 
'--- Even if the filename field is empty, all of the other form elements are
'--- available. 
'---
%>
The file that you uploaded was empty. Most likely, you did not specify a valid
filename to your browser or you left the filename field blank. Please try again.
<FONT SIZE="-1"><CENTER>
<TABLE WIDTH="80%" BORDER="1" CELLSPACING="2" CELLPADDING="0" HEIGHT="206">
<TR>
<TH COLSPAN="2"><P><CENTER>Contents of The Form</CENTER></TH></TR>
<TR>
<TH WIDTH="30%"><P><CENTER>Tag Name</CENTER></TH>
<TH WIDTH="70%"><P><CENTER>Value</CENTER></TH></TR>
<% 
'---
'--- Iterate through all contents of the form. Only non-empty elements will
'--- be displayed. The default property of a file element is the name on the
'--- server (.ServerName property). When the file field is empty, a temporary
'--- file is nevertheless created. This cache file is automatically deleted
'--- at the end of the page.
'---
for each x in upl.form
		response.write("<TR><TD ALIGN=""RIGHT"">" & x & "</TD><TD>'" & upl.form(x) & "'</TD></TR>")
next
%>
</TABLE>
</CENTER></FONT>
<% ElseIf upl.Form("FILE1").ContentDisposition <> "form-data" Then %>
Your upload did not succeed, most likely because your browser
does not support Upload via this mechanism.
<br>
For Internet Explorer Users:
<UL>
<LI>For Windows 95 or Windows NT 4.0:
	<UL>
	<LI><A HREF="http://www.microsoft.com/ie/">Download</A> V3.02 or later of Internet Explorer
	<LI><A HREF="http://www.microsoft.com/ie/download">Download</A> the File Upload Add-on
	<LI>For further information, See Knowledge Base Article <A HREF="http://www.microsoft.com/kb/articles/Q165/2/87.htm">Q165287</A>
	</UL>
<LI>For Windows 3.1, WFW 3.11 (Windows 16-bit), or Windows NT 3.51:
	<UL><A HREF="http://www.microsoft.com/ie/">Download</A> V3.02A or later of Internet Explorer for 16-bit Windows
	</UL>
</UL>
For Netscape Users:
<UL>
<LI><A HREF="http://home.netscape.com">Download</A> a version of Netscape Navigator or Communicator of 2.x or later
</UL>
For users of other browsers:
<UL>
<LI>Your browser must support a standard called RFC 1867. Please check with your browser vendor for
support of this standard.
</UL>
<%Else %>
<P>The file was successfully transmitted by the user.</P>
<% 
set rsBlob = Server.CreateObject("adodb.recordset")
'Open Recorsets
rsBlob.Open "IntermediateBlobTable", "AccessUpload", 2, 3
'--- 
'--- For SQL Server Users, use the following line to open the recordset
'--- Make sure you replace:
'---	<myserver> by your SQL Server name
'---
'--- rsBlob.Open "IntermediateBlobTable", "driver={SQL Server};server=<myserver>;uid=sa;pwd=;database=SQLServerUpload", 2, 3

'Add new record and update
rsBlob.AddNew
rsBlob.Fields("author")  = upl.form("AUTHOR")
rsBlob.Fields("descrip") = upl.form("DESCRIP")
upl.form("FILE1").SaveAsBlob rsBlob.Fields("filecol")


rsBlob.Update
rsBlob.Close
Set rsBlob = Nothing 
%>
<P>&nbsp;</P>
<FONT SIZE="-1"><CENTER>
<TABLE WIDTH="80%" BORDER="1" CELLSPACING="2" CELLPADDING="0" HEIGHT="206">
<TR>
<TH COLSPAN="2"><P><CENTER>Contents of The Form</CENTER></TH></TR>
<TR>
<TH WIDTH="30%"><P><CENTER>Tag Name</CENTER></TH>
<TH WIDTH="70%"><P><CENTER>Value</CENTER></TH></TR>
<% 
'---
'--- Iterate through all contents of the form. Only non-empty elements will
'--- be displayed. The default property of a file element is the name on the
'--- server (.ServerName property).
'---
for each x in upl.form
		response.write("<TR><TD ALIGN=""RIGHT"">" & x & "</TD><TD>'" & upl.form(x) & "'</TD></TR>")
next
%>
</TABLE>
<P>&nbsp;</P>
<TABLE WIDTH="80%" BORDER="1" CELLSPACING="2" CELLPADDING="0" HEIGHT="206">
<TR>
<TH COLSPAN="2"><P><CENTER>Information About The Uploaded File Name "FILE1"</CENTER></TH></TR>
<TR>
<TD WIDTH="30%" HEIGHT="27" ALIGN="RIGHT" VALIGN="TOP">&nbsp;User's filename</TD>
<TD WIDTH="70%"><%=upl.Form("FILE1").UserFilename%>&nbsp;</TD></TR>
<TR>
<TD WIDTH="30%" HEIGHT="27" ALIGN="RIGHT" VALIGN="TOP">Size in bytes&nbsp;</TD>
<TD WIDTH="70%"><%=upl.Form("FILE1").TotalBytes%>&nbsp;</TD></TR>
<TR>
<TD WIDTH="30%" HEIGHT="27" ALIGN="RIGHT" VALIGN="TOP">Content Type</TD>
<TD WIDTH="70%"><%=upl.Form("FILE1").ContentType%>&nbsp;</TD></TR>
<TR>
<TD WIDTH="30%" HEIGHT="27" ALIGN="RIGHT" VALIGN="TOP">Content Disposition</TD>
<TD WIDTH="70%"><%=upl.Form("FILE1").ContentDisposition%>&nbsp;</TD></TR>
<TR>
<TD WIDTH="30%" HEIGHT="27" ALIGN="RIGHT" VALIGN="TOP">MIME Version</TD>
<TD WIDTH="70%"><%=upl.Form("FILE1").MimeVersion%>&nbsp;</TD></TR>
<TR>
<TD WIDTH="30%" HEIGHT="27" ALIGN="RIGHT" VALIGN="TOP">Content Transfer Encoding</TD>
<TD WIDTH="70%"><%=upl.Form("FILE1").ContentTransferEncoding%>&nbsp;</TD></TR>
</TABLE>
</FONT></CENTER>
<% End If %>
</BODY>
</HTML>
