<%@ LANGUAGE="VBSCRIPT" %>

<% 
'--- Module: FORMRESP2.ASP
'---
'--- Upload Two Files form processing. 
'---
'--- Items of Note:
'--- 1) Instead of using Response.Form, we use upl.Form, which behaves identically
'--- 2) In the simple example, we did not have to refer to particular form element
'---    when referencing the uploaded file. Here, because there are multiple files
'---    elements, it is recommended that the form element containing the file be
'---    explicitly referenced, i.e.
'---
'---    Simple example:    upl.SaveAs "myfile.tst"
'---    Two Files example: upl.Form("FILE1").SaveAs "myfile.tst"
'---
'--- The simple form will still work, but will default to the first TYPE="FILE"
'--- element on the form. When using multiple file/form elements, it is better to
'--- be explicit.
'--- See the SA-FileUp documentation for more information.
'---
'--- Copyright (c) 1997, Software Artisans, Inc.
'--- Mail: info@softartisans.com   http://www.softartisans.com
%>

<HTML>
<HEAD>
<META HTTP-EQUIV="Content-Type" content="text/html; charset=iso-8859-1">
<TITLE>Two File Upload Results</TITLE>
</HEAD>
<BODY BGCOLOR="#ffffff">
<%
'---
'--- Instanciate SA-FileUp
'---
Set upl = Server.CreateObject("SoftArtisans.FileUp")
'---
'--- Set the default path to store uploaded files. This step is not
'--- strictly necessary, but performance is better if you specify it.
'---
upl.Path = "c:\temp"
%>
<FONT SIZE="-1"><CENTER>
<TABLE WIDTH="95%" BORDER="1" CELLSPACING="2" CELLPADDING="0" HEIGHT="206">
<TR>
<TH COLSPAN="2"><P><CENTER>Contents of The Form</CENTER></TH></TR>
<TR>
<TH WIDTH="20%"><P><CENTER>Tag Name</CENTER></TH>
<TH WIDTH="80%"><P><CENTER>Value</CENTER></TH></TR>
<% 
'---
'--- Iterate through all contents of the form. Only non-empty elements will
'--- be displayed. The default property of a file element is the name on the
'--- server (.ServerName property). When the file field is empty, a temporary
'--- file is nevertheless created. This cache file is automatically deleted
'--- at the end of the page.
'---
for each item in upl.form
		response.write("<TR><TD ALIGN=""RIGHT"">" & item & "</TD>")
		if Not IsObject(upl.form(item)) Then
			'---
			'--- This is a regular (non-file) form element. Show its value
			'---
			response.write("<TD>" & upl.form(item) & "</TD></TR>")
		Else
		'--- 
		'--- This is a form element. Show all the details
		'---
%>
<TD>
<%
'---
'--- Set the filename. You can put any valid filename here.
'--- In this case, we are using the form tag name to generate the filename
'---
filename = item & ".upl"
'---
'--- Save the file now
'---
upl.Form(item).SaveAs filename %>
<TABLE WIDTH="100%" BORDER="1" CELLSPACING="2" CELLPADDING="0" HEIGHT="206">
	<TR>
	<TH COLSPAN="2"><P><CENTER>File Details</CENTER></TH></TR>
	<TR>
	<TH WIDTH="35%"><P><CENTER>Item</CENTER></TH>
	<TH WIDTH="65%"><P><CENTER>Value</CENTER></TH></TR>
	<TR>
	<TD WIDTH="35%" ALIGN="RIGHT" VALIGN="TOP">&nbsp;Server filename</TD>
	<TD WIDTH="65%"><%=upl.Form(item).ServerName%>&nbsp;</TD></TR>
	<TR>
	<TD WIDTH="35%" ALIGN="RIGHT" VALIGN="TOP">&nbsp;User's filename</TD>
	<TD WIDTH="65%"><%=upl.Form(item).UserFilename%>&nbsp;</TD></TR>
	<TR>
	<TD WIDTH="35%" ALIGN="RIGHT" VALIGN="TOP">Size in bytes&nbsp;</TD>
	<TD WIDTH="65%"><%=upl.Form(item).TotalBytes%>&nbsp;</TD></TR>
	<TR>
	<TD WIDTH="35%" ALIGN="RIGHT" VALIGN="TOP">Content Type</TD>
	<TD WIDTH="65%"><%=upl.Form(item).ContentType%>&nbsp;</TD></TR>
	<TR>
	<TD WIDTH="35%" ALIGN="RIGHT" VALIGN="TOP">Content Disposition</TD>
	<TD WIDTH="65%"><%=upl.Form(item).ContentDisposition%>&nbsp;</TD></TR>
	<TR>
	<TD WIDTH="35%" ALIGN="RIGHT" VALIGN="TOP">MIME Version</TD>
	<TD WIDTH="65%"><%=upl.Form(item).MimeVersion%>&nbsp;</TD></TR>
	<TR>
	<TD WIDTH="35%" ALIGN="RIGHT" VALIGN="TOP">Content Transfer Encoding</TD>
	<TD WIDTH="65%"><%=upl.Form(item).ContentTransferEncoding%>&nbsp;</TD></TR>
</TABLE>
</TD></TR>
<% 
	End If
next %>
</TABLE>
</FONT></CENTER>
</BODY>
</HTML>
