Attribute VB_Name = "DBCreate"
' Database Creation Procedures
' 1995-1998 Tuomas Salste (vbshop@aivosto.com)
' Include this module in your project if needed

Option Explicit
Public Const dbCounter = -10
Public Const dbFixedText = -11
Public Const idxUnique = True
Public Const idxNonUnique = False
Public Const idxPrimary = True
Public Const idxNonPrimary = False


' Appends a new field 'FieldName' to a TableDef
Sub AddField(td As TableDef, ByVal FieldName As String, ByVal FieldType As Integer, ByVal Size As Integer, Optional ByVal Required As Variant, Optional ByVal AllowZeroLength As Variant, Optional ByVal DefaultValue As Variant, Optional ByVal ValidationRule As Variant, Optional ByVal ValidationText As Variant)

Dim fl As New Field
fl.Name = FieldName
If FieldType = dbCounter Then
    fl.Type = dbLong
    fl.Attributes = fl.Attributes Or dbAutoIncrField
ElseIf FieldType = dbFixedText Then
    fl.Type = dbText
    fl.Attributes = fl.Attributes Or dbFixedField
Else
    fl.Type = FieldType
End If

' AllowZeroLength
' Text and memo fields can allow zero length strings ("")
If FieldType = dbText Or FieldType = dbMemo Or FieldType = dbFixedText Then
    If Not IsMissing(AllowZeroLength) Then
        fl.AllowZeroLength = CBool(AllowZeroLength)
    End If
End If

' Required
If Not IsMissing(Required) Then
    fl.Required = CBool(Required)
End If

' DefaultValue
If Not IsMissing(DefaultValue) Then
    fl.DefaultValue = DefaultValue
End If

' Validation
If Not IsMissing(ValidationRule) Then
    fl.ValidationRule = ValidationRule
End If
If Not IsMissing(ValidationText) Then
    fl.ValidationText = ValidationText
End If

If FieldType = dbText Then fl.Size = Size
td.Fields.Append fl

End Sub


' Appends a new index 'IndexName' to a TableDef
Sub AddIndex(td As TableDef, ByVal IndexName As String, ByVal IndexFields As String, ByVal IndexPrimary As Integer, ByVal IndexUnique As Integer)

Dim idx As New Index
idx.Name = IndexName
idx.Fields = IndexFields
idx.Primary = IndexPrimary
idx.Unique = IndexUnique
td.Indexes.Append idx

End Sub

' Appends a QueryDef 'QueryName' to a database
Sub AddQueryDef(db As Database, ByVal QueryName As String, ByVal SQL As String)

Dim qd As QueryDef
On Error Resume Next
Set qd = db.CreateQueryDef(QueryName, SQL)

End Sub

