UNIT Unit1;


INTERFACE


USES
	Windows, SysUtils, Classes, Controls, Forms,	Dialogs, StdCtrls,
	ComCtrls, FileCtrl, Graphics, Buttons, ExtCtrls, Menus, AwkGbls,
  AwkMain, AwkTypes, Err_Msgs, Zipper, ZipSrch, TrboSrch;


TYPE
	TfrmAddFiles = CLASS( TForm )
		OpenDialog1		: TOpenDialog;
    	lstFileSpec		: TListBox;

     (* Buttons *)
    	Button1			: TButton;
		btnAddDir		: TButton;
		btnPassword		: TButton;
     btnOK				: TBitBtn;
    	btnClose			: TBitBtn;
    	btnSelectDir	: TBitBtn;
    	BitBtn1			: TBitBtn;

     (* Edit controls *)
		edtFileSpec		: TEdit;
		edtDefaultDir	: TEdit;
    	edtDirFileSpec	: TEdit;

     (* Labels & misc *)
		Label1			: TLabel;
    	Label2			: TLabel;
		Panel1			: TPanel;

     (* Switch radio buttons (members	stored in items property *)
		rgSwitch			: TRadioGroup;

     (* Directory selection group *)
		GroupBox1		: TGroupBox;
		ckbRecurseDirs	: TCheckBox;
		ckbStoreDirs	: TCheckBox;

     (* SkipFiles group *)
    	GroupBox2		: TGroupBox;
    	ckbArchive		: TCheckBox;
    	ckbReadOnly		: TCheckBox;
    	ckbHidden		: TCheckBox;
    	ckbSysFile		: TCheckBox;
    	ckbVolumeID		: TCheckBox;

     (* Menu *)
    	MainMenu1		: TMainMenu;
    	File1				: TMenuItem;
    	SelectFiles1	: TMenuItem;
    	Close1			: TMenuItem;

     (* Popup Menu *)
    	PopupMenu1		: TPopupMenu;
    	RemoveSelected1: TMenuItem;
    	RemoveAll1		: TMenuItem;

     (* Compressor selection *)
    	Panel2			: TPanel;
     rbBh				: TRadioButton;
     rbArj				: TRadioButton;
     rbGZip			: TRadioButton;
     rbLha				: TRadioButton;
     rbZip				: TRadioButton;
     rbTar				: TRadioButton;
     rbZoo				: TRadioButton;
    rbCab: TRadioButton;
    ComboBox1: TComboBox;
    Label3: TLabel;

		PROCEDURE FormActivate( Sender: TObject );
    	PROCEDURE FormCreate(Sender: TObject);
		PROCEDURE rgSwitchClick( Sender: TObject );

		PROCEDURE InitializeNewCompressComponent;
		PROCEDURE SetSkipFilesState;
		PROCEDURE SetCompressMethodState;

		PROCEDURE ckbRecurseDirsClick( Sender: TObject );
		PROCEDURE ckbStoreDirsClick( Sender: TObject );

		PROCEDURE btnOKClick( Sender: TObject );
		PROCEDURE btnAddFilesClick( Sender: TObject );
		PROCEDURE btnAddDirClick( Sender: TObject );
		PROCEDURE btnCloseClick( Sender: TObject );
		PROCEDURE btnPasswordClick( Sender: TObject );
		PROCEDURE btnSelectDirClick( Sender: TObject );

    	PROCEDURE PopupMenu1Popup( Sender: TObject );
    	PROCEDURE MethodButtonsClick(Sender: TObject);
    	PROCEDURE DefineCompressorClick(Sender: TObject);

    	PROCEDURE edtDefaultDirKeyPress( Sender: TObject; VAR Key: CHAR );
		PROCEDURE edtFileSpecKeyPress( Sender: TObject; VAR Key: CHAR );
    	PROCEDURE edtDirFileSpecExit(Sender: TObject);
    	PROCEDURE edtFileSpecEnter(Sender: TObject);
    	PROCEDURE ckbArchiveClick(Sender: TObject);
    	PROCEDURE ckbReadOnlyClick(Sender: TObject);
    	PROCEDURE ckbHiddenClick(Sender: TObject);
    	PROCEDURE ckbSysFileClick(Sender: TObject);
    	PROCEDURE ckbVolumeIDClick(Sender: TObject);
    	PROCEDURE Button1MouseDown(Sender: TObject; Button: TMouseButton;
      	Shift: TShiftState; X, Y: INTEGER);
    	PROCEDURE ComboBox1Change(Sender: TObject);
    	PROCEDURE lstFileSpecClick(Sender: TObject);
	PRIVATE
		FUNCTION  AddToList: BOOLEAN;
	PUBLIC
	END;





VAR
	frmAddFiles	: TfrmAddFiles;
  Loading		: BOOLEAN = False;



IMPLEMENTATION



USES
	Main;


{$R *.DFM}


{-------------------------------------------------------------}

										(* assign the ItemIndex of rgSwitch
											( option buttons ) to the Switch property *)

PROCEDURE TfrmAddFiles.rgSwitchClick( Sender: TObject );
BEGIN
	CompressComponent.Switch := TSwitch( rgSwitch.ItemIndex );
END;
{-------------------------------------------------------------}

										(* assign the checked value of the CheckBox
											to RecurseDirs property *)
PROCEDURE TfrmAddFiles.ckbRecurseDirsClick( Sender: TObject );
BEGIN
	CompressComponent.RecurseDirs := ckbRecurseDirs.Checked;
END;
{-------------------------------------------------------------}

										(* assign the checked value of the CheckBox
											to StoreDirs property *)
PROCEDURE TfrmAddFiles.ckbStoreDirsClick( Sender: TObject );
BEGIN
	CompressComponent.StoreDirs := ckbStoreDirs.Checked;
END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.btnOKClick( Sender: TObject );
BEGIN

	IF edtFileSpec.Text <> '' THEN
  	IF MessageDlg( 'Add file: ' + edtFileSpec.Text,
     		mtConfirmation,
           [ mbYes, mbNo ],
           0 ) = mrYes THEN

     	IF lstFileSpec.Items.Indexof( edtFileSpec.Text ) = -1 THEN
        BEGIN
  			lstFileSpec.Items.Insert( 0, edtFileSpec.Text );
        	lstFileSpec.ItemIndex := 0;
        END;


	edtFileSpec.Text := '';


	IF lstFileSpec.Items.Count > 0 THEN
	BEGIN

    CompressComponent.FileSpec.Assign( lstFileSpec.Items );
    ModalResult := mrOK;

  END;

END;
{-------------------------------------------------------------}

										(* Add Files Button *)
PROCEDURE TfrmAddFiles.btnAddFilesClick( Sender: TObject );

VAR
	i: INTEGER;

BEGIN

  IF edtFileSpec.Text <> '' THEN
		OpenDialog1.FileName := ExtractFilename( edtFileSpec.Text )
  ELSE
		OpenDialog1.FileName := '*.*';

	OpenDialog1.Title := 'Select file( s ) to add ( Ctrl+Click or Shift+Click )';

	IF OpenDialog1.Execute THEN
		FOR i := 0 to OpenDialog1.Files.Count - 1 DO
     	IF lstFileSpec.Items.Indexof( OpenDialog1.Files[i] ) = -1 THEN
        BEGIN
        	lstFileSpec.Items.Insert( 0, OpenDialog1.Files[i] );
        	lstFileSpec.ItemIndex := 0;
        END;

  IF lstFileSpec.Items.Count > 0 THEN
  	btnOK.Enabled := TRUE;

  edtFileSpec.Text := '';   
  edtFileSpec.Setfocus;

END;
{-------------------------------------------------------------}

										(* Add Directory Button *)
PROCEDURE TfrmAddFiles.btnAddDirClick( Sender: TObject );
VAR
	Dir, Spec: STRING;
BEGIN

  Dir := edtDefaultDir.Text;

	//IF SelectDirectory( Dir, [sdAllowCreate, sdPerformCreate, sdPrompt], -1 ) THEN
	IF SelectDirectory( Dir, [sdPrompt], -1 ) THEN
  BEGIN

		SetCurrentDir( Dir );
     edtDefaultDir.Text := Dir;

     Dir := AppendDirTail( Dir );
     Spec := Dir + ExtractFilename( edtDirFileSpec.Text );

     IF lstFileSpec.Items.Indexof( Spec ) = -1 THEN
     BEGIN
     	lstFileSpec.Items.Insert( 0, Spec );
        lstFileSpec.ItemIndex := 0;
  		btnOK.Enabled := TRUE;
     END;

     edtFileSpec.Setfocus;

  END;

END;
{-------------------------------------------------------------}

										(* Close Button *)
PROCEDURE TfrmAddFiles.btnCloseClick( Sender: TObject );
BEGIN
	Close;
	ModalResult := mrCancel;
END;
{-------------------------------------------------------------}

										(* Password Button *)
PROCEDURE TfrmAddFiles.btnPasswordClick( Sender: TObject );
VAR
  PW			,
	FirstPW	: STRING;
  Prompt	,
  Caption	: STRING;
  i		 	: INTEGER;
  Protect	: BOOLEAN;
BEGIN

	Protect := TRUE;
  									(* Get password input twice.  Second time is
                             	for verification *)
	FOR i := 1 TO 2 DO
  BEGIN

     IF Protect THEN
     BEGIN

        CASE i OF
           1:	BEGIN
                 Caption := 'Security Encryption...';
                 Prompt  := 'Enter Password:';
              END;
           2:	BEGIN
                 FirstPW := PW;
                 Caption := 'Verify Password...';
                 Prompt  := 'Re-enter Password:';
              END;
        END;

        PW := '';
        WHILE ( PW = '' ) DO
           IF NOT InputQuery( Caption, Prompt, PW ) THEN
           BEGIN
              Protect := FALSE;		(* Cancel selected *)
              Break;
           END;
     END;
  END;


  IF Protect THEN
     IF CompareStr( FirstPW, PW ) <> 0 THEN
     BEGIN
        MessageDlg( 'Password verification failed.'#13#13 +
        				'Please retry...', mtInformation, [ mbOK ], 0 );
        Protect := False;
     END;


	IF Protect THEN
  BEGIN
     CompressComponent.Password := FirstPW;
     btnPassword.Caption := 'PROTECTED';
  END ELSE BEGIN
     CompressComponent.Password := '';
     btnPassword.Caption := '&Password';
  END;

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.InitializeNewCompressComponent;
BEGIN

	IF Loading THEN Exit;

  (* Check/Uncheck SkipFiles *)
	SetSkipFilesState;

  (* Check/Uncheck compression active method *)
  SetCompressMethodState;

  (* Set check state of properties RecurseDirs & StoreDirs *)
	ckbRecurseDirs.Checked 	:= CompressComponent.RecurseDirs;
	ckbStoreDirs.Checked 	:= CompressComponent.StoreDirs;

  (* Set index of active switch *)
	IF CompressComponent.Switch > swMove THEN
		CompressComponent.Switch := swAdd;

	rgSwitch.ItemIndex := Ord( CompressComponent.Switch );

  (* If the active component's DefaultDir is blank, set to current dir *)
	IF ( CompressComponent.DefaultDir = '' ) OR
			( NOT DirectoryExists( CompressComponent.DefaultDir ) ) THEN
		CompressComponent.DefaultDir := GetCurrentDir;

  (* Fill edit control with active components DefaultDir property *)
  edtDefaultDir.Text := CompressComponent.DefaultDir;

  (* Assign ListBox control the active components FileSpec property *)
  lstFileSpec.Items.Assign( CompressComponent.FileSpec );

  (* Disable OK when ListBox is blank *)
  btnOK.Enabled := CompressComponent.FileSpec.Count > 0;

  (* Set focus to edit control FileSpec *)
	edtFileSpec.SetFocus;

  (* If component supports password encryption,
     set buttons enabled property, else disable *)
  WITH CompressComponent DO
  	btnPassword.Enabled := IsPasswordSupported( ArcType );

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.SetSkipFilesState;
BEGIN
  (* Check/uncheck SkipFiles selections *)
  ckbArchive.Checked  := CompressComponent.FileAttribute.ftArchive;
  ckbReadOnly.Checked := CompressComponent.FileAttribute.ftReadOnly;
  ckbHidden.Checked   := CompressComponent.FileAttribute.ftHidden;
  ckbSysFile.Checked  := CompressComponent.FileAttribute.ftSysFile;
  ckbVolumeID.Checked := CompressComponent.FileAttribute.ftVolumeID;
END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.SetCompressMethodState;
BEGIN

  ComboBox1.Clear;
  WITH ComboBox1.Items DO
  BEGIN
     IF ( mtStore 		IN CompressComponent.CompressMethodState ) THEN Add( 'Store' );
     IF ( mtDeflate 	IN CompressComponent.CompressMethodState ) THEN Add( 'Deflate' );
     IF ( mtFuse 		IN CompressComponent.CompressMethodState ) THEN Add( 'Fuse' );
     IF ( mtFrozen 		IN CompressComponent.CompressMethodState ) THEN Add( 'Frozen' );
     IF ( mtGreatest 	IN CompressComponent.CompressMethodState ) THEN Add( 'Greatest' );
     IF ( mtFastest 	IN CompressComponent.CompressMethodState ) THEN Add( 'Fastest' );
     IF ( mtMsZip 		IN CompressComponent.CompressMethodState ) THEN Add( 'MsZip' );
     IF ( mtQuantum		IN CompressComponent.CompressMethodState ) THEN Add( 'Quantum' );
     IF ( mtLzx			IN CompressComponent.CompressMethodState ) THEN Add( 'Lzx' );
	END;

  WITH ComboBox1 DO
     CASE CompressComponent.CompressMethod OF
        mtStore		: ItemIndex := Items.IndexOf( 'Store' );
        mtDeflate	: ItemIndex := Items.IndexOf( 'Deflate' );
        mtFuse		: ItemIndex := Items.IndexOf( 'Fuse' );
        mtFrozen 	: ItemIndex := Items.IndexOf( 'Frozen' );
        mtGreatest 	: ItemIndex := Items.IndexOf( 'Greatest' );
        mtFastest	: ItemIndex := Items.IndexOf( 'Fastest' );
        mtMsZip		: ItemIndex := Items.IndexOf( 'MsZip' );
        mtQuantum	: ItemIndex := Items.IndexOf( 'Quantum' );
        mtLzx			: ItemIndex := Items.IndexOf( 'Lzx' );
     END;

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.FormActivate( Sender: TObject );
VAR
	Ext: STRING;
BEGIN

  lstFileSpec.Clear;
	Caption := frmMain.OpenDialog1.Filename;

	IF ( CompressComponent = NIL ) OR
  		( CompressComponent.ArchiveFile = '' ) THEN
  BEGIN

     (* Enable/disable archive type radio buttons *)
     WITH CompressComponent DO	(* IsArcCompressable *)
     BEGIN
        rbArj.Enabled 	:= IsArcCompressable( atARJ  );
        rbCab.Enabled 	:= IsArcCompressable( atCAB   );
        rbBh.Enabled 	:= IsArcCompressable( atBH   );
        rbGZip.Enabled := IsArcCompressable( atGZIP );
        rbLha.Enabled 	:= IsArcCompressable( atLHA  );
        rbTar.Enabled 	:= IsArcCompressable( atTAR  );
        rbZip.Enabled 	:= IsArcCompressable( atZIP  );
        rbZoo.Enabled 	:= IsArcCompressable( atZOO  );
     END;

     Ext := Uppercase( ExtractFileExt( frmMain.OpenDialog1.Filename ) );

     (* Check file extensions first to associate archive type desired *)
     IF Ext = '.BH' THEN
			DefineCompressorClick( rbBh )
     ELSE IF Ext = '.CAB' THEN
			DefineCompressorClick( rbCab )
     ELSE IF Ext = '.ZIP' THEN
			DefineCompressorClick( rbZip )
     ELSE IF ( Ext = '.LZH' ) OR ( Ext = '.LHA' ) THEN
			DefineCompressorClick( rbLha )
     ELSE IF Ext = '.ZOO' THEN
			DefineCompressorClick( rbZoo )
     ELSE
     								(* Use tag stored in frmMain (default=BH) *)
  		DefineCompressorClick( frmMain );

  END ELSE BEGIN

     (* Since an archive was previously used, enable ONLY that type *)
     rbArj.Enabled 	:= FALSE;
     rbBh.Enabled 	:= FALSE;
     rbCab.Enabled 	:= FALSE;
     rbGZip.Enabled := FALSE;
     rbLha.Enabled 	:= FALSE;
     rbTar.Enabled 	:= FALSE;
     rbZip.Enabled 	:= FALSE;
     rbZoo.Enabled 	:= FALSE;

     								(* If archive has previously been open
     									then ArcType is retained. *)
  	CASE frmMain.ZipTV1.ArcType OF

     	atBH	: 	BEGIN
        				DefineCompressorClick( rbBh );
                    rbBh.Enabled := TRUE;
        			END;

     	atCAB	: 	BEGIN
        				DefineCompressorClick( rbCab );
                    rbCab.Enabled := TRUE;
        			END;

        atZIP	: 	BEGIN
        				DefineCompressorClick( rbZip );
                    rbZip.Enabled := TRUE;
        			END;

        atLHA,
        atLZH	: 	BEGIN
        				DefineCompressorClick( rbLha );
                    rbLha.Enabled := TRUE;
        			END;

        atZOO	: 	BEGIN
        				DefineCompressorClick( rbZoo );
                    rbZoo.Enabled := TRUE;
        			END;
     ELSE
     	EXIT;
     END;

  END;

  edtFileSpec.Text := '*.*';

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.FormCreate(Sender: TObject);
BEGIN
	Loading := True;
END;
{-------------------------------------------------------------}
FUNCTION TfrmAddFiles.AddToList: BOOLEAN;

VAR
	Dir: STRING;

BEGIN

	RESULT := FALSE;

	IF edtFileSpec.Text <> '' THEN
	BEGIN

		Dir := edtDefaultDir.Text;

		IF Pos( '\', edtFileSpec.Text ) = 0 THEN
		BEGIN

			IF NOT DirectoryExists( Dir ) THEN
        BEGIN
        	MessageDlg( Dir + ' does not exist', mtWarning, [ mbOK ], 0 );
           edtDefaultDir.SetFocus;
        	EXIT;
        END;

			IF Pos( ':', edtFileSpec.Text ) > 0 THEN
				edtFileSpec.Text := Copy( edtFileSpec.Text, Pos( ':', edtFileSpec.Text ) + 1, LENGTH( edtFileSpec.Text ) );

			IF Dir[ Length( Dir ) ] = '\' THEN
				SetLength( Dir, Length( Dir ) - 1 );

			IF ( Dir <> '' ) AND
					DirectoryExists( Dir ) THEN
				edtFileSpec.Text := AppendDirTail( Dir ) + edtFileSpec.Text
			ELSE
				edtFileSpec.Text := AppendDirTail( GetCurrentDir ) + edtFileSpec.Text;

		END;

     IF lstFileSpec.Items.Indexof( edtFileSpec.Text ) = -1 THEN
     BEGIN
        lstFileSpec.Items.Insert( 0, edtFileSpec.Text );
        lstFileSpec.ItemIndex := 0;
        btnOK.Enabled := TRUE;
     END;
     edtFileSpec.Text := '';

	END;

	RESULT := TRUE;

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.btnSelectDirClick( Sender: TObject );

VAR
	Dir: STRING;

BEGIN

	SetCurrentDir( CompressComponent.DefaultDir );
	IF SelectDirectory( Dir, [sdAllowCreate, sdPerformCreate, sdPrompt], -1 ) THEN
	BEGIN
		CompressComponent.DefaultDir := Dir;
		SetCurrentDir( Dir );
		edtDefaultDir.Text := CompressComponent.DefaultDir;
	END;

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.edtDefaultDirKeyPress( Sender: TObject; VAR Key: CHAR );
BEGIN
	IF Key = #13 THEN
  	edtFileSpec.Setfocus;
END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.edtFileSpecKeyPress( Sender: TObject; VAR Key: CHAR );
BEGIN
	IF Key = #13 THEN
		IF AddToList THEN
     BEGIN
     	edtFileSpec.Text := '';
			edtFileSpec.Setfocus;
     END;
END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.PopupMenu1Popup( Sender: TObject );

CONST
	REM_SELECTED = 0;
  REM_ALL = 1;

VAR
	i,j: INTEGER;

BEGIN

	IF lstFileSpec.items.Count > 0 THEN

     CASE TMenuItem( Sender ).MenuIndex OF

        REM_SELECTED:
        	BEGIN
              j := 0;
              FOR i := 1 TO lstFileSpec.Items.Count DO
                 IF lstFileSpec.Selected[ j ] THEN
                    lstFileSpec.Items.Delete( j )
                 ELSE
                 	Inc( j );
        	END;

        REM_ALL:
           IF MessageDlg( 'Clear all?',
                             mtConfirmation,
                             [ mbYes, mbNo ],
                             0 ) = mrYes THEN
              lstFileSpec.Clear;


     END;

  btnOK.Enabled := lstFileSpec.Items.Count > 0;
  edtFileSpec.SetFocus;

END;
{-------------------------------------------------------------}
(** Assign the CompressMethod property **)
PROCEDURE TfrmAddFiles.MethodButtonsClick(Sender: TObject);
VAR
	CompressMethodIndex: BYTE;
BEGIN

  CompressMethodIndex := TRadioButton( Sender ).TAG;
  CompressComponent.CompressMethod := TCompressMethod( CompressMethodIndex );

END;
{-------------------------------------------------------------}
(* Assign the variable CompressComponent (type TCompBase) the
   desired compression component dropped on the form

   All radio buttons 'tag' property have a stored value that
   this routine checks to verify which was selected.

   If 'New' is selected from the main form (frmMain) retrieve
   the previous archive type used from the stored value in
   frmMain's tag property... else retreive the value of the
   tag property from the radio button selected on this form.

   After radio button is selected, store the selected buttons
   tag value in frmMain.tag property so the last archive type
   used can be set automatically when this form is once again
   activated.

   *)
PROCEDURE TfrmAddFiles.DefineCompressorClick(Sender: TObject);

VAR
	Tag: INTEGER;

CONST
	cArj 		 = 1;
	cBlakHole = 2;
  cCab		 = 3;
  cGZip 	 = 4;
  cLha		 = 5;
  cTar		 = 6;
  cZip      = 7;
  cZoo      = 8;

BEGIN

  IF ( Sender IS TRadioButton ) THEN

  										(* Clicked a radio button *)
		Tag := TRadioButton( Sender ).Tag

  ELSE
  										(* Called from FormActivate event *)
  	Tag := TForm( Sender ).Tag;



  CASE Tag OF
     //cArj 		:;		(* Component to be added in future versions *)
     cBlakHole: 	BEGIN
     					CompressComponent := frmMain.BlakHole1;
                    rbBh.Checked := TRUE;
                 END;
     cCab		:	BEGIN
     					CompressComponent := frmMain.MakeCab1;
                    rbCab.Checked := True;
     				END;
     //cGZip 	:;			(* Component to be added in future versions *)
     cLha		:			(* Component to be added in future versions *)
     				BEGIN
     					CompressComponent := frmMain.Lha1;
                    rbLha.Checked := TRUE;
                 END;
     //cTar		:;		(* Component to be added in future versions *)
     cZip     : 	BEGIN
     					CompressComponent := frmMain.Zip1;
                    rbZip.Checked := TRUE;
                 END;
     //cZoo     :;		(* Component to be added in future versions *)
  ELSE

  	(* Default *)
     CompressComponent := frmMain.BlakHole1;
     rbBh.Checked := TRUE;
     Tag := rbBh.Tag;

  END;

  (* Store the tag in frmMain *)
  frmMain.Tag := Tag;

  (* Reset form controls to match compression components properties *)
	InitializeNewCompressComponent;

  Loading := False;

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.edtDirFileSpecExit(Sender: TObject);
BEGIN
	IF edtDirFileSpec.Text = '' THEN
  	edtDirFileSpec.Text := '*.*';
END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.edtFileSpecEnter(Sender: TObject);
BEGIN
	//IF edtFileSpec.Text = '' THEN
  //	edtFileSpec.Text := '*.*';

	edtFileSpec.SelStart := 0;
  edtFileSpec.SelLength := Length( edtFileSpec.Text );
END;
{-------------------------------------------------------------}
(* Archive CheckBox - Set compression component FileType.ftArchive property *)
PROCEDURE TfrmAddFiles.ckbArchiveClick(Sender: TObject);
BEGIN
	CompressComponent.FileAttribute.ftArchive := ckbArchive.Checked;
END;
{-------------------------------------------------------------}
(* ReadOnly CheckBox - Set compression component FileType.ftReadOnly property *)
PROCEDURE TfrmAddFiles.ckbReadOnlyClick(Sender: TObject);
BEGIN
	CompressComponent.FileAttribute.ftReadOnly := ckbReadOnly.Checked;
END;
{-------------------------------------------------------------}
(* Hidden CheckBox - Set compression component FileType.ftHidden property *)
PROCEDURE TfrmAddFiles.ckbHiddenClick(Sender: TObject);
BEGIN
	CompressComponent.FileAttribute.ftHidden := ckbHidden.Checked;
END;
{-------------------------------------------------------------}
(* SysFile CheckBox - Set compression component FileType.ftSysFile property *)
PROCEDURE TfrmAddFiles.ckbSysFileClick(Sender: TObject);
BEGIN
	CompressComponent.FileAttribute.ftSysFile := ckbSysFile.Checked;
END;
{-------------------------------------------------------------}
(* VolumeID CheckBox - Set compression component FileType.ftVolumeID property *)
PROCEDURE TfrmAddFiles.ckbVolumeIDClick(Sender: TObject);
BEGIN
	CompressComponent.FileAttribute.ftVolumeID := ckbVolumeID.Checked;
END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.Button1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: INTEGER);
BEGIN
  PopupMenu1.Popup( Button1.Left + 10, Button1.Top + 40 );
END;
{-------------------------------------------------------------}
(** Assign the CompressMethod property **)
PROCEDURE TfrmAddFiles.ComboBox1Change(Sender: TObject);

VAR
	i, bIndex: BYTE;

CONST
	CompressedTypeName : ARRAY[ Ord( mtStore )..Ord( mtQuantum ) ] OF STRING =
  	(
        'Store',
        'Deflate',
        'Fuse',
        'Frozen',
        'Greatest',
        'Fastest',
        'MsZip',
        'Lzx',
        'Quantum'
  	);

BEGIN

	bIndex := 0;
	FOR i := Ord( mtStore ) TO Ord( mtQuantum ) DO
		WITH ComboBox1 DO
  		IF Items[ ItemIndex ] = CompressedTypeName[ i ] THEN
        BEGIN
           bIndex := i;
           Break;
        END;

	CompressComponent.CompressMethod := TCompressMethod( bIndex );

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.lstFileSpecClick(Sender: TObject);
BEGIN
	edtFileSpec.Text := lstFileSpec.Items[ lstFileSpec.ItemIndex ];
END;
{-------------------------------------------------------------}

END.

