UNIT ZipCheck;

INTERFACE

USES
  SysUtils, Classes, Forms, DsgnIntf, AwkMain, AwkGbls, Err_Msgs, UnBH,
  UnARC, UnARJ, UnGZip, UnLHA, UnRAR, UnTAR, UnZip, UnZoo, ZipTV;


TYPE
	TOnStatus = PROCEDURE( Sender: TObject; FN: STRING; PassFail: BOOLEAN ) OF OBJECT;
	TOnBegin  = PROCEDURE( Sender: TObject; FN: STRING ) OF OBJECT;
	TOnEnd    = PROCEDURE( Sender: TObject; FN: STRING ) OF OBJECT;

  TZipCheck = CLASS( TUnBASE )
  PRIVATE
  	FCancel  : BOOLEAN;
  	FOnStatus: TOnStatus;
     FOnBegin : TOnBegin;
     FOnEnd	: TOnEnd;

		PROCEDURE ztvNextVolume( Sender: TObject; VAR Dir,FN: STRING; VolumeID: STRING; VAR Cancel: BOOLEAN );
		PROCEDURE zcUnBaseNextVolume( Sender: TObject; VAR Dir,FN: STRING; VolumeID: STRING; VAR Cancel: BOOLEAN );

     PROCEDURE SetCancel( SC: BOOLEAN );
		PROCEDURE ArcOnBegin( Sender: TObject; FN: STRING; RecNum: INTEGER; VAR Extract: BOOLEAN );
     PROCEDURE ArcOnEnd( Sender: TObject; FN: STRING; CRC_PASS: BOOLEAN );
		PROCEDURE ArcOnRead( Sender: TObject; Offset, Filenum: INTEGER);
     PROCEDURE ArcOnTotals( Sender: TObject ; NumFiles: INTEGER );
		FUNCTION  ArcPutBlock( VAR Buf; VAR Count: INTEGER ): BOOLEAN;
  PROTECTED
  PUBLIC
		CONSTRUCTOR Create( AOwner: TComponent ); OVERRIDE;
		DESTRUCTOR 	Destroy; OVERRIDE;

  	PROCEDURE Activate;
     PROPERTY  Cancel	: BOOLEAN READ FCancel WRITE SetCancel DEFAULT FALSE;
  PUBLISHED
  	PROPERTY  ArcType;
     PROPERTY  FileSpec;
     PROPERTY  Passwords;
		PROPERTY  ProgressNotify;


     PROPERTY  OnActivate;
     PROPERTY  OnDeactivate;
     PROPERTY  OnBegin: TOnBegin READ FOnBegin WRITE FOnBegin;
     PROPERTY  OnEnd  : TOnEnd	 READ FOnEnd	WRITE FOnEnd;

     PROPERTY  OnError;
     PROPERTY  OnGetPassword;
     PROPERTY  OnProgress;
     PROPERTY  OnStatus: TOnStatus READ FOnStatus WRITE FOnStatus;
     PROPERTY  OnNextVolume;
  END;



VAR
  ztv: TZipTV;
	zcUnBASE: TUnBASE;
  CurrentUnpackedByte : LONGINT;



PROCEDURE REGISTER;



IMPLEMENTATION


{-------------------------------------------------------------}
PROCEDURE REGISTER;
BEGIN
  RegisterComponents( 'ZipTV', [ TZipCheck ] );
	RegisterPropertyEditor( TypeInfo( STRING ), TZipCheck, 'About', TAboutShow );
	RegisterPropertyEditor( TypeInfo( STRING ), TZipCheck, 'ArchiveFile', TOpenShow );
END;
{-------------------------------------------------------------}
CONSTRUCTOR TZipCheck.Create(AOwner: TComponent);
BEGIN
	INHERITED Create(AOwner);
	//FPasswords 	:= TStringList.Create;
	FileSpec 	:= '*.*';	(* default *)
  FCancel 		:= FALSE;
END;
{-------------------------------------------------------------}
DESTRUCTOR TZipCheck.Destroy;
BEGIN
	//FPasswords.Free;
	INHERITED Destroy;
END;
{-------------------------------------------------------------}
PROCEDURE TZipCheck.zcUnBaseNextVolume( Sender: TObject; VAR Dir,FN: STRING; VolumeID: STRING; VAR Cancel: BOOLEAN );
BEGIN

	IF Assigned( OnProgress ) THEN
  	ztv.Activate;

  IF Assigned( OnNextVolume ) THEN
  	OnNextVolume( Self, Dir, FN, VolumeID, Cancel );

END;
{-------------------------------------------------------------}
(* When using the 'activate method' with variable ztv, if the ztvNextVolume
event is not assigned, an error is triggered because of the multi-volume
feature. This procedure settles that assignment. *)
PROCEDURE TZipCheck.ztvNextVolume( Sender: TObject; VAR Dir,FN: STRING; VolumeID: STRING; VAR Cancel: BOOLEAN );
BEGIN
  Cancel := True;
END;
{-------------------------------------------------------------}
PROCEDURE TZipCheck.SetCancel( SC: BOOLEAN );
BEGIN
	FCancel := SC;
  zcUnBASE.Cancel := TRUE;
  Application.ProcessMessages;
END;
{-------------------------------------------------------------}
FUNCTION  TZipCheck.ArcPutBlock( VAR Buf; VAR Count: INTEGER ): BOOLEAN;
VAR
	CurByte: LONGINT;
BEGIN

	RESULT := TRUE;

	IF Assigned( OnProgress ) THEN
  BEGIN

     Dec( CurrentUnpackedByte, Count );
     CurByte := ztv.TotalUnpackedSize - CurrentUnpackedByte;
     Percent :=  CurByte * 100 DIV ztv.TotalUnpackedSize;
		OnProgress( Self, ztv.Filename, Percent );

  END;

END;
{-------------------------------------------------------------}
(* Assign total archive UnpackedSize to global variable *)
PROCEDURE TZipCheck.ArcOnTotals( Sender: TObject ; NumFiles: INTEGER );
BEGIN
  CurrentUnpackedByte := ztv.TotalUnpackedSize;
END;
{-------------------------------------------------------------}
PROCEDURE TZipCheck.ArcOnRead( Sender: TObject; Offset, Filenum: INTEGER);
BEGIN
	(* MUST assign OnRead to prevent 'required event' error - do not delete! *)
END;
{-------------------------------------------------------------}
PROCEDURE TZipCheck.ArcOnBegin( Sender: TObject; FN: STRING; RecNum: INTEGER; VAR Extract: BOOLEAN );
BEGIN
	IF Assigned( OnBegin ) THEN OnBegin( Self, FN );
END;
{-------------------------------------------------------------}
PROCEDURE TZipCheck.ArcOnEnd( Sender: TObject; FN: STRING; CRC_Pass: BOOLEAN );
BEGIN
	OnStatus( Self, ExtractFilename( FN ), CRC_Pass );
  IF Assigned( OnEnd ) THEN OnEnd( Self, FN );
END;
{-------------------------------------------------------------}
PROCEDURE TZipCheck.Activate;
BEGIN

	IF ( FArchiveFile = '' ) OR
  	( NOT IsArcVerifyable( ArcType ) ) THEN
  BEGIN

     RaiseErrorStr( FArchiveFile, '0', E_InvalidArc );
     EXIT;

  END ELSE IF NOT Assigned( OnStatus ) THEN
  BEGIN

     RaiseErrorStr( FArchiveFile, '0', E_RequiredEvent );
     EXIT;

  END;


  FCancel := FALSE;
  ztv := NIL;
  zcUnBASE := NIL;


  TRY

     IF Assigned( OnProgress ) THEN
     BEGIN

        (* Create a TZipTV object to retrieve the archives
           TotalUnpackedSize, to be used in the OnProgress
           calculation *)
        ztv := TZipTV.Create( NIL );

        ztv.OnError 	 := OnError;
        ztv.OnRead 		 := ArcOnRead;
        ztv.OnTotals 	 := ArcOnTotals;
        ztv.ArchiveFile := ArchiveFile;
        ztv.OnNextVolume:= ztvNextVolume;
        ztv.FileSpec 	 := FileSpec;  //'*.*';
        ztv.Activate;

     END;


     CASE ArcType OF

        atArc,
        atArcExe		: zcUnBASE := TUnARC.Create ( NIL );

        atArj,
        atArjExe		: zcUnBASE := TUnARJ.Create ( NIL );

        atBH,
        atBHExe	 	: zcUnBASE := TUnBH.Create  ( NIL );

        atGZIP		: zcUnBASE := TUnGZIP.Create( NIL );

        atLHA,
        atLhaExe,
        atLZH,
        atLzhExe		: zcUnBASE := TUnLHA.Create ( NIL );

        (* Requires UnRAR.DLL in windows/systems directory *)
        atRar,
        atRarExe		: zcUnBASE := TUnRAR.Create ( NIL );

        atTar			: zcUnBASE := TUnTAR.Create ( NIL );

        atZip,
        atZipExe,
        atZip250,
        atZip250Exe	: BEGIN
                          zcUnBASE := TUnZIP.Create( NIL );
                          zcUnBASE.ZipCmntBufSize := 32000;
                      END;

        atZoo			: zcUnBASE := TUnZOO.Create ( NIL );

     ELSE

        BEGIN

           RaiseErrorStr( FArchiveFile, '0', E_INVALIDARC );
           EXIT;

        END;

     END;

     Write_Buf  					:= ArcPutBlock;


                                      (* Assign zcUnBASE properties *)
     zcUnBASE.UseStoredDirs 	:= FALSE;
     zcUnBASE.ArchiveFile 	:= ArchiveFile;
     zcUnBASE.FileSpec 		:= FileSpec;
     zcUnBASE.Passwords 		:= Passwords;

                                      (* Assign zcUnBASE events to point to
                                         ZipSrch events *)

     zcUnBASE.OnBegin 			:= ArcOnBegin;
     zcUnBASE.OnEnd				:= ArcOnEnd;
     zcUnBASE.OnNextVolume	:= zcUnBaseNextVolume;
     zcUnBASE.OnActivate 		:= OnActivate;
     zcUnBASE.OnDeactivate 	:= OnDeactivate;
     zcUnBASE.OnError			:= OnError;
     zcUnBASE.OnGetPassword 	:= OnGetPassword;

                                      (* Activate decompression unique to
                                         TZipSearch/TZipCheck *)
     zcUnBASE.ExtractToVerify;


                                      (* Assign ZipSearch.Passwords as updated
                                         zcUnBASE.Passwords *)
     Passwords := zcUnBASE.Passwords;

  FINALLY
                                      (* Reset the write buffer for all other
                                         components *)
  	Write_Buf := PutBlock;
     IF ztv <> NIL THEN ztv.Destroy;
     IF zcUnBASE <> NIL THEN zcUnBASE.Destroy;

  END;

END;
{-------------------------------------------------------------}


END.

