{$D-}
UNIT Unit1;

INTERFACE

USES
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	AwkMain, ZipSrch, UnGZIP, UnTar, UnCAB, UnZoo, UnZIP, UnLHA, UnBH, UnARJ,
	UnARC, Err_Msgs, Menus, StdCtrls, Buttons, ExtCtrls, ComCtrls;

TYPE
	TForm1 = CLASS(TForm)

    ZipSearch1   : TZipSearch;
	  OpenDialog1	: TOpenDialog;

	  ListBox1		: TListBox;
	  ComboBox1		: TComboBox;    (* SearchMode property selection *)
	  StatusBar1	: TStatusBar;

	  MainMenu1    : TMainMenu;
	  File1        : TMenuItem;
	  Open1        : TMenuItem;
	  Exit1        : TMenuItem;

	  edtFileSpec  : TEdit;
	  edtSearchText: TEdit;
	  edtArchiveFile: TEdit;
    edtOffsetBegin: TEdit;
    edtOffsetEnd	: TEdit;

	  BitBtn1      : TBitBtn;			(* ok *)
	  BitBtn2		: TBitBtn;  		(* close *)
	  BitBtn3		: TBitBtn;  		(* cancel operation *)
	  btnOpenArchive: TBitBtn;

	  Label1			: TLabel;  			(* Search For *)
	  Label2			: TLabel;       	(* FileSpec *)
	  Label3			: TLabel;       	(* ArchiveFile *)
    Label4			: TLabel;
    Label5			: TLabel;

	  Panel1			: TPanel;
	  Panel2			: TPanel;
	  Panel3			: TPanel;
	  Panel4			: TPanel;
	  Panel5			: TPanel;

	  RadioGroup1	: TRadioGroup;
	  RadioGroup2	: TRadioGroup;
	  RadioGroup3	: TRadioGroup;

    (* Misc procedures *)
	  FUNCTION  FIXEDLENGTHSTR(InInt : Integer): ShortString;		(* int2str formating *)

    (* Form related procedures *)
	  PROCEDURE FormActivate(Sender: TObject);
	  PROCEDURE Open1Click(Sender: TObject);

    (* Edit control procedures *)
    PROCEDURE edtOffsetBeginChange(Sender: TObject);
    PROCEDURE edtOffsetEndChange(Sender: TObject);
	  PROCEDURE edtSearchTextChange(Sender: TObject);

    (* Menu related procedures *)
	  PROCEDURE btnOpenArchiveClick(Sender: TObject);

    (* Form Buttons *)
	  PROCEDURE BitBtn1Click(Sender: TObject);			(* ok *)
	  PROCEDURE BitBtn2Click(Sender: TObject);         (* close *)
	  PROCEDURE BitBtn3Click(Sender: TObject);         (* cancel *)

    (* ZipSearch events *)
	  PROCEDURE ZipSearch1ElaspedTime(Sender: TObject; ElaspedTime: REAL);
	  PROCEDURE ZipSearch1Error(Sender: TObject; FN, VolumeID: STRING; ECode: INTEGER);
	  PROCEDURE ZipSearch1FileChange(Sender: TObject; SearchFile, SearchText: STRING);
	  PROCEDURE ZipSearch1Finish(Sender: TObject; Files, Matches, Bytes: Integer);
	  PROCEDURE ZipSearch1GetPassword(Sender: TObject; FN: STRING;	VAR Password:
    			STRING; VAR TryAgain: BOOLEAN);
	  PROCEDURE ZipSearch1Match(Sender: TObject; ArchiveFile, SearchFile: STRING;	Offset: INTEGER);
    PROCEDURE ZipSearch1NextVolume(Sender: TObject; VAR Dir, FN: STRING;
     		VolumeID: STRING; VAR Cancel: BOOLEAN);

	PRIVATE
	PUBLIC
	END;



VAR
	Form1: TForm1;



IMPLEMENTATION




{$R *.DFM}


{-------------------------------------------------------------}
							(* ZipSearch Events *)
{-------------------------------------------------------------}
(* *** OnMatch event -- activated when a match is found *** *)
PROCEDURE TForm1.ZipSearch1Match(Sender: TObject; ArchiveFile, SearchFile: STRING; Offset: INTEGER);
BEGIN

	ListBox1.Items.Add('Pos: ' +
								FIXEDLENGTHSTR( Offset ) +
								' at File: ' +
								ExtractFilename( SearchFile ) );

END;
{-------------------------------------------------------------}
(* OnElaspedTime event - activated at the end of a search.  It passes
	 the time the search took to search a 'single' archive *)
PROCEDURE TForm1.ZipSearch1ElaspedTime(Sender: TObject;	ElaspedTime: REAL);
VAR
	s: ShortString;
BEGIN
	s := Format( 'Seconds: %g', [ ElaspedTime ]);
	MessageDlg( s + #13#13'OnElaspedTime event', mtInformation, [ mbOK ], 0 );
END;
{-------------------------------------------------------------}
(* OnFinish event - activates when search is finished.
	 Files, Matches, & Bytes parameters are the total combined totals
	 of all compressed files searhed *)
PROCEDURE TForm1.ZipSearch1Finish(Sender: TObject; Files, Matches, Bytes: Integer);
BEGIN
	StatusBar1.SimplePanel := False;
	Panel5.Visible := False;

	StatusBar1.Panels[0].Text := 'Files Searched: ' + IntToStr( Files );
	StatusBar1.Panels[1].Text := 'Matches: ' + IntToStr( Matches );
	StatusBar1.Panels[2].Text := 'Bytes Searched: ' + IntToStr( Bytes );
END;
{-------------------------------------------------------------}
(* OnFileChange event - activates once for each compressed
	file contained in	an archive,	passing the compressed filename prior
  searching it *)
PROCEDURE TForm1.ZipSearch1FileChange(Sender: TObject; SearchFile, SearchText: STRING);
BEGIN
	StatusBar1.SimpleText := 'Searching:  ' + ExtractFilename( SearchFile );
END;
{-------------------------------------------------------------}
(* OnNextVolume event ( for ARJ multi-volume archives *)
PROCEDURE TForm1.ZipSearch1NextVolume(Sender: TObject; VAR Dir, FN: STRING;
  VolumeID: STRING; VAR Cancel: BOOLEAN);
BEGIN

  IF NOT InputQuery( 'Enter new drv:\directory...', 'Filename: ' + FN, Dir ) THEN
  	Cancel := TRUE;

END;
{-------------------------------------------------------------}
(* OnError event *)
PROCEDURE TForm1.ZipSearch1Error(Sender: TObject; FN, VolumeID: STRING; ECode: INTEGER);
BEGIN

	ShowMessage( 'File   : ' + FN + #13 +
  				'Error# : ' + IntToStr( Ecode ) + #13 +
              LoadStr( ECode ) );

END;
{-------------------------------------------------------------}
(* OnGetPassword event... request password from user *)
PROCEDURE TForm1.ZipSearch1GetPassword(Sender: TObject; FN: STRING;
		VAR Password: STRING; VAR TryAgain: BOOLEAN);
BEGIN

  (* InputQuery is a Delphi function *)
	IF NOT InputQuery( 'Encrypted file...', 'Enter password', Password ) THEN
  	TryAgain := False;

END;
{-------------------------------------------------------------}




{-------------------------------------------------------------}
							(* Form controls - Form *)
{-------------------------------------------------------------}
(* Fill form controls with ZipControl property values *)
PROCEDURE TForm1.FormActivate(Sender: TObject);
BEGIN

	edtArchiveFile.Text := ZipSearch1.ArchiveFile;
	edtSearchText.Text  := ZipSearch1.SearchText;
	edtFileSpec.Text    := ZipSearch1.FileSpec;
	ComboBox1.ItemIndex 	:= Ord( ZipSearch1.SearchMode );
	RadioGroup1.ItemIndex := Ord( ZipSearch1.SearchFind );
	RadioGroup2.ItemIndex := Ord( ZipSearch1.SearchCase );
	RadioGroup3.ItemIndex := Ord( ZipSearch1.SearchType );
	edtSearchTextChange( Sender );	(* Enable/Disable OK button *)

END;


{-------------------------------------------------------------}
							(* Form controls - Buttons *)
{-------------------------------------------------------------}
(* Select Archive - Button *)
PROCEDURE TForm1.btnOpenArchiveClick(Sender: TObject);
BEGIN
	Open1Click( Sender );
END;
{-------------------------------------------------------------}
(* OK Button *)
PROCEDURE TForm1.BitBtn1Click(Sender: TObject);
BEGIN

	IF NOT FileExists( edtArchiveFile.Text ) THEN
  BEGIN
  	MessageDlg( edtArchiveFile.Text + ' not found.', mtInformation, [ mbOK ], 0 );
     edtArchiveFile.SetFocus;
		EXIT;
  END;

	(* Set form controls *)
	ListBox1.Items.Clear;
  StatusBar1.SimplePanel := True;
  Panel5.Visible := True;

  (* Assign ZipSearch component property values from form controls *)
  ZipSearch1.SearchFind := TztvSearchFind( RadioGroup1.ItemIndex );
	ZipSearch1.SearchCase := TztvSearchCase( RadioGroup2.ItemIndex );
	ZipSearch1.SearchType := TztvSearchType( RadioGroup3.ItemIndex );
	ZipSearch1.SearchMode := TztvSearchMode( ComboBox1.ItemIndex );

  (* Assign ZipSearch component property values... activate search *)
	ZipSearch1.SearchText := edtSearchText.Text;
	ZipSearch1.FileSpec := edtFileSpec.Text;

  (* Assign the archive filename *)
  (* In ZipSearch, always assign all properties prior to assigning the
     filename *)
	ZipSearch1.ArchiveFile := edtArchiveFile.Text;

  (* Activate the search *)
  ZipSearch1.Search;

END;
{-------------------------------------------------------------}
(* Close Button - Menu: 'Exit' also uses this procedure *)
PROCEDURE TForm1.BitBtn2Click(Sender: TObject);
BEGIN
	Close;
END;
{-------------------------------------------------------------}
(* Cancel Button *)
PROCEDURE TForm1.BitBtn3Click(Sender: TObject);
BEGIN
  ZipSearch1.Cancel := TRUE;
	Panel5.Visible := False;
END;



{-------------------------------------------------------------}
							(* Form controls - Edit controls *)
{-------------------------------------------------------------}
(* Assign OffsetBegin property *)
PROCEDURE TForm1.edtOffsetBeginChange(Sender: TObject);
VAR
	i: INTEGER;
BEGIN
	IF edtOffsetBegin.Text = '' THEN
  	i := 0
  ELSE
		i := StrToInt( edtOffsetBegin.Text );

	ZipSearch1.OffsetBegin := i;
END;
{-------------------------------------------------------------}
(* Assign OffsetEnd property *)
PROCEDURE TForm1.edtOffsetEndChange(Sender: TObject);
VAR
	i: INTEGER;
BEGIN
	IF edtOffsetEnd.Text = '' THEN
  	i := 0
  ELSE
		i := StrToInt( edtOffsetEnd.Text );

	ZipSearch1.OffsetEnd := i;
END;
{-------------------------------------------------------------}
(* Enable/Disable OK button *)
PROCEDURE TForm1.edtSearchTextChange(Sender: TObject);
BEGIN
	BitBtn1.Enabled := ( edtSearchText.Text <> '' ) AND ( edtArchiveFile.Text <> '' );
END;



{-------------------------------------------------------------}
							(* Form controls - Menu *)
{-------------------------------------------------------------}
(* File/Open menu item *)
PROCEDURE TForm1.Open1Click(Sender: TObject);
BEGIN

	IF ZipSearch1.SearchType = stArcsOnly THEN
		OpenDialog1.Filter := LoadStr( F_TZIPTV )  (* see F_TZIPTV in err_msgs.rc and err_msgs.pas *)
	ELSE
		OpenDialog1.Filter := '*.*';

	OpenDialog1.Options := [ ofHideReadOnly, ofFileMustExist, ofPathMustExist ];

	IF OpenDialog1.Execute THEN
  BEGIN

		edtArchiveFile.Text := OpenDialog1.Filename;
		ZipSearch1.ArchiveFile := edtArchiveFile.Text;
     edtOffsetEnd.Text := IntToStr( ZipSearch1.LengthOfFile );

     IF ( NOT ZipSearch1.IsArcDecompressable( ZipSearch1.ArcType ) ) THEN
     BEGIN

     	edtFileSpec.Enabled := FALSE;
        edtFileSpec.Color := clGray;

       	IF ( ZipSearch1.SearchType = stArcsOnly )	THEN
        BEGIN
     		ZipSearch1.SearchType := stAllFiles;
        	RadioGroup3.ItemIndex := 1;
        END;

     END ELSE BEGIN

     	edtFileSpec.Enabled := TRUE;
        edtFileSpec.Color := clWindow;

     END;

  END;

END;


{-------------------------------------------------------------}
							(* Misc functions *)
{-------------------------------------------------------------}
FUNCTION TForm1.FIXEDLENGTHSTR (InInt : Integer) : ShortString;
VAR
	OutStr: ShortString;
BEGIN
	OutStr := '               ' + InttoStr (InInt);
	RESULT := Copy( OutStr, Length( OutStr ) - 9, Length( OutStr ) );
END;
{-------------------------------------------------------------}



END.
