unit UPTShConsts; // Copyright  1996-1998 Plasmatech Software Design. All rights reserved.
{
 Shell Control Pack
 Version 1.3d

 This unit declares the resource strings used for internationalisation. For Delphi 2 and
 C++Builder it also declares the PTLoadStr function and gptshResourceInstance global
 variable.

 To build your project with a single language's translations in the executable itself,
 declare one of the following conditional defines in your Project|Options.

 To build a separate translation DLL with Delphi 3, build a .drc file with Project|Options|Linker|Detailed Map file.
 Apply each language's translation .CSV file to the .drc file with the MergeDRC utility. Build these merged drc files
 into .res files with brc32.exe. For each target language, create a new Delphi project that builds to a DLL and

 Other strings and forms should be 
 for your application must also be in the DLL.

 To build a separate translation DLL with Delphi 2

 Language    $DEFINE    2-character locale id
 ----------- ---------- ---------------------
 Czech       LANG_CS    cs
 Danish      LANG_DA    da
 Dutch       LANG_NL    nl
 English     LANG_EN    en
 Finnish     LANG_FI    fi
 French      LANG_FR    fr
 German      LANG_DE    de
 Hungarian   LANG_HU    hu
 Italian     LANG_IT    it
 Japanese    LANG_JP    jp
 Norwegian   LANG_NO    no
 Polish      LANG_PL    pl
 Portuguese  LANG_PT    pt
 Russian     LANG_RU    ru
 Spanish     LANG_ES    es
 Swedish     LANG_SV    sv

 History
 ==============================================================
 V1.30d --TBA-- No changes.
 V1.30c 16Mar98 C++Builder 3 support.
 V1.30b  7Feb98 Added Czech, Hungarian, Polish and Russian.
 V1.30a  7Jan98 No changes.
 V1.30  28Nov97 This unit was added to the pack for this version.
}

interface
uses Windows;

{$INCLUDE PTCompVer.inc}

{$IFDEF RESOURCESTRINGS}
function PTLoadStr( id: String ): String;
{$ELSE}
function PTLoadStr( id: Integer ): String;
{$ENDIF}


{$IFDEF RESOURCESTRINGS}
  {$IFDEF LANG_CS} {$I Lang\Czech\PTShConstsD3.inc}    {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_DA} {$I Lang\Danish\PTShConstsD3.inc}   {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_DE} {$I Lang\German\PTShConstsD3.inc}   {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_ES} {$I Lang\Spanish\PTShConstsD3.inc}  {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_EN} {$I Lang\English\PTShConstsD3.inc}  {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_FI} {$I Lang\Finnish\PTShConstsD3.inc}  {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_FR} {$I Lang\French\PTShConstsD3.inc}   {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_HU} {$I Lang\Hungarian\PTShConstsD3.inc}{$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_IT} {$I Lang\Italian\PTShConstsD3.inc}  {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_JP} {$I Lang\Japanese\PTShConstsD3.inc} {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_NL} {$I Lang\Dutch\PTShConstsD3.inc}    {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_NO} {$I Lang\Norwegian\PTShConstsD3.inc} {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_PL} {$I Lang\Polish\PTShConstsD3.inc}   {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_PT} {$I Lang\Portuguese_Brazil\PTShConstsD3.inc} {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_RU} {$I Lang\Russian\PTShConstsD3.inc}  {$DEFINE APPLIED_LANG} {$ENDIF}
  {$IFDEF LANG_SV} {$I Lang\Swedish\PTShConstsD3.inc}  {$DEFINE APPLIED_LANG} {$ENDIF}

  {$IFNDEF APPLIED_LANG} {$I Lang\English\PTShConstsD3.inc} {$ENDIF}  // Default to english

{$ELSE}

  {$I Lang\PTShConstsD2.inc}

  {$IFDEF VER90} // C++Builder has its own UPTShConsts.cpp file
    {$IFDEF LANG_CS} {$R PTShConstsD2_cs.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_DA} {$R PTShConstsD2_da.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_DE} {$R PTShConstsD2_de.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_ES} {$R PTShConstsD2_es.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_FI} {$R PTShConstsD2_fi.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_FR} {$R PTShConstsD2_fr.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_HU} {$R PTShConstsD2_hu.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_IT} {$R PTShConstsD2_it.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_JP} {$R PTShConstsD2_jp.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_NL} {$R PTShConstsD2_nl.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_NO} {$R PTShConstsD2_no.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_PL} {$R PTShConstsD2_pl.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_PT} {$R PTShConstsD2_pt.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_RU} {$R PTShConstsD2_ru.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFDEF LANG_SV} {$R PTShConstsD2_sv.res} {$DEFINE APPLIED_LANG} {$ENDIF}
    {$IFNDEF APPLIED_LANG} {$R PTShConstsD2.res}  {$ENDIF}
  {$ENDIF}

var gptshResourceInstance: THandle = 0;
  {If you use a custom resource dll you should assign your module handle to this variable.}

{$ENDIF}




implementation

{$IFDEF RESOURCESTRINGS}
function PTLoadStr( id: String ): String;
begin
  result := id;
end;
{$ELSE}
function PTLoadStr( id: Integer ): String;
var Buffer: array[0..1023] of Char;
begin
  if (gptshResourceInstance = 0) then gptshResourceInstance := HInstance;
  SetString(Result, Buffer, LoadString(gptshResourceInstance, id, Buffer, SizeOf(Buffer)));
end;
{$ENDIF}

end.

