unit UPTImageCombo; // Copyright  1996-1998 Plasmatech Software Design. All rights reserved.
{
 Shell Control Pack
 Version 1.3d

 History
 ==============================================================
 V1.30d --TBA-- No changes.
 V1.30c 16Mar98 Slight changes to method ordering in item destruction.
 V1.30b  7Feb98 Added Index property to TPTImageComboItem.
 V1.30a  7Jan98 No changes.
 V1.30  28Nov97 Added AutoSizeHeight property to TPTCustomImageCombo.
                Added WM_SETFONT handling for image combo. Image based combos now change height with different
                  font sizes.
                Added better design-time handling of change ItemHeight property.
                Changed icon drawing in image combo - image is now centered vertically.
                Fixed bug with TPTImageCombo which would cause AV's when no ImageList property was assigned.
 V1.20b 12Oct97 No significant changes.
 V1.20a  5Oct97 No changes.
 V1.20   6Sep97 No changes.
 V1.10a  6Jul97 No changes.
 V1.10  26Jun97 Changes to OnDeleteItem.
 V1.00c 31May97 No changes.
 V1.00b 17May97 Delphi 3 support.
 V1.00a  1May97 No changes.
 V1.00  21Apr97 Released version 1.0
}
{$RANGECHECKS OFF} {$OVERFLOWCHECKS OFF} {$WRITEABLECONST OFF}
{$BOOLEVAL OFF}    {$EXTENDEDSYNTAX ON}  {$TYPEDADDRESS ON}

{$INCLUDE PTCompVer.inc}

interface
uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls;

{ $DEFINE PTDEBUG} // <-- Define this symbol to turn on leak checking

type//-- Classes
     TPTImageComboItem = class;

    //-- Components
     TPTCombobox = class;
     TPTCustomImageCombo = class;
     TPTImageCombo = class;


     TPTImageComboItem = class                                    
       protected
         mOwner: TPTCustomImageCombo;
         mItemIndex: Integer;

         mIndex: Integer;
         mIndent: Integer;
         mImageIndex: Integer;
         mOverlayIndex: Integer;
         mCaption: String;
         mTag: Integer;
         mData: Pointer;

         procedure SetIndent( aValue: Integer );
         procedure SetImageIndex( aValue: Integer );
         procedure SetCaption( const aValue: String );
         procedure SetOverlayIndex( aValue: Integer );

       protected
         constructor Create( aOwner: TPTCustomImageCombo );
         destructor  Destroy; override;

       public
         property Index: Integer read mIndex; // Index in the list of the owning combobox
         property Indent: Integer read mIndent write SetIndent;
         property ImageIndex: Integer read mImageIndex write SetImageIndex;
         property OverlayIndex: Integer read mOverlayIndex write SetOverlayIndex;
         property Caption: String read mCaption write SetCaption;
         property Data: Pointer read mData write mData;  // User defined information
         property Tag: Integer read mTag write mTag;     // User defined information
     end; {TPTImageComboItem}


     TPTDeleteComboItemEvent = procedure( aSender: TObject;  aItem: Pointer ) of object;

     TPTCustomCombobox = class(TCustomCombobox)
       private
         mOnDeleteItemProc: TPTDeleteComboItemEvent;
         mOnCloseUpProc: TNotifyEvent;
         mOnSelEndCancelProc: TNotifyEvent;
         mOnSelEndOkProc: TNotifyEvent;

         procedure SetItemHeight2( aValue: Integer );

         procedure CNCommand( var aMsg: TWMCommand ); message CN_COMMAND;
         procedure WMDeleteItem( var amsg: TWMDeleteItem ); message WM_DELETEITEM;

       protected
        // New events
         procedure DeleteItem( aItem: Pointer ); virtual;
         procedure CloseUp; dynamic;
         procedure SelEndCancel; dynamic;
         procedure SelEndOk; dynamic;

         property OnDeleteItem: TPTDeleteComboItemEvent read mOnDeleteItemProc write mOnDeleteItemProc;
         property OnCloseUp: TNotifyEvent read mOnCloseUpProc write mOnCloseUpProc;
         property OnSelEndCancel: TNotifyEvent read mOnSelEndCancelProc write mOnSelEndCancelProc;
         property OnSelEndOk: TNotifyEvent read mOnSelEndOkProc write mOnSelEndOkProc;
         // property OnCNCommand ... maybe later

         property ItemHeight write SetItemHeight2;
     end; {TPTCustomCombobox}


     TPTCombobox = class(TPTCustomCombobox)
       published
        // -- Normal combobox properites
         property Style; {Must be published before Items}
         property Color;
         property Ctl3D;
         property DragMode;
         property DragCursor;
         property DropDownCount;
         property Enabled;
         property Font;
         property ItemHeight;
         property Items;
         property MaxLength;
         property ParentColor;
         property ParentCtl3D;
         property ParentFont;
         property ParentShowHint;
         property PopupMenu;
         property ShowHint;
         property Sorted;
         property TabOrder;
         property TabStop;
         property Text;
         property Visible;
         property OnChange;
         property OnClick;
         property OnDblClick;
         property OnDragDrop;
         property OnDragOver;
         property OnDrawItem;
         property OnDropDown;
         property OnEndDrag;
         property OnEnter;
         property OnExit;
         property OnKeyDown;
         property OnKeyPress;
         property OnKeyUp;
         property OnMeasureItem;
         property OnStartDrag;
        // -- Added by TPTCustomCombobox
         property OnDeleteItem;
         property OnCloseUp;
         property OnSelEndCancel;
         property OnSelEndOk;
     end; {TPTCombobox}


     TPTDeleteImageComboItemEvent = procedure( aSender: TObject;  aItem: TPTImageComboItem ) of object;

     TPTCustomImageCombo = class(TPTCustomCombobox)
       private
{$IFDEF PTDEBUG}
         mdbgItems: Integer; // Count of TPTImageComboItem objects created. Used for debugging lifetime of said objects.
{$ENDIF}

         mAutoSizeHeight: Boolean;
         mImageList: TImageList;
         mIndentPixels: Integer;
         mOnDeleteImageComboItemProc: TPTDeleteImageComboItemEvent;

         function  GetImageComboItem( index: Integer ): TPTImageComboItem;

         procedure CNDrawItem( var aMsg: TWMDrawItem ); message CN_DRAWITEM;
         procedure WMEraseBkgnd( var aMsg: TWMEraseBkgnd ); message WM_ERASEBKGND;
         procedure WMSetFont( var aMsg: TWMSetFont ); message WM_SETFONT;
       protected
         procedure DoAutoSize( hf: HFont );
         procedure AutoSize( hf: HFont ); dynamic;

         procedure SetIndentPixels( aValue: Integer );
         procedure SetImageList( const aValue: TImageList );

         procedure CreateParams( var p: TCreateParams ); override;
         procedure CreateWnd; override;
         procedure DestroyWnd; override;
         procedure DrawItem(aIndex: Integer; aRect: TRect; aState: TOwnerDrawState); override;
         procedure Notification( aComponent: TComponent; operation: TOperation ); override;
         procedure DeleteItem( aItem: Pointer ); override;

         property Text stored FALSE;

        // New Properties
         property AutoSizeHeight: Boolean read mAutoSizeHeight write mAutoSizeHeight default TRUE;
         property IndentPixels: Integer read mIndentPixels write SetIndentPixels default 12;
         property ImageList: TImageList read mImageList write SetImageList;

         property OnDeleteItem: TPTDeleteImageComboItemEvent read mOnDeleteImageComboItemProc write mOnDeleteImageComboItemProc;
       public
         constructor Create( aOwner: TComponent ); override;
         destructor  Destroy;  override;

         function  AddItem( aCaption: String;  aImageIndex: Integer;  aIndent: Integer ): TPTImageComboItem; virtual;
//         function  InsertItem( aIndex: Integer;
//                               aCaption: String;  aImageIndex: Integer;  aIndent: Integer ): TPTImageComboItem; virtual;

         property  ImageComboItem[index: Integer]: TPTImageComboItem read GetImageComboItem;
     end; {TPTCustomImageCombo}


     TPTImageCombo = class(TPTCustomImageCombo)
       published
         property AutoSizeHeight;
         property IndentPixels;
         property ImageList;
         property OnDeleteItem;
         property OnCloseUp;
         property OnSelEndCancel;
         property OnSelEndOk;
        // -- Normal combobox properties
         property Color;
         property Ctl3D;
         property DragMode;
         property DragCursor;
         property DropDownCount;
         property Enabled;
         property Font;
         property ItemHeight;
         property MaxLength;
         property ParentColor;
         property ParentCtl3D;
         property ParentFont;
         property ParentShowHint;
         property PopupMenu;
         property ShowHint;
         property Sorted;
         property TabOrder;
         property TabStop;
         property Visible;
         property OnChange;
         property OnClick;
         property OnDblClick;
         property OnDragDrop;
         property OnDragOver;
         property OnDrawItem;
         property OnDropDown;
         property OnEndDrag;
         property OnEnter;
         property OnExit;
         property OnKeyDown;
         property OnKeyPress;
         property OnKeyUp;
         property OnMeasureItem;
         property OnStartDrag;
     end; {TPTImageCombo}


{*****************************************************************************}
implementation

{$IFDEF PTDEBUG}
var g_dbgItems: Integer = 0;
{$ENDIF}


{**************************************
  TPTCustomCombobox
**************************************}
procedure TPTCustomCombobox.SetItemHeight2( aValue: Integer );
begin
  if (ItemHeight <> aValue) and (Style in [csOwnerDrawFixed, csOwnerDrawVariable]) then
  begin
    inherited ItemHeight := aValue;
    RecreateWnd;
  end
  else
    inherited ItemHeight := aValue;
end;

procedure TPTCustomCombobox.CNCommand( var aMsg: TWMCommand );
begin
  case aMsg.notifyCode of
    CBN_CLOSEUP:      CloseUp;
    CBN_SELENDCANCEL: SelEndCancel;
    CBN_SELENDOK:     SelEndOk;
  else
    inherited;
  end;
end; {TPTCustomCombobox.CNCommand}

procedure TPTCustomCombobox.WMDeleteItem( var aMsg: TWMDeleteItem );
begin
  DeleteItem( Pointer(aMsg.deleteItemStruct.itemData) );
  Pointer(aMsg.deleteItemStruct.itemData) := nil;
  inherited;
end;

procedure TPTCustomCombobox.DeleteItem( aItem: Pointer );
  begin if Assigned(OnDeleteItem) then OnDeleteItem(self, aItem); end;

procedure TPTCustomCombobox.CloseUp;
  begin if Assigned(OnCloseUp) then OnCloseUp(self); end;

procedure TPTCustomCombobox.SelEndCancel;
  begin  if Assigned(OnSelEndCancel) then OnSelEndCancel(self); end;

procedure TPTCustomCombobox.SelEndOk;
  begin if Assigned(OnSelEndOk) then OnSelEndOk(self); end;



{**************************************
  TPTImageComboItem
**************************************}
constructor TPTImageComboItem.Create( aOwner: TPTCustomImageCombo );
begin
  inherited Create;
  mOwner := aOwner;
  mOverlayIndex := -1;
{$IFDEF PTDEBUG}
  Inc( mOwner.mdbgItems );
  Inc( g_dbgItems );
{$ENDIF}
end;

destructor TPTImageComboItem.Destroy;
begin
{$IFDEF PTDEBUG}
  Dec( mOwner.mdbgItems );
  Dec( g_dbgItems );
{$ENDIF}
  inherited Destroy;
end;

procedure TPTImageComboItem.SetIndent( aValue: Integer );
begin
  mIndent := aValue;
  mOwner.Invalidate;
end;

procedure TPTImageComboItem.SetImageIndex( aValue: Integer );
begin
  mImageIndex := aValue;
  mOwner.Invalidate;
end;

procedure TPTImageComboItem.SetCaption( const aValue: String );
begin
  mCaption := aValue;
  mOwner.Invalidate;
end;

procedure TPTImageComboItem.SetOverlayIndex( aValue: Integer );
begin
  mOverlayIndex := aValue;
  mOwner.Invalidate;
end;


{**************************************
  TPTCustomImageCombo
**************************************}
constructor TPTCustomImageCombo.Create( aOwner: TComponent );
begin
  inherited;
  Style := csOwnerDrawFixed;
//  mfOwnsObjects := TRUE;
  mIndentPixels := 12;
  mAutoSizeHeight := TRUE;
end; {TPTCustomImageCombo.Create}

destructor TPTCustomImageCombo.Destroy;
{$IFDEF PTDEBUG}
var comboItems, dbgItems: Integer;
{$ENDIF}
begin
{$IFDEF PTDEBUG}
  comboItems := g_dbgItems;
  dbgItems := mdbgItems;
{$ENDIF}
  inherited;
{$IFDEF PTDEBUG}
  if comboItems - g_dbgItems <> dbgItems then
  begin
    MessageBeep(UINT(-1));
    Windows.MessageBox( 0, PChar(Format('TPTCustomImageCombo: %d items leaked!',[comboItems - g_dbgItems])), 'Debug', MB_OK );
  end;
{$ENDIF}
end; {TPTCustomImageCombo.Destroy}

function TPTCustomImageCombo.GetImageComboItem( index: Integer ): TPTImageComboItem;
  begin result := Items.Objects[index] as TPTImageComboItem; end;


procedure TPTCustomImageCombo.CNDrawItem( var aMsg: TWMDrawItem );
var state: TOwnerDrawState;
begin
  with aMsg.DrawItemStruct^ do
  begin
    State := TOwnerDrawState(WordRec(LongRec(itemState).Lo).Lo);
    Canvas.Handle := hDC;
    Canvas.Font := Font;
    Canvas.Brush := Brush;
    if (Integer(itemID) >= 0) and (odSelected in State) then
    begin
      Canvas.Brush.Color := clHighlight;
      Canvas.Font.Color := clHighlightText
    end;
    if Integer(itemID) >= 0 then
      DrawItem(itemID, rcItem, State)
    else
      Canvas.FillRect(rcItem);
    Canvas.Handle := 0;
  end;
end;

procedure TPTCustomImageCombo.WMEraseBkgnd( var aMsg: TWMEraseBkgnd );
var brush: TBrush;
begin
  brush := TBrush.Create;
  if Owner is TForm then
    brush.Color := TForm(Owner).Color
  else
    brush.Color := clWindow;
  Windows.FillRect( aMsg.dc, ClientRect, brush.Handle );
  brush.Free;
  aMsg.result := 1;
end; {TPTCustomImageCombo.WMEraseBkgnd}

procedure TPTCustomImageCombo.WMSetFont( var aMsg: TWMSetFont );
begin
  AutoSize(aMsg.Font);
  inherited;
end; {TPTCustomImageCombo.WMSetFont}

function TPTCustomImageCombo.AddItem( aCaption: String;  aImageIndex: Integer;  aIndent: Integer ): TPTImageComboItem;
const NOSTRING: String = '';
begin
  result := TPTImageComboItem.Create(self);
  result.mCaption := aCaption;
  result.mImageIndex := aImageIndex;
  result.mIndent := aIndent;
  result.mIndex := Items.AddObject( NOSTRING, result );
end; {TPTCustomImageCombo.AddItem}

procedure TPTCustomImageCombo.DoAutoSize( hf: HFONT );
var h: Integer;
    oldf: HFONT;
    dc: HDC;
    tm: TTextMetric;
begin
  dc := GetDC(0);  oldf:=0;
  try
    oldf := SelectObject(dc, hf);
    GetTextMetrics(dc, tm);
    h := Abs(tm.tmHeight) +2;
  finally
    if (oldf<>0) then SelectObject( dc, oldf );
    ReleaseDC(0, dc);
  end;
  if Assigned(ImageList) and (ImageList.Height > h) then
    h := ImageList.Height;
  ItemHeight := h;
end; {TPTCustomImageCombo.DoAutoSize}

procedure TPTCustomImageCombo.AutoSize( hf: HFONT );
begin
  if AutoSizeHeight then DoAutoSize(hf);
end; {TPTCustomImageCombo.AutoSize}

procedure TPTCustomImageCombo.SetIndentPixels( aValue: Integer );
begin
  if (mIndentPixels <> aValue) then begin mIndentPixels:=aValue; Invalidate; end;
end; {TPTCustomImageCombo.SetIndentPixels}

procedure TPTCustomImageCombo.SetImageList( const aValue: TImageList );
begin
  mImageList:=aValue;
  Invalidate;
  if Assigned(mImageList) then
    mImageList.FreeNotification(self);
  if not (csLoading in ComponentState) then AutoSize(Font.Handle);
end; {TPTCustomImageCombo.SetImageList}

procedure TPTCustomImageCombo.CreateParams( var p: TCreateParams );
begin
  inherited;
  p.style := p.style and not CBS_HASSTRINGS;
    { Under Windows NT (4.0) if the combo has the CBS_HASSTRINGS style set, then when the WM_DELETEITEM
      message is sent, the itemData member of the DELETEITEMSTRUCT record is 0 (so we GP fault and items leak).
      The unfortunate side effect of this fix is that keyboard access doesn't work anymore. }
end; {TPTCustomImageCombo.CreateParams}

procedure TPTCustomImageCombo.CreateWnd;
begin
  inherited;
  SendMessage( Handle, CB_SETEXTENDEDUI, 1,0 );
end; {TPTCustomImageCombo.CreateWnd}

procedure TPTCustomImageCombo.DestroyWnd;
begin
  Items.Clear;  // Prevent TCustomCombobox.DestroyWnd from streaming out Items.
  inherited;
end; {TPTCustomImageCombo.DestroyWnd}

procedure TPTCustomImageCombo.DrawItem(aIndex: Integer; aRect: TRect; aState: TOwnerDrawState);
var i: TPTImageComboItem;
    x, top, indent: Integer;
    r: TRect;
begin
  if Assigned(OnDrawItem) then OnDrawItem(Self, aIndex, aRect, aState)
  else
  begin
    i := Items.Objects[aIndex] as TPTImageComboItem;
    if not Assigned(i) then Exit;

    if WindowFromDC(Canvas.Handle) = Handle then indent := 0 else indent := i.Indent;
    { Should check odComboBoxEdit (aka. ODS_COMBOBOXEDIT) in aState, but StdCtrls doesn't declare it :(
      This WindowFromDC trick works Ok though. :) }

    Canvas.Brush.Color := clWindow;
    Canvas.FillRect(aRect);

    if Assigned(mImageList) then
    begin
      if (odSelected in aState) then
      begin
        Canvas.Brush.Color := clHighlight;
        mImageList.BlendColor := clHighlight;
        mImageList.DrawingStyle := dsSelected;
      end
      else
        mImageList.DrawingStyle := dsNormal;

      top := (aRect.Top + aRect.Bottom - ImageList.Height) div 2;
      if (i.OverlayIndex < 0) then
        mImageList.Draw( Canvas, aRect.Left + indent*mIndentPixels + 2, top, i.ImageIndex )
      else
        mImageList.DrawOverlay( Canvas, aRect.Left + indent*mIndentPixels +2, top, i.ImageIndex, i.OverlayIndex );
    end;

    if (odSelected in aState) then
      Canvas.Brush.Color := clHighlight;

    if (i.Caption <> '') then
    begin
      if Assigned(mImageList) then x := mImageList.Width+4 else x := 4;
      r.left := aRect.Left + indent*mIndentPixels+2 + x -1;
      r.top := aRect.Top;
      r.right := r.left + Canvas.TextWidth(i.Caption) +1 +2;
      r.bottom := aRect.Bottom;
      Canvas.TextRect( r, r.left+1,r.top+1, i.Caption );
    end;
  end;
end; {TPTCustomImageCombo.DrawItem}

procedure TPTCustomImageCombo.Notification( aComponent: TComponent; operation: TOperation );
begin
  inherited;
  if (operation = opRemove) and (aComponent = mImageList) then
    mImageList := nil;
end; {TPTCustomImageCombo.Notification}

procedure TPTCustomImageCombo.DeleteItem( aItem: Pointer );
begin
  if Assigned(OnDeleteItem) then OnDeleteItem( self, TPTImageComboItem(aItem) );
  TObject(aItem).Free;
//  inherited;
end; {TPTCustomImageCombo.DeleteItem}


initialization
finalization
{$IFDEF PTDEBUG}
  if g_dbgItems <> 0 then
    Windows.MessageBox( 0, PChar(Format('TPTImageComboItem leak!'#13'Items leaked: %d',[g_dbgItems])), 'Debug', MB_OK );
{$ENDIF}
end.

