unit Reg_PTShellControls; // Copyright  1996-1998 Plasmatech Software Design. All rights reserved.
{
 Shell Control Pack
 Version 1.3d

 History
 ==============================================================
 V1.30d --TBA-- No changes.
 V1.30c 16Mar98 C++Builder 3 support.
 V1.30b  7Feb98 Changed default control page from 'Plasmatools' to 'Shell'.
 V1.30a  7Jan98 No changes.
 V1.30  28Nov97 No significant changes.
 V1.20b 12Oct97 No changes.
 V1.20a  5Oct97 No changes.
 V1.20   6Sep97 Fixed problem with TPTSplitter editor being registered twice.
 V1.10a  6Jul97 No changes.
 V1.10  26Jun97 Added UPTComControls unit and TPTTreeView and TPTListView components.
 V1.00c 31May97 Added TFilterProperty editor support to Delphi 3.
                Added TFilterProperty editor to Filter property of TPTShellList (Delphi 2 & 3).
 V1.00b 17May97 Changes to support Delphi 3.
 V1.00a  1May97 No changes.
 V1.00  21Apr97 Released version 1.0
}
{$INCLUDE PTCompVer.inc}

interface
uses UPTShell95, UPTShellUtils, UPTShellControls, UPTSysFolderDlg, UPTSplitter, UPTImageCombo, UPTFrame,
     UPTTreeList, UPTShConsts,
     FPTOpenDlg, FPTFolderBrowseDlg,
{$IFNDEF CBUILDER3}
     FiltEdit,
{$ENDIF}
     Dialogs, Forms;

procedure Register;

implementation
uses Classes, DsgnIntf, Controls, TypInfo,
     FPTShellLocatorEditor, FPTAbout;

const CTLPACK_PAGENAME  = 'Shell';
      CTLPACK_NAME      = 'Shell Control Pack';
      CTLPACK_COPYRIGHT = '1996-1998'#13#10;
      CTLPACK_VERSION   = PTSHELLCONTROLS_VERSION;
      CTLPACK_PATCH     = PTSHELLCONTROLS_PATCH;


const STest = '&Test...';
      SAbout = '&About...';
      SSwapPanes = 'Swap &Panes';
      SCenterPanes = '&Center Panes';

{-- TPTShellLocatorEditor --------------------------------}

{ This is the property editor for design-time pidls. }
type TPTShellLocatorEditor = class(TClassProperty)
       procedure Edit; override;
       function GetAttributes: TPropertyAttributes; override;
     end;

function EditPidl( o: TPTShellLocator ): Boolean;
var f: TFrmShellLocatorEditor;
begin
  f := TFrmShellLocatorEditor.Create(Application);
  try
    f.Locator := o;
    result := (f.ShowModal = mrOk);
  finally
    f.Free;
  end;
end;

procedure TPTShellLocatorEditor.Edit;
begin
  if EditPidl( TPTShellLocator(GetOrdValue) ) then Modified;
end; {TPTShellLocatorEditor.Edit}

function TPTShellLocatorEditor.GetAttributes: TPropertyAttributes;
  begin result := [paDialog, paReadOnly]; end;
{=========================================================}



{-- TCSIDLEditor -----------------------------------------}
type TCSIDLEditor = class(TEnumProperty)
       procedure GetValues( proc: TGetStrProc ); override;
     end;

procedure TCSIDLEditor.GetValues( proc: TGetStrProc );
var i: Integer;
    enumType: PTypeInfo;
    s: String;
begin
  enumType := GetPropType;
  with GetTypeData(enumType)^ do
    for i := MinValue to MaxValue do
    begin
      s := GetEnumName(enumType, i);
      if Pos('_',s)=0 then
        Proc(s);
    end;
end; {TCSIDLEditor.GetValues}
{=========================================================}


{-- TPTAboutEditor ---------------------------------------}
type TPTAboutEditor = class(TDefaultEditor)
       procedure ExecuteVerb(index: Integer);  override;
       function GetVerb(index: Integer): String;  override;
       function GetVerbCount: Integer;  override;
     end;

procedure TPTAboutEditor.ExecuteVerb(index: Integer);
  begin FPTAbout.TPTFrmAbout.ExecuteCtl( CTLPACK_NAME, CTLPACK_COPYRIGHT, Component.ClassName, CTLPACK_VERSION, CTLPACK_PATCH ); end;

function TPTAboutEditor.GetVerb(index: Integer): String;
  begin result := SAbout; end;

function TPTAboutEditor.GetVerbCount: Integer;
  begin result := 1; end;
{== END TPTAboutEditor ===================================}


{-- TPTSysFolderDlgEditor --------------------------------}
type TPTSysFolderDlgEditor = class(TDefaultEditor)
       procedure ExecuteVerb(index: Integer);  override;
       function GetVerb(index: Integer): String;  override;
       function GetVerbCount: Integer;  override;
     end;

procedure TPTSysFolderDlgEditor.ExecuteVerb(index: Integer);
begin
  case index of
    0: FPTAbout.TPTFrmAbout.ExecuteCtl( CTLPACK_NAME, CTLPACK_COPYRIGHT, Component.ClassName, CTLPACK_VERSION, CTLPACK_PATCH );
    1: (Component as TPTSysFolderDlg).Execute;
  end;
end;

function TPTSysFolderDlgEditor.GetVerb(index: Integer): String;
begin
  case index of
    0: result := SAbout;
    1: result := STest;
  else
    result := '';
  end;
end;

function TPTSysFolderDlgEditor.GetVerbCount: Integer;
  begin result := 2; end;
{=========================================================}


{-- TPTFolderBrowseDlgEditor -----------------------------}
type TPTFolderBrowseDlgEditor = class(TDefaultEditor)
       procedure ExecuteVerb(index: Integer);  override;
       function GetVerb(index: Integer): String;  override;
       function GetVerbCount: Integer;  override;
     end;

procedure TPTFolderBrowseDlgEditor.ExecuteVerb(index: Integer);
begin
  case index of
    0: FPTAbout.TPTFrmAbout.ExecuteCtl( CTLPACK_NAME, CTLPACK_COPYRIGHT, Component.ClassName, CTLPACK_VERSION, CTLPACK_PATCH );
    1: (Component as TPTFolderBrowseDlg).Execute;
  end;
end;

function TPTFolderBrowseDlgEditor.GetVerb(index: Integer): String;
begin
  case index of
    0: result := SAbout;
    1: (Component as TPTSysFolderDlg).Execute;
  else result := '';
  end;
end;

function TPTFolderBrowseDlgEditor.GetVerbCount: Integer; begin result := 2; end;
{=========================================================}


{-- TPTOpenDlgEditor -------------------------------------}
type TPTOpenDlgEditor = class(TDefaultEditor)
       procedure ExecuteVerb(index: Integer);  override;
       function GetVerb(index: Integer): String;  override;
       function GetVerbCount: Integer;  override;
     end;

procedure TPTOpenDlgEditor.ExecuteVerb(index: Integer);
begin
  case index of
    1: (Component as TPTOpenDlg).Execute;
    0: FPTAbout.TPTFrmAbout.ExecuteCtl( CTLPACK_NAME, CTLPACK_COPYRIGHT, Component.ClassName, CTLPACK_VERSION, CTLPACK_PATCH );
  end;
end;

function TPTOpenDlgEditor.GetVerb(index: Integer): String;
begin
  case index of
    1: result := STest;
    0: result := SAbout;
  else result := '';
  end;
end;

function TPTOpenDlgEditor.GetVerbCount: Integer;  begin result := 2; end;
{=========================================================}


{-- TPTSaveDlgEditor -------------------------------------}
type TPTSaveDlgEditor = class(TDefaultEditor)
       procedure ExecuteVerb(index: Integer);  override;
       function GetVerb(index: Integer): String;  override;
       function GetVerbCount: Integer;  override;
     end;

procedure TPTSaveDlgEditor.ExecuteVerb(index: Integer);
begin
  case index of
    1: (Component as TPTSaveDlg).Execute;
    0: FPTAbout.TPTFrmAbout.ExecuteCtl( CTLPACK_NAME, CTLPACK_COPYRIGHT, Component.ClassName, CTLPACK_VERSION, CTLPACK_PATCH );
  end;
end;

function TPTSaveDlgEditor.GetVerb(index: Integer): String;
begin
  case index of
    1: result := STest;
    0: result := SAbout;
  else result := '';
  end;
end;

function TPTSaveDlgEditor.GetVerbCount: Integer;  begin result := 2; end;
{=========================================================}



{-- TPTSplitterEditor ------------------------------------}
type TPTSplitterEditor = class(TDefaultEditor)
       procedure ExecuteVerb(index: Integer);  override;
       function GetVerb(index: Integer): String;  override;
       function GetVerbCount: Integer;  override;
     end;

procedure TPTSplitterEditor.ExecuteVerb(index: Integer);
var s: TPTSplitter;
begin
  s := Component as TPTSplitter;
  case index of
    0: FPTAbout.TPTFrmAbout.ExecuteCtl( CTLPACK_NAME, CTLPACK_COPYRIGHT, Component.ClassName, CTLPACK_VERSION, CTLPACK_PATCH );
    1: s.Position := (s.Width - s.SplitterWidth) div 2;
    2: s.SwapPanes(TRUE);
  end;
end; {TPTSplitterEditor.ExecuteVerb}

function TPTSplitterEditor.GetVerb(index: Integer): String;
begin
  case index of
    0: result := SAbout;
    1: result := SCenterPanes;
    2: result := SSwapPanes;
  else result := '';
  end;
end; {TPTSplitterEditor.GetVerb}

function TPTSplitterEditor.GetVerbCount: Integer;
  begin result := 3; end;
{== END TPTSplitterEditor ================================}


{-- TOpenDialogEditor ------------------------------------}
type TOpenDialogEditor = class(TDefaultEditor)
       procedure ExecuteVerb(index: Integer);  override;
       function GetVerb(index: Integer): String;  override;
       function GetVerbCount: Integer;  override;
     end;

procedure TOpenDialogEditor.ExecuteVerb(index: Integer);
begin
  (Component as TOpenDialog).Execute;
end;

function TOpenDialogEditor.GetVerb(index: Integer): String;
begin
  case index of
    0: result := STest;
  else result := '';
  end;
end; {TOpenDialogEditor.GetVerb}

function TOpenDialogEditor.GetVerbCount: Integer;
  begin result := 1; end;
{== END TOpenDialogEditor ================================}


procedure RegisterComponentEditors( components: array of TComponentClass;  editor: TComponentEditorClass );
var i: Integer;
begin
  for i := Low(components) to High(components) do
    RegisterComponentEditor( components[i], editor );
end;

procedure Register;
begin
  RegisterComponents( CTLPACK_PAGENAME, [TPTShellTree, TPTShellList, TPTShellCombo,
                                         TPTOpenDlg, TPTSaveDlg, TPTFolderBrowseDlg,
                                         TPTFrame, TPTGroup,
                                         TPTSplitter, TPTImageCombo,
                                         TPTSysFolderDlg,
                                         TPTCombobox,
                                         TPTTreeView, TPTListView] );
  RegisterNoIcon( [TPTPane] );

  RegisterPropertyEditor( TypeInfo(TPTShellLocator), nil, '', TPTShellLocatorEditor );
  RegisterPropertyEditor( TypeInfo(TCSIDL), nil, '', TCSIDLEditor );

  RegisterComponentEditor( TPTSysFolderDlg, TPTSysFolderDlgEditor );
  RegisterComponentEditor( TPTFolderBrowseDlg, TPTFolderBrowseDlgEditor );
  RegisterComponentEditor( TPTOpenDlg, TPTOpenDlgEditor );
  RegisterComponentEditor( TPTSaveDlg, TPTSaveDlgEditor );
  RegisterComponentEditor( TPTSplitter, TPTSplitterEditor );

  RegisterComponentEditors( [TPTShellTree, TPTShellList, TPTShellCombo,
                             TPTFrame, TPTGroup,
                             TPTImageCombo, TPTCombobox,
                             TPTTreeView, TPTListView],
                            TPTAboutEditor );

  RegisterComponentEditor( TOpenDialog, TOpenDialogEditor );

{$IFNDEF CBUILDER3}
  RegisterPropertyEditor(TypeInfo(String), TPTFileDlg, 'Filter', TFilterProperty);
  RegisterPropertyEditor(TypeInfo(String), TPTShellList, 'Filter', TFilterProperty);
{$ENDIF}
end;

end.

