{ Copyright  1997, 1998 Plasmatech Software Design. All rights reserved.

  File: PTCompVer.inc
  Vers: 2.0
  Date: 5-Mar-98

  This file defines a set of useful compiler definitions. If you rely on
  the definitions in this file you can just update this one file when
  new versions of Delphi and C++Builder are released.

  Include this file at the start of your units with $INCLUDE. 

  Of course, it would be better if the compilers themselves defined these
  symbols, but they don't.

  Symbol    Meaning
  ========  ==============
  VER9x     Compiler version is between 90 and 99. Includes Delphi 2 and
            C++ Builder 1.0.
  VER10x    Compiler version is between 100 and 109. Includes Delphi 3.
  VER11x    Compiler version is between 110 and 119. Included C++Builder 3.

  DELPHI    Is a Delphi verison of the compiler.
  CBUILDER  Is a C++Builder version of the compiler.

  VCL20     VCL version 2 (Delphi 2, C++Builder 1).
  VCL30     VCL version 3 (Delphi 3.x).
  VCL35     VCL version 3.5 (C++Builder 3).

  VCL20PLUS VCL version 2.0 or greater.
  VCL30PLUS VCL version 3.0 or greater.
  VCL35PLUS VCL version 3.5 or greater.

  CBUILDER1 C++Builder 1.
  CBUILDER3 C++Builder 3.
  DELPHI2   Delphi 2.
  DELPHI3   Delphi 3.

  INTERFACES
            True if the compiler understands interfaces. ie. The interface
            keyword, automatic reference counting, GUID semantics etc.

  WIDESTRINGS
            True if the WideString type is a heap-allocated, automatically
            freed 2-byte per char string type (like Delphi 3).

  RESOURCESTRINGS
            True if the 'resourcestring' keyword has meaning.
}


// -- CBuilder 1.0 ----------
{$IFDEF VER93}
  {$DEFINE VER9x}
  {$DEFINE CBUILDER}
  {$DEFINE CBUILDER1}
  {$DEFINE VCL20}
  {$DEFINE VCL20PLUS}
{$ENDIF}

// -- CBuilder 3.0 ----------
{$IFDEF VER110}
  {$DEFINE VER11x}
  {$DEFINE CBUILDER}
  {$DEFINE CBUILDER3}
  {$DEFINE INTERFACES}
  {$DEFINE WIDESTRINGS}
  {$DEFINE RESOURCESTRINGS}
  {$DEFINE VCL35}
  {$DEFINE VCL20PLUS}
  {$DEFINE VCL30PLUS}
  {$DEFINE VCL35PLUS}
{$ENDIF}

// -- Delphi 2.0 ------------
{$IFDEF VER90}
  {$DEFINE VER9x}
  {$DEFINE DELPHI}
  {$DEFINE DELPHI2}
  {$DEFINE VCL20}
  {$DEFINE VCL20PLUS}
{$ENDIF}

// -- Delphi 3.0 ------------
{$IFDEF VER100}
  {$DEFINE DELPHI}
  {$DEFINE DELPHI3}
  {$DEFINE VER10x}
  {$DEFINE INTERFACES}
  {$DEFINE WIDESTRINGS}
  {$DEFINE RESOURCESTRINGS}
  {$DEFINE VCL30}
  {$DEFINE VCL20PLUS}
  {$DEFINE VCL30PLUS}
{$ENDIF}

