unit FPTShellLocatorEditor; // Copyright  1996-1998 Plasmatech Software Design. All rights reserved.
{
 Shell Control Pack
 Version 1.3d

 Implements the shell locator property editor.

 History
 ==============================================================
 V1.30d --TBA-- No changes.
 V1.30c 16Mar98 C++Builder 3 support.
 V1.30b  7Feb98 No changes.
 V1.30a  7Jan98 Minor form changes to support new TPTGroup control features.
 V1.30  28Nov97 No changes.
 V1.20b 12Oct97 No changes.
 V1.20a  5Oct97 No changes.
 V1.20   6Sep97 No changes.
 V1.10a  6Jul97 Added NT types to the csidl combobox.
 V1.10  26Jun97 No changes.
 V1.00c 31May97 No changes.
 V1.00b 17May97 Fixed bugs. Delphi 3 support.
 V1.00a  1May97 No changes.
 V1.00  21Apr97 Released version 1.0
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  UPTFrame, StdCtrls, UPTShellControls, UPTSysFolderDlg, FPTOpenDlg,
  FPTFolderBrowseDlg, UPTShellUtils;

type
  TFrmShellLocatorEditor = class(TForm)
    PTGroup1: TPTGroup;
    BrowseBtn: TButton;
    OkBtn: TButton;
    CancelBtn: TButton;
    HelpBtn: TButton;
    UsePidlRdo: TRadioButton;
    DontUseAnythingRdo: TRadioButton;
    ItemTxt: TLabel;
    PTGroup4: TPTGroup;
    UsePathnameRdo: TRadioButton;
    PathNameEdt: TEdit;
    PTSysFolderDlg1: TPTSysFolderDlg;
    UseCSIDLRdo: TRadioButton;
    PTGroup2: TPTGroup;
    ComboBox1: TComboBox;
    PTFolderBrowseDlg1: TPTFolderBrowseDlg;
    procedure HelpBtnClick(Sender: TObject);
    procedure UsePidlRdoClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BrowseBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    mLocator: TPTShellLocator;
    procedure SetLocator( aValue: TPTShellLocator );
  public
    property Locator: TPTShellLocator read mLocator write SetLocator;
  end;

var
  FrmShellLocatorEditor: TFrmShellLocatorEditor;

function GetCSIDLStr( id: TCSIDL ): String;

implementation
uses UPTShell95;
{$R *.DFM}

const HELP_FILENAME = 'PTShCtrl.hlp';

type TItemRec = packed record  s: String;  c: TCSIDL; end;

const g_sItems: array[0..22] of TItemRec = (
                  (s:'csidlDesktop';                    c:csidlDesktop ),
                  (s:'csidlPrograms';                   c:csidlPrograms ),
                  (s:'csidlControls (Control Panel)';   c:csidlControls ),
                  (s:'csidlPrinters';                   c:csidlPrinters ),
                  (s:'csidlPersonal';                   c:csidlPersonal ),
                  (s:'csidlFavorites';                  c:csidlFavorites ),
                  (s:'csidlStartup';                    c:csidlStartup ),
                  (s:'csidlRecent';                     c:csidlRecent ),
                  (s:'csidlSendTo';                     c:csidlSendTo ),
                  (s:'csidlBitBucket (Recyle Bin)';     c:csidlBitBucket ),
                  (s:'csidlStartMenu';                  c:csidlStartMenu ),
                  (s:'csidlDesktopDirectory';           c:csidlDesktopDirectory ),
                  (s:'csidlDrives (My Computer)';       c:csidlDrives ),
                  (s:'csidlNetwork (Net. Neighborhood)'; c:csidlNetwork ),
                  (s:'csidlNethood';                    c:csidlNethood ),
                  (s:'csidlFonts';                      c:csidlFonts ),
                  (s:'csidlTemplates';                  c:csidlTemplates ),
                  (s:'csidlCommonStartMenu';            c:csidlCommonStartMenu ),
                  (s:'csidlCommonPrograms';             c:csidlCommonPrograms ),
                  (s:'csidlCommonStartup';              c:csidlCommonStartup ),
                  (s:'csidlCommonDesktopDirectory';     c:csidlCommonDesktopDirectory ),
                  (s:'csidlAppData';                    c:csidlAppData ),
                  (s:'csidlPrintHood';                  c:csidlPrintHood ) );

procedure TFrmShellLocatorEditor.FormCreate(Sender: TObject);
var i: Integer;
begin
  for i := Low(g_sItems) to High(g_sItems) do
    Combobox1.Items.Add( g_sItems[i].s );
end;

procedure TFrmShellLocatorEditor.SetLocator( aValue: TPTShellLocator );
var i: Integer;
    s: String;
begin
  mLocator := aValue;
  PathNameEdt.Text := mLocator.Pathname;
//  if (i > High(g_sItems)) then Combobox1.ItemIndex := -1;  //?
  if Assigned(mLocator) then
    if (mLocator.CSIDL <> csidlNone) then
    begin
      for i := 0 to High(g_sItems) do
        if g_sItems[i].c = mLocator.CSIDL then
        begin
          Combobox1.ItemIndex := i;
          Break;
        end;
      UseCSIDLRdo.Checked := TRUE
    end
    else if Assigned(mLocator.IdList) then
    begin
      s := mLocator.PathName;
      if (s <> '') then
      begin
        PathNameEdt.Text := s;
        UsePathnameRdo.Checked := TRUE;
      end
      else
      begin
        ItemTxt.Caption := ShellGetFriendlyNameFromIdList( nil, mLocator.IdList, ptfnNormal );
        UsePidlRdo.Checked := TRUE
      end;
    end
    else
      DontUseAnythingRdo.Checked := TRUE;
end; {TFrmShellLocatorEditor.SetLocator}

procedure TFrmShellLocatorEditor.HelpBtnClick(Sender: TObject);
begin
  WinHelp( Handle, HELP_FILENAME, HELP_CONTEXT, 30000 );
end; {TFrmShellLocatorEditor.HelpBtnClick}

procedure TFrmShellLocatorEditor.UsePidlRdoClick(Sender: TObject);
const _VALS: array[Boolean] of TColor = (clBtnFace, clWhite);
var f: Bool;
begin
  f := UsePathnameRdo.Checked;
  PathNameEdt.Enabled := f;
  PathNameEdt.Color := _VALS[f];

  f := UsePidlRdo.Checked;
  BrowseBtn.Enabled := f;
  ItemTxt.Enabled := f;

  f := UseCsidlRdo.Checked;
  Combobox1.Enabled := f;
  Combobox1.Color := _VALS[f];
  if f and (Combobox1.ItemIndex < 0) then
    Combobox1.ItemIndex := 0;
end; {TFrmShellLocatorEditor.UsePidlRdoClick}

procedure TFrmShellLocatorEditor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  if (ModalResult = mrOk) and Assigned(mLocator) then
  begin
    if DontUseAnythingRdo.Checked then
      mLocator.IdList := nil
    else if UsePathnameRdo.Checked then
      mLocator.Pathname := PathNameEdt.Text
    else if UsePidlRdo.Checked then
    begin
      if Assigned(PTFolderBrowseDlg1.SelectedFolder.IdList) then
        mLocator.IdList := PTFolderBrowseDlg1.SelectedFolder.IdList;
    end
    else
      mLocator.CSIDL := g_sItems[Combobox1.ItemIndex].c;
  end;
end; {TFrmShellLocatorEditor.FormClose}

procedure TFrmShellLocatorEditor.BrowseBtnClick(Sender: TObject);
begin
  if PTFolderBrowseDlg1.Execute then
    ItemTxt.Caption := ShellGetFriendlyNameFromIdList( nil, PTFolderBrowseDlg1.SelectedFolder.IdList, ptfnNormal );
end; {TFrmShellLocatorEditor.BrowseBtnClick}


function GetCSIDLStr( id: TCSIDL ): String;
var i: Integer;
begin
  for i := 0 to High(g_sItems) do
    if g_sItems[i].c = id then
    begin
      result := g_sItems[i].s;
      Exit;
    end;
  result := '';
end;

end.

