unit FPTOpenDlg; // Copyright  1996-1998 Plasmatech Software Design. All rights reserved.
{
 Shell Control Pack
 Version 1.3d

 Implements the TPTFrmOpenDlg form and the TPTOpenDlg and TPTSaveDlg components.

 History
 ==============================================================
 V1.30d --TBA-- Added public Form property, giving access to the form object from component events.
                Added OnFormClose, OnFolderChanged, OnSelectionChanged, OnFormShow and OnTypeChanged events.
                Added properties, events and methods to TPTFrmOpenDlg to better support visual inheritance.
                  Reference to the component object is no longer kept in the form object, making visual
                  inheritance and customization a lot easier.
                Changed OnInitialized event. It is now called after the new Form property is initialized.
 V1.30c 16Mar98 Added ptofShowHidden options.
                Added virtual Resize method instead of FormResize event handler.
                C++Builder 3 support.
 V1.30b  7Feb98 Added OnHelp event for Delphi 3 only. The OnHelp event is available in Delphi 2 and C++Builder 1
                  in order to keep .dfm files compatible with Delphi 3, but the event is never invoked.
                Fixed: ptofShowHelp option now works.
                Fixed: When ptofNoValidate is false, the filenames are checked for invalid characters.
 V1.30a  7Jan98 Fixed ptofNoChangeDir. When false, the current directory is now changed.
 V1.30  28Nov97 Added internationalisation support.
 V1.20b 12Oct97 No changes.
 V1.20a  5Oct97 No changes.
 V1.20   6Sep97 Changed FilterIndex from 0 to 1 based to match documentation and TOpenDialog.
                Changes to dfm for TPTSplitter Visual Form Inheritance fix.
                Fixed problem where ptofReadOnly did not reflect the read only checkbox after executing the dialog.
                Fixed problem where OnInitialized property was not being called.
 V1.10a  6Jul97 Fixed problem when using ptofHideFoldersInListWhenTreeVisible option and creating new folders.
                C++ Builder support.
 V1.10  26Jun97 Fixed Access Violation caused when using the (useless) HistoryList property.
                Added popup menu to shell list.
                Added custom draw events for tree and list controls.
 V1.00c 31May97 Minor changes to PTShellList1Change method for extra performance.
                Added ptofHideFoldersInListWhenTreeVisible option.
 V1.00b 17May97 Delphi 3 support.
 V1.00a  1May97 No changes.
 V1.00  21Apr97 Released version 1.0
}
{$RANGECHECKS OFF} {$OVERFLOWCHECKS OFF} {$WRITEABLECONST OFF}
{$BOOLEVAL OFF}    {$EXTENDEDSYNTAX ON}  {$TYPEDADDRESS ON}

{$I PTCompVer.inc}

interface
uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, TypInfo,
     StdCtrls, ComCtrls, Buttons, ExtCtrls, Menus, Ole2,
       UPTShellControls, UPTImageCombo, UPTSplitter, UPTShell95, UPTShellUtils, UPTTreeList, UPTShConsts,
  UPTFrame;

type
  TPTOpenOption = ( ptofAllowMultiselect,
                        { When True, this option allows users to select more than one file in the File Name list view. }
                    ptofCreatePrompt,
                        { When True, this option displays a dialog box with a message if the user enters a filename
                          that doesn't exist in the File Name edit box and chooses OK (Open/Save). The message tells the
                          user the file doesn't exist and asks if the user wants to create a new file with that name. }
                    ptofExtensionDifferent,
                        { This option is set when the filename returned from the dialog box has an extension that
                          differs from the default file extension, the value in the DefaultExt property. Your
                          application can then use this information. Setting an ofExtensionDifferent value with the
                          Object Inspector has no meaning. }
                    ptofFileMustExist,
                        { If True, this option displays a dialog box with a message if the user enters a file that
                          doesn't exist in the File Name edit box and chooses OK. The message informs the user the
                          file can't be found and asks the user to make sure they entered the correct path and filename. }
                    ptofHideReadOnly,
                    ptofNoChangeDir,
                    ptofNoDereferenceLinks,
                        { If True, directs the dialog box to return the path and filename of the selected shortcut
                          (.LNK) file. If this value is not given, the dialog box returns the path and filename of
                          the file referenced by the shortcut. }

                    //ptofNoLongNames,
                    //ptofNoNetworkButton,
                    ptofNoReadOnlyReturn,
                        { If True, a message box appears informing the user if the selected file is read-only. }
                    ptofNoTestFileCreate,
                        { This option applies only when the user wants to save a file on a create-no-modify network
                          share point, which can't be opened again once it has been opened. If ofNoTestFileCreate
                          is True, your application won't check for write protection, a full disk, an open drive door,
                          or network protection when saving the file because doing so creates a test file. Your
                          application will then have to handle file operations carefully so that a file isn't
                          closed until you really want it to be. }
                    ptofNoValidate,
                        { If True, this option doesn't prevent the user from entering invalid characters in a filename.
                          If ofNoValidate is False and the user enters invalid characters for a filename in the File
                          Name edit box, a message dialog box appears informing the user the filename contains
                          invalid characters. }
                    ptofOverwritePrompt,
                        { If True, this option displays a message dialog box if the user attempts to save a file that
                          already exists. The message informs the user the file exists and lets the user choose to
                          overwrite the existing file or not. }
                    ptofReadOnly,
                        { If True, the Read Only check box is checked when the dialog box is displayed. }
                    ptofPathMustExist,
                        { If this option is True, the user can type only existing path names as part of the filename
                          in the File Name edit box. If the user enters a path name that doesn't exist, a message box
                          appears informing the user that the path name is invalid. }
                    ptofShareAware,
                        { If True, the dialog box ignores all sharing errors and returns the name of the selected file
                          even though a sharing violation occurred. If ofShareAware is False, a sharing violation
                          results in a message box informing the user of the problem. }
                    ptofShowHelp,
                        { If True, this option displays a Help button in the dialog box. }
                    ptofAllowTree,  {If True then a "Show Tree" button is placed on the button bar}
                    ptofShowTree,   {If True then shows a tree view to the left of the list view, like a mini-explorer. }
                    ptofShowHints,   {If True then popup hints are enabled}
                    ptofHideFoldersInListWhenTreeVisible,

                    ptofOleDrag,  {True allows Ole drag operations}
                    ptofOleDrop,  {True allows Ole drop operations}

                    ptofShowHidden {If false, then hidden and system files do not appear in the tree or list.}  
                  );
  TPTOpenOptions = set of TPTOpenOption;

const
  DEF_OPEN_OPTIONS = [ptofHideReadOnly, ptofAllowTree, ptofShowHints, ptofOleDrag, ptofOleDrop, ptofShowHidden];
  DEF_SAVE_OPTIONS = [ptofHideReadOnly, ptofAllowTree, ptofShowHints, ptofOleDrag, ptofOleDrop, ptofShowHidden];

type
  TPTDialog = class; // <-- Also used by TPTFolderBrowseDlg, maybe move to another unit...
    TPTFileDlg = class;  // <-- General class, knows about TPTFrmOpenDlg
      TPTCustomOpenDlg = class;
        TPTOpenDlg = class;
      TPTCustomSaveDlg = class;
        TPTSaveDlg = class;
  TPTFrmOpenDlg = class;

{$IFNDEF VCL30PLUS}
  THelpEvent = function (Command: Word; Data: Longint; var CallHelp: Boolean): Boolean of object;
{$ENDIF}

  TPTDialog = class(TComponent)
    private
      mFormWidth, mFormHeight: Integer;
      mWindowState: TWindowState;
      mTitle: String;
      mOnInit: TNotifyEvent;
      mOnFormShow: TNotifyEvent;
      mOnFormClose: TNotifyEvent;
      mfExecuting: Boolean;
    protected
      procedure DoInitialized; dynamic;
      function  DoExecute: Boolean; dynamic; abstract;

      property Executing: Boolean read mfExecuting;
      property Title: String read mTitle write mTitle;
      property FormWidth: Integer read mFormWidth write mFormWidth default -1;
      property FormHeight: Integer read mFormHeight write mFormHeight default -1;
      property FormWindowState: TWindowState read mWindowState write mWindowState default wsNormal;
      property OnInitialized: TNotifyEvent read mOnInit write mOnInit;
      property OnFormClose: TNotifyEvent read mOnFormClose write mOnFormClose;
      property OnFormShow: TNotifyEvent read mOnFormShow write mOnFormShow;
    public
      constructor Create( aOwner: TComponent ); override;

      function  Execute: Boolean;

      procedure ReadStateFromRegistry( baseKey: HKEY;  aSubKeyName, aValueName: String );
      procedure WriteStateToRegistry( baseKey: HKEY;  aSubKeyName, aValueName: String );

      procedure ReadStateFromStream( aStream: TStream ); dynamic;
      procedure WriteStateToStream( aStream: TStream ); dynamic;
    published
  end; {TPTDialog}


  TPTFileDlg = class(TPTDialog)
    private
      mHistoryList: TStrings;
      mOptions: TPTOpenOptions;
      mDefaultExt: String;
      mFiles: TStrings;
      mFilter: String;
      mFilterIndex: Integer;
      mHelpContext: THelpContext;
      mInitialDir: String;
      mFormSplitterPos: Integer;
      mOnAddListItemProc, mOnAddTreeItemProc, mOnAddComboItemProc: TPTShAddItemEvent;
      mOnFolderChanged, mOnSelectionChanged, mOnTypeChanged: TNotifyEvent;

      mOnLvCustomDrawShProc: TPTShLvCustomDrawEvent;
      mOnLvCustomDrawShExProc: TPTShLvCustomDrawEvent;

      mOnTvCustomDrawShProc: TPTShTvCustomDrawEvent;
      mOnTvCustomDrawShExProc: TPTShTvCustomDrawEvent;

      mOnHelp: THelpEvent;

      function  GetFilename: String;
      function  GetFilterIndex: Integer;
      procedure SetFilename( aValue: String );
      procedure SetOptions( aValue: TPTOpenOptions );
      procedure SetFilter( aValue: String );
      procedure SetFilterIndex( aValue: Integer );
      procedure SetFormSplitterPos( aValue: Integer );
      procedure SetOnAddListItem(aValue: TPTShAddItemEvent);
      procedure SetOnAddTreeItem(aValue: TPTShAddItemEvent);
      procedure SetOnAddComboItem(aValue: TPTShAddItemEvent);
      procedure SetHistoryList(aValue: TStrings);
    protected
      mForm: TPTFrmOpenDlg; // Valid TPTFrmOpenDlg form during a call to Execute

      function  DoExecute: Boolean; override;
      function  CreateForm: TPTFrmOpenDlg; dynamic;
      procedure InitForm( aForm: TPTFrmOpenDlg ); dynamic;
      procedure SaveFormSettings( aForm: TPTFrmOpenDlg ); dynamic;

      property Form: TPTFrmOpenDlg read mForm;
      property DefaultExt: String read mDefaultExt write mDefaultExt;
      property Options: TPTOpenOptions read mOptions write SetOptions;
      property FileName: String read GetFilename write SetFilename;
      property Files: TStrings read mFiles;
      property Filter: String read mFilter write SetFilter;
      property FilterIndex: Integer read GetFilterIndex write SetFilterIndex default 1;
      property FormSplitterPos: Integer read mFormSplitterPos write SetFormSplitterPos default -1;
      property HelpContext: THelpContext read mHelpContext write mHelpContext default 0;
      property HistoryList: TStrings read mHistoryList write SetHistoryList stored FALSE;
      property InitialDir: String read mInitialDir write mInitialDir;
      property OnAddListItem: TPTShAddItemEvent read mOnAddListItemProc write SetOnAddListItem;
      property OnAddTreeItem: TPTShAddItemEvent read mOnAddTreeItemProc write SetOnAddTreeItem;
      property OnAddComboItem: TPTShAddItemEvent read mOnAddComboItemProc write SetOnAddComboItem;
      property OnLvCustomDrawSh: TPTShLvCustomDrawEvent read mOnLvCustomDrawShProc write mOnLvCustomDrawShProc;
      property OnLvCustomDrawShEx: TPTShLvCustomDrawEvent read mOnLvCustomDrawShExProc write mOnLvCustomDrawShExProc;
      property OnTvCustomDrawSh: TPTShTvCustomDrawEvent read mOnTvCustomDrawShProc write mOnTvCustomDrawShProc;
      property OnTvCustomDrawShEx: TPTShTvCustomDrawEvent read mOnTvCustomDrawShExProc write mOnTvCustomDrawShExProc;
      property OnHelp: THelpEvent read mOnHelp write mOnHelp;
      property OnFolderChanged: TNotifyEvent read mOnFolderChanged write mOnFolderChanged;
      property OnSelectionChanged: TNotifyEvent read mOnSelectionChanged write mOnSelectionChanged;
      property OnTypeChanged: TNotifyEvent read mOnTypeChanged write mOnTypeChanged;
    public
      constructor Create( aOwner: TComponent ); override;
      destructor  Destroy; override;

      procedure ReadStateFromStream( aStream: TStream ); override;
      procedure WriteStateToStream( aStream: TStream ); override;

    published
  end; {TPTFileDlg}


  TPTCustomOpenDlg = class(TPTFileDlg)
    protected
      procedure InitForm( aForm: TPTFrmOpenDlg ); override;
    public
      constructor Create( aOwner: TComponent ); override;
  end; {TPTCustomOpenDlg}


  TPTOpenDlg = class(TPTCustomOpenDlg)
    public
      property Executing;
      property FileName;
      property Files;
      property Form;
    published
      property Title;
      property Options default DEF_OPEN_OPTIONS;
      property Filter;
      property FilterIndex;
      property FormWidth;
      property FormHeight;
      property FormWindowState;
      property FormSplitterPos;
      property HelpContext;
      property HistoryList;
      property InitialDir;

      property DefaultExt;

      property OnAddListItem;
      property OnAddTreeItem;
      property OnAddComboItem;
      property OnInitialized;

      property OnLvCustomDrawSh;
      property OnLvCustomDrawShEx;
      property OnTvCustomDrawSh;
      property OnTvCustomDrawShEx;

      property OnHelp;

      property OnFormClose;
      property OnFormShow;
      property OnFolderChanged;
      property OnSelectionChanged;
      property OnTypeChanged;
  end; {TPTOpenDlg}



  TPTCustomSaveDlg = class(TPTFileDlg)
    protected
      procedure InitForm( aForm: TPTFrmOpenDlg ); override;
    public
      constructor Create( aOwner: TComponent ); override;
  end; {TPTCustomSaveDlg}


  TPTSaveDlg = class(TPTCustomSaveDlg)
    public
      property Executing;
      property FileName;
      property Files;
      property Form;
    published
      property DefaultExt;

      property Title;
      property Options default DEF_SAVE_OPTIONS;
      property Filter;
      property FilterIndex;
      property FormWidth;
      property FormHeight;
      property FormWindowState;
      property FormSplitterPos;
      property HelpContext;
      property HistoryList;
      property InitialDir;

      property OnAddListItem;
      property OnAddTreeItem;
      property OnAddComboItem;
      property OnInitialized;

      property OnLvCustomDrawSh;
      property OnLvCustomDrawShEx;
      property OnTvCustomDrawSh;
      property OnTvCustomDrawShEx;

      property OnHelp;

      property OnFormClose;
      property OnFormShow;
      property OnFolderChanged;
      property OnSelectionChanged;
      property OnTypeChanged;
  end; {TPTSaveDlg}

  TPTFrmOpenDlg_LIS = (lisEdit, lisList); // C++ Builder demands formal type decl for enumerations.
  TPTFrmOpenDlg = class(TForm)
    LookInTxt: TLabel;
    PTShellCombo1: TPTShellCombo;
    UpOneLevelBtn: TSpeedButton;
    ListBtn: TSpeedButton;
    DetailsBtn: TSpeedButton;
    CreateNewFolderBtn: TSpeedButton;
    Panel1: TPanel;
    FileNameTxt: TLabel;
    FilesOfTypeTxt: TLabel;
    FileTypesCbx: TPTCombobox;
    FileNameEdt: TEdit;
    OpenBtn: TButton;
    CancelBtn: TButton;
    FileNameCbx: TComboBox;
    PTSplitter1: TPTSplitter;
    PTShellList1: TPTShellList;
    PTShellTree1: TPTShellTree;
    ReadOnlyChk: TCheckBox;
    ShowTreeBtn: TSpeedButton;
    HelpBtn: TButton;
    LvPopup: TPopupMenu;
    View1Mitm: TMenuItem;
    N1: TMenuItem;
    New1Mitm: TMenuItem;
    N2: TMenuItem;
    Properties1Mitm: TMenuItem;
    Folder1Mitm: TMenuItem;
    LargeIcons1Mitm: TMenuItem;
    Smallicons1MItm: TMenuItem;
    List1Mitm: TMenuItem;
    Details1Mitm: TMenuItem;
    Paste1Mitm: TMenuItem;
    N3: TMenuItem;
    SplitterContainer: TPTGroup;
    procedure ViewBtnClick(Sender: TObject);
    procedure PTShellList1Change(Sender: TObject; Item: TListItem; Change: TItemChange);
    procedure UpOneLevelBtnClick(Sender: TObject);
    procedure ShowTreeBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure PTShellTree1Change(Sender: TObject; Node: TTreeNode);
    procedure FileTypesCbxSelEndOk(Sender: TObject);
    procedure CreateNewFolderBtnClick(Sender: TObject);
    procedure FileNameEdtChange(Sender: TObject);
    procedure Paste1MitmClick(Sender: TObject);
    procedure Properties1MitmClick(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    procedure ReadOnlyChkClick(Sender: TObject);
    procedure PTShellList1FolderChanged(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
{$IFDEF VCL30PLUS}
    function FormHelp(Command: Word; Data: Integer; var CallHelp: Boolean): Boolean;
{$ENDIF}
    procedure ListDblClickOpen(aSender: TObject;  var afHandled: Boolean);
    procedure WMGetMinMaxInfo( var aMsg: TWMGetMinMaxInfo ); message WM_GETMINMAXINFO;

  protected
  //-- Property helpers and vars --
    mDefaultExt: String;
    mOptions: TPTOpenOptions;
    mFiles: TStrings;  // Last request for 'files'
    mFilter: String;
    mInitialDir: String;

    mOnTypeChanged: TNotifyEvent;
    mOnFolderChanged: TNotifyEvent;
    mOnSelectionChanged: TNotifyEvent;
    mOnFormShow: TNotifyEvent;
    mOnFormClose: TNotifyEvent;
{$IFNDEF VCL30PLUS}
    mOnHelp: THelpEvent;
{$ENDIF}
    mOnFormHelp: THelpEvent;

    procedure DoOnFormClose; dynamic;
    procedure DoOnFolderChanged; dynamic;
    procedure DoOnSelectionChanged; dynamic;
    procedure DoOnFormShow; dynamic;
    procedure DoOnTypeChanged; dynamic;

    function  GetFilename: String;
    function  GetFiles: TStrings;
    function  GetFilterIndex: Integer;
    function  GetFormSplitterPos: Integer;
    function  GetOnAddListItem: TPTShAddItemEvent;
    function  GetOnAddTreeItem: TPTShAddItemEvent;
    function  GetOnAddComboItem: TPTShAddItemEvent;
    function  GetOnLvCustomDrawSh: TPTShLvCustomDrawEvent;
    function  GetOnLvCustomDrawShEx: TPTShLvCustomDrawEvent;
    function  GetOnTvCustomDrawSh: TPTShTvCustomDrawEvent;
    function  GetOnTvCustomDrawShEx: TPTShTvCustomDrawEvent;

    procedure SetFilename( aValue: String );
    procedure SetFilter( aValue: String );
    procedure SetFilterIndex( aValue: Integer );
    procedure SetFormSplitterPos( aValue: Integer );
    procedure SetInitialDir( aValue: String );
    procedure SetOptions( aValue: TPTOpenOptions );
    procedure SetOnAddListItem( aValue: TPTShAddItemEvent );
    procedure SetOnAddTreeItem( aValue: TPTShAddItemEvent );
    procedure SetOnAddComboItem( aValue: TPTShAddItemEvent );
    procedure SetOnLvCustomDrawSh( aValue: TPTShLvCustomDrawEvent );
    procedure SetOnLvCustomDrawShEx( aValue: TPTShLvCustomDrawEvent );
    procedure SetOnTvCustomDrawSh( aValue: TPTShTvCustomDrawEvent );
    procedure SetOnTvCustomDrawShEx( aValue: TPTShTvCustomDrawEvent );

  protected
    mUserFilter: String; // Used for filters typed into the filename box
    mExecuting: Boolean;

    mSelections: TStrings;
    mLastInputState: TPTFrmOpenDlg_LIS;

    procedure DoTranslation; dynamic;
    procedure ApplyUserFilter( aFilter: String );
    procedure GetSelectedFiles( s: TStrings );
    procedure ShowTree( aShow: Boolean );

    procedure DoHide; override;
    procedure DoShow; override;
  public
    constructor Create( aOwner: TComponent ); override;
    destructor Destroy; override;
    function  ParseInputString( const ins: String ): Boolean;

    property DefaultExt: String read mDefaultExt write mDefaultExt;
    property Executing: Boolean read mExecuting;
    property Options: TPTOpenOptions read mOptions write SetOptions;
    property FileName: String read GetFilename write SetFilename;
    property Files: TStrings read GetFiles;
    property Filter: String read mFilter write SetFilter;
    property FilterIndex: Integer read GetFilterIndex write SetFilterIndex default 1; // Does default count in this situation?
    property FormSplitterPos: Integer read GetFormSplitterPos write SetFormSplitterPos default -1; // Does default count in this situation?
    property HelpContext;
//    property HistoryList: TStrings read mHistoryList write SetHistoryList stored FALSE;
    property InitialDir: String read mInitialDir write SetInitialDir;
    property OnAddListItem: TPTShAddItemEvent read GetOnAddListItem write SetOnAddListItem;
    property OnAddTreeItem: TPTShAddItemEvent read GetOnAddTreeItem write SetOnAddTreeItem;
    property OnAddComboItem: TPTShAddItemEvent read GetOnAddComboItem write SetOnAddComboItem;
    property OnLvCustomDrawSh: TPTShLvCustomDrawEvent read GetOnLvCustomDrawSh write SetOnLvCustomDrawSh;
    property OnLvCustomDrawShEx: TPTShLvCustomDrawEvent read GetOnLvCustomDrawShEx write SetOnLvCustomDrawShEx;
    property OnTvCustomDrawSh: TPTShTvCustomDrawEvent read GetOnTvCustomDrawSh write SetOnTvCustomDrawSh;
    property OnTvCustomDrawShEx: TPTShTvCustomDrawEvent read GetOnTvCustomDrawShEx write SetOnTvCustomDrawShEx;
{$IFDEF VCL30PLUS}
    property OnHelp;
{$ELSE}
    property OnHelp: THelpEvent read mOnHelp write mOnHelp;
{$ENDIF}
    property OnFormHelp: THelpEvent read mOnFormHelp write mOnFormHelp;
    property OnFormClose: TNotifyEvent read mOnFormClose write mOnFormClose;
    property OnFormShow: TNotifyEvent read mOnFormShow write mOnFormShow;
    property OnFolderChanged: TNotifyEvent read mOnFolderChanged write mOnFolderChanged;
    property OnSelectionChanged: TNotifyEvent read mOnSelectionChanged write mOnSelectionChanged;
    property OnTypeChanged: TNotifyEvent read mOnTypeChanged write mOnTypeChanged;
  end;

var
  PTFrmOpenDlg: TPTFrmOpenDlg;

implementation
uses Registry;
{$R *.DFM}

{-- Local Utilities ------------------}
procedure GetWndRestoreRect( h: HWND;  var r: TRect );
var wp: TWindowPlacement;
begin
  wp.length := Sizeof(TWindowPlacement);
  Windows.GetWindowPlacement( h, @wp );
  r := wp.rcNormalPosition;
end;


{The list of filter strings is thus:
  [Visible][TStringList of extensions:[]]
  ---------------------------------------
  [Item1 (*.*)][ [*.*] ]
  [Item2 (*.doc)][ [*.doc] ]
  [Item3 (*.gif, *.jpg, *.bmp)][ [*.gif][*.jpg][*.bmp] ]
}

type TFilterItemRec = record
       mExtension: String;
     end;
     PFilterItemRec = ^TFilterItemRec;

function NewFilterItemRec: PFilterItemRec;
begin
  New(result);
end;

procedure DisposeFilterItemRec( pfir: PFilterItemRec );
begin
  Dispose(pfir);
end;

procedure GetCharsUpToNextCharDB( var aPos: Integer;  aSource: String;  var aDest: String;  aCharToFind: Char );
begin
  aDest := '';
  while (aSource[aPos] <> aCharToFind) and (aPos <= Length(aSource)) do
    CopyCharDB(aPos, aSource, aDest);
end; {GetCharsUpToNextChar}

{ Takes a filter in the form "FileType1|*.ext11;*.ext12;*.ext1n|FileType2|*.ext21|" etc.
  and fills aStrings.Strings[] with the FileType part and the .Objects[] part with a TFilterItemRec.
  The TFilterItemRec comprises a TStringList itself which is a list of all the extensions
  eg. [*.ext11][*.ext12][*.ext1n]. The ExtensionsToTStrings method takes a semi-colon delimited list of
  extensions and adds them to a TStrings. }
procedure FilterToTStrings( aFilter: String;  aStrings: TStrings );
var pos: Integer;
    tmp: String;

    displayName: String;
    extensions: String;  // All extensions (*.gif;*.jpg;*.bmp;etc...)

var p: PFilterItemRec;
begin
  pos := 1;
  SetLength(tmp, 255); tmp:='';  // Allocate some space now to prevent reallocations
  while (pos <= Length(aFilter)) do
  begin
   // Get all chars up to '|' character
    GetCharsUpToNextCharDB(pos, aFilter, displayName, '|'); Inc( pos ); // skip bar
    GetCharsUpToNextCharDB(pos, aFilter, extensions, '|');  Inc( pos ); // skip bar
    p := NewFilterItemRec;
    p.mExtension := extensions;
    aStrings.AddObject( displayName, TObject(p) );
  end;
end; {FilterToTStrings}

procedure FilterStringsFree( aStrings: TStrings );
var i: Integer;
begin
  for i := 0 to aStrings.Count-1 do
    DisposeFilterItemRec(Pointer(aStrings.Objects[i]));
end; {FilterStringsFree}

{== END Local Utilities ==============}

type TMemoryStream2 = class(TMemoryStream)
       public
         property Capacity;  // Why wasn't this public to start with???
     end;

{**************************************
  TPTDialog
**************************************}
constructor TPTDialog.Create( aOwner: TComponent );
begin
  inherited;
  mFormWidth := -1;
  mFormHeight := -1;
  mWindowState := wsNormal;
end;

procedure TPTDialog.DoInitialized;
  begin  if Assigned(OnInitialized) then OnInitialized(self); end;


procedure TPTDialog.ReadStateFromRegistry( baseKey: HKEY;  aSubKeyName, aValueName: String );
var r: TRegistry;
    ms: TMemoryStream2;
begin
  r := TRegistry.Create;
  ms := TMemoryStream2.Create;
  ms.Capacity := 128;
  try
    r.RootKey := baseKey;
    r.OpenKey( aSubKeyName, FALSE );
    ms.Capacity := r.ReadBinaryData( aValueName, ms.Memory^, ms.Capacity );
    ms.Position := 0;
    ReadStateFromStream( ms );
    r.CloseKey;
  finally
    ms.Free;
    r.Free;
  end;
end; {TPTDialog.ReadStateFromRegistry}

procedure TPTDialog.WriteStateToRegistry( baseKey: HKEY;  aSubKeyName, aValueName: String );
var r: TRegistry;
    ms: TMemoryStream;
begin
  r := TRegistry.Create;
  ms := TMemoryStream.Create;
  try
    r.RootKey := baseKey;
    r.OpenKey( aSubKeyName, TRUE );
    WriteStateToStream( ms );
    r.WriteBinaryData( aValueName, ms.Memory^, ms.Size );
    r.CloseKey;
  finally
    ms.Free;
    r.Free;
  end;
end; {TPTDialog.WriteStateToRegistry}

procedure TPTDialog.ReadStateFromStream( aStream: TStream );
begin
  aStream.ReadBuffer( mFormWidth, Sizeof(Integer) );
  aStream.ReadBuffer( mFormHeight, Sizeof(Integer) );
  aStream.ReadBuffer( mWindowState, Sizeof(TWindowState) );
end; {TPTDialog.ReadStateFromStream}

procedure TPTDialog.WriteStateToStream( aStream: TStream );
begin
  aStream.WriteBuffer( mFormWidth, Sizeof(Integer) );
  aStream.WriteBuffer( mFormHeight, Sizeof(Integer) );
  aStream.WriteBuffer( mWindowState, Sizeof(TWindowState) );
end; {TPTDialog.WriteStateToStream}

function TPTDialog.Execute: Boolean;
begin
  if mfExecuting then raise Exception.Create( ClassName + ' already executing' );
  mfExecuting := TRUE;
  try
    result := DoExecute;
  finally
    mfExecuting := FALSE;
  end;
end; {TPTDialog.Execute}



{**************************************
  TPTFileDlg
**************************************}
constructor TPTFileDlg.Create( aOwner: TComponent );
begin
  inherited;
  mFormSplitterPos := -1;
  mFilterIndex := 1;
  mFiles := TStringList.Create;
  mHistoryList := TStringList.Create;
end; {TPTFileDlg.Create}

destructor TPTFileDlg.Destroy;
begin
  mFiles.Free;
  mHistoryList.Free;
  inherited;
end;

function TPTFileDlg.CreateForm: TPTFrmOpenDlg;
begin
  result := TPTFrmOpenDlg.Create( Application );
end;

function TPTFileDlg.DoExecute: Boolean;
var
  c: TCursor;
  f: TPTFrmOpenDlg;
begin
  if Assigned(mForm) then raise Exception.Create( Format('%s already executing', [Name]) );
  c := Screen.Cursor; Screen.Cursor := crHourglass;
  f:=nil;
  try
    if (csDesigning in ComponentState) then
      mFiles.Clear;

    f := CreateForm;
    InitForm(f);
    mForm := f;
    f:=nil;

    DoInitialized;

    result := (mForm.ShowModal = mrOk);

    SaveFormSettings( mForm );
  finally
    mForm.Free;
    mForm := nil;
    Screen.Cursor := c;
    f.Free;
  end;
end;

procedure TPTFileDlg.ReadStateFromStream( aStream: TStream );
var f: Boolean;
begin
  inherited;
  aStream.ReadBuffer( f, Sizeof(Boolean) );
  if (f) then Include(mOptions, ptofShowTree) else Exclude(mOptions, ptofShowTree);
  aStream.ReadBuffer( mFormSplitterPos, Sizeof(Integer) );
end;


procedure TPTFileDlg.WriteStateToStream( aStream: TStream );
var f: Boolean;
begin
  inherited;
  f := (ptofShowTree in mOptions);
  aStream.WriteBuffer( f, Sizeof(Boolean) );
  aStream.WriteBuffer( mFormSplitterPos, Sizeof(mFormSplitterPos) );
end;

function TPTFileDlg.GetFilename: String;
begin
  if Assigned(mForm) then
    result := mForm.FileName
  else
    if mFiles.Count>0 then
      result := mFiles[0]
    else
      result := '';
end;

function TPTFileDlg.GetFilterIndex: Integer;
begin
  if Assigned(mForm) then
    result := mForm.FilterIndex
  else
    result := mFilterIndex;
end;

procedure TPTFileDlg.SetFilename( aValue: String );
begin
  mFiles.Clear;
  mFiles.Add( aValue );
  if Assigned(mForm) then
    mForm.Filename := aValue;
end;

procedure TPTFileDlg.SetOptions( aValue: TPTOpenOptions );
begin
  mOptions := aValue;
  if Assigned(mForm) then
    mForm.Options := aValue;
end;

procedure TPTFileDlg.SetFilter( aValue: String );
begin
  mFilter := aValue;
  if Assigned(mForm) then
    mForm.Filter := aValue;
end;

procedure TPTFileDlg.SetFilterIndex( aValue: Integer );
begin
  mFilterIndex := aValue;
  if Assigned(mForm) then
    mForm.FilterIndex := aValue;
end;

procedure TPTFileDlg.SetFormSplitterPos( aValue: Integer );
begin
  mFormSplitterPos := aValue;
  if Assigned(mForm) then
    mForm.FormSplitterPos := aValue;
end;

procedure TPTFileDlg.SetHistoryList( aValue: TStrings );
  begin mHistoryList.Assign( aValue ); end;

procedure TPTFileDlg.InitForm( aForm: TPTFrmOpenDlg );
begin
  aForm.OnAddListItem := OnAddListItem;
  aForm.OnAddTreeItem := OnAddTreeItem;
  aForm.OnAddListItem := OnAddComboItem;
  aForm.OnLvCustomDrawSh := OnLvCustomDrawSh;
  aForm.OnLvCustomDrawShEx := OnLvCustomDrawShEx;
  aForm.OnTvCustomDrawSh := OnTvCustomDrawSh;
  aForm.OnTvCustomDrawShEx := OnTvCustomDrawShEx;

  aForm.OnFormClose := OnFormClose;
  aForm.OnFormShow := OnFormShow;
  aForm.OnTypeChanged := OnTypeChanged;
  aForm.OnFolderChanged := OnFolderChanged;
  aForm.OnSelectionChanged := OnSelectionChanged;

  aForm.InitialDir := InitialDir;
  aForm.FileName := FileName; // Don't use 'self.FileName' here

  aForm.Options := Options;
  if (FormWidth > 0) then aForm.Width := FormWidth;
  if (FormHeight > 0) then aForm.Height := FormHeight;
  aForm.WindowState := FormWindowState;

  aForm.Filter := Filter;
  aForm.FilterIndex := FilterIndex;
  aForm.FormSplitterPos := FormSplitterPos;

  aForm.LookInTxt.Caption := PTLoadStr(SLookIn);
  aForm.FilesOfTypeTxt.Caption := PTLoadStr(SFilesOfType);
  aForm.OpenBtn.Caption := PTLoadStr(SOpenButton);
  aForm.HelpContext := HelpContext;
  aForm.OnFormHelp := OnHelp;
end;

procedure TPTFileDlg.SaveFormSettings( aForm: TPTFrmOpenDlg );
var
  tmpr: TRect;
begin
  Options := aForm.Options;
  Files.Assign( aForm.Files );

  GetWndRestoreRect( aForm.Handle, tmpr );
  FormWidth := tmpr.right - tmpr.left;
  FormHeight := tmpr.bottom - tmpr.top;
  FormWindowState := aForm.WindowState;

  FilterIndex := mForm.FilterIndex;
  FormSplitterPos := mForm.FormSplitterPos;
end;

procedure TPTFileDlg.SetOnAddListItem(aValue: TPTShAddItemEvent);
begin
  mOnAddListItemProc := aValue;
  if Assigned(mForm) then
    mForm.OnAddListItem := aValue;
end;

procedure TPTFileDlg.SetOnAddTreeItem(aValue: TPTShAddItemEvent);
begin
  mOnAddTreeItemProc := aValue;
  if Assigned(mForm) then
    mForm.OnAddTreeItem := aValue;
end;

procedure TPTFileDlg.SetOnAddComboItem(aValue: TPTShAddItemEvent);
begin
  mOnAddComboItemProc := aValue;
//  if Assigned(mForm) then mForm.PTShellTree1.OnAddItem := aValue;
end;


{**************************************
  TPTCustomOpenDlg
**************************************}
constructor TPTCustomOpenDlg.Create( aOwner: TComponent );
begin
  inherited;
  mOptions := DEF_OPEN_OPTIONS;
end; {TPTOpenDlg.Create}

procedure TPTCustomOpenDlg.InitForm( aForm: TPTFrmOpenDlg );
begin
  inherited;

  if (Title = '') then
    aForm.Caption := PTLoadStr(SOpenCaption)
  else
    aForm.Caption := Title;
end;


{**************************************
  TPTCustomSaveDlg
**************************************}
constructor TPTCustomSaveDlg.Create( aOwner: TComponent );
begin
  inherited Create( aOwner );
  mOptions := DEF_SAVE_OPTIONS;
end; {TPTSaveDlg.Create}

procedure TPTCustomSaveDlg.InitForm( aForm: TPTFrmOpenDlg );
begin
  inherited;
  if (Title = '') then
    aForm.Caption := PTLoadStr(SSaveAsCaption)
  else
    aForm.Caption := Title;
end;


{**************************************
  TPTFrmOpenDlg
**************************************}
constructor TPTFrmOpenDlg.Create( aOwner: TComponent );
begin
  inherited;
  mFiles := TStringList.Create;
  mSelections := TStringList.Create;
  PTShellList1.OnDblClickOpen := ListDblClickOpen;
{$IFDEF VCL30PLUS}
  OnHelp := FormHelp;
{$ENDIF}
end;

procedure TPTFrmOpenDlg.DoTranslation;
  function IMax( a, b: Integer ): Integer; begin if (a>b) then result := a else result := b; end;
var x: Integer;
begin
  Font.Name := PTLoadStr(SDialogFontName);

  CancelBtn.Caption := PTLoadStr(SCancelButton);
  HelpBtn.Caption := PTLoadStr(SHelpButton);
  UpOneLevelBtn.Hint := PTLoadStr(SUpOneLevelHint);
  CreateNewFolderBtn.Hint := PTLoadStr(SCreateNewFolderHint);

  ListBtn.Hint := PTLoadStr(SViewListHint) + '|' + PTLoadStr(SViewListContext);
  DetailsBtn.Hint := PTLoadStr(SViewDetailsHint) + '|' + PTLoadStr(SViewDetailsContext);

  ReadOnlyChk.Caption := PTLoadStr(SOpenAsReadOnly);
  FileNameTxt.Caption := PTLoadStr(SFileName);
  ShowTreeBtn.Hint := PTLoadStr(SShowTreeHint);

  {It is the responsibility of the caller to translate LookInTxt, FilesOfTypesTxt, OpenBtn and the
   form's title itself.}
  View1Mitm.Caption := PTLoadStr(SViewMenu);                   View1Mitm.Hint := PTLoadStr(SViewContext);

  LargeIcons1Mitm.Caption := PTLoadStr(SViewLargeIconsMenu);   LargeIcons1Mitm.Hint := PTLoadStr(SViewLargeIconsContext);
  SmallIcons1Mitm.Caption := PTLoadStr(SViewSmallIconsMenu);   SmallIcons1Mitm.Hint := PTLoadStr(SViewSmallIconsContext);
  List1Mitm.Caption := PTLoadStr(SViewListMenu);               List1Mitm.Hint := PTLoadStr(SViewListContext);
  Details1Mitm.Caption := PTLoadStr(SViewDetailsMenu);         Details1Mitm.Hint := PTLoadStr(SViewDetailsContext);

  Paste1Mitm.Caption := PTLoadStr(SEditPasteMenu);             Paste1Mitm.Hint := PTLoadStr(SPasteContext);

  New1Mitm.Caption := PTLoadStr(SNewMenu);                     New1Mitm.Hint := PTLoadStr(SNewPopupContext);
  Folder1Mitm.Caption := PTLoadStr(SNewFolderMenu);            Folder1Mitm.Hint := PTLoadStr(SCreateFolderContext);

  Properties1Mitm.Caption := PTLoadStr(SPropertiesMenu);       Properties1Mitm.Hint := PTLoadStr(SPropertiesContext);

 // Adjust controls for different language text lengths
  x := IMax( FilesOfTypeTxt.BoundsRect.Right, FileNameTxt.BoundsRect.Right ) + 8;

  with FileTypesCbx.BoundsRect do FileTypesCbx.BoundsRect := Rect( x, Top, Right, Bottom );
  with FileNameEdt.BoundsRect do  FileNameEdt.BoundsRect := Rect( x, Top, Right, Bottom );
  with ReadOnlyChk.BoundsRect do  ReadOnlyChk.BoundsRect := Rect( x, Top, Right, Bottom );

  x := LookInTxt.BoundsRect.Right + 8;
  with PTShellCombo1.BoundsRect do PTShellCombo1.BoundsRect := Rect( x, Top, Right, Bottom );
end; {TPTFrmOpenDlg.DoTranslation}

destructor TPTFrmOpenDlg.Destroy;
begin
  mSelections.Free;
  mFiles.Free;
  inherited;
end; {TPTFrmOpenDlg.Destroy}

{ Respond to view menu or view button click. Update state of menu and buttons so they remain synchronised. }
procedure TPTFrmOpenDlg.ViewBtnClick(Sender: TObject);
var tag: Integer;
  procedure CheckItems( a: array of TComponent;  prop: ShortString );
  var i: Integer;
  begin
    for i := Low(a) to High(a) do
      SetOrdProp( a[i], GetPropInfo(a[i].ClassInfo, prop), Integer(a[i].Tag=tag) );
  end;
begin
  tag := (sender as TComponent).Tag;
  PTShellList1.ViewStyle := TViewStyle(tag);
  CheckItems( [ListBtn, DetailsBtn], 'Down' );
  CheckItems( [LargeIcons1Mitm, SmallIcons1Mitm, List1Mitm, Details1Mitm], 'Checked' );
end;

procedure TPTFrmOpenDlg.ListDblClickOpen(aSender: TObject;  var afHandled: Boolean);
begin
  ModalResult := mrOk;
  afHandled := TRUE;
end;

procedure TPTFrmOpenDlg.WMGetMinMaxInfo( var aMsg: TWMGetMinMaxInfo );
  begin aMsg.minMaxInfo.ptMinTrackSize := Point(459,274); end;

procedure TPTFrmOpenDlg.DoOnFormClose;
begin
  if Assigned(mOnFormClose) then
    OnFormClose(self);
end;

procedure TPTFrmOpenDlg.DoOnFolderChanged;
begin
  if Assigned(mOnFolderChanged) then
    OnFolderChanged(self);
end;

procedure TPTFrmOpenDlg.DoOnSelectionChanged;
begin
  if Assigned(mOnSelectionChanged) then
    OnSelectionChanged(self);
end;

procedure TPTFrmOpenDlg.DoOnFormShow;
begin
  if Assigned(mOnFormShow) then
    OnFormShow(self);
end;

procedure TPTFrmOpenDlg.DoOnTypeChanged;
begin
  if Assigned(mOnTypeChanged) then
    OnTypeChanged(self);
end;

function TPTFrmOpenDlg.GetFilename: String;
begin
  if Executing then
  begin
    GetSelectedFiles( mFiles );
    if mFiles.Count>0 then
      result := mFiles[0]
    else
      result := '';
  end
  else
    result := FileNameEdt.Text;
end;

function TPTFrmOpenDlg.GetFiles: TStrings;
begin
  GetSelectedFiles( mFiles );
  result := mFiles;
end;

function TPTFrmOpenDlg.GetFilterIndex: Integer;
begin
  if FileTypesCbx.Items.Count>0 then
    result := FileTypesCbx.ItemIndex + 1
  else
    result := 0;
end;

function TPTFrmOpenDlg.GetFormSplitterPos: Integer;
begin
  result := PTSplitter1.Position;
end;

function TPTFrmOpenDlg.GetOnAddListItem: TPTShAddItemEvent;  begin result := PTShellList1.OnAddItem; end;
function TPTFrmOpenDlg.GetOnAddTreeItem: TPTShAddItemEvent;  begin result := PTShellTree1.OnAddItem; end;
function TPTFrmOpenDlg.GetOnAddComboItem: TPTShAddItemEvent; begin {result := PTShellCombo1.OnAddItem;} end;

function TPTFrmOpenDlg.GetOnLvCustomDrawSh: TPTShLvCustomDrawEvent;    begin result := PTShellList1.OnCustomDrawSh; end;
function TPTFrmOpenDlg.GetOnLvCustomDrawShEx: TPTShLvCustomDrawEvent;  begin result := PTShellList1.OnCustomDrawShEx; end;
function TPTFrmOpenDlg.GetOnTvCustomDrawSh: TPTShTvCustomDrawEvent;    begin result := PTShellTree1.OnCustomDrawSh; end;
function TPTFrmOpenDlg.GetOnTvCustomDrawShEx: TPTShTvCustomDrawEvent;  begin result := PTShellTree1.OnCustomDrawShEx; end;

procedure TPTFrmOpenDlg.SetFilename( aValue: String );
begin
  FileNameEdt.Text := aValue;
end;

procedure TPTFrmOpenDlg.SetFilter( aValue: String );
begin
  mFilter := aValue;
  FilterToTStrings( mFilter, FileTypesCbx.Items );
end;

procedure TPTFrmOpenDlg.SetFilterIndex( aValue: Integer );
begin
  if (aValue>=1) and (aValue <= FileTypesCbx.Items.Count) then
  begin
    FileTypesCbx.ItemIndex := aValue-1;
    FileTypesCbxSelEndOk(self);
  end
  else if FileTypesCbx.Items.Count>0 then
    FileTypesCbx.ItemIndex := 0;
end;

procedure TPTFrmOpenDlg.SetFormSplitterPos( aValue: Integer );
begin
  PTSplitter1.Position := aValue;
end;

procedure TPTFrmOpenDlg.SetInitialDir( aValue: String );
begin
  mInitialDir := aValue;
  PTShellList1.Folder.Pathname := aValue;
end;

procedure TPTFrmOpenDlg.SetOptions( aValue: TPTOpenOptions );
var
  treeOptions: TPTShellTreeOptions;
  listOptions: TPTShellListOptions;

  procedure ApplyListOption( aApply: Boolean;  aListOpt: TPTShellListOption );
  begin
    if aApply then Include(listOptions, aListOpt) else Exclude(listOptions, aListOpt);
  end;

  procedure ApplyTreeOption( aApply: Boolean;  aTreeOpt: TPTShellTreeOption );
  begin
    if aApply then Include(treeOptions, aTreeOpt) else Exclude(treeOptions, aTreeOpt);
  end;

  procedure ApplyOptions( aApply: Boolean;  aTreeOpt: TPTShellTreeOption;  aListOpt: TPTShellListOption );
  begin
    ApplyListOption( aApply, aListOpt );
    ApplyTreeOption( aApply, aTreeOpt );
  end;
begin
  mOptions := aValue;

  treeOptions := PTShellTree1.Options;
  listOptions := PTShellList1.Options;
  ApplyOptions( ptofOleDrag in aValue,  ptstoOleDrag, ptsloOleDrag );
  ApplyOptions( ptofOleDrop in aValue,  ptstoOleDrop, ptsloOleDrop );
  ApplyOptions( ptofShowHidden in aValue, ptstoShowHidden, ptsloShowHidden );
  ApplyListOption( ptofHideFoldersInListWhenTreeVisible in aValue, ptsloHideFoldersWhenLinkedToTree );
  PTShellList1.MultiSelect := (ptofAllowMultiselect in aValue);
  PTShellTree1.Options := treeOptions;
  PTShellList1.Options := listOptions;

  ReadOnlyChk.Visible := not (ptofHideReadOnly in aValue);
  HelpBtn.Visible := (ptofShowHelp in aValue);

  ShowHint := (ptofShowHints in aValue);
end; {TPTFrmOpenDlg.SetOptions}

procedure TPTFrmOpenDlg.SetOnAddListItem( aValue: TPTShAddItemEvent );  begin PTShellList1.OnAddItem := aValue; end;
procedure TPTFrmOpenDlg.SetOnAddTreeItem( aValue: TPTShAddItemEvent );  begin PTShellTree1.OnAddItem := aValue; end;
procedure TPTFrmOpenDlg.SetOnAddComboItem( aValue: TPTShAddItemEvent ); begin {PTShellCombo1.OnAddItem := aValue;} end;

procedure TPTFrmOpenDlg.SetOnLvCustomDrawSh( aValue: TPTShLvCustomDrawEvent );  begin PTShellList1.OnCustomDrawSh := aValue; end;
procedure TPTFrmOpenDlg.SetOnLvCustomDrawShEx( aValue: TPTShLvCustomDrawEvent );begin PTShellList1.OnCustomDrawShEx := aValue; end;
procedure TPTFrmOpenDlg.SetOnTvCustomDrawSh( aValue: TPTShTvCustomDrawEvent );  begin PTShellTree1.OnCustomDrawSh := aValue; end;
procedure TPTFrmOpenDlg.SetOnTvCustomDrawShEx( aValue: TPTShTvCustomDrawEvent );begin PTShellTree1.OnCustomDrawShEx := aValue; end;

procedure TPTFrmOpenDlg.ShowTree( aShow: Boolean );
var c: TCursor;
begin
  if aShow then
  begin
    if Assigned(PTShellCombo1.ShellTree) and (PTSplitter1.Position > -PTSplitter1.SplitterWidth) then
      Exit; // Already showing
    try
      ShowTreeBtn.Down := TRUE;
      if not Assigned(PTShellCombo1.ShellTree) then
      begin
        c := Screen.Cursor;
        Screen.Cursor := crHourglass;
        try
          PTShellTree1.SelectedFolder := PTShellCombo1.SelectedFolder;
            // Assign selected folder before linking the list and combo to prevent redundant update

          PTShellCombo1.ShellList := nil;
          PTShellCombo1.ShellTree := PTShellTree1;
          PTShellTree1.ShellList := PTShellList1;

          PTSplitter1.Pane1MinSize := 4;
          if FormSplitterPos<0 then
            PTSplitter1.Position := 200
          else
            PTSplitter1.Position := FormSplitterPos;
        finally
          Screen.Cursor := c;
        end;
      end
      else
      begin
{-- Support for ptsloHideFoldersWhenLinkedToTree option}
        PTShellTree1.ShellList := PTShellList1;
        PTShellCombo1.ShellTree := PTShellTree1;
        if FormSplitterPos<0 then
          PTSplitter1.Position := 200
        else
          PTSplitter1.Position := FormSplitterPos;
      end;
    except
      ShowTreeBtn.Down := FALSE;
      raise;
    end;
    Options := Options + [ptofShowTree];
    PTShellTree1.TabStop := TRUE;
  end
  else // not aShow
  begin
    ShowTreeBtn.Down := FALSE;
    if PTShellTree1.Focused then PTShellList1.SetFocus;
    PTShellTree1.TabStop := FALSE;
{-- Support for ptsloHideFoldersWhenLinkedToTree option}
    PTShellTree1.ShellList := nil;
    PTShellCombo1.ShellTree := nil;
    PTShellCombo1.ShellList := PTShellList1;
    FormSplitterPos := PTSplitter1.Position;
    PTSplitter1.Pane1MinSize := -PTSplitter1.SplitterWidth;
    PTSplitter1.Position := -PTSplitter1.SplitterWidth;
    Options := Options - [ptofShowTree];
  end;
  if (PTShellList1.Visible) and (ptsloHideFoldersWhenLinkedToTree in PTShellList1.Options) then
    PTShellList1.FillItems;
end; {TPTFrmOpenDlg.ShowTree}


procedure TPTFrmOpenDlg.ApplyUserFilter( aFilter: String );
begin
  mUserFilter := aFilter;
  PTShellList1.FileFilter := aFilter;
  PTShellList1.FillItems;
end; {TPTFrmOpenDlg.ApplyUserFilter}


procedure TPTFrmOpenDlg.GetSelectedFiles( s: TStrings );
begin
  s.Assign( mSelections );
end; {TPTFrmOpenDlg.GetSelectedFiles}


procedure TPTFrmOpenDlg.PTShellList1Change(Sender: TObject; Item: TListItem; Change: TItemChange);
  procedure AddFilename( var sofar: String;  const toadd: String );
  begin
    if Length(sofar)>0 then sofar := sofar + ' ';
    sofar := sofar + '"' + toadd + '"';
  end;
var ld: TPTShListData;
    vsi: TList; // Valid selected items
    i: Integer;
    tmpitem: TListItem;
    tmps: String;
begin
  if (Change <> ctState) or (not Executing) then
    Exit; // Only interested in selection changes

  vsi := TList.Create;
  try
    if PTShellList1.SelCount > 1 then
    begin
      for i := PTShellList1.Selected.Index to PTShellList1.Items.Count-1 do
      begin
        tmpitem := PTShellList1.Items[i];
        if tmpitem.Selected and Assigned(tmpitem.Data) then
        begin
          ld := PTShellList1.ShListData[i];
          if not ld.IsFolder then
            vsi.Add( ld );
        end;
      end;
    end
    else if (PTShellList1.SelCount = 1) then
    begin
      tmpitem := PTShellList1.Selected;
      if Assigned(tmpitem) and Assigned(tmpitem.Data) then
      begin
        begin
          ld := PTShellList1.GetDataFromItem( PTShellList1.Selected );
          if not ld.IsFolder then
            vsi.Add( ld );
        end;
      end;
    end;

    if vsi.Count>1 then
    begin
      tmps := '';
      for i := 0 to vsi.Count-1 do
        AddFilename( tmps, TPTShListData(vsi[i]).FileName );
      FileNameEdt.Text := tmps;
    end
    else if vsi.Count=1 then
      FileNameEdt.Text := TPTShListData(vsi[0]).DisplayName;

    mLastInputState := lisList;
  finally
    vsi.Free;
  end;

  DoOnSelectionChanged;
end;

procedure TPTFrmOpenDlg.UpOneLevelBtnClick(Sender: TObject);
  begin PTShellCombo1.GoUp(1); end;

procedure TPTFrmOpenDlg.ShowTreeBtnClick(Sender: TObject);
  begin ShowTree( ShowTreeBtn.Down ) end;

procedure TPTFrmOpenDlg.FormDestroy(Sender: TObject);
begin
  FilterStringsFree( FileTypesCbx.Items );
end;

procedure TPTFrmOpenDlg.FormKeyDown(Sender: TObject; var Key: Word;  Shift: TShiftState);
begin
  case key of
    VK_F4:
      if Shift=[] then
      begin
        if PTShellCombo1.DroppedDown then
        begin
          PTShellCombo1.DroppedDown := FALSE;
          PTShellList1.SetFocus;
          PTShellCombo1.Perform( CN_COMMAND, MakeLong(0,CBN_SELENDOK), PTShellCombo1.Handle );
        end
        else
        begin
          PTShellCombo1.SetFocus;
          PTShellCombo1.DroppedDown := TRUE;
        end;
      end;
        
    VK_F5:
      if Shift=[] then
      begin
        if not PTShellCombo1.Focused then PTShellCombo1.FillItems;
        if not PTShellList1.Focused then PTShellList1.FillItems;
        if Assigned(PTShellTree1.ShellList) and not (PTShellTree1.Focused) then
          PTShellTree1.RefreshNodes;
      end;

    VK_F12:
      if Shift=[] then
      begin
        if (ptofAllowTree in Options) then
          ShowTree( not ShowTreeBtn.Down );
      end;
  end;
end;


{Do processing in WideChars for easy DBCS support. To do this sort of processing in native DBCS is a real pain - and
 possibly slower than doing the DBCS->UNICODE, UNICODE<-DBCS conversion anyway.

 Given a starting fully qualified path 'aCurrent' and a relative modifier path 'aEntered' returns the
 new fully qualified path. Supports drive-letters and UNC names.}
function ApplyPathname( aCurrent, aEntered: String ): String;
var wcCurrent, wcEntered, wcResult: array[0..MAX_PATH] of WideChar;
  function StrLenW( pwc: PWideChar ): Integer;
  begin
    result := 0;
    while pwc^ <> WideChar(#0) do
    begin
      Inc(pwc);
      Inc(result);
    end;
  end; {StrLenW - local}

  function AllDots( wc: PWideChar ): Bool;
  begin
    while wc^ <> WideChar(#0) do
    begin
      if wc^ <> WideChar('.') then begin result := FALSE; Exit; end;
      Inc( wc );  // Add 2
    end;
    result := TRUE;
  end; {AllDots - local}

  {Might add a wide char to the string. The caller is responsible for ensuring there is sufficient space.}
  procedure EnsureTrailingSlash( pwc: PWideChar;  len: Integer );
  begin
    if (len<0) then len := StrLenW(pwc);
    Inc( pwc, len-1 );
    if (pwc^ <> WideChar('\')) then
    begin
      (pwc+1)^ := WideChar('\');
      (pwc+2)^ := WideChar(#0);
    end;
  end; {EnsureTrailingSlash - local}

  procedure EnsureNoTrailingSlash( pwc: PWideChar;  len: Integer );
  begin
    if (len<0) then len := StrLenW(pwc);
    Inc( pwc, len-1 );
    if (pwc^ = WideChar('\')) then
      pwc^ := WideChar(#0);
  end; {EnsureNoTrailingSlash - local}

  {Returns a ptr to the position of the minimum position - the first part of the path that you cannot go back below}
  function GetMinimumSizePtr( pwc: PWideChar;  len: Integer ): PWideChar;
  begin
//    writeln( ' GetMinimumSizePtr' );
    if (len<0) then len := StrLenW(pwc);
    if (len>=3) and ((pwc+1)^ = WideChar(':')) then
      result := (pwc+3)
    else if (len>2) and ((pwc+0)^ = WideChar('\')) and ((pwc+1)^ = WideChar('\')) then
    begin
//      writeln( ' Is UNC name' );
      Inc( pwc, 2 );  // Skip the first two slashes
      while (pwc^ <> WideChar(#0)) and (pwc^ <> WideChar('\')) do // Find next slash
        Inc(pwc);
      if (pwc^ = WideChar(#0)) then
      begin
//        writeln( ' Early abort' );
        result:=nil;
        Exit;
      end;  // If end reached here then failed

      Inc(pwc);
      while (pwc^ <> WideChar(#0)) and (pwc^ <> WideChar('\')) do // Find next slash or end
        Inc(pwc);

//      writeln( ' Found it' );

      result := (pwc);
    end
    else
      result := nil;
  end; {GetMinimumSizePtr - local}

  procedure RemoveRightmostElement( pwc: PWideChar );
  var len: Integer;
      endc: PWideChar;
      minpos: PWideChar;
  begin
//    writeln( ' RemoveRightmostElement '+WideCharToString(pwc) );
    len := StrLenW(pwc);
    endc := PWideChar( UINT(pwc) + len*2 -2 );
    minpos := GetMinimumSizePtr(pwc, len);
//    writeln( ' MinPos '+WideCharToString(minpos)+' '+IntToStr(len*2)+' '+IntToStr( UINT(minpos)-UINT(pwc) ) );
    if UINT(minpos) - UINT(pwc) = len*2 then
    begin
//      writeln( ' No remove necessary' );
      Exit;
    end;
    while (UINT(endc) > UINT(minpos)) and (endc <> pwc) and (endc^ <> WideChar('\')) do
      Dec(endc);
    endc^ := WideChar(#0);
//    writeln( ' After remove '+WideCharToString(pwc) );
  end; {RemoveRightmostElement - local}

  procedure StrAppendW( pdest, ptoappend: PWideChar );
  var len: Integer;
  begin
    len := StrLenW(pdest);
    pdest := PWideChar( UINT(pdest)+len*2 );
    while ptoappend^ <> WideChar(#0) do
    begin
      pdest^ := ptoappend^;
      Inc(pdest);
      Inc(ptoappend);
    end;
    pdest^ := WideChar(#0);
  end; {StrAppendW - local}

  procedure GetTokenAndAdvance( var pwc: PWideChar;  ptoken: PWideChar );
  var ptok: PWideChar;
  begin
//    writeln( 'GetTokenAndAdvance' );
    ptok := ptoken;
    while (pwc^ <> WideChar(#0)) and (pwc^ <> WideChar('\')) do
    begin
      ptok^ := pwc^;
//      writeln( ' pwc^='+PChar(pwc)^+(PChar(pwc)+1)^ );
      Inc( pwc );
      Inc( ptok );
    end;
    if (pwc^ = WideChar('\')) then Inc(pwc);
    ptok^ := WideChar(#0);
//    writeln( ' tok:'+WideCharToString(ptoken) );
  end; {GetTokenAndAdvance - local}

  procedure Merge;
  var token: array[0..MAX_PATH] of WideChar;
      pinentered: PWideChar;
      i, max: Integer;
  begin
    Move( wcCurrent, wcResult, (Length(aCurrent)+1)*2 );
    pinentered := @wcEntered[0];

    token[0] := WideChar(#0);
    GetTokenAndAdvance( pinentered, @token[0] );
    while token[0] <> WideChar(#0) do
    begin
      if AllDots(@token[0]) then
      begin
        max := StrLenW(token)-1;
//        writeln( ' Is all dots - removing '+IntToStr(max)+' elements' );
        for i := 1 to max do
          RemoveRightmostElement( @wcResult[0] );
      end
      else
      begin
        if (wcResult[0] <> WideChar(#0)) then
          EnsureTrailingSlash( @wcResult[0], -1 );
        StrAppendW( @wcResult[0], @token[0] );
//        writeln( ' After append: '+WideCharToString(wcResult) );
      end;
      token[0] := WideChar(#0);
      GetTokenAndAdvance( pinentered, @token[0] );
    end;
  end; {Merge - local}

type TPathType = (ptAbsDisk, ptAbsNet, ptRel, ptErr);
  function GetPathTypeW( pwc: PWideChar ): TPathType;
  var len: Integer;
  begin
//    writeln( 'GetPathTypeW '+WideCharToString(pwc) );
    len := StrLenW(pwc);
    if (len>=2) and ((pwc+1)^ = WideChar(':')) then
      result := ptAbsDisk
    else if (len>=3) and ((pwc+0)^ = WideChar('\')) and ((pwc+1)^ = WideChar('\')) then
      result := ptAbsNet
    else if (pwc^ = WideChar('\')) then
      result := ptAbsDisk // Just one slash means 'current drive root directory'
    else if (len>0) then
      result := ptRel
    else
      result := ptErr;
  end; {GetPathTypeW - local}

var pwc: PWideChar;
begin {ApplyPathname}
  if (Length(aCurrent)>2) and (aCurrent[ Length(aCurrent) ]='\') then
    Delete(aCurrent,Length(aCurrent),1);
  StringToWideChar( aCurrent, @wcCurrent[0], Sizeof(wcCurrent) );
  StringToWideChar( aEntered, @wcEntered[0], Sizeof(wcEntered) );

  wcResult[0] := WideChar(#0);

 // Determine if the entered string is an absolute path, if so we can ignore aCurrent
  case GetPathTypeW(wcEntered) of
    ptAbsDisk:
      begin
//        writeln( 'ptAbsDisk' );
        if wcEntered[0] = WideChar('\') then
        begin
//          writeln( ' \ special case' );
          case GetPathTypeW(wcCurrent) of
            ptAbsDisk:
              begin
                wcResult[0] := wcCurrent[0];
                wcResult[1] := wcCurrent[1];
                wcResult[2] := WideChar(#0);
              end;
            ptAbsNet:
              begin
                Move( wcCurrent, wcResult, (Length(aCurrent)+1)*2 );
                pwc := GetMinimumSizePtr( wcResult, -1 );
                pwc^ := WideChar(#0);
//                writeln( WideCharToString(wcResult) );
              end;
            else // can't be ptRel, by definition the current path must be an absolute path
          end;
          StrAppendW(@wcResult[0], @wcEntered[0]);
        end
        else if Length(aEntered)=2 then
        begin
          wcResult[0] := wcEntered[0];
          wcResult[1] := wcEntered[1];
          wcResult[2] := WideChar('\');
          wcResult[3] := WideChar(#0);
        end
        else
          Move( wcEntered, wcResult, (Length(aEntered)+1)*2 );
      end; {ptAbsDisk}

    ptAbsNet:
      begin
//        writeln( 'ptAbsNet' );
        Move( wcEntered, wcResult, (Length(aEntered)+1)*2 );
      end; {ptAbsNet}

    ptRel:
      begin
//        writeln( 'ptRel' );
        Merge;
      end; {ptRel}
    else
  end; {case}

  result := WideCharToString( @wcResult[0] );
end; {ApplyPathname}


function IsFileReadOnly( aFile: String ): Boolean;
var dw: DWORD;
begin
  dw := Windows.GetFileAttributes( PChar(aFile) );
  result := ( (dw <> $FFFFFFFF) and ((dw and FILE_ATTRIBUTE_READONLY)<>0) );
end; {IsFileReadOnly}


function IsExtensionRegistered( const ext: String ): Boolean;
var r: TRegistry;
begin
  r := TRegistry.Create;
  try
    r.RootKey := HKEY_CLASSES_ROOT;
    result := r.KeyExists( ext );
  finally
    r.Free;
  end;
end; {IsExtensionRegistered}


function MessageDlgCaption( const aCaption, aMsg: String;
                            dlgType: TMsgDlgType;
                            buttons: TMsgDlgButtons;
                            helpCtx: Integer ): Integer;
begin
  with Dialogs.CreateMessageDialog( aMsg, dlgType, buttons ) do
    try
      Caption := aCaption;
      HelpContext := helpctx;
      Result := ShowModal;
    finally
      Free;
    end;
end; {MessageDlgCaption}


procedure NotFound( const caption, filename: String );
begin
  MessageDlgCaption( caption, Format(PTLoadStr(SFileNotFound), [filename]), mtWarning, [mbOk], 0 );
end;

function DoYouWishToCreateIt( const caption, filename: String ): Boolean;
begin
  result := (MessageDlgCaption( caption, Format(PTLoadStr(SDoesNotExistCreate), [filename]), mtConfirmation, [mbYes, mbNo], 0 ) = mrYes);
end;

procedure NoReadOnlyReturn( const caption, filename: String );
begin
  MessageDlgCaption( Caption, Format(PTLoadStr(SExistsAndIsReadOnly), [filename]), mtWarning, [mbOk], 0 );
end;

function FileExistsOverwrite( const caption, filename: String ): Boolean;
begin
  result := (MessageDlgCaption( caption, Format(PTLoadStr(SFileExistsReplace), [filename]), mtWarning, [mbYes, mbNo], 0 ) = mrYes);
end;

procedure ThereCanBeOnlyOne( const caption, filename: String );
begin
  MessageDlgCaption( caption, Format(PTLoadStr(SThereCanBeOnlyOne), [filename]), mtWarning, [mbOk], 0 );
end;

procedure ThisFilenameIsNotValid( const caption, filename: String );
begin
  MessageDlgCaption( caption, Format(PTLoadStr(SFilenameIsInvalid), [filename]), mtWarning, [mbOk], 0 ); 
end;


{Returns TRUE if a '*' or '?' char is found - DBCS enabled}
function AnyWildcardsDB( s: String ): Boolean;
var pos: Integer;
begin
  pos := 1;
  while (pos <= Length(s)) do
  begin
    if IsDBCSLeadByte( Byte(s[pos]) ) then
      Inc(pos,2)
    else
    begin
      if (s[pos] = '*') or (s[pos] = '?') then
      begin
        result := TRUE;
        Exit;
      end;
      Inc(pos);
    end;
  end;
  result := FALSE;
end; {AnyWildcardsDB}


function AnyOfThisCharDB( const ins: String;  thisChar: Char ): Boolean;
var inpos: Integer;
begin
  inpos := 1;
  while (inpos <= Length(ins)) do
  begin
    if IsDBCSLeadByte(Byte(ins[inpos])) then
      Inc( inpos, 2 )
    else if (ins[inpos] = thisChar) then
    begin
      result := TRUE;
      Exit;
    end
    else
      Inc( inpos );
  end;
  result := FALSE;
end; {AnyOfThisCharDB}


procedure ParametizeDB_special( const ins: String;  outs: TStrings );
{$IFNDEF VCL30PLUS}
  function AnsiPos(const Substr, S: string): Integer;
  begin
    result := Pos(Substr, S);
  end;
{$ENDIF}
const WHITESPACE = [' ',#9];
var curs: String;
    state: (sNormal, sInQuotes, sInWhitespace);
    inpos: Integer;
    curchar: Char;
    fIsDBCS: Boolean;
begin
  curs := '';
  state := sInWhitespace;
  inpos := 1;
  while (inpos <= Length(ins)) do
  begin
    curchar := ins[inpos];
    fIsDBCS := IsDBCSLeadByte( Byte(curchar) );
    case state of
      sNormal:
        begin
          if not fIsDBCS and (curchar = '"') then
          begin
            curs := TrimRightDB(curs);
            if Length(curs)>0 then
            begin
              outs.Add( curs );
              curs := '';
            end;
            state := sInQuotes;
            Inc( inpos, 1 );
          end
          else
            CopyCharDB( inpos, ins, curs );
        end;

      sInQuotes:
        begin
          if not fIsDBCS and (curchar = '"') then
          begin
            curs := TrimRightDB(curs);
            if Length(curs)>0 then
            begin
              outs.Add( curs );
              curs := '';
            end;
            state := sInWhitespace;
            Inc( inpos );
          end
          else
            CopyCharDB( inpos, ins, curs );
        end;

      sInWhitespace:
        begin
          if not fIsDBCS then
          begin
            if (curchar = '"') then
            begin
              curs := '';
              state := sInQuotes;
            end
            else if not (curchar in WHITESPACE) then
            begin
              curs := curchar;
              state := sNormal;
            end;
            Inc( inpos, 1 );
          end
          else // fIsDBCS
          begin
            CopyCharDB( inpos, ins, curs );
            state := sNormal;
          end;
        end;
    end; {case}
  end; {while}

  curs := TrimRightDB(curs);
  if Length(curs)>0 then
    outs.Add( curs );
end; {ParametizeDB}



// Also input: all the selected items in PTShellList1
function TPTFrmOpenDlg.ParseInputString( const ins: String ): Boolean;
  function ApplyOptions( pathname: String;  options: TPTOpenOptions ): Boolean;
  var fFileExists: Boolean;
  begin
    fFileExists := FileExists(pathname);
    if fFileExists then
    begin
      if IsFileReadOnly(pathname) and (ptofNoReadOnlyReturn in options) then
      begin
        NoReadOnlyReturn(Caption, pathname);
        result := FALSE;
        Exit;
      end;

      if (ptofOverwritePrompt in options) then
      begin
        if not FileExistsOverwrite(Caption, pathname) then
          begin result := FALSE; Exit; end;
      end;

      result := TRUE;
      Exit;
    end;
   // not FileExists

    if (ptofFileMustExist in options) then
      begin NotFound(Caption, pathname); result := FALSE; Exit; end;

    if (ptofCreatePrompt in options) then
      if not DoYouWishToCreateIt(Caption, ExtractFileName(pathname)) then
        begin result := FALSE; Exit; end;

    result := TRUE;
  end; {ApplyOptions - local}

  function GetCurrentFolderPath: String;
  begin
    result := PTShellList1.Folder.Pathname;
  end; {GetCurrentFolderPath - local}

  function IfFolderOpenIt( pathname: String ): Boolean;
  var dskishf, ishf: IShellFolder;
      fFileExists: Boolean;
      pidl: PItemIdList;
      wca: array[0..MAX_PATH] of WideChar;
      dw, dw2, dwAttrib, chEaten: DWORD;
  begin
    result := FALSE;

    dskishf:=nil; pidl:=nil; ishf:=nil;
    try
      StringToWideChar( pathname, @wca[0], SizeOf(wca) );
      SHGetDesktopFolder(dskishf);
      dw := dskishf.ParseDisplayName( Handle, nil, @wca[0], chEaten, pidl, dwAttrib );

      fFileExists := FileExists(pathname);
      if Ole2.Succeeded(dw) then
      begin
        dwAttrib := SFGAO_FOLDER;
        dw2 := dskishf.GetAttributesOf( 1, pidl, dwAttrib );
        if Ole2.Succeeded(dw2) and (not fFileExists) and ( (dwAttrib and SFGAO_FOLDER)<>0 ) then
        begin
          dw2 := dskishf.BindToObject( pidl, nil, @IID_IShellFolder, Pointer(ishf) );
          if Ole2.Failed(dw2) then raise Exception.Create( {$IFDEF PTDEBUG}'TPTFrmOpenDlg.ParseInputString BindToObject: '#13+{$ENDIF}
                                                           SysErrorMessage(dw2) );
          PTShellCombo1.SelectedFolder.IdList := pidl;
          FileNameEdt.SelectAll;
          result := TRUE;
        end;
      end;
    finally
      if Assigned(ishf) then ishf.Release;
      if Assigned(pidl) then ShellMemFree(pidl);
      if Assigned(dskishf) then dskishf.Release;
    end;
  end; {IfFolderOpenIt - local}

  function DereferenceShortcut( pathname: String ): String;
  var ld: TLinkData;
  begin
    if (AnsiCompareText( ExtractFileExt(pathname), '.lnk' )=0) and
       Ole2.Succeeded(ResolveShortcut( pathname, ld, FALSE )) and
       (ld.pathname <> '')
    then
      result := ld.pathname
    else
      result := pathname;
  end; {DereferenceShortcut - local}

  procedure HandleDefaultExt( var pathname: String );
  var ext: String;
  begin
    if DefaultExt <> '' then
    begin
      ext := ExtractFileExt(pathname);
      if Length(ext) > 0 then
      begin
        if IsExtensionRegistered(ext) then
          Options := Options + [ptofExtensionDifferent]
        else
        begin
          Options := Options - [ptofExtensionDifferent];
          pathname := pathname + '.' + DefaultExt;
        end;
      end
      else
      begin
        pathname := pathname + '.' + DefaultExt;
        Options := Options - [ptofExtensionDifferent];
      end;
    end;
  end; {HandleDefaultExt}

  { Look for invalid chars and simple invalid sequences. }
  function InitialValidityCheck(s: String): Boolean;
    function AllCharsValid(s: String): Boolean;
    var i: Integer;
    begin
      i := 1;
      while (i <= Length(s)) do
      begin
        if IsDBCSLeadByte(Byte(s[i])) then
          Inc(i,2)
        else if s[i] in ['/', '|','<','>'] then
        begin
          result := false;
          Exit;
        end
        else
          Inc(i);
      end;
      result := true;
    end;

    function DoubleBackslashOk(s: String): Boolean;
    var i: Integer;
    begin
      result := true;
      i := 3;
      while (i <= Length(s)) do
      begin
        if IsDBCSLeadByte(Byte(s[i])) then
          Inc(i,2)
        else if (s[i] = '\') and (s[i-1] = '\') then
        begin
          result := false;
          Break;
        end
        else
          Inc(i);
      end;
    end;
  begin
    result := AllCharsValid(s) and DoubleBackslashOk(s);
  end;

var sl: TStrings;
    i, li: Integer;
    curpathname, curname, curpath, curfldpath: String;
    firstFound: TListItem;

begin {ParseInputString}
  result := FALSE;
  sl := TStringList.Create;
  mSelections.Clear;
  try
    if AnyOfThisCharDB(ins, '"') then
      ParametizeDB_special( ins, sl )
    else
      sl.Add( ins );

    curfldpath := GetCurrentFolderPath;
    EnsureTrailingCharDB(curfldpath, '\');

    if sl.Count > 0 then
    begin
      for i := 0 to sl.Count-1 do
      begin
        if not (ptofNoValidate in Options) and not InitialValidityCheck(ins) then
        begin
          ThisFilenameIsNotValid(Caption, ins);
          Exit;
        end;

        curpathname := ApplyPathname( curfldpath, sl[i] );
        if (curpathname='') then Continue;

        if IfFolderOpenIt(curpathname) then
          Exit;

        if not (ptofNoDereferenceLinks in Options) then
          curpathname := DereferenceShortcut(curpathname);

        if (sl.Count=1) then
        begin
          if (mLastInputState = lisList) and Assigned(PTShellList1.SelectedItem) then
            curpathname := PTShellList1.SelectedItem.Pathname
          else // mLastInputState = lisEdit
          begin
            HandleDefaultExt( curpathname );

            curname := ExtractFileName(curpathname);
            curpath := ExtractFilePath(curpathname);
            EnsureTrailingCharDB(curpath, '\');

            if AnsiCompareText( curpath, curfldpath )<>0 then
              PTShellCombo1.SelectedFolder.Pathname := ExtractFilePath(curpathname);

            firstFound := nil;
            for li := 0 to PTShellList1.Items.Count-1 do
            begin
              if AnsiCompareText( PTShellList1.Items[li].Caption, curname )=0 then
              begin
                if Assigned(firstFound) then
                begin
                  ThereCanBeOnlyOne(Caption, curname);
                  firstFound.Selected := TRUE;
                  firstFound.Focused := TRUE;
                  PTShellList1.SetFocus;
                  Exit;
                end
                else
                  firstFound := PTShellList1.Items[li];
              end;
              if Assigned(firstFound) then
                curpathname := TPTShListData(firstFound.Data).Pathname;
            end;
          end;
          result := ApplyOptions( curpathname, Options );
        end {if sl.Count=1}
        else
          result := ApplyOptions( curpathname, Options + [ptofFileMustExist] );

        if result then
          mSelections.Add( curpathname )
        else
          Exit;
      end;
    end;
  finally
    sl.Free;
    if not result then mSelections.Clear;
  end;
end; {TPTFrmOpenDlg.ParseInputString}


procedure TPTFrmOpenDlg.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var fname: String;
begin
  if ModalResult = mrOk then
  begin
    fname := ExtractFileName(FileNameEdt.Text);
    if AnyWildcardsDB(fname) then
    begin
      CanClose := FALSE;
      ParseInputString( ExtractFilePath(FileNameEdt.Text) );
      ApplyUserFilter( fname );
      FileNameEdt.Text := fname;
      FileNameEdt.SelectAll;
    end
    else
    begin
      CanClose := ParseInputString( FileNameEdt.Text );
    end;
  end;

  if CanClose and not (ptofNoChangeDir in Options) and (PTShellTree1.SelectedPathName <> '') then
    try
      SetCurrentDirectory( PChar(PTShellTree1.SelectedPathName) );
    except
    end;
end;


procedure TPTFrmOpenDlg.PTShellTree1Change(Sender: TObject; Node: TTreeNode);
begin
  if Executing then
    if (node <> nil) then
      FileNameEdt.Text := '';
end;

procedure TPTFrmOpenDlg.FileTypesCbxSelEndOk(Sender: TObject);
begin
  if (mUserFilter <> '') then FileNameEdt.Clear;
  mUserFilter := '';
  PTShellList1.FileFilter := PFilterItemRec(FileTypesCbx.Items.Objects[FileTypesCbx.ItemIndex]).mExtension;

  if Executing then
    DoOnTypeChanged;
end;

procedure TPTFrmOpenDlg.CreateNewFolderBtnClick(Sender: TObject);
begin
  if PTShellTree1.Focused or
     (ShowTreeBtn.Down and (ptofHideFoldersInListWhenTreeVisible in Options))
  then
    PTShellTree1.CreateNewFolder( TRUE )
  else
    PTShellList1.CreateNewFolder( TRUE );
end; {TPTFrmOpenDlg.CreateNewFolderBtnClick}

procedure TPTFrmOpenDlg.FileNameEdtChange(Sender: TObject);
begin
  if Executing then
    mLastInputState := lisEdit;
end;

procedure TPTFrmOpenDlg.Paste1MitmClick(Sender: TObject);
begin
  PTShellList1.DoCommandForFolder( PTSH_CMDS_PASTE );
end;

procedure TPTFrmOpenDlg.Properties1MitmClick(Sender: TObject);
begin
  PTShellList1.DoCommandForFolder( PTSH_CMDS_PROPERTIES );
end;

{$IFDEF VCL30PLUS}
function TPTFrmOpenDlg.FormHelp(Command: Word; Data: Integer; var CallHelp: Boolean): Boolean;
begin
  if Assigned(OnFormHelp) then
    result := OnFormHelp( command, data, callhelp )
  else
    result := false;
end;
{$ENDIF}

procedure TPTFrmOpenDlg.HelpBtnClick(Sender: TObject);
begin
  Application.HelpContext( HelpContext ); // FormHelp is still called in this case
end;

procedure TPTFrmOpenDlg.DoHide;
begin
  mExecuting := false;
  inherited;
  DoOnFormClose;
end;

procedure TPTFrmOpenDlg.DoShow;
  procedure SetPanel1Height;
  var i, max: Integer;
  begin
    max := 0;
    for i := 0 to Panel1.ControlCount-1 do
      with Panel1.Controls[i] do
        if Visible then
          with BoundsRect do
            if bottom > max then
              max := bottom;
    Panel1.Height := max + 4;
  end;
var
  ofsx: Integer;
  tmps1: String;
begin
  inherited;

  FileTypesCbx.Perform( CB_SETEXTENDEDUI, 1,0 );

 // If no tree button, then hide it and move the other buttons across a bit
  if not (ptofAllowTree in Options) then
  begin
    ShowTreeBtn.Visible := FALSE;
    ofsx := ListBtn.Left - ShowTreeBtn.Left;
    ListBtn.Left := ListBtn.Left - ofsx;
    DetailsBtn.Left := DetailsBtn.Left - ofsx;
  end;

  SetPanel1Height;

  DoTranslation;

  ShowTree( ptofShowTree in Options );  // Causes events that cause edit field to be reset.

  tmps1 := ExtractFilePath( Filename );
  if (InitialDir = '') then
    if Length(tmps1) <> 0 then
    begin
      PTShellCombo1.SelectedFolder.Pathname := tmps1;
      tmps1 := ExtractFileName(Filename);
      if (tmps1 <> '') then
        Filename := tmps1;
    end
    else
      PTShellCombo1.SelectedFolder.Pathname := GetCurrentDir
  else
    PTShellCombo1.SelectedFolder.Pathname := InitialDir;

  mLastInputState := lisList;

  DoOnFormShow;

  mExecuting := true;
end;

procedure TPTFrmOpenDlg.ReadOnlyChkClick(Sender: TObject);
begin
  if ReadOnlyChk.Checked then
    Include( mOptions, ptofReadOnly )
  else
    Exclude( mOptions, ptofReadOnly );
end;

procedure TPTFrmOpenDlg.PTShellList1FolderChanged(Sender: TObject);
begin
  if Executing then
    DoOnFolderChanged;
end;

procedure TPTFrmOpenDlg.FormResize(Sender: TObject);
var w, x, y: Integer;
begin
  inherited;
  y := PTShellCombo1.BoundsRect.Bottom + 4;
  SplitterContainer.BoundsRect := Rect(4, y, ClientWidth-4, Panel1.Top);
  w := OpenBtn.Width;

  x := ClientWidth - w - 4;
  OpenBtn.Left := x;
  CancelBtn.Left := x;
  HelpBtn.Left := x;

  FileNameCbx.Width := x - FileNameCbx.Left - 8;
  FileNameEdt.Width := x - FileNameEdt.Left - 8;
  FileTypesCbx.Width := x - FileTypesCbx.Left - 8;
end;



end.

