unit FPTFolderBrowseDlg; // Copyright  1996-1998 Plasmatech Software Design. All rights reserved.
{
 Shell Control Pack
 Version 1.3d

 History
 ==============================================================
 V1.30d --TBA-- Added public Form property to TPTFolderBrowseDlg, giving access to the form object
                  from component events.
                Added properties, events and methods to TPTFrmFolderBrowseDlg to better support visual
                  inheritance. Reference to the component object is no longer kept in the form object,
                  making visual inheritance and customization a lot easier.
                Fixed OnInitialized event - it is now correctly invoked.
 V1.30c 16Mar98 Added ptfbShowHidden option.
 V1.30b  7Feb98 No changes.
 V1.30a  7Jan98 No changes.
 V1.30  28Nov97 Added internationalisation support.
                Added ptfbCreateFolderIcon, ptfbDeleteFolderIcon and ptfbVirtualFolders options.
                Fixed problem with OnAddItem event not being called.
 V1.20b 12Oct97 No changes.
 V1.20a  5Oct97 No changes.
 V1.20   6Sep97 Added ptfbOleDrag and ptfbOleDrop options.
 V1.10a  6Jul97 Added ptfbIncludeNonFolders option.
 V1.10  26Jun97 Added OnCustomDrawSh event.
                Added BaseFolder property.
 V1.00c 31May97 No significant changes.
 V1.00b 17May97 Delphi 3 support.
 V1.00a  1May97 Fixed GP fault when pressing F5 in tree.
 V1.00  21Apr97 Released version 1.0
}
{$RANGECHECKS OFF} {$OVERFLOWCHECKS OFF} {$WRITEABLECONST OFF}
{$BOOLEVAL OFF}    {$EXTENDEDSYNTAX ON}  {$TYPEDADDRESS ON}

{$INCLUDE PTCompVer.inc}

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Ole2, Buttons,
  UPTShellControls, FPTOpenDlg, UPTShell95, UPTTreeList, UPTShellUtils, UPTShConsts, UPTFrame;

type
  TPTFolderBrowseDlgOption = (ptfbCreateDeleteButtons,
                              ptfbContextMenus,
                              ptfbReadOnly,
                              ptfbIncludeNonFolders,
                              ptfbOleDrag,
                              ptfbOleDrop,
                              ptfbCreateFolderIcon,
                              ptfbDeleteFolderIcon,
                              ptfbVirtualFolders,
                              ptfbShowHidden );
  TPTFolderBrowseDlgOptions = set of TPTFolderBrowseDlgOption;

const DEF_PTFBOPTIONS = [ptfbContextMenus, ptfbCreateFolderIcon, ptfbDeleteFolderIcon, ptfbShowHidden];

type
  TPTFrmFolderBrowseDlg = class;
  TPTCustomFolderBrowseDlg = class;
    TPTFolderBrowseDlg = class;

  TPTFolderBrowseSelChangeEvent = procedure( aSender: TObject; aNewSel: PItemIdList ) of object;

  TPTCustomFolderBrowseDlg = class(TPTDialog)
    private
      mForm: TPTFrmFolderBrowseDlg;
      mBaseFolder: TPTShellLocator;

      mOptions: TPTFolderBrowseDlgOptions;
      mOnAddItem: TPTShAddItemEvent;
      mOnSelChangeProc: TPTFolderBrowseSelChangeEvent;
      mStatus: String;
      mSelectedFolder: TPTShellLocator;

      mOnTvCustomDrawShProc: TPTShTvCustomDrawEvent;
      mOnTvCustomDrawShExProc: TPTShTvCustomDrawEvent;

      function  GetOkEnabled: Boolean;
      function  GetSelectedPathName: String;

      procedure SetBaseFolder( aValue: TPTShellLocator );
      procedure SetOkEnabled( aValue: Boolean );
      procedure SetStatus( aValue: String );
      procedure SetSelectedPathName( aValue: String );
      procedure SetSelectedFolder( aValue: TPTShellLocator );
    protected
      procedure AssertFormActive;
      procedure AssertFormNotActive;

      function  DoExecute: Boolean; override;
      function  CreateForm: TPTFrmFolderBrowseDlg; dynamic;
      procedure InitForm( aForm: TPTFrmFolderBrowseDlg ); dynamic;
      procedure SaveFormSettings( aForm: TPTFrmFolderBrowseDlg ); dynamic;

    protected
      property Form: TPTFrmFolderBrowseDlg read mForm;
      property SelectedPathName: String read GetSelectedPathName write SetSelectedPathName;
      property SelectedFolder: TPTShellLocator read mSelectedFolder write SetSelectedFolder;
      property Status: String read mStatus write SetStatus;
      property OkEnabled: Boolean read GetOkEnabled write SetOkEnabled;
      property BaseFolder: TPTShellLocator read mBaseFolder write SetBaseFolder;
      property Options: TPTFolderBrowseDlgOptions read mOptions write mOptions default DEF_PTFBOPTIONS;
      property OnAddItem: TPTShAddItemEvent read mOnAddItem write mOnAddItem;
      property OnSelChange: TPTFolderBrowseSelChangeEvent read mOnSelChangeProc write mOnSelChangeProc;
      property OnTvCustomDrawSh: TPTShTvCustomDrawEvent read mOnTvCustomDrawShProc write mOnTvCustomDrawShProc;
      property OnTvCustomDrawShEx: TPTShTvCustomDrawEvent read mOnTvCustomDrawShExProc write mOnTvCustomDrawShExProc;

    public
      constructor Create(aOwner: TComponent); override;
      destructor Destroy; override;

    //-- Properties -------------
      property Executing;
  end; {TPTCustomFolderBrowseDlg}


  TPTFolderBrowseDlg = class(TPTCustomFolderBrowseDlg)
    public
      property Form;
      property SelectedFolder;
      property SelectedPathname;
      property Status;
      property OkEnabled;
      
    published
      property Title;
      property FormWidth;
      property FormHeight;
      property FormWindowState;

      property BaseFolder;
      property Options;

      property OnAddItem;
      property OnFormClose;
      property OnFormShow;
      property OnSelChange;
      property OnInitialized;
      property OnTvCustomDrawSh;
      property OnTvCustomDrawShEx;
  end; {TPTFolderBrowseDlg}


  TPTFrmFolderBrowseDlg = class(TForm)
    PTShellTree1: TPTShellTree;
    ButtonPanel: TPanel;
    OkBtn: TButton;
    CancelBtn: TButton;
    CreateBtn: TButton;
    DeleteBtn: TButton;
    CreateNewFolderBtn: TSpeedButton;
    DeleteFolderBtn: TSpeedButton;
    StatusTxt: TPTFrame;
    procedure FormResize(Sender: TObject);
    procedure PTShellTree1Change(Sender: TObject; Node: TTreeNode);
    procedure FormCreate(Sender: TObject);
    procedure CreateBtnClick(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
  private
    function  GetSelectedPathname: String;
    function  GetStatus: String;
    function  GetOkEnabled: Boolean;
    procedure SetSelectedPathname( aValue: String );
    procedure SetStatus(aValue: String);
    procedure SetOkEnabled( aValue: Boolean );
    procedure WMGetMinMaxInfo( var aMsg: TWMGetMinMaxInfo ); message WM_GETMINMAXINFO;
  protected
    mExecuting: Boolean;
    mOptions: TPTFolderBrowseDlgOptions;
    mOnFormShow: TNotifyEvent;
    mOnFormClose: TNotifyEvent;
    mOnSelChange: TPTFolderBrowseSelChangeEvent;
    mOnAddItem: TPTShAddItemEvent;
    procedure DoShow; override;
    procedure DoHide; override;
    procedure DoTranslation; dynamic;
    procedure SetOptions( aValue: TPTFolderBrowseDlgOptions ); virtual;
  public
    property Executing: Boolean read mExecuting;
    property SelectedPathname: String read GetSelectedPathname write SetSelectedPathname;
    property Status: String read GetStatus write SetStatus;
    property OkEnabled: Boolean read GetOkEnabled write SetOkEnabled;
    property Options: TPTFolderBrowseDlgOptions read mOptions write SetOptions;

    property OnAddItem: TPTShAddItemEvent read mOnAddItem write mOnAddItem;
    property OnFormClose: TNotifyEvent read mOnFormClose write mOnFormClose;
    property OnFormShow: TNotifyEvent read mOnFormShow write mOnFormShow;
    property OnSelChange: TPTFolderBrowseSelChangeEvent read mOnSelChange write mOnSelChange; 
  end; {TPTFrmFolderBrowseDlg}

var
  PTFrmFolderBrowseDlg: TPTFrmFolderBrowseDlg;

{*********************************************************}
implementation
{$R *.DFM}

procedure RaiseNotActive; begin raise Exception.Create( 'TPTFolderBrowseDlg form not active' ); end;
procedure RaiseAlreadyActive; begin raise Exception.Create( 'TPTFolderBrowseDlg form already active' ); end;

procedure GetWndRestoreRect( h: HWND;  var r: TRect );
var wp: TWindowPlacement;
begin
  wp.length := Sizeof(TWindowPlacement);
  GetWindowPlacement( h, @wp );
  r := wp.rcNormalPosition;
end; 


{**************************************
  TPTCustomFolderBrowseDlg
**************************************}
constructor TPTCustomFolderBrowseDlg.Create(aOwner: TComponent);
begin
  inherited;
  Title := '';
  Options := DEF_PTFBOPTIONS;
  mSelectedFolder := TPTShellLocator.Create;
  mBaseFolder := TPTShellLocator.Create;
end;

destructor TPTCustomFolderBrowseDlg.Destroy;
begin
  mSelectedFolder.Free;
  mBaseFolder.Free;
  inherited;
end;

function TPTCustomFolderBrowseDlg.GetOkEnabled: Boolean;
begin
  AssertFormActive;
  result := mForm.OkEnabled;
end;

function TPTCustomFolderBrowseDlg.GetSelectedPathname: String;
  begin result := mSelectedFolder.Pathname; end;

procedure TPTCustomFolderBrowseDlg.SetBaseFolder( aValue: TPTShellLocator );
  begin mBaseFolder.Assign( aValue ); end;

procedure TPTCustomFolderBrowseDlg.SetOkEnabled( aValue: Boolean );
begin
  AssertFormActive;
  mForm.OkEnabled := aValue;
end;

procedure TPTCustomFolderBrowseDlg.SetStatus( aValue: String );
begin
  if Assigned(mForm) then
    mForm.Status := aValue;
  mStatus := aValue;
end;

procedure TPTCustomFolderBrowseDlg.SetSelectedPathname( aValue: String );
  begin mSelectedFolder.Pathname := aValue; end;

procedure TPTCustomFolderBrowseDlg.SetSelectedFolder( aValue: TPTShellLocator );
  begin mSelectedFolder.Assign(aValue); end;

procedure TPTCustomFolderBrowseDlg.AssertFormActive;
  begin if not Assigned(mForm) then RaiseNotActive; end;

procedure TPTCustomFolderBrowseDlg.AssertFormNotActive;
  begin if Assigned(mForm) then RaiseAlreadyActive; end;

function TPTCustomFolderBrowseDlg.DoExecute: Boolean;
var
  c: TCursor;
  f: TPTFrmFolderBrowseDlg;
begin
  AssertFormNotActive;
  c := Screen.Cursor;  Screen.Cursor := crHourglass;
  f:=nil;
  try
    f := CreateForm;
    InitForm(f);
    mForm := f;
    f:=nil;

    DoInitialized;
    result := (mForm.ShowModal = mrOk);

    SaveFormSettings(mForm);
  finally
    mForm.Free;
    mForm:=nil;
    f.Free;
    Screen.Cursor := c;
  end;
end; {TPTCustomFolderBrowseDlg.DoExecute}

function TPTCustomFolderBrowseDlg.CreateForm: TPTFrmFolderBrowseDlg;
begin
  result := TPTFrmFolderBrowseDlg.Create( Application );
end; {TPTCustomFolderBrowseDlg.CreateForm}

procedure TPTCustomFolderBrowseDlg.InitForm( aForm: TPTFrmFolderBrowseDlg );
begin
  aForm.Status := Status;
  if (FormWidth > 0) then aForm.Width := FormWidth;
  if (FormHeight > 0) then aForm.Height := FormHeight;
  aForm.WindowState := FormWindowState;

  aForm.Options := Options;

  if Title='' then
    aForm.Caption := PTLoadStr(SBrowseForFolder)
  else
    aForm.Caption := Title;

  aForm.PTShellTree1.BaseFolder := BaseFolder;
  aForm.PTShellTree1.SelectedFolder := SelectedFolder;

  aForm.OnSelChange := OnSelChange;
  aForm.OnAddItem := OnAddItem;
  aForm.PTShellTree1.OnCustomDrawSh := OnTvCustomDrawSh;
  aForm.PTShellTree1.OnCustomDrawShEx := OnTvCustomDrawShEx;
  aForm.OnFormShow := OnFormShow;
  aForm.OnFormClose := OnFormClose;                         
end; {TPTCustomFolderBrowseDlg.InitForm}

procedure TPTCustomFolderBrowseDlg.SaveFormSettings( aForm: TPTFrmFolderBrowseDlg );
var
  tmpr: TRect;
begin
  GetWndRestoreRect( aForm.Handle, tmpr );
  FormWidth := tmpr.right - tmpr.left;
  FormHeight := tmpr.bottom - tmpr.top;

  FormWindowState := aForm.WindowState;

  if (aForm.ModalResult = mrOk) then
    SelectedFolder.Assign( aForm.PTShellTree1.SelectedFolder );
end; {TPTCustomFolderBrowseDlg.SaveFormSettings}


{***************************************
  TPTFolderBrowseDlg
***************************************}


{**************************************
  TFrmFolderBrowseDlg
**************************************}
procedure TPTFrmFolderBrowseDlg.DoShow;
begin
  inherited;
  if Assigned(OnFormShow) then
    OnFormShow(self);
end;

procedure TPTFrmFolderBrowseDlg.DoHide;
begin
  inherited;
  if Assigned(OnFormClose) then
    OnFormClose(self);
end;

procedure TPTFrmFolderBrowseDlg.DoTranslation;
begin
  Font.Name := PTLoadStr(SDialogFontName);

  OkBtn.Caption := PTLoadStr(SOkButton);
  CancelBtn.Caption := PTLoadStr(SCancelButton);
  CreateNewFolderBtn.Hint := PTLoadStr(SCreateFolder) + '|' + PTLoadStr(SCreateFolderContext);
  DeleteFolderBtn.Hint := PTLoadStr(SDeleteHint) + '|' + PTLoadStr(SDeleteContext);

  if Caption='' then Caption := PTLoadStr(SBrowseForFolder);
end; {TPTFrmFolderBrowseDlg.DoTranslation}

procedure TPTFrmFolderBrowseDlg.SetOptions( aValue: TPTFolderBrowseDlgOptions );
var
  treeOptions: TPTShellTreeOptions;
  procedure ApplyOption( aApply: Boolean; aOption: TPTShellTreeOption );
  begin
    if aApply then
      Include( treeOptions, aOption )
    else
      Exclude( treeOptions, aOption );
  end;
begin
  treeOptions := PTShellTree1.Options;
  ApplyOption( ptfbOleDrag in aValue,  ptstoOleDrag );
  ApplyOption( ptfbOleDrop in aValue,  ptstoOleDrop );
  ApplyOption( ptfbIncludeNonFolders in aValue,  ptstoIncludeNonFolders );
  ApplyOption( ptfbVirtualFolders in aValue,  ptstoVirtualFolders );
  ApplyOption( ptfbContextMenus in aValue,  ptstoContextMenus );
  ApplyOption( ptfbShowHidden in aValue,  ptstoShowHidden );
  PTShellTree1.Options := treeOptions;

  CreateBtn.Visible := (ptfbCreateDeleteButtons in aValue);
  DeleteBtn.Visible := (ptfbCreateDeleteButtons in aValue);

  CreateNewFolderBtn.Visible := (ptfbCreateFolderIcon in aValue);
  DeleteFolderBtn.Visible := (ptfbDeleteFolderIcon in aValue);

  PTShellTree1.ReadOnly := (ptfbReadOnly in aValue);
end; {TPTFrmFolderBrowseDlg.SetOptions}

function TPTFrmFolderBrowseDlg.GetSelectedPathname: String;
  begin  result := PTShellTree1.SelectedPathname; end;

function TPTFrmFolderBrowseDlg.GetStatus: String;
  begin result := StatusTxt.Caption end;

function TPTFrmFolderBrowseDlg.GetOkEnabled: Boolean;
  begin result := OkBtn.Enabled end;

procedure TPTFrmFolderBrowseDlg.SetSelectedPathname(aValue: String);
  begin PTShellTree1.SelectedPathname := aValue; end;

procedure TPTFrmFolderBrowseDlg.SetStatus(aValue: String);
  begin StatusTxt.Caption := aValue; end;

procedure TPTFrmFolderBrowseDlg.SetOkEnabled( aValue: Boolean );
  begin OkBtn.Enabled := aValue; end;

procedure TPTFrmFolderBrowseDlg.WMGetMinMaxInfo( var aMsg: TWMGetMinMaxInfo );
  begin aMsg.minMaxInfo.ptMinTrackSize := Point(366,340); end;

procedure TPTFrmFolderBrowseDlg.FormCreate(Sender: TObject);
begin
  PTShellTree1.ShowRoot := TRUE;
end;

procedure TPTFrmFolderBrowseDlg.FormResize(Sender: TObject);
var r: TRect;
    x: Integer;
begin
  StatusTxt.Width := Width-24;
  r := PTShellTree1.BoundsRect;
  PTShellTree1.BoundsRect := Rect(r.left, StatusTxt.BoundsRect.Bottom+8, r.left+Width-24, ButtonPanel.BoundsRect.Top-8);

  if not (ptfbCreateDeleteButtons in Options) then
  begin
    CancelBtn.Left := PTShellTree1.BoundsRect.Right - CancelBtn.ClientWidth;
    OkBtn.Left := CancelBtn.Left - 4 - OkBtn.ClientWidth;     
  end;

  x := PTShellTree1.BoundsRect.Right;

  if DeleteFolderBtn.Visible then
  begin
    with DeleteFolderBtn.BoundsRect do
      DeleteFolderBtn.BoundsRect := Rect(x - DeleteFolderBtn.ClientWidth, Top, x, Bottom);
    x := DeleteFolderBtn.Left - 8;
  end;

  if CreateNewFolderBtn.Visible then
  begin
    with CreateNewFolderBtn.BoundsRect do
      CreateNewFolderBtn.BoundsRect := Rect(x - CreateNewFolderBtn.ClientWidth, Top, x, Bottom);
    x := CreateNewFolderBtn.Left - 4;
  end;

  with StatusTxt.BoundsRect do
    StatusTxt.BoundsRect := Rect(Left, Top, x, Bottom);
end; {TPTFrmFolderBrowseDlg.FormResize}

procedure TPTFrmFolderBrowseDlg.PTShellTree1Change(Sender: TObject; Node: TTreeNode);
var hasPathname: Boolean;
begin
  if Assigned(Node) and Assigned(Node.Data) and (TObject(Node.Data) is TPTShTreeData) then
    with TPTShTreeData(Node.Data) do
    begin
      hasPathname := (Pathname<>'');
      CreateBtn.Enabled := hasPathname;
      CreateNewFolderBtn.Enabled := hasPathname;
      DeleteBtn.Enabled := hasPathname and (node.AbsoluteIndex <> 0);
      DeleteFolderBtn.Enabled := DeleteBtn.Enabled;
      if Assigned(OnSelChange) then
        OnSelChange(self, {.}AbsoluteIdList );
    end;
end;

procedure TPTFrmFolderBrowseDlg.CreateBtnClick(Sender: TObject);
begin
  PTShellTree1.CreateNewFolder( TRUE );
end;

procedure TPTFrmFolderBrowseDlg.DeleteBtnClick(Sender: TObject);
begin
  PTShellTree1.DoCommandForNode( PTShellTree1.Selected, PTSH_CMDS_DELETE );
  PTShellTree1.RefreshNodes;
end;


end.

