unit FPTAbout; // Copyright  1996-1998 Plasmatech Software Design. All rights reserved.
{
 This is a shared unit. It is (or will be) distributed with the following products:
   Shell Control Pack . . . . . . as source
   Shell Control Pack ActiveX . . in .ocx

 Version 1.00.4     -- This version is incremented separately to the products with which it is shipped.
                       Incrementing this number will cause an increment of all the products with which
                       it is shipped. Increment one of the shipping product numbers will not necessarily
                       mean an increment in this version number.

 History
 ==============================================================
 V1.00.4  6Jul97 Change minor x.y0z versions to be displayed as x.yz instead. 
 V1.00.3 31May97 Started shared unit version numbering system.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ShellApi, DsgnIntf;

type
  TPTFrmAbout = class(TForm)
    CopyrightTxt: TLabel;
    ProductTxt: TLabel;
    VersionTxt: TLabel;
    Bevel1: TBevel;
    Button1: TButton;
    CloseBtn: TButton;
    Panel1: TPanel;
    Image1: TImage;
    Panel2: TPanel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  public
    class procedure Execute( aProduct, aYear: String;  aVersion: Integer;  aPatch: Integer );
    class procedure ExecuteCtl( aProduct, aYear, aCtlName: String;  aVersion: Integer;  aPatch: Integer );
  end;

var
  PTFrmAbout: TPTFrmAbout;

implementation
{$R *.DFM}

class procedure TPTFrmAbout.Execute( aProduct, aYear: String;  aVersion: Integer;  aPatch: Integer );
var f: TPTFrmAbout;
    s: String;
begin
  Application.CreateForm( TPTFrmAbout, f );
  try
    f.ProductTxt.Caption := Format(f.ProductTxt.Caption, [aProduct]);

    s := f.VersionTxt.Caption;
    if (aVersion mod 100) <> 0 then
    begin
      s := Format(s, [Format('%.02f',[aVersion/100])]);
      if s[Length(s)] = '0' then SetLength(s, Length(s)-1);
    end
    else
      s := Format(s, [IntToStr(aVersion div 100)]);
    if (aPatch > 0) then
      s := s + Char(Ord('a')+aPatch-1);
    f.VersionTxt.Caption := s;

    f.CopyrightTxt.Caption := Format(f.CopyrightTxt.Caption, [aYear]);
    f.ShowModal;
  finally
    f.Free;
  end;
end;


class procedure TPTFrmAbout.ExecuteCtl( aProduct, aYear, aCtlName: String;  aVersion: Integer;  aPatch: Integer );
var f: TPTFrmAbout;
    s: String;
begin
  Application.CreateForm( TPTFrmAbout, f );
  try
    f.ProductTxt.Caption := Format(f.ProductTxt.Caption, [aProduct]);

    s := f.VersionTxt.Caption;
    if (aVersion mod 100) <> 0 then
    begin
      s := Format(s, [Format('%.02f',[aVersion/100])]);
      if s[Length(s)] = '0' then SetLength(s, Length(s)-1);
    end
    else
      s := Format(s, [IntToStr(aVersion div 100)]);
    if (aPatch > 0) then
      s := s + Char(Ord('a')+aPatch-1);
    f.VersionTxt.Caption := s;

    f.CopyrightTxt.Caption := Format(f.CopyrightTxt.Caption, [aYear]);
    f.Caption := f.Caption + ' ' + aCtlName;
    f.ShowModal;
  finally
    f.Free;
  end;
end;

procedure TPTFrmAbout.Button1Click(Sender: TObject);
const PLASMATECH_URL = 'http://plasmatech.com';
begin
  ShellExecute( Handle, nil, PLASMATECH_URL, nil, nil, SW_SHOWNORMAL );
end;

procedure TPTFrmAbout.FormCreate(Sender: TObject);
begin
end;


end.

