#include <windows.h>
#include <glide.h>
#include "winstuff.h"
#include "stdio.h"

BOOL keys[256];
HWND mainhwnd;
static RECT rect;
int cxChar;
int cyChar;
int UseKeys;
HDC hdc;
TEXTMETRIC  tm;
extern int frameCount;
extern LPDIRECTINPUTDEVICE g_pMouse;

HINSTANCE  g_hinst;                     /* My instance handle */
BOOL       g_fActive;                   /* Am I the active window? */


LRESULT CALLBACK DemoWindowProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch (iMsg) {
	case WM_CREATE:
            hdc = GetDC(hwnd);
            SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));
            GetTextMetrics(hdc,&tm);
            cxChar = tm.tmAveCharWidth;
            cyChar = tm.tmHeight +tm.tmExternalLeading;
            ReleaseDC(hwnd,hdc);

	    return 0;
	case WM_MOVE:
        if (!grSstControl(GR_CONTROL_MOVE)) {
            //PostMessage( hWndMain, WM_CLOSE, 0, 0 );
            return 0;
        }
        break;
    case WM_SIZE:
        if (!grSstControl(GR_CONTROL_RESIZE)) {
            //PostMessage( hWndMain, WM_CLOSE, 0, 0 );
            return 0;
        }
        rect.left = 0;
        rect.top = 0;
        rect.right = LOWORD(lParam);
        rect.bottom = HIWORD(lParam);
        break;
    case WM_ACTIVATE:
        {
        WORD fActive = LOWORD(wParam);
        BOOL fMinimized = (BOOL) HIWORD(wParam);

        /*   if ( ( fActive == WA_INACTIVE ) || fMinimized ) {
              grSstControl( GR_CONTROL_DEACTIVATE );
           } else {
              grSstControl( GR_CONTROL_ACTIVATE );
           }*/
       }
       break;
    case WM_KILLFOCUS:
		//if (VoodooRunning) grSstControl( GR_CONTROL_DEACTIVATE );
		return 0;
	case WM_SETFOCUS:
		//if (VoodooRunning) grSstControl( GR_CONTROL_ACTIVATE );
		return 0;
	case WM_KEYDOWN:
		if(wParam == VK_CAPITAL){
		    UseKeys = !UseKeys;
		    return 0;
		}
		if(UseKeys)
    		keys[wParam] = TRUE;
        else
            keys['Q'] = TRUE;
		return 0;
	case WM_KEYUP:
		keys[wParam] = FALSE;
		return 0;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	}
    return(DefWindowProc(hwnd,iMsg,wParam,lParam));
}

HWND StartWindow(HINSTANCE hInstance, int iCmdShow)
{
    HWND                hwnd;
    WNDCLASSEX            wc;
    g_hinst=hInstance;
    wc.cbSize        = sizeof(wc);
    wc.style         = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc   = DemoWindowProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon(hInstance, IDI_APPLICATION);
    wc.hCursor       = LoadCursor(NULL,IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = szAppName;
    wc.hIconSm       = LoadIcon(hInstance, IDI_APPLICATION);
    RegisterClassEx(&wc);

    hwnd = CreateWindowEx(
        0,
        szAppName,
        szAppName,
        WS_OVERLAPPEDWINDOW,
        //WS_POPUP,
		CW_USEDEFAULT,
        CW_USEDEFAULT,
		CW_USEDEFAULT,
        CW_USEDEFAULT,
        NULL,
        NULL,
        hInstance,
        NULL );
    ShowWindow( hwnd, iCmdShow);
    UpdateWindow( hwnd );
	mainhwnd = hwnd;
	return(hwnd);
}

int Print(char *mytext){
    //return 0;
    int tmp;

    ScrollWindow(mainhwnd, 0 , -cyChar,
        &rect,&rect);
    hdc = GetDC(mainhwnd);
    SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));
    tmp = TextOut (hdc, cxChar<<1, cyChar*(rect.bottom/cyChar -2),mytext,strlen(mytext));
    ReleaseDC(mainhwnd,hdc);
    ValidateRect(mainhwnd,&rect);

    return tmp;
}