#ifndef _THINGS_H_
#define _THINGS_H_

#include <glide.h>
#include "math3d.h"
#include "land.h"

#define setflag 1
#define setuseinput 2
#define setyaw 3
#define setpitch 4
#define setroll 5
#define setx 6
#define sety 7
#define setz 8
#define setlight 9
#define setrad 10
#define setdyaw 11
#define setdpitch 12
#define setdroll 13
#define setmove 14

#define move_none 0
#define move_fly 1
#define move_roll 2


typedef struct faces_t{
    int *ndx;
    int NumSides;
    int Surf;
    float *t,*s;
    int texindx;
    int surfclr;
};

void FreeThing(entity_t &Entity);
BOOL MyDrawTriangleTooClose(GrVertex bad1, GrVertex bad2,GrVertex bad3,
                       GrVertex old1, GrVertex old2,GrVertex old3,
                       Matrix rot,float x, float y, float z);
short	BigShort (short l);
short	LittleShort (short l);
int		BigLong (int l);
int		LittleLong (int l);
float	BigFloat (float l);
float	LittleFloat (float l);

typedef struct SURFS{
    char *Name;
    char r,g,b,a;
    short Flags; //Bla It is there if we want it though.
    short Lumi, Diff, Spec, Refl, Tran;
    //Luminosity, (donno what to do with this.)
    //Diffuse, ditto
    //Specular, I'll have to find that one sometime.
    //Reflection, only if we have CPU and polygons to burn.
    //Transparency, 255 - Trans == Alpha.
    short Glos;  //something about being glossy. 0 none, 1024 max.
    //I'm defining somethings but not really so I know what they are later.
    //char *RIMG;  //Reflection image file.
    //float RSAN;  haha, mirror reflection angle! haha
    //float FIND;  Refraction, haha, like I have time to figure that out too.
    //float EDGE;  something about transpearency threshold.
    //float SMAN;  This specifies smoothing angle threshold.
    char *CTEX, *DTEX, *STEX, *RTEX, *TTEX, *BTEX;
    //CTex, Color texture, what is the difference between this and TIMG?
    //DTex, Diffuse texture. (I won't use it.)
    //STex, Specular texture. (maybe, not with transperency.)
    //RTex, Reflection texture. (I don't understand this one well, maybe variable reflection won't use)
    //TTex, Transparency texture. Will probably use with color texture very much. (6 letters and a mip level pair)
    //ie MyText00 biggest copy, MyText01 next largest ...
    //BTex, Bump map.  won't use this either. (How?)
    char *TIMG;     //This will be the texture map source.
    //short TFLG;     //Not used.  Maybe antialiasing flag later.
    POINT TSIZ, TCTR, TFAL, TVEL;//Texture info that I don't understand yet.
    //char Tr, Tg, Tb, Tn;//TCLR thingy...  I think it modifies the channels.
    short TVAL; //Modifies DTEX, STEX, RTEX, and TTEX...??
    //short TAMP;  //Amplitude of bump map. . .


};


class entity_t{
    //private:
    public:
    float ox,oy,oz;
    float dx,dy,dz,redx,redy,redz;
    float ax,ay,az,dyaw,dpitch,droll,ayaw,apitch,aroll,iyaw,ipitch,iroll;
    int useinput;
    double MyShootTime;
    float zoomx,zoomy;
    faces_t *Tris;
    SURFS *Surfs;
    int NumSurfs;
    int NumTris;
    int BoxX[2],BoxY[2],BoxZ[2];
    Matrix RotA;
    GrVertex *Verts;//,xVerts[26];
    //public:
    char *lwon;
    int rad;
    float yaw, pitch, roll;//yaw=xz, pitch=y offset from yaw, roll = rotational around the compound angle of yaw and pitch.
    int flag;
    entity_t *Owner,*Enemy;
    int movetype;
    int locid;
    float lightr, lightg, lightb, lighta,lighth;
    int light,die,nolight;
    float x,y,z;
    int NumVerts;
    GrVertex *rVerts;//,xVerts[26];
    light_t  *lit;
    entity_t *prev;
    entity_t *next;
    //Functions:
    entity_t(char *lwo);                //Just loads this lwo during startup.
    entity_t();                         //Just sit there. probably camera.
    entity_t(float ix,float iy,float iz);
    entity_t(float ix,float iy,float iz, float idx, float idy, float idz);
    entity_t(float ix,float iy,float iz, float idx, float idy, float idz, float iyaw, float ipitch, float iroll);
    entity_t(char *lwo,float ix,float iy,float iz);
    entity_t(char *lwo,float ix,float iy,float iz, float idx, float idy, float idz);
    entity_t(char *lwo,float ix,float iy,float iz, float idx, float idy, float idz, float iyaw, float ipitch, float iroll);


    void setit(int modify, float value);    //Set soemthing
    void setsize(float lx, float ly, float lz, float hx, float hy, float hz);
    void fov();                              //Set Field Of View
    void LoadLWO(char *mlwo);                 //Reads a lwo that is new.
    void PrintStats();                       //Prints coords and headings.
    void lights(float Red, float Green, float Blue, float Alpha = 255,float hard = 2);
    void entity_t::castlight(entity_t *Other);
    double thinktime;                      //When to think the next thing.
    int (*nextthink)();                 //What to do later.

    int move();                         //move my butt.

    void render(Matrix rotc);                           //Draw me.

    int CameraRender();                 //Render the world from this point.

    int collide(entity_t *Other);        //see if we hit this guy.
    int collide(void);                  //see if we hit the ground.

    ~entity_t();                        //Destructor.  Free and die.


};

extern entity_t Camera, *Self, *Other, *Head,*Tail;

#endif //Things.h