#include <windows.h>
#include "dmouse.h"
#include "winstuff.h"
#include <stdio.h>
#include <e:\directx\sdk\inc\dinput.h>
char MyS[256];

/****************************************************************************
 *
 *      DIInit
 *
 *      Initialize the DirectInput variables.
 *
 ****************************************************************************/

BOOL DIInit(HWND hwnd)
{
    HRESULT hr;

    /*
     *  Register with DirectInput and get an IDirectInput to play with.
     */
    hr = DirectInputCreate(g_hinst, DIRECTINPUT_VERSION, &g_pdi, NULL);

    if (FAILED(hr)) {
        sprintf(MyS,"DirectInputCreate");
        Print(MyS);
        //Complain(hwnd, hr, "DirectInputCreate");
        return FALSE;
    }

    /*
     *  Obtain an interface to the system mouse device.
     */
    hr = g_pdi->CreateDevice(GUID_SysMouse, &g_pMouse, NULL);

    if (FAILED(hr)) {
        sprintf(MyS,"CreateDevice(SysMouse)");
        Print(MyS);
        //Complain(hwnd, hr, "CreateDevice(SysMouse)");
        return FALSE;
    }

    /*
     *  Set the data format to "mouse format".
     */
    hr = g_pMouse->SetDataFormat(&c_dfDIMouse);

    if (FAILED(hr)) {
        sprintf(MyS,"SetDataFormat");
        Print(MyS);
        //Complain(hwnd, hr, "SetDataFormat(SysMouse, dfDIMouse)");
        return FALSE;
    }


    /*
     *  Set the cooperativity level.
     */
    hr = g_pMouse->SetCooperativeLevel(hwnd,
                                       DISCL_EXCLUSIVE | DISCL_FOREGROUND);

    if (FAILED(hr)) {
        sprintf(MyS,"SetCooperativeLevel");
        Print(MyS);
        //Complain(hwnd, hr, "SetCooperativeLevel(SysMouse)");
        return FALSE;
    }


    /*
     *  Create the handle that tells us new data is available.
     */
    g_hevtMouse = CreateEvent(0, 0, 0, 0);

    if (g_hevtMouse == NULL) {
        sprintf(MyS,"CreateEvent");
        Print(MyS);
        //Complain(hwnd, GetLastError(), "CreateEvent");
        return FALSE;
    }

    /*
     *  Associate the event with the device.
     */
    hr = g_pMouse->SetEventNotification(g_hevtMouse);

    if (FAILED(hr)) {
        sprintf(MyS,"SetEventNotification");
        Print(MyS);
        //Complain(hwnd, hr, "SetEventNotification(SysMouse)");
        return FALSE;
    }

    /*
     *  Set the buffer size to DINPUT_BUFFERSIZE elements.
     *  The buffer size is a DWORD property associated with the device.
     */
    DIPROPDWORD dipdw =
        {
            {
                sizeof(DIPROPDWORD),        // diph.dwSize
                sizeof(DIPROPHEADER),       // diph.dwHeaderSize
                0,                          // diph.dwObj
                DIPH_DEVICE,                // diph.dwHow
            },
            DINPUT_BUFFERSIZE,              // dwData
        };

    hr = g_pMouse->SetProperty(DIPROP_BUFFERSIZE, &dipdw.diph);

    if (FAILED(hr)) {
        sprintf(MyS,"Set Buffer Size");
        Print(MyS);
        //Complain(hwnd, hr, "Set buffer size(SysMouse)");
        return FALSE;
    }
    g_pMouse->Acquire();
    return TRUE;

}
/****************************************************************************
 *
 *      DITerm
 *
 *      Terminate our usage of DirectInput.
 *
 ****************************************************************************/

void DITerm(void)
{
    if (g_pdi)      g_pdi   ->Release(), g_pdi    = NULL;
    if (g_pMouse)   g_pMouse->Release(), g_pMouse = NULL;

    if (g_hevtMouse) CloseHandle(g_hevtMouse), g_hevtMouse = NULL;
}

void UpdateCursorPosition(int dx, int dy)
{

    /*
     *  Pick up any leftover fuzz from last time.  This is important
     *  when scaling down mouse motions.  Otherwise, the user can
     *  drag to the right extremely slow for the length of the table
     *  and not get anywhere.
     */

    MouseCurX += dx;
    MouseCurY -= dy;
    if (dx) GDx = dx;
    if (dy) GDy = dy;
    /* Clip the cursor to our client area */
    if (MouseCurX < 0)                MouseCurX = 0;
    if (MouseCurX >= 640) MouseCurX = 639;

    if (MouseCurY < 0)                MouseCurY = 0;
    if (MouseCurY >= 480) MouseCurY = 479;

}
int MouseRead(HWND hwnd){
    int buttons=0;
    while(buttons==0){
        DIDEVICEOBJECTDATA od;

        DWORD dwElements = 1;


        HRESULT hr;
        hr = g_pMouse->GetDeviceData(
                             sizeof(DIDEVICEOBJECTDATA), &od,
                             &dwElements,
                             0
                             );
        if (hr == DIERR_INPUTLOST) {
            /*
             *  We had acquisition, but lost it.  Try to reacquire it.
             *
             *  WARNING!  DO NOT ATTEMPT TO REACQUIRE IF YOU GET
             *  DIERR_NOTACQUIRED!  Otherwise, you're extremely likely
             *  to get caught in an infinite loop:  The acquire will fail,
             *  and you'll get another DIERR_NOTACQUIRED so you'll
             *  try to aquire again, and that'll fail, etc.
             */
            //PostMessage(hwnd, WM_SYNCACQUIRE, 0, 0L);
            return 0;
        }

        /* Unable to read data or no data available */
        if (FAILED(hr) )
            return 0;
        if (dwElements == 0)
            return 0;

        /* Look at the element to see what happened */

        switch (od.dwOfs) {

        /* DIMOFS_X: Mouse horizontal motion */
        case DIMOFS_X: UpdateCursorPosition(od.dwData, 0); break;


        /* DIMOFS_Y: Mouse vertical motion */
        case DIMOFS_Y: UpdateCursorPosition(0, od.dwData); break;
        case DIMOFS_BUTTON0:
            keys[VK_LBUTTON]=1-keys[VK_LBUTTON];break;
        case DIMOFS_BUTTON1:
            keys[VK_RBUTTON]=1-keys[VK_RBUTTON];break;
        case DIMOFS_BUTTON2:
            keys[VK_MBUTTON]=1-keys[VK_MBUTTON];break;


        }
    }
    return 1;
}