#include "winstuff.h"
#ifndef _MATH3D_H_
#define _MATH3D_H_
//No more deg2rad because we will use rad.
#ifndef M_PI
#define M_PI    3.141592654f
#define M_PIx2  6.283185308f
#define M_PId2  1.570796327f
#endif
//Don't need this next line but it is available.
//Don't use it because we are using a lookup table.
#define DEG2RAD( x ) ( (x) * M_PI / 180.0f )

typedef float Matrix[4][4];
extern Matrix rotx, roty, rotz, rotc, rote, roto, tranm;


/* Math3d.c prototypes */
void MatMakeXRot( Matrix m, float radians );
void MatMakeYRot( Matrix m, float radians );
void MatMakeZRot( Matrix m, float radians );
void MatMakeIdent( Matrix m );
void MatMultMat(Matrix m, Matrix n,Matrix result);
void PointMatMult( GrVertex *result, GrVertex *v, Matrix m );
void PointMatMultxz( GrVertex *result, GrVertex *v, Matrix m );
void PointMatMultyz( GrVertex *result, GrVertex *v, Matrix m );

void SetIntelPrecision();
#endif //math3d.h