#include <math.h>
#include "math3d.h"
#include "winstuff.h"
#include "trigs.h"

void MatMakeXRot( Matrix m, float radians ){
  float c = Cos[ (int)radians ];
  float s = Sin[ (int)radians ];

  m[0][0] = 1.0f;  m[0][1] = 0.0f;    m[0][2] = 0.0f;    m[0][3] = 0.0f;
  m[1][0] = 0.0f;  m[1][1] = c;       m[1][2] = s;       m[1][3] = 0.0f;
  m[2][0] = 0.0f;  m[2][1] = -s;      m[2][2] = c;       m[2][3] = 0.0f;
  m[3][0] = 0.0f;  m[3][1] = 0.0f;    m[3][2] = 0.0f;    m[3][3] = 1.0f;
}

void MatMakeYRot( Matrix m, float radians ){
  float c = Cos[ (int)radians ];
  float s = Sin[ (int)radians ];

  m[0][0] = c;     m[0][1] = 0.0f;    m[0][2] = -s;      m[0][3] = 0.0f;
  m[1][0] = 0.0f;  m[1][1] = 1.0f;    m[1][2] = 0.0f;    m[1][3] = 0.0f;
  m[2][0] = s;     m[2][1] = 0.0f;    m[2][2] = c;       m[2][3] = 0.0f;
  m[3][0] = 0.0f;  m[3][1] = 0.0f;    m[3][2] = 0.0f;    m[3][3] = 1.0f;
}

void MatMakeZRot( Matrix m, float radians ){
  float c = Cos[ (int)radians ];
  float s = Sin[ (int)radians ];

  m[0][0] = c;     m[0][1] = s;       m[0][2] = 0.0f;    m[0][3] = 0.0f;
  m[1][0] = -s;    m[1][1] = c;       m[1][2] = 0.0f;    m[1][3] = 0.0f;
  m[2][0] = 0.0f;  m[2][1] = 0.0f;    m[2][2] = 1.0f;    m[2][3] = 0.0f;
  m[3][0] = 0.0f;  m[3][1] = 0.0f;    m[3][2] = 0.0f;    m[3][3] = 1.0f;
}

void MatMakeIdent( Matrix m ){
  int i, j;

  for( i = 0; i < 4; i++ )
    {
      for( j = 0; j < 4; j++ )
        {
          if( i == j )
            m[i][j] = 1.0f;
          else
            m[i][j] = 0.0f;
        }
    }
}
void MatMultMat(Matrix m, Matrix n,Matrix result){
    Matrix New;
    int tmp1,tmp2,tmp3,i,j;

    for (tmp2 = 0;tmp2<4;tmp2++)
        for (tmp3 = 0;tmp3<4;tmp3++){
            New[tmp2][tmp3]=0;
            for(tmp1 = 0; tmp1<4;tmp1++)
                New[tmp2][tmp3] += (m[tmp2][tmp1]*n[tmp1][tmp3]);
        }
    for (i = 0; i <4;i++)
        for (j=0;j<4;j++)
            result[i][j] = New[i][j];
    //return New;
}
void PointMatMult( GrVertex *result, GrVertex *v, Matrix m ){
  float w;
  GrVertex ptmp;

  ptmp = *v;
  ptmp.x = ( v->x * m[0][0] ) + ( v->y * m[1][0] ) +
    ( v->z * m[2][0] ) + m[3][0];
  ptmp.y = ( v->x * m[0][1] ) + ( v->y * m[1][1] ) +
    ( v->z * m[2][1] ) + m[3][1];
  ptmp.z = ( v->x * m[0][2] ) + ( v->y * m[1][2] ) +
    ( v->z * m[2][2] ) + m[3][2];
  //w = ( v->x * m[0][3] ) + ( v->y * m[1][3] ) +
  //  ( v->z * m[2][3] ) + m[3][3];
  //if( w != 0.0f ) { ptmp.x /= w;  ptmp.y /= w;  ptmp.z /= w; }
  *result = ptmp;
}
void PointMatMultxz( GrVertex *result, GrVertex *v, Matrix m ){
  float w;
  GrVertex ptmp;

  ptmp = *v;
  ptmp.x = ( v->x * m[0][0] ) + ( v->y * m[1][0] ) +
    ( v->z * m[2][0] ) + m[3][0];
  //ptmp.y = ( v->x * m[0][1] ) + ( v->y * m[1][1] ) +
    //( v->z * m[2][1] ) + m[3][1];
  ptmp.z = ( v->x * m[0][2] ) + ( v->y * m[1][2] ) +
    ( v->z * m[2][2] ) + m[3][2];
  //w = ( v->x * m[0][3] ) + ( v->y * m[1][3] ) +
  //  ( v->z * m[2][3] ) + m[3][3];
  //if( w != 0.0f ) { ptmp.x /= w;  ptmp.y /= w;  ptmp.z /= w; }
  *result = ptmp;
}
void PointMatMultyz( GrVertex *result, GrVertex *v, Matrix m ){
  float w;
  GrVertex ptmp;

  ptmp = *v;
  //ptmp.x = ( v->x * m[0][0] ) + ( v->y * m[1][0] ) +
    //( v->z * m[2][0] ) + m[3][0];
  ptmp.y = ( v->x * m[0][1] ) + ( v->y * m[1][1] ) +
    ( v->z * m[2][1] ) + m[3][1];
  ptmp.z = ( v->x * m[0][2] ) + ( v->y * m[1][2] ) +
    ( v->z * m[2][2] ) + m[3][2];
  //w = ( v->x * m[0][3] ) + ( v->y * m[1][3] ) +
  //  ( v->z * m[2][3] ) + m[3][3];
  //if( w != 0.0f ) { ptmp.x /= w;  ptmp.y /= w;  ptmp.z /= w; }
  *result = ptmp;
}

void SetIntelPrecision(){
    int memvar;
	//taken directly from the Glide 2.0 programming Guide
	//dunno how or if this works but here it is anyway
	_asm {
		finit
		fwait
		fstcw memvar
		fwait
		mov eax,memvar
		and eax,0xfffffcff
		mov memvar,eax
		fldcw memvar
		fwait
	}
	memvar=0;
}


