/*IMPACT Engine 3d screensaver.
By Andy Bay  ABay@Teir.com
June-July 1997
I started programming glide and 3d in February of '97.
I started programming in Quick Basic when I was 8.
I got into computers when I was 5.
*/


#include <conio.h>//Files I think.
#include <stdlib.h>//I think I use something in here.  probably memcopy.
#include <stdio.h>//sprintf and such functions:
#include <math.h>//If you make a 3d game without this, hi.
#include <string.h>//I do a little bit of stuff with strings.
#include <glide.h>//3d api
#include <windows.h>//Windows stuff
#include "winstuff.h"//This app window stuff.
#include <time.h>//Gotta wear a watch
#include <e:\directx\sdk\inc\dinput.h>//I like my mouse.
#include "myjoy.h"//Joysticks are useful too.
//#include "midasdll.h"//For sound.
#include "things.h"//My Stuff
#include "dmouse.h"//My Mouse
//#include "sound.h"//More sound stuff
#include "trigs.h"//My Sin and Cos lookup tables.
#include "land.h"//Land engine.
#include "direct.h"//Duh, I forgot. Must be important though.

Matrix rotx, roty, rotz, rotc, rote, roto, tranm;   //These are the major matrix holders.
float Camx,Camy,Camz,Camzoomx,Camzoomy;             //The camera originally wasn't as available so
                                                    //I had these
BOOL paused=0;                                      //Is the game paused?
GrHwConfiguration hwconfig;                         //Glide Hardware config structure
BOOL VoodooRunning=FALSE,SoundActive=FALSE;         //Is the Voodoo operating?  Sound?
HWND mainhwnd;                                      //I made a global for the windows hwnd so I could get to it.
int TryCount,OldTryCount,AttCount,AttOld;           //Statistics for triangle rendering.
int frameCount = 0;                                 //frame number for this second
BOOL DIInit(HWND hwnd);                             //Prototype for Mouse init.
void DITerm(void);                                  //Prototype for Mouse closing.
int mouseon=1;                                      //Use mouse?  (I don't think I use it in this.)
int FogColor = 0x00202040;                          //Fog color in AARRGGBB hex
GrVertex FoVTri[3], FoVTriT[3];                     //Field of view verts
float Tridx[3],Tridz[3],Trim[3],Trib[3],Tric[3];    //Field of view equation data dz*x+dx*z<c

char ** commandLineToArgv(LPSTR lpCmdLine, int *pArgc);//Commandline reading.
                                                    //I got this from tlib.
float factorx;// = widthx / 2;                      //used for fov calc
float factory;// = widthy / 2;                      //used for fov calc
float alpha = 45; 	                                //(your favorite viewing angle);
float gfov = 1 / tan(DEG2RAD(alpha) /2);            //you'd best look at entity_t::fov()
float aspect;                                       //ratio for y

void InitGlide(void);                               //prototype
long startime, endtime,Score=0;                     //Time variables for dt calc.
double dt,dt2,dt3,GameTime,SwitchCam=60;            //several time things
/*
    dt is the time from the last frame.  0 during pause.
    dt2 is the time from the last second mark we used.(this goes from 0 to 1 then starts over used for
        instantaneous fps)
    dt3 is somewhere.
    GameTime is the total dt's
    SwitchCam is when the camera goes to the next thing.
*/

int JoyActive=0;                                    //Is the joystick active.
JOYINFOEX JoyStats;                                 //Joystick state.
JOYCAPS JoyCaps;                                    //Number of Joysticks and other info.

char MyS[256],MyS2[256];                            //Temporary strings.
float wWidth, wHeight,worker,wHWidth,wHHeight,GDx,GDy;//some screen variables and mouse globals.
extern BOOL keys[256];                              //keyboard key states.
//Glide stuff
    FxBool
        depthBias = FXTRUE,
        blend = FXFALSE,
        texturing = FXFALSE,
        antialias = FXTRUE,
        bilinear = FXTRUE,
        render = FXTRUE,
        backbuffer = FXTRUE,
        background = FXTRUE;

    GrState
        nonBlendState, blendState;

    GrScreenResolution_t
        screenRes;

    GrColorCombineFnc_t
        ccFnc = GR_COLORCOMBINE_ITRGB;

    entity_t Camera, *Self, *Other,*Head,*Tail;
    //Camera and thing linked list.  The camera is the only automatic thing.
    //This engine is based on the Camera being indipendant of any particular thing.
    //Self is the current thing being affected.
    //Other is used more liberally.
    //Head is the first linked list entity.
    //Tail is the last.  Easier to keep track of it than to keep going through it from the head.

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	MSG msg;

    float
        cvdx=0,cvdy=0;


    int i,j,thingcount=0,oldthingc=0,rthing=0,orthingc=0;//temp variables and thing statistic count.


    float                                           // I don't think these are used here.
        speed,dx,dy,c,s,GDs,dx1,dy1,dz1,dz;

    int oldframeCount =0,                           //Frame thing.
        nTris = 0,tmp;                              //temp variables.
    screenRes = GR_RESOLUTION_640x480;              //Target resolution.

    //Start check for parameters

    int     argc;
    char    **argv;
    argv = commandLineToArgv(szCmdLine, &argc);
    getcwd(MyS,255);
    for(i = 0;i<argc;i++){
        //Print(argv[i]);
        if(!strcmpi(argv[i],"/p"))
            exit(1);
        if(!strcmpi(argv[i],"/c"))
            exit(1);
    }

    mainhwnd=StartWindow(hInstance,iCmdShow);
    Print(MyS);                                     //Print the current directory

    //End Check



    if(mouseon)                                     //I guess it is used some.
        i = DIInit(mainhwnd);                       //Aquire the mouse.
    JoyActive = DIInitJoy(mainhwnd);                //See if there are joystick ports.
    if(JoyActive){
        JoyStats.dwSize = sizeof(JOYINFOEX);        //Have to tell GetDevCaps the size of the structure.
        j=joyGetDevCaps(0,&JoyCaps,sizeof(JOYCAPS));//Get the data for the joystick, like is it active.
        JoyFixBias();                               //Fix the biases because they go from 0-65536 and not -32k to 32k
    }
    initTrigs();                                    //Load the Sin and Cos lookup tables.
    srand(clock());                                 //Randomize the random number generator
    //Sound activation:
    //InitSound();
    land = new land_t[GridNum*GridNum];             //allocate the land.
    Print("Please wait.  Terraforming.  Hit Caps to gain keyboard usage");
    Genland();                                      //Guess
    InitGlide();                                    //Start Glide After that so they can see it.

    if(VoodooRunning){                              //It worked, set some stuff up.
        wWidth = grSstScreenWidth();                //Set the width in case we got something differnt
        wHeight = grSstScreenHeight();              //Hight version
        wHWidth = wWidth/2;                         //Center of screen
        wHHeight = wHeight/2;                       //Center again.
        aspect = wWidth/wHeight;;                   //Aspect is used!
        Camera.fov();                               //Generate FoV stuff
    }
    Tail=Head = Self = new entity_t("mainship.lwo",1024,300,1192,0,0,0);//Make our first thing
    Head->next = Tail;                              //This actually doesn't work too well.
    Tail->prev = Head;                              //Yeah very not.  Makes a loop.  Could be useful.
    Camera.setit(setx,1024);                        //Put the camera here
    Camera.setit(sety,300);
    Camera.setit(setz,1024);
    Camera.setit(setflag,2);                        //Tell the camera to follow something.
    Camera.setit(setmove,move_none);                //This doesn't have a special movetype
    //Camera.setit(setuseinput,1);                  //This would tell the camera to use the inputs
    Camera.next = Self;                             //This tells the camera what to follow
    Camera.prev = Self;                             //This tells it what it was following.
    //Self->prev = &Camera;                         //Chain use to start with the Camera.
    Self->setit(setflag,5);                         //AI type.  Kill anything that moves.
    Self->setit(setmove,move_fly);                  //make this thing fly.
    Self->setsize(-8,-4,-8,8,4,8);                  //size.
    Self->setit(setuseinput,0);                     //It too doesn't use input.
    for(i = 0;i<5;i++){                             //Make the other 10 things.
        //There are 5 planes and they always hate the tank after them.
        //First we create him.
        Tail->next = new entity_t("enemy1.lwo",random(GridNum*gridsep),300,random(GridNum*gridsep),0,0,128+4*i,random(MaxAng),0,0);
        Tail->next->prev = Tail;                    //Then we set the new guys' previous to the current guy
        Tail = Tail->next;                          //Then we move the Tail to the new guy
        Tail->setit(setmove,move_fly);              //Set his movement type
        Tail->setit(setflag,5);                     //If it moves, shoot it.
        Tail->setsize(-10,-10,-10,10,10,10);        //He is a little bigger.

        //This is our tank.  First we make him.
        Tail->next = new entity_t("tank.lwo",random(GridNum*gridsep),0,random(GridNum*gridsep),0,0,128+4*i,random(MaxAng),0,0);
        Tail->Enemy = Tail->next;                   //You'll see a lot of this going on.
        Tail->next->Enemy = Tail;                   //Make him angery at the plane just made.
        Tail->next->prev = Tail;
        Tail = Tail->next;
        Tail->setit(setmove,move_roll);             //This guy rolls along the ground.
        Tail->setit(setflag,5);                     //Kill anything that moves.
        Tail->setsize(-10,-10,-10,10,10,10);        //He's big too.
    }
    Head->prev = 0;                                 //Fix the loop problem
    Tail->next = 0;

    dt=0;                                           //start the time up.
    dt2=0;
    startime = clock();                             //when is now?

    while ( 1 ) {                                   //Main Game Loop
                                    //Read windows input/events
        while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
            if (msg.message == WM_QUIT) break;
                TranslateMessage(&msg);
    			DispatchMessage(&msg);
	    }

	    if (VoodooRunning == FALSE) continue;       //Allow HW failures to be reported nicely.  Until I figure out dialog boxes, or something.
	    grSstIdle();                              //This could be good if you get too many frames.
        grBufferSwap(1);                            //Send the back buffer forward.
        grBufferClear( FogColor, 0, GR_WDEPTHVALUE_FARTHEST );//Clear the buffer with the fog color.
        endtime = clock();                          //What time is it now?
        dt=dt2;                                     //save the dt2
        dt2=((double)(endtime-startime)/CLOCKS_PER_SEC);//find the delta time.
        dt=dt2-dt;                                  //Find how long it has been since the last frame.
        if (dt2>=1) {                               //If dt2 is over a second, it is time to reset it.
            oldthingc=thingcount;                   //Lots of statistics.
            thingcount=0;
            orthingc=rthing;
            rthing=0;
            oldframeCount = frameCount/dt2;
            dt3=dt2;                                //Dt3 backs up dt2 before dt2 is reset.
            frameCount = 0;
            startime = endtime;
            dt2=0;
            AttOld=AttCount;
            AttCount=0;
            OldTryCount=TryCount;
            TryCount=0;
        }
        if(paused == 1) dt=0;                       //Pausing is a hack but it works well.  Time teaser
        GameTime +=dt;                              //Adjust game clock.
        if (keys['I']){                             //Info screen.
            Camera.PrintStats();
            Camera.next->PrintStats();
            //sprintf(MyS,"Ball: Yaw: %f,Pitch: %f,Roll: %f %f %f",Ball.eye.yaw,Ball.eye.pitch,Ball.eye.roll,cvdx,cvdy);
            //Print(MyS);
            //sprintf(MyS,"dx: %f ,dy: %f,dz: %f, %i",Ball.dx,Ball.dy,Ball.dz,255/8);
            //Print(MyS);
            sprintf(MyS,"Frame: %i FPS: %f", frameCount,frameCount/dt2);
            Print(MyS);
            sprintf(MyS,"Attempts: %i Drew: %if", AttOld,OldTryCount);
            Print(MyS);
            sprintf(MyS,"Tris/Sec : %f", OldTryCount/(oldframeCount/dt3));
            Print(MyS);
            sprintf(MyS,"For 60fps: %f", OldTryCount/(60/dt3));
            Print(MyS);
            sprintf(MyS,"For 45fps: %f", OldTryCount/(45/dt3));
            Print(MyS);
            sprintf(MyS,"For 30fps: %f", OldTryCount/(30/dt3));
            Print(MyS);
            sprintf(MyS,"Num Frames: %i Things: %i Rendered %i T/f: %f RT/f: %f",oldframeCount,oldthingc, orthingc,(float)oldthingc/oldframeCount, (float)orthingc/oldframeCount);

            Print(MyS);
        }
        if (keys['H']){                             //Display a rendering grid.
            Print("");
            for(i = 0;i<GridNum;i++){
                sprintf(MyS,"");
                for(j=0;j<GridNum;j++){
                    sprintf(MyS,"%s%i",MyS,land[i*GridNum+j].rendered);
                }
                Print(MyS);
            }
        }
        if(GameTime>SwitchCam){             //This controls the automatic camera switch
            keys['N']=1;
            SwitchCam=GameTime+120;
        }
        if (keys['N']){                     //Manual camera switch/invoked by autoswitch
            keys['N'] = FALSE;
            //Camera.prev = Camera.next;
            if(Camera.next->flag == -1)
                Camera.next->setit(setflag,5);
            Camera.next->setit(setuseinput,0);
            Camera.prev = Camera.next;
            if(Camera.next->movetype == move_fly ||Camera.next->movetype == move_roll){
                Camera.next = Camera.next->next;
            }
            else{
                Camera.next = Camera.prev->next;
                if((Camera.next) && !(Camera.next->movetype == move_fly ||Camera.next->movetype == move_roll)){
                    Camera.next = Head;
                }
            }
            if(Camera.next == 0) Camera.next = Head;
        }
        if (keys['Y']){                             //Manual control
            keys['Y'] = 0;
            Camera.next->setit(setflag,-1);         //AI type, User.
            Camera.next->setit(setuseinput,1);      //Use the input.
            Camera.iyaw = 0;
            Camera.ipitch = 0;
            //Camera.dyaw = 0;
            //Camera.dpitch = 0;
        }
        if (keys['B']){                             //Previous camera view.
            keys['B'] = FALSE;
            if(Camera.next->flag == -1)
                Camera.next->setit(setflag,5);
            Camera.next->setit(setuseinput,0);
            //Camera.prev = Camera.next;
            Camera.next = Camera.next->prev;
            if(Camera.next == 0) Camera.next = Tail;
        }
        if(keys['V']){                              //Camera mode
            keys['V'] = 0;
            if (Camera.flag == 3){
                Camera.setit(setflag,2);            //Chase
            }
            else
                Camera.setit(setflag,3);            //Inside
        }

        Self = Head;
        tmp = 0;
        while(Self){                                //This tells everybody to move.
            Self->move();
            if(Self->thinktime>0 && Self->thinktime<GameTime)
                Self->die = 1;
            if(Self->die) {                         //If the die flag is set, they remove themself.
                Other = Self;
                Self = Self->next;
                delete Other;
                continue;
            }
            Self= Self->next;
            tmp++;
        }
        Camera.move();                              //Tell the camera to move too.
        Camera.CameraRender();                      //Render the land.
        Self = Head;
        while(Self){                                //This loop handles collision and rendering.
            thingcount++;
            if((Camera.flag == 3 && Camera.next != Self )|| Camera.flag !=3){//If 1st person, make sure it isn't who we are.
                if(Self->locid>-1 && Self->locid<GridNum2 && land[Self->locid].rendered){//Make sure they are in a grid that was rendered.
                    Self->render(rotc);
                    rthing++;
                }
            }
            Other = Head;
            while(Other){//Collision detection.
                if(Other != Self ){
                    if(Self != Other->Owner && Other->movetype == move_roll && Self->movetype == 3&& Self->collide(Other) ){
                        Tail->next = new entity_t(Other->x,Other->y,Other->z,0,150,0,Other->yaw,Other->pitch,Other->roll);
                        Tail->next->prev = Tail;        //I copy basic info and relocate them.
                        Tail=Tail->next;
                        Tail->lights(255,0,0,128,6);
                        Tail->setit(setmove,4);
                        Tail->setit(setrad,Other->rad);
                        Tail->thinktime = GameTime+8;
                        Tail->next = new entity_t("tank.lwo",Other->x,Other->y,Other->z,0,150,0,Other->yaw,Other->pitch,Other->roll);
                        Tail->next->prev = Tail;
                        Tail=Tail->next;
                        Tail->setit(setmove,4);
                        Tail->setit(setrad,Other->rad);
                        Tail->setit(setdroll,90*Deg-random(MaxAng/2));
                        Tail->thinktime = GameTime+6;
                        Other->Enemy = Self->Owner;
                        if(Other == Camera.next){
                            Camera.prev = Camera.next;
                            Camera.next = Tail;
                        }
                        //sprintf(MyS,"(%f %f %f) (%f %f %f)",Self->x,Self->y,Self->z,Other->x,Other->y,Other->z);
                        if(Self->Owner->flag == 5 && Self->Owner->Enemy == Other)
                            Self->Owner->Enemy = 0;
                        Other->x = random(GridNum*gridsep);
                        Other->z = random(GridNum*gridsep);
                        Other->setit(setyaw,random(MaxAng));
                        //Print(MyS);
                        Self->die = 1;
                        break;
                        //Print("wow");
                    }
                    if(Self != Other->Owner && Self->movetype == 3 && Other->movetype == move_fly && Self->collide(Other) ){
                        Tail->next = new entity_t(Other->x,Other->y,Other->z,0,0,350,Other->yaw,Other->pitch,Other->roll);
                        Tail->next->prev = Tail;
                        Tail=Tail->next;
                        Tail->lights(255,0,0,128,6);
                        Tail->setit(setmove,4);
                        Tail->setit(setrad,Other->rad);
                        Tail->thinktime = GameTime+8;
                        //Print(Other->lwon);
                        Tail->next = new entity_t(Other->lwon,Other->x,Other->y,Other->z,0,0,350,Other->yaw,Other->pitch,Other->roll);
                        if(Tail->next == 0) Print("Crap!");
                        Tail->next->prev = Tail;
                        Tail=Tail->next;
                        Tail->setit(setmove,4);
                        Tail->setit(setrad,Other->rad);
                        Tail->thinktime = GameTime+6;
                        Other->Enemy = Self->Owner;
                        if(Other == Camera.next){
                            Camera.prev = Camera.next;
                            Camera.next = Tail;
                        }

                        if(Self->Owner->flag == 5 && Self->Owner->Enemy == Other)
                            Self->Owner->Enemy = 0;

                        //sprintf(MyS,"(%f %f %f) (%f %f %f)",Self->x,Self->y,Self->z,Other->x,Other->y,Other->z);
                        Other->x = random(GridNum*gridsep);
                        Other->z = random(GridNum*gridsep);
                        Other->setit(setyaw,random(MaxAng));
                        //Print(MyS);
                        Self->die = 1;
                        break;
                    }
                    if(Self->movetype == move_fly && Other->movetype == move_fly && Self->collide(Other)){
                        //Guy 1
                        Tail->next = new entity_t(Self->x,Self->y,Self->z,0,0,350,Self->yaw,Self->pitch,Self->roll);
                        Tail->next->prev = Tail;
                        Tail=Tail->next;
                        Tail->lights(255,0,0,128,6);
                        Tail->setit(setrad,Self->rad);
                        Tail->setit(setmove,4);
                        Tail->thinktime = GameTime+10;
                        Tail->next = new entity_t(Self->lwon,Self->x,Self->y,Self->z,0,0,350,Self->yaw,Self->pitch,Self->roll);
                        Tail->next->prev = Tail;
                        Tail=Tail->next;
                        Tail->setit(setrad,Self->rad);
                        Tail->setit(setmove,4);
                        Tail->thinktime = GameTime+20;
                        if(Self->Owner == Head)
                            Head->Enemy = 0;
                        if(Self == Camera.next){
                            Camera.prev = Camera.next;
                            Camera.next = Tail;
                        }
                        //Guy 2
                        Tail->next = new entity_t(Other->x,Other->y,Other->z,0,0,350,Other->yaw,Other->pitch,Other->roll);
                        Tail->next->prev = Tail;
                        Tail=Tail->next;
                        Tail->lights(255,0,0,128,6);
                        Tail->setit(setmove,4);
                        Tail->setit(setrad,Other->rad);
                        Tail->thinktime = GameTime+10;
                        Tail->next = new entity_t(Other->lwon,Other->x,Other->y,Other->z,0,0,350,Other->yaw,Other->pitch,Other->roll);
                        Tail->next->prev = Tail;
                        Tail=Tail->next;
                        Tail->setit(setrad,Other->rad);
                        Tail->setit(setmove,4);
                        Tail->thinktime = GameTime+20;
                        if(Other == Camera.next){
                            Camera.prev = Camera.next;
                            Camera.next = Tail;
                        }

                        //sprintf(MyS,"(%f %f %f) (%f %f %f)",Self->x,Self->y,Self->z,Other->x,Other->y,Other->z);
                        Self->x = random(GridNum*gridsep);
                        Self->z = random(GridNum*gridsep);
                        Self->setit(setyaw,random(MaxAng));

                        Other->x = random(GridNum*gridsep);
                        Other->z = random(GridNum*gridsep);
                        Other->setit(setyaw,random(MaxAng));
                        //Print(MyS);
                        //Self->die = 1;
                        break;
                    }
                }
                Other = Other->next;
            }
            Self =  Self->next;
        }
        Self = Head;

        if (keys['O']){//Passthrough on.
            keys['O'] = FALSE;
            grSstControl( GR_CONTROL_DEACTIVATE );
        }
        if (keys['J']){//Joystick toggle.
            keys['J'] = FALSE;
            JoyActive = !JoyActive;
        }
        if (keys['P']){//Pause
            keys['P'] = FALSE;
            paused = 1-paused;
        }

        if (keys['U']){//Passthrough off.
            keys['U'] = FALSE;
            grSstControl( GR_CONTROL_ACTIVATE );
        }

        if (keys['q'] || keys['Q']){//Quit, also triggered by anything when caps wasn't pressed.
            grGlideShutdown();      //Turn the Glide Engine off.
            DITerm();               //Release the mouse
/*            if(SoundActive){      //Sound stuff
                if ( !MIDASstopBackgroundPlay() )
                    MIDASerror();
                if ( !MIDASclose() )
                    MIDASerror();
            }*/
            //Print("Deleting land");  It dies on me for some reason so I have a memory leak
            //delete land;
            //Print("done");
            Self=Head;  //Delete all the things.
            while(Self){
                Other = Self->next;
                delete Self;
                Self = Other;
            }
            exit(0);
        }

        frameCount++;//Add one to the frame count

    }//End Game Loop
    DITerm();       //This never is run but just in case we do it again.
    grGlideShutdown();
/*    if(SoundActive){
        if ( !MIDASstopBackgroundPlay() )
            MIDASerror();
        if ( !MIDASclose() )
            MIDASerror();
    }*/
            Self=Head;
            while(Self){
                Other = Self->next;
                delete Self;
                Self = Other;
            }
            delete land;        //probable death.
    return msg.wParam;

}//End Main

void InitGlide(void){       //Setup glide.

    grGlideInit();          //Init it for use and questions.

    if ( !grSstQueryHardware( &hwconfig ) ){//Find out if we have one.
        fprintf( stderr, "main: grSstQueryHardware failed!\n" );
        grGlideShutdown();  //shut it down.
        sprintf(MyS,"Egad, Try this again when you have a Voodoo Card!\n It's worth it!");
        Print(MyS);//Print the error
        MessageBox(mainhwnd,MyS,szAppName,MB_OK|MB_ICONEXCLAMATION);
        // and a box.
        return;
    }

    /* Select SST 0 */
    grSstSelect( 0 );//Select the primary one.

    /* Open up the hardware */
    if ( !grSstWinOpen((unsigned long)mainhwnd,
                   screenRes,
                   //GR_RESOLUTION_NONE,
                   GR_REFRESH_60Hz,
                   GR_COLORFORMAT_ARGB,
                   GR_ORIGIN_LOWER_LEFT,
                   GR_SMOOTHING_ENABLE,
                   1 ) ){
        //fprintf( stderr, "main: grSstWinOpen failed!\n" );
        grGlideShutdown();
        sprintf(MyS,"Egad, Voodoo unable to grab frame buffer space!");
        Print(MyS);
        MessageBox(mainhwnd,MyS,szAppName,MB_OK|MB_ICONEXCLAMATION);

        return;
    }
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LEQUAL);
	grDepthMask(FXTRUE);
    VoodooRunning=TRUE;
    //guTexCombineFunction(GR_TMU0, GR_TEXTURECOMBINE_DECAL);
    grTexCombine(GR_TMU0,GR_COMBINE_FUNCTION_LOCAL,GR_COMBINE_FACTOR_NONE,GR_COMBINE_FUNCTION_LOCAL,GR_COMBINE_FACTOR_NONE,FXFALSE,FXFALSE);

    grRenderBuffer(backbuffer == FXTRUE ? GR_BUFFER_BACKBUFFER : GR_BUFFER_FRONTBUFFER);

    /* Set up alpha blend state for compositing and antialiasing */
    guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA );
    grAlphaBlendFunction( GR_BLEND_SRC_ALPHA,
                        GR_BLEND_ONE_MINUS_SRC_ALPHA, GR_BLEND_ONE,
                        GR_BLEND_ZERO );
    grAlphaTestFunction( GR_CMP_ALWAYS );

  	//setup fog
  	static GrFog_t    fogtable[GR_FOG_TABLE_SIZE];
  	float dist = 2000;  //This isn't the same distance the render uses.
  	float dist2;
  	dist2 = 1/dist;
	grFogMode( GR_FOG_WITH_TABLE );
	grFogColorValue( FogColor);
	guFogGenerateExp(fogtable,dist2);
	grFogTable( fogtable );


}
//This needs backface culling but it is otherwise cool.
//The purpose of this is that guDrawTriangleWithClip doesn't clip to Z.
BOOL MyDrawTriangleTooClose(GrVertex bad1, GrVertex bad2,GrVertex bad3,
                       GrVertex old1, GrVertex old2,GrVertex old3,
                       Matrix rot,float x, float y, float z){
    GrVertex newv[4],oldv[3];//sometimes you get 2 triangles for a
                                 //trapazoid
    int numbad,ch1,ch2,ch3,t1,t2,t3;
    ch1 = bad1.z<1;
    ch2 = bad2.z<1;
    ch3 = bad3.z<1;

    numbad = ch1+ch2+ch3;
    if(numbad == 3){
        TryCount--;
        return 0;//Why draw a hidden triangle?  Actually, DON'T!
    }
    else if(numbad == 2){
        t1 = ch1 && ch2;
        t2 = ch2 && ch3;
        t3 = ch3 && ch1;
        float t;
        old1.x -=x; old1.y -=y; old1.z -=z;
        PointMatMult(&old1,&old1,rot);
        old2.x -=x; old2.y -=y; old2.z -=z;
        PointMatMult(&old2,&old2,rot);
        old3.x -=x; old3.y -=y; old3.z -=z;
        PointMatMult(&old3,&old3,rot);

        if (t1){
            newv[0] = bad1;   //Back 1  note translated and screen ready
            newv[1] = bad2;   //Back 2
            newv[2] = bad3;   //Front
            oldv[0] = old1;   //note rotated and use ready.  pre 1/z
            oldv[1] = old2;
            oldv[2] = old3;
        }else if(t2){
            newv[0] = bad2;
            newv[1] = bad3;
            newv[2] = bad1;
            oldv[0] = old2;
            oldv[1] = old3;
            oldv[2] = old1;
        }else{
            newv[0] = bad3;
            newv[1] = bad1;
            newv[2] = bad2;
            oldv[0] = old3;
            oldv[1] = old1;
            oldv[2] = old2;
        }

        //newv[2].r = 0;
        //newv[2].g = 128;
        //newv[2].b = 0;

        t = (1-oldv[0].z)/(oldv[2].z-oldv[0].z);
        newv[0].z=newv[0].oow=1;
        newv[0].ooz = 1;
        newv[0].x = Camzoomx*((oldv[2].x-oldv[0].x)*t+oldv[0].x)+wHWidth+vertex_snapper;
        newv[0].y = Camzoomy*((oldv[2].y-oldv[0].y)*t+oldv[0].y)+wHHeight+vertex_snapper;
        newv[0].x -=vertex_snapper;
        newv[0].y -=vertex_snapper;
        newv[0].r=(newv[2].r-newv[0].r)*t+newv[0].r;
        newv[0].g=(newv[2].g-newv[0].g)*t+newv[0].g;
        newv[0].b=(newv[2].b-newv[0].b)*t+newv[0].b;
        newv[0].a=(newv[2].a-newv[0].a)*t+newv[0].a;

        t = (1-oldv[1].z)/(oldv[2].z-oldv[1].z);
        newv[1].z=newv[1].oow=1;
        newv[1].ooz = 1;
        newv[1].x = Camzoomx*((oldv[2].x-oldv[1].x)*t+oldv[1].x)+wHWidth+vertex_snapper;
        newv[1].y = Camzoomy*((oldv[2].y-oldv[1].y)*t+oldv[1].y)+wHHeight+vertex_snapper;
        newv[1].x -=vertex_snapper;
        newv[1].y -=vertex_snapper;
        newv[1].r=(newv[2].r-newv[1].r)*t+newv[1].r;
        newv[1].g=(newv[2].g-newv[1].g)*t+newv[1].g;
        newv[1].b=(newv[2].b-newv[1].b)*t+newv[1].b;
        newv[1].a=(newv[2].a-newv[1].a)*t+newv[1].a;
        //if(keys[220]){
            guDrawTriangleWithClip(&newv[0],&newv[1],&newv[2]);
            //Print("trying 1");
        //}
        //sprintf(MyS,"%i %i %i %i %i %i %i",numbad,t1,t2,t3,ch1,ch2,ch3);
        //Print(MyS);
        return 1;
    }
    else if(numbad == 1){
        float t;
        t1 = ch3;
        t2 = ch1;
        t3 = ch2;
        old1.x -=x; old1.y -=y; old1.z -=z;
        PointMatMult(&old1,&old1,rot);
        old2.x -=x; old2.y -=y; old2.z -=z;
        PointMatMult(&old2,&old2,rot);
        old3.x -=x; old3.y -=y; old3.z -=z;
        PointMatMult(&old3,&old3,rot);

        if (t1){
            newv[0] = bad1;   //Front 1  note translated and screen ready
            newv[1] = bad2;   //Front 2
            newv[2] = bad3;   //Behind
            oldv[0] = old1;   //Front 1  note rotated and use ready.  pre 1/z
            oldv[1] = old2;   //Front 2
            oldv[2] = old3;   //Behind
        }else if(t2){
            newv[0] = bad2;   //Front 1
            newv[1] = bad3;   //...
            newv[2] = bad1;
            oldv[0] = old2;   //Front 1
            oldv[1] = old3;   //Front 2
            oldv[2] = old1;   //Behind
        }else{
            newv[0] = bad3;
            newv[1] = bad1;
            newv[2] = bad2;
            oldv[0] = old3;   //Front 1
            oldv[1] = old1;   //Front 2
            oldv[2] = old2;   //Behind
        }
        float a,r,g,b;
        a = newv[2].a;
        r = newv[2].r;
        g = newv[2].g;
        b = newv[2].b;
        t = (1-oldv[0].z)/(oldv[2].z-oldv[0].z);


        newv[2].z=newv[2].oow=1;
        newv[2].ooz = 1;
        newv[2].x = Camzoomx*((oldv[2].x-oldv[0].x)*t+oldv[0].x)+wHWidth+vertex_snapper;
        newv[2].y = Camzoomy*((oldv[2].y-oldv[0].y)*t+oldv[0].y)+wHHeight+vertex_snapper;
        newv[2].x -=vertex_snapper;
        newv[2].y -=vertex_snapper;
        newv[2].r=(r-newv[0].r)*t+newv[0].r;
        newv[2].g=(g-newv[0].g)*t+newv[0].g;
        newv[2].b=(b-newv[0].b)*t+newv[0].b;
        newv[2].a=(a-newv[0].a)*t+newv[0].a;

        t = (1-oldv[1].z)/(oldv[2].z-oldv[1].z);
        newv[3].z=newv[3].oow=1;
        newv[3].ooz = 1;
        newv[3].x = Camzoomx*((oldv[2].x-oldv[1].x)*t+oldv[1].x)+wHWidth+vertex_snapper;
        newv[3].y = Camzoomy*((oldv[2].y-oldv[1].y)*t+oldv[1].y)+wHHeight+vertex_snapper;
        newv[3].x -=vertex_snapper;
        newv[3].y -=vertex_snapper;
        newv[3].r=(r-newv[1].r)*t+newv[1].r;
        newv[3].g=(g-newv[1].g)*t+newv[1].g;
        newv[3].b=(b-newv[1].b)*t+newv[1].b;
        newv[3].a=(a-newv[1].a)*t+newv[1].a;
        //newv[0].r = newv[1].r = 255;
        //if(keys[219]){
        guDrawTriangleWithClip(&newv[0],&newv[1],&newv[2]);
            //Print("trying 2");
        //}
        //if(keys[221]){
        guDrawTriangleWithClip(&newv[1],&newv[2],&newv[3]);
            //Print("trying 3");
        //}
        AttCount++;
        TryCount++;
        //Print("One Bad");
        return 1;

    }
    else{ //Why t.h. did we send a perfectly good triangle here?
        //Print("duh");
        guDrawTriangleWithClip(&bad1,&bad2,&bad3);
        return 1;
    }
    return 0;
}

//Make a normal commandline parameter list.
static char    *fakeName = "ImpSaver";
static char    *argvbuf[32];
static char    cmdLineBuffer[1024];

char ** commandLineToArgv(LPSTR lpCmdLine, int *pArgc)
{
    char    *p, *pEnd;
    int     argc = 0;

    argvbuf[argc++] = fakeName;

    if (lpCmdLine == NULL) {
        *pArgc = argc;
         return argvbuf;
    }

    strcpy(cmdLineBuffer, lpCmdLine);
    p = cmdLineBuffer;
    pEnd = p + strlen(cmdLineBuffer);
    if (pEnd >= &cmdLineBuffer[1022]) pEnd = &cmdLineBuffer[1022];

    fflush(stdout);

    while (1) {
        /* skip over white space */
        fflush(stdout);

        while (*p == ' ') p++;
        if (p >= pEnd) break;

        argvbuf[argc++] = p;
        if (argc >= 32) break;

        /* skip till there's a 0 or a white space */
        while (*p && (*p != ' ')) p++;

        if (*p == ' ') *p++ = 0;
    }

    *pArgc = argc;
    return argvbuf;
}
