// RSObject.h: interface for the CRSObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_RSOBJECT_H__E9EAE9E2_D9E1_11D0_8163_00C0F00AADB3__INCLUDED_)
#define AFX_RSOBJECT_H__E9EAE9E2_D9E1_11D0_8163_00C0F00AADB3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


class CRSTriList : public CObject
{
public:
	CRSTriList() { pt1=pt2=pt3=0; }
	CRSTriList(const CRSTriList &temp) { pt1=temp.pt1; pt2=temp.pt2; pt3=temp.pt3; }
	CRSTriList(unsigned tp1,unsigned tp2,unsigned tp3) { pt1=tp1; pt2=tp2; pt3=tp3; }
	CRSTriList operator=(const CRSTriList &temp) { pt1=temp.pt1; pt2=temp.pt2; pt3=temp.pt3; return *this; }
	virtual ~CRSTriList() { }
	unsigned pt1;
	unsigned pt2;
	unsigned pt3;
};


class CRSVertex : public CObject
{
public:
	CRSVertex() { x=y=z=0; }
	CRSVertex(const CRSVertex &temp) { x=temp.x; y=temp.y; z=temp.z; }
	CRSVertex(float tx,float ty,float tz) { x=tx; y=ty; z=tz; }
	CRSVertex operator=(const CRSVertex &temp) { x=temp.x; y=temp.y; z=temp.z; return *this; }
	virtual ~CRSVertex() { }
	float x;
	float y;
	float z;
};


class CRSObject
{
public:
	void InitObject(float, float, float, float, float, float, int, int, int, int, int, int, unsigned);
	void MoveObject(void);
	void TransAll(float, float, float);
	void TransZ(float);
	void TransY(float);
	void TransX(float);
	CRSObject();
	virtual ~CRSObject();
	BOOL LoadObject(CString);
	void AddVertex(CRSVertex);
	void AddTriangle(CRSTriList);
	BOOL DrawObject(float ScaleTex);
	void RotateX(unsigned);
	void RotateY(unsigned);
	void RotateZ(unsigned);
	void MCopy();
	unsigned NumVert;
	unsigned NumTri;
	CObArray TriList;    // array to contain triangles
	CObArray Master;     // array to contain original list of vertices
	CObArray Working;    // array to contain modified list of vertices
	float XMove,XSource;
	float YMove,YSource;
	float ZMove,ZSource;
	int XRot,XRotSource;
	int YRot,YRotSource;
	int ZRot,ZRotSource;
	unsigned TexNum;
private:
};

unsigned long LoadTexture(CString FileName);

#endif // !defined(AFX_RSOBJECT_H__E9EAE9E2_D9E1_11D0_8163_00C0F00AADB3__INCLUDED_)
