// RSObject.cpp: implementation of the CRSObject class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "sintable.h"
#include "RSObject.h"
#include "3dfxscr2.h"
#include <glide.h>

extern unsigned long TexID[5];
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define VTX_SNAP ((float)(3<<18))

CRSObject::CRSObject()
{
	NumVert = 0;
	NumTri = 0;
}

CRSObject::~CRSObject()
{

}

BOOL CRSObject::LoadObject(CString FileName)
{
	CFile file;
	unsigned count;
	CRSVertex tempvertex;
	CRSTriList temptrilist;

	if (!file.Open(FileName,CFile::modeRead))
		return FALSE;
	file.Read(&NumVert,sizeof(NumVert));
	for (count=0;count<NumVert;count++)
	{
		file.Read(&tempvertex,sizeof(CRSVertex));
		Master.Add(new CRSVertex(tempvertex));
		Working.Add(new CRSVertex(tempvertex));
	} 
	file.Read(&NumTri,sizeof(NumTri));
	for (count=0;count<NumTri;count++)
	{
		file.Read(&temptrilist,sizeof(temptrilist));
		TriList.Add(new CRSTriList(temptrilist));
	}
	file.Close();
	return TRUE;
}

void CRSObject::AddVertex(CRSVertex TempVert)
{
	Master.Add(new CRSVertex(TempVert));
	Working.Add(new CRSVertex(TempVert));
}

void CRSObject::AddTriangle(CRSTriList TempTri)
{
	TriList.Add(new CRSTriList(TempTri));
}

void CRSObject::RotateX(unsigned degrees)
{
    unsigned i;
    float c =  SIN[degrees+90];
    float s =  SIN[degrees];
	float y,z;
    for (i=0;i < NumVert;i++)
    {
		y = ((CRSVertex *)(Working.GetAt(i)))->y;
		z = ((CRSVertex *)(Working.GetAt(i)))->z;
		((CRSVertex *) (Working.GetAt(i)))->y = y*c - z*s;
		((CRSVertex *) (Working.GetAt(i)))->z = y*s + z*c;
    }
}

void CRSObject::RotateY(unsigned degrees)
{
    unsigned i;
    float c = SIN[degrees+90];
    float s = SIN[degrees];
	float x,z;

    for (i=0;i < NumVert;i++)
    {
 		x = ((CRSVertex *)(Working.GetAt(i)))->x;
		z = ((CRSVertex *)(Working.GetAt(i)))->z;
  		((CRSVertex *) (Working.GetAt(i)))->x = x*c + z*s;
		((CRSVertex *) (Working.GetAt(i)))->z = z*c - x*s;
    }
}

void CRSObject::RotateZ(unsigned degrees)
{
    unsigned i;
	float c = SIN[degrees+90];
    float s = SIN[degrees];
 	float x,y;
   
	for (i=0;i < NumVert;i++)
    {
 		x = ((CRSVertex *)(Working.GetAt(i)))->x;
		y = ((CRSVertex *)(Working.GetAt(i)))->y;
		((CRSVertex *) (Working.GetAt(i)))->x = x*c + y*s;
		((CRSVertex *) (Working.GetAt(i)))->y = y*c - x*s;
    }
}

void CRSObject::MCopy()
{
	unsigned count;
	CRSVertex *temp;

	for (count=0;count<NumVert;count++)
	{
		temp = (CRSVertex *)(Working.GetAt(count));
		*temp = *(CRSVertex *)(Master.GetAt(count));
	}
}

BOOL CRSObject::DrawObject(float ScaleTex)
{
	BOOL status = TRUE;
	unsigned count;
	GrVertex p1,p2,p3;
	float z,zmult;
	float xcent=320.0;
	float ycent=240.0;
	CRSVertex *temp;
	const ZOFFSET = 75;
	const float SCALEZ = 2048.0; // smaller = farther away
	p1.x=p1.y=p1.z=0;
	p2.x=p2.y=p2.z=0;
	p3.x=p3.y=p3.z=0;


#define RSS1(vertlist,param1) ((CRSVertex *)(vertlist[param1]))
#define RSS2(trilist,param1) ((CRSTriList *)(trilist[param1]))
	guColorCombineFunction(GR_COLORCOMBINE_DECAL_TEXTURE);
	guTexSource( TexID[TexNum] );
	grTexCombineFunction(GR_TMU0, GR_TEXTURECOMBINE_DECAL);

	for (count=0;count<NumTri;count++)
	{
		temp = RSS1(Working,RSS2(TriList,count)->pt1);
		z = ZOFFSET + temp->z;
		p1.oow = 1/z;
		zmult = SCALEZ/z;
		p1.x = zmult * temp->x + xcent;
		p1.y = zmult * temp->y + ycent;
		temp = RSS1(Master,RSS2(TriList,count)->pt1);
		p1.tmuvtx[0].sow=temp->x*ScaleTex*p1.oow; //0.0f;
		p1.tmuvtx[0].tow=temp->y*ScaleTex*p1.oow; //0.0f;
		
		temp = RSS1(Working,RSS2(TriList,count)->pt2);
		z = ZOFFSET + temp->z;
		p2.oow = 1/z;
		zmult = SCALEZ/z;
		p2.x = zmult * temp->x + xcent;
		p2.y = zmult * temp->y + ycent;
		temp = RSS1(Master,RSS2(TriList,count)->pt2);
		p2.tmuvtx[0].sow=temp->x*ScaleTex*p2.oow; //255.0f*p2.oow;
		p2.tmuvtx[0].tow=temp->y*ScaleTex*p2.oow; //0.0f;

		temp = RSS1(Working,RSS2(TriList,count)->pt3);
		z = ZOFFSET + temp->z;
		p3.oow = 1/z;
		zmult = SCALEZ/z;
		p3.x = zmult * temp->x + xcent;
		p3.y = zmult * temp->y + ycent;
		temp = RSS1(Master,RSS2(TriList,count)->pt3);
		p3.tmuvtx[0].sow=temp->x*ScaleTex*p3.oow; //255.0f*p3.oow;
		p3.tmuvtx[0].tow=temp->y*ScaleTex*p3.oow; //255.0f*p3.oow;
		
		p1.x += VTX_SNAP;
		p1.y += VTX_SNAP;
		p1.z += VTX_SNAP;
		
		p2.x += VTX_SNAP;
		p2.y += VTX_SNAP;
		p2.z += VTX_SNAP;

		p3.x += VTX_SNAP;
		p3.y += VTX_SNAP;
		p3.z += VTX_SNAP;

		grDrawTriangle(&p1,&p2,&p3); 
	}
	return status;
}

void CRSObject::TransX(float move)
{
    unsigned i;

    for (i=0;i < NumVert;i++)
    {
  		((CRSVertex *) (Working.GetAt(i)))->x += move;
    }
}

void CRSObject::TransY(float move)
{
    unsigned i;

    for (i=0;i < NumVert;i++)
    {
	 ((CRSVertex *) (Working.GetAt(i)))->y += move;
    }
}

void CRSObject::TransZ(float move)
{
    unsigned i;

    for (i=0;i < NumVert;i++)
    {
	 ((CRSVertex *) (Working.GetAt(i)))->z += move;
    }
}

void CRSObject::TransAll(float xmove, float ymove, float zmove)
{
    unsigned i;

    for (i=0;i < NumVert;i++)
    {
  	 ((CRSVertex *) (Working.GetAt(i)))->x += xmove;
	 ((CRSVertex *) (Working.GetAt(i)))->y += ymove;
	 ((CRSVertex *) (Working.GetAt(i)))->z += zmove;
    }

}

void CRSObject::MoveObject()
{
	if (ZSource > 5.0f)
	{
		MCopy();
		XRotSource+=XRot;
		YRotSource+=YRot;
		ZRotSource+=ZRot;
		if (XRotSource>359)
			XRotSource-=360;
		else if (XRotSource<0)
			XRotSource+=360;
		if (YRotSource>359)
			YRotSource-=360;
		else if (YRotSource<0)
			YRotSource+=360;
		if (ZRotSource>359)
			ZRotSource-=360;
		else if (ZRotSource<0)
			ZRotSource+=360;
		XSource+=XMove;
		YSource+=YMove;
		ZSource+=ZMove;
		RotateX(XRotSource);
		RotateY(YRotSource);
		RotateZ(ZRotSource);
		TransAll(XSource,YSource,ZSource);
	}
	else
	{
		float XPos, YPos;
		XPos = (float)(rand()%2);
		if (!XPos)
			XPos--;
		YPos = (float)(rand()%2);
		if (!YPos)
			YPos--;
		InitObject(XPos*(rand()%8+1),YPos*(rand()%8+1),500.0f,XPos*(rand()%6+1)/20.0f,YPos*(rand()%6+1)/20.0f,(float)-(rand()%30+25)/10.0f,0,0,0,rand()%4+2,rand()%3+2,rand()%3+2,rand()%5);
	}
}

void CRSObject::InitObject(float XSrc, float YSrc, float ZSrc, float XMv, float YMv, float ZMv, int XRtSrc, int YRtSrc, int ZRtSrc, int XRt, int YRt, int ZRt, unsigned TextureNumber)
{
	XSource = XSrc;
	YSource = YSrc;
	ZSource = ZSrc;
	XMove = XMv;
	YMove = YMv;
	ZMove = ZMv;
	XRotSource = XRtSrc;
	YRotSource = YRtSrc;
	ZRotSource = ZRtSrc;
	XRot = XRt;
	YRot = YRt;
	ZRot = ZRt;
	TexNum = TextureNumber;
}

unsigned long LoadTexture(CString FileName)
{
	Gu3dfInfo TexInfo;
	GrMipMapId_t TextureID;

	if ( !gu3dfGetInfo( FileName, &TexInfo ) )  
	{
		grGlideShutdown();
		exit( -1 );
		return -1;
	}
	else
	{
		TexInfo.data = malloc( TexInfo.mem_required );
		if ( TexInfo.data == 0 ) 
		{
			grGlideShutdown();
			exit( -1 );
		}
		if ( !gu3dfLoad(FileName, &TexInfo ) ) 
		{
			grGlideShutdown();
			exit( -1 );
		}
		TextureID = guTexAllocateMemory( 0, GR_MIPMAPLEVELMASK_BOTH,
			                      TexInfo.header.width, TexInfo.header.height,
				                  TexInfo.header.format, GR_MIPMAP_NEAREST,
					              TexInfo.header.small_lod, TexInfo.header.large_lod,
						          TexInfo.header.aspect_ratio,
							      GR_TEXTURECLAMP_WRAP, GR_TEXTURECLAMP_WRAP,
								  GR_TEXTUREFILTER_BILINEAR, GR_TEXTUREFILTER_BILINEAR,
								  0.0F, FXFALSE );
		if ( TextureID == GR_NULL_MIPMAP_HANDLE )
		{
			grGlideShutdown();
			exit( -1 );
		}
		guTexDownloadMipMap(TextureID, TexInfo.data, &TexInfo.table.nccTable );
		free( TexInfo.data );
		return TextureID;
	}
}