// MainWin.cpp : implementation file
//

#include "stdafx.h"
#include "3dfxscr2.h"
#include "MainWin.h"
#include "RSObject.h"
#include <glide.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MAXOBJS MaxObjs   // Maximum Objects per .INI file

extern unsigned MaxObjs;
extern float SIN[450];
extern unsigned long TexID[7];
CRSObject object[50];
CRSObject dude;
CRSObject bkgd;

/////////////////////////////////////////////////////////////////////////////
// CMainWin dialog


CMainWin::CMainWin(CWnd* pParent /*=NULL*/)
	: CDialog(CMainWin::IDD, pParent)
{

	//{{AFX_DATA_INIT(CMainWin)
	//}}AFX_DATA_INIT
	
	m_rotval = 0;
}


void CMainWin::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainWin)
	//}}AFX_DATA_MAP
}


void CMainWin::InitAnimation()
{
	CRSVertex temp;
	BOOL status=TRUE;

	dude.LoadObject("dude.rs3");

//
//	Initialize Background Plane
//
	{
		CRSVertex TempVert;
		CRSTriList TempTri;

		TempVert.x = -200.0f;
		TempVert.y = -200.0f;
		TempVert.z = 0.0f;
		bkgd.AddVertex(TempVert);
		TempVert.x = -200.0f;
		TempVert.y = 200.0f;
		TempVert.z = 0.0f;
		bkgd.AddVertex(TempVert);
		TempVert.x = 200.0f;
		TempVert.y = -200.0f;
		TempVert.z = 0.0f;
		bkgd.AddVertex(TempVert);
		TempVert.x = 200.0f;
		TempVert.y = 200.0f;
		TempVert.z = 0.0f;
		bkgd.AddVertex(TempVert);
		TempTri.pt1 = 1;
		TempTri.pt2 = 3;
		TempTri.pt3 = 2;
		bkgd.AddTriangle(TempTri);
		TempTri.pt1 = 2;
		TempTri.pt2 = 0;
		TempTri.pt3 = 1;
		bkgd.AddTriangle(TempTri);
		bkgd.NumVert=4;
		bkgd.NumTri=2;
	}

	InitObjects(object);

	dude.InitObject(0.0f,-1.0f,15.0f,0.0f,0.0f,0.0f,359,0,359,-2,1,-5,4);
	bkgd.InitObject(0.0f,0.0f,501.0f,0.0f,0.0f,0.0f,0,0,0,0,0,4,5);
}

void CMainWin::DoAnimation()
{	
	do
	{
		grBufferClear(0,0,GR_WDEPTHVALUE_FARTHEST);
		dude.MoveObject();
		bkgd.MoveObject();
		MoveObjects(object);
		dude.DrawObject(40.0f);
		bkgd.DrawObject(1.0f);
		grBufferSwap(1);
	}
	while (1);
}

BOOL CMainWin::InitObjects(CRSObject *object)
{
	char FName[20];
	unsigned count;
	BOOL status=TRUE;
//	float randnum;

	for (count=0;count<MAXOBJS;count++)
	{
		sprintf(FName,"object%d.RS3",rand()%3);
		if(!object[count].LoadObject(FName))
		{
			status=FALSE;
		}
	}
	for (count=0;count<MAXOBJS;count++)
	{
		float XPos, YPos;
		XPos = (float)(rand()%2);
		if (!XPos)
			XPos--;
		YPos = (float)(rand()%2);
		if (!YPos)
			YPos--;
		object[count].InitObject(XPos*(rand()%8+1),YPos*(rand()%8+1),500.0f,XPos*(rand()%6+1)/20.0f,YPos*(rand()%6+1)/20.0f,(float)-(rand()%30+25)/7.0f,0,0,0,rand()%2+2,rand()%2+2,rand()%2+2,rand()%5);
	}
	return status;
}


void CMainWin::MoveObjects(CRSObject *object)
{
	unsigned count;

	for (count=0;count<MAXOBJS;count++)
	{
		object[count].MoveObject();
		object[count].DrawObject(25.0f);
	}
}




BEGIN_MESSAGE_MAP(CMainWin, CDialog)
	//{{AFX_MSG_MAP(CMainWin)
	ON_WM_SHOWWINDOW()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainWin message handlers




BOOL CMainWin::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	InitAnimation();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CMainWin::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	
	// TODO: Add your message handler code here
	DoAnimation();
}

void CMainWin::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	EndDialog(0);
	CDialog::OnMouseMove(nFlags, point);
}
