// 3dfxscr2.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "3dfxscr2.h"
#include "mainwin.h"
#include "RSObject.h"
//#include <scrnsave.h>
#include <glide.h>
#include "ConfigDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*  Objects limited due to contest limit of 10 data files

  Object0 -  Dagger
  Object1 -  Scythe
  Object2 -  Axe
  Object3 -  
  Object4 -  
  Object5 -
  Object6 -
  Object7 -
  Object8 -
  Object9 -
  Dude    - Guy spinning around in center

*/

/* Textures limited due to contest limit of 10 data files

  Tex1  - Red Flame on Black Background
  Tex2  - Scottish Tartan Pattern
  Tex3  - Red/Blue/White Swirls
  Tex4  - White & some black Fractal
  Tex5  - Wicked Grid pattern
  Tex6  -
  Tex7  -
  Tex8  -
  Tex9  -
  Plane - Green Swirl on Black Background

*/
/////////////////////////////////////////////////////////////////////////////
// CMy3dfxscr2App

BEGIN_MESSAGE_MAP(CMy3dfxscr2App, CWinApp)
	//{{AFX_MSG_MAP(CMy3dfxscr2App)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy3dfxscr2App construction

CMy3dfxscr2App::CMy3dfxscr2App()
{
}

/////////////////////////////////////////////////////////////////////////////
// Create the Screen Saver Application

CMy3dfxscr2App theApp;

unsigned long TexID[7];
unsigned MaxObjs;
/////////////////////////////////////////////////////////////////////////////
// CMy3dfxscr2App initialization

BOOL CMy3dfxscr2App::InitInstance()
{
    GrHwConfiguration hw3dfx;
	CMainWin mDlg;
	char test=0;
	
	srand( (unsigned)time( NULL ) );

	LoadStdProfileSettings(0);

	if (!stricmp(m_lpCmdLine,"-C") || !stricmp(m_lpCmdLine,"/C"))
	{
		CConfigDlg cfgDlg;
		if (cfgDlg.DoModal() == IDOK)
			WriteProfileInt("Config","MaxObjects",cfgDlg.m_MaxObjs);
	}
	else
	{
		MaxObjs = GetProfileInt("Config","MaxObjects",20);
		grGlideInit();
		if (!grSstQueryHardware(&hw3dfx))
		{
			MessageBox(NULL,"Unable to detect Voodoo Hardware","Error",MB_OK);
			return 1;
		}
		grSstSelect(0);
		grSstWinOpen(0, GR_RESOLUTION_640x480, GR_REFRESH_60Hz, GR_COLORFORMAT_RGBA, GR_ORIGIN_LOWER_LEFT, 2, 1);

		/* Set up Render State */

		guColorCombineFunction(GR_COLORCOMBINE_DECAL_TEXTURE);

		TexID[0]=LoadTexture("tex1.3df");
		TexID[1]=LoadTexture("tex2.3df");
		TexID[2]=LoadTexture("tex3.3df");
		TexID[3]=LoadTexture("tex4.3df");
		TexID[4]=LoadTexture("tex5.3df");
		TexID[5]=LoadTexture("plane.3df");

		grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
		grDepthBufferFunction(GR_CMP_LESS);	
		grDepthMask(FXTRUE);

		SetIntelPrecision();

// do dialog stuff here		
		mDlg.DoModal();
//		DoAnimation();

		grGlideShutdown();
	}
	return FALSE;
}


//
// Sets up 16 bit precision in the processor
//
// Appears non-functional, as the snap-vertex trick isn't working.
// Use the slow-but-faithful typecasting method for now, until the
// problem can be resolved.
//
void SetIntelPrecision()
{
	long memvar;

	_asm {
		finit
		fwait
		fstcw [memvar]
		fwait		
		mov eax,[memvar]
		and eax,0xfffffcff
		mov [memvar],eax
		fldcw [memvar]
		fwait
	}
}

BOOL CMy3dfxscr2App::InitApplication() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CWinApp::InitApplication();
}
