/*SDOC*************************************************************

  Module: Screen20.CPP

  Copyright 1997 (c) Sebastien St-Laurent. 
  May be distributed freely.

  Description:	Screen Blanker Contest Main Exec

*************************************************************EDOC*/
/*SDOC*************************************************************

  Things left to do:

  Basicly, to make this blanker complete, it would simply need
  to have a config window to change the constants for the effect.
  Also, saving the constants and retreiving them from a file to 
  keep track of the configuration. This would have been done but 
  because of a lack of time, i concentrated on finishing the screen
  blanker itself.

*************************************************************EDOC*/
/*SDOC*************************************************************

  Known bugs : 

	- Sometimes, after running for a while, the scheen blanker freezes
	  i have not yet figured out the cause, it might be glide related...

*************************************************************EDOC*/


#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <string.h>
#include <conio.h>
#include <math.h>
#include <time.h>

#include <glide.h>
#include "Effect_2.h"

#define ScreenTextureSize 256
#define scrWidth 640
#define scrHeight 480

#define ScaleX(a) (float)scrWidth/a
#define ScaleY(a) (float)scrWidth/a

GrHwConfiguration		hwconfig;

LRESULT CALLBACK WindowFunc(HWND,UINT,WPARAM,LPARAM);

char szWinName[] = "Screen20";
CBlankerB *Blanker2;

// Error handler
void ERRASSERT(FxBool Bool, char *Message)
{
	if (Bool==FXTRUE) return;
	exit(1);
}

// Main function
int WINAPI WinMain(HINSTANCE hThisInst, HINSTANCE hPrevInst, LPSTR lpszArgs, int nWinMode) 
{
	// Process command line arguments
	if (lpszArgs[0]!=0 && (strcmp(lpszArgs,"/s")==0 || strcmp(lpszArgs,"/S")==0))
	{
		HWND hwnd;
		MSG msg;
		MSG msg2;
		WNDCLASS wcl;

		// Define a window class for our screen blanker
		wcl.hInstance = hThisInst;
		wcl.lpszClassName = szWinName;
		wcl.lpfnWndProc = WindowFunc;
		wcl.style = 0;

		wcl.hIcon = LoadIcon(NULL, IDI_APPLICATION);
		wcl.hCursor = LoadCursor(NULL, IDC_ARROW);
		wcl.lpszMenuName = NULL;

		wcl.cbClsExtra = 0;
		wcl.cbWndExtra = 0;

		wcl.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);

		// Register our window class
		if (!RegisterClass(&wcl)) return -1;

		// Now, create a window based on the class we just defined
		hwnd = CreateWindow( szWinName, "Screen Blanker #20", WS_OVERLAPPEDWINDOW|WS_MAXIMIZE, CW_USEDEFAULT, 
				CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, HWND_DESKTOP, NULL, hThisInst, NULL);

		ShowWindow(hwnd, SW_MAXIMIZE);
		UpdateWindow(hwnd);

		// Init the 3DFX
		GrScreenResolution_t resolution = GR_RESOLUTION_640x480;

		// Initialise Glide
		grGlideInit();
		ERRASSERT( grSstQueryHardware( &hwconfig ), "No 3DFX compatible card found!" );
		grSstSelect( 0 );
		ERRASSERT( grSstWinOpen( (long)hwnd,
						  resolution,
						  GR_REFRESH_60Hz,
						  GR_COLORFORMAT_ABGR,
						  GR_ORIGIN_UPPER_LEFT,
						  2, 1 ), "Unable to create 3DFX view!" );

    
  

		// Init the screen blanker
		Blanker2 = new CBlankerB;
		Blanker2->ResetCard();

		// Message loop
		while (PeekMessage(&msg2,hwnd, 0, 0, PM_REMOVE)) {}
		PostMessage(hwnd,WM_USER+1,0,0);
		while (GetMessage(&msg, NULL, 0,0))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
			
			// This will post a message to force the update of the blanker.
			if (!PeekMessage(&msg2,hwnd, 0, 0, PM_NOREMOVE)) PostMessage(hwnd,WM_USER+1,0,0);
		}

		// Deinit the 3DFX
		delete Blanker2;
		grGlideShutdown();

		return msg.wParam;
	}
	else
	// Blanker configuration
	if (lpszArgs[0]==0 || strcmp(lpszArgs,"/c")==0 || strcmp(lpszArgs,"/C")==0)
	{
	}

	return 0;
}


// Window function for our exec.
LRESULT CALLBACK WindowFunc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
	// Terminate execution on any oth thoes events.
	case WM_DESTROY:
	case WM_KEYDOWN:
	case WM_LBUTTONDOWN:
	case WM_RBUTTONDOWN:
	case WM_MBUTTONDOWN:
	case WM_KILLFOCUS:
	case WM_MOUSEMOVE:
		PostQuitMessage(0);
		break;
	case (WM_USER+1):
		Blanker2->DoFrame();
		break;
	default:
		return DefWindowProc(hwnd,message,wParam,lParam);
	}
	return 0;
}

