// Effect2.h
// Class for effect #2
//   Blur Vortex

#ifndef __H_CBLANKERB__
#define __H_CBLANKERB__


//#include "TypesDeBase.H"
#include <windows.h>
#include <glide.h>

class CBlankerB
{
private:	// Private variables
	// Screen Texture
	WORD		ScreenTexture[256*256];
	FxU32		ScreenTexturePos;
	GrTexInfo	ScreenTextureInfo;

	GrVertex VertBig[4];
	GrVertex VertSml[4];
	GrVertex VertBox[4];
	
	// Effect Texture 1
	FxU32		FXTexturePos;
	GrTexInfo	FXTextureInfo;
	Gu3dfInfo	FXTextureFileInfo;

	// Effect Texture 2
	FxU32		FXTexture2Pos;
	GrTexInfo	FXTexture2Info;
	Gu3dfInfo	FXTexture2FileInfo;
						  
						  
	DWORD frame;

	// Constant variables for effect modification
	float CST_Recurse_XOfs;
	float CST_Recurse_YOfs;
	float CST_Recurse_XSpeed1;
	float CST_Recurse_XSpeed2;
	float CST_Recurse_YSpeed1;
	float CST_Recurse_YSpeed2;
	float CST_ColorVarSpeed_R1;
	float CST_ColorVarSpeed_G1;
	float CST_ColorVarSpeed_B1;
	float CST_ColorVarSpeed_R2;
	float CST_ColorVarSpeed_G2;
	float CST_ColorVarSpeed_B2;
	float CST_AlphaVarSpeed1;
	float CST_AlphaVar1;
	float CST_AlphaVarSpeed2;
	float CST_AlphaVar2;
	float CST_XOfs_Speed;
	float CST_YOfs_Speed;
	float CST_DistVarSpeed1;
	float CST_DistVarSpeed2;

public:		// Public member functions
	CBlankerB(void);
	~CBlankerB(void);

	void ResetEffect(void);
	void ResetCard(void);
	void DoFrame(void);
	DWORD GetFrameCount(void);

private:	// Private member functions
	void RenderSceneBig(void);
	void RenderSceneSmall(void);

};

#endif

