/*SDOC*************************************************************

  Module: Effect2.CPP

  Copyright 1997 (c) Sebastien St-Laurent. 
  May be distributed freely.

  Description:	Screen Blanker Contest Test Effect #2

*************************************************************EDOC*/

/*SDOC*************************************************************
  CONCEPT DESCRIPTION : 

	This screen blanker is a test based on what i call "Recursive
	Bluring". The idea is simple. Imagine you hook-up a video 
	camera to a TV, then you take the camera and point it at the TV.
	The camera will pick up the image on the TV and will display it
	onto the TV and will repeat this process indefenitely.

	I use this procedure to do my screen blanker. This can creatre some
	nice blury effects but has consequences, dus to the fact that the
	voodoo cards are slow when you attempt to read their video memory,
	i have to render each frame twice. Once at 256x256, which i transfer
	to a texture of the 3dfx. Then i render the same frame again but in
	full screen. The texture i grab every frame is used as the background
	the folowing frame. The bluring is automaticaly done by the 3dfx
	since i stretch a 256x256 texture to the whole screen.

	For this perticular effet, every frame i draw 2 textures rings
	around the screen and i manipulate them to do the moving effects.
	The rest of the effect is automaticaly done by the recursive
	bluring.

*************************************************************EDOC*/


#include "Effect_2.h"
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

// Constructor for the effect class
CBlankerB::CBlankerB(void)
{
	FXTextureFileInfo.data = NULL;

	// Reset the 3dfx card to match the settings needed for the screen blanker
	ResetEffect();
	ResetCard();

	// Init the effect constant variables //
	
		// Recursive background displacement and squishing
		CST_Recurse_XOfs = 8.0f;
		CST_Recurse_YOfs = 8.0f;
		CST_Recurse_XSpeed1 = 72.0f;
		CST_Recurse_XSpeed2 = 97.0f;
		CST_Recurse_YSpeed1 = 65.0f;
		CST_Recurse_YSpeed2 = 49.0f;

		// Color Variation constants
		CST_ColorVarSpeed_R1 = 71.0f;
		CST_ColorVarSpeed_G1 = 124.0f;
		CST_ColorVarSpeed_B1 = 151.0f;
		CST_ColorVarSpeed_R2 = 100.0f;
		CST_ColorVarSpeed_G2 = 70.0f;
		CST_ColorVarSpeed_B2 = 120.0f;

		// Transparency controls
		CST_AlphaVarSpeed1 = 44.0f;
		CST_AlphaVar1 = 80.0f;
		CST_AlphaVarSpeed2 = 37.0f;
		CST_AlphaVar2 = 50.0f;

		// Circle displacement control
		CST_XOfs_Speed = 91.0f;
		CST_YOfs_Speed = 63.0f;
		CST_DistVarSpeed1 = 27.0f;
		CST_DistVarSpeed2 = 37.0f;
}

// Destructor for the effect class
CBlankerB::~CBlankerB(void)
{
}

// This function will set the card and load the textures
void CBlankerB::ResetEffect(void)
{
	// Reset frame counter
	srand( (unsigned)time( NULL ) );
	frame=rand();
	
	// Init Screen Texture (used to capture the screen from the 3dfx)
	memset(ScreenTexture,0,256*256*sizeof(WORD));
	ScreenTexturePos = grTexMinAddress(GR_TMU0);
	ScreenTextureInfo.smallLod = GR_LOD_256;
	ScreenTextureInfo.largeLod = GR_LOD_256;
	ScreenTextureInfo.aspectRatio  = GR_ASPECT_1x1;
	ScreenTextureInfo.format = GR_TEXFMT_RGB_565;
	ScreenTextureInfo.data = ScreenTexture;

	// Get Texture 1 from file
	gu3dfGetInfo("c:\\windows\\screen20.da1", &FXTextureFileInfo);
	if (FXTextureFileInfo.mem_required==0) exit(-2);
	if (FXTextureFileInfo.data!=NULL) delete FXTextureFileInfo.data;
	FXTextureFileInfo.data = new char[FXTextureFileInfo.mem_required];
	gu3dfLoad("c:\\windows\\screen20.da1", &FXTextureFileInfo);
	FXTexturePos = ScreenTexturePos + 256*256*sizeof(WORD);
	FXTextureInfo.smallLod = FXTextureFileInfo.header.small_lod;
	FXTextureInfo.largeLod = FXTextureFileInfo.header.large_lod;
	FXTextureInfo.aspectRatio = FXTextureFileInfo.header.aspect_ratio;
	FXTextureInfo.format = FXTextureFileInfo.header.format;
	FXTextureInfo.data = FXTextureFileInfo.data;

	// Get Texture 2 from file
	gu3dfGetInfo("c:\\windows\\screen20.da2", &FXTexture2FileInfo);
	if (FXTexture2FileInfo.mem_required==0) exit(-2);
	if (FXTexture2FileInfo.data!=NULL) delete FXTexture2FileInfo.data;
	FXTexture2FileInfo.data = new char[FXTexture2FileInfo.mem_required];
	gu3dfLoad("c:\\windows\\screen20.da2", &FXTexture2FileInfo);
	FXTexture2Pos = FXTexturePos + 256*256*sizeof(WORD);
	FXTexture2Info.smallLod = FXTexture2FileInfo.header.small_lod;
	FXTexture2Info.largeLod = FXTexture2FileInfo.header.large_lod;
	FXTexture2Info.aspectRatio = FXTexture2FileInfo.header.aspect_ratio;
	FXTexture2Info.format = FXTexture2FileInfo.header.format;
	FXTexture2Info.data = FXTexture2FileInfo.data;

	// Init Big Background Vetices
	VertBig[0].x=0.0f;
	VertBig[0].y=0.0f;
	VertBig[0].ooz=1.0f;
	VertBig[0].oow=1.0f;
	VertBig[0].r=3.0f;
	VertBig[0].g=3.0f;
	VertBig[0].b=3.0f;
	VertBig[0].a=245.0f;
	VertBig[0].tmuvtx[0].oow = 1.0f;
	VertBig[0].tmuvtx[0].sow = 0.0f;
	VertBig[0].tmuvtx[0].tow = 0.0f;

	VertBig[1].x=639.0f;
	VertBig[1].y=0.0f;
	VertBig[1].ooz=1.0f;
	VertBig[1].oow=1.0f;
	VertBig[1].r=3.0f;
	VertBig[1].g=3.0f;
	VertBig[1].b=3.0f;
	VertBig[1].a=245.0f;
	VertBig[1].tmuvtx[0].oow = 1.0f;
	VertBig[1].tmuvtx[0].sow = 255.0f;
	VertBig[1].tmuvtx[0].tow = 0.0f;

	VertBig[2].x=0.0f;
	VertBig[2].y=479.0f;
	VertBig[2].ooz=1.0f;
	VertBig[2].oow=1.0f;
	VertBig[2].r=3.0f;
	VertBig[2].g=3.0f;
	VertBig[2].b=3.0f;
	VertBig[2].a=245.0f;
	VertBig[2].tmuvtx[0].oow = 1.0f;
	VertBig[2].tmuvtx[0].sow = 0.0f;
	VertBig[2].tmuvtx[0].tow = 255.0f;

	VertBig[3].x=639.0f;
	VertBig[3].y=479.0f;
	VertBig[3].ooz=1.0f;
	VertBig[3].oow=1.0f;
	VertBig[3].r=3.0f;
	VertBig[3].g=3.0f;
	VertBig[3].b=3.0f;
	VertBig[3].a=245.0f;
	VertBig[3].tmuvtx[0].oow = 1.0f;
	VertBig[3].tmuvtx[0].sow = 255.0f;
	VertBig[3].tmuvtx[0].tow = 255.0f;

	// Init Small Background Vertices
	VertSml[0].x=16.0f;
	VertSml[0].y=16.0f;
	VertSml[0].ooz=1.0f;
	VertSml[0].oow=1.0f;
	VertSml[0].r=1.0f;
	VertSml[0].g=3.0f;
	VertSml[0].b=2.0f;
	VertSml[0].a=240.0f;
	VertSml[0].tmuvtx[0].oow = 1.0f;
	VertSml[0].tmuvtx[0].sow = 0.0f;
	VertSml[0].tmuvtx[0].tow = 0.0f;

	VertSml[1].x=239.0f;
	VertSml[1].y=16.0f;
	VertSml[1].ooz=1.0f;
	VertSml[1].oow=1.0f;
	VertSml[1].r=2.0f;
	VertSml[1].g=1.0f;
	VertSml[1].b=1.0f;
	VertSml[1].a=240.0f;
	VertSml[1].tmuvtx[0].oow = 1.0f;
	VertSml[1].tmuvtx[0].sow = 255.0f;
	VertSml[1].tmuvtx[0].tow = 0.0f;

	VertSml[2].x=16.0f;
	VertSml[2].y=239.0f;
	VertSml[2].ooz=1.0f;
	VertSml[2].oow=1.0f;
	VertSml[2].r=0.0f;
	VertSml[2].g=2.0f;
	VertSml[2].b=3.0f;
	VertSml[2].a=240.0f;
	VertSml[2].tmuvtx[0].oow = 1.0f;
	VertSml[2].tmuvtx[0].sow = 0.0f;
	VertSml[2].tmuvtx[0].tow = 255.0f;

	VertSml[3].x=239.0f;
	VertSml[3].y=239.0f;
	VertSml[3].ooz=1.0f;
	VertSml[3].oow=1.0f;
	VertSml[3].r=2.0f;
	VertSml[3].g=3.0f;
	VertSml[3].b=1.0f;
	VertSml[3].a=240.0f;
	VertSml[3].tmuvtx[0].oow = 1.0f;
	VertSml[3].tmuvtx[0].sow = 255.0f;
	VertSml[3].tmuvtx[0].tow = 255.0f;

	// Init Box (square used to build the circular rings)
	VertBox[0].ooz=1.0f;
	VertBox[0].oow=1.0f;
	VertBox[0].r=0.0f;
	VertBox[0].g=0.0f;
	VertBox[0].b=0.0f;
	VertBox[0].a=255.0f;
	VertBox[0].tmuvtx[0].oow = 1.0f;
	VertBox[0].tmuvtx[0].sow = 0.0f;
	VertBox[0].tmuvtx[0].tow = 0.0f;

	VertBox[1].ooz=1.0f;
	VertBox[1].oow=1.0f;
	VertBox[1].r=0.0f;
	VertBox[1].g=0.0f;
	VertBox[1].b=0.0f;
	VertBox[1].a=255.0f;
	VertBox[1].tmuvtx[0].oow = 1.0f;
	VertBox[1].tmuvtx[0].sow = 255.0f;
	VertBox[1].tmuvtx[0].tow = 0.0f;

	VertBox[2].ooz=1.0f;
	VertBox[2].oow=1.0f;
	VertBox[2].r=0.0f;
	VertBox[2].g=0.0f;
	VertBox[2].b=0.0f;
	VertBox[2].a=255.0f;
	VertBox[2].tmuvtx[0].oow = 1.0f;
	VertBox[2].tmuvtx[0].sow = 0.0f;
	VertBox[2].tmuvtx[0].tow = 255.0f;

	VertBox[3].ooz=1.0f;
	VertBox[3].oow=1.0f;
	VertBox[3].r=0.0f;
	VertBox[3].g=0.0f;
	VertBox[3].b=0.0f;
	VertBox[3].a=255.0f;
	VertBox[3].tmuvtx[0].oow = 1.0f;
	VertBox[3].tmuvtx[0].sow = 255.0f;
	VertBox[3].tmuvtx[0].tow = 255.0f;
}


// This function will resed the state of the 3dfx card do it can render the blanker
void CBlankerB::ResetCard(void)
{
	// Set the 3dfx to operate in the desiered mode
	grRenderBuffer(GR_BUFFER_BACKBUFFER);
	grColorMask(TRUE,FALSE);
	grDepthMask(FXFALSE);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	guAlphaSource(GR_ALPHASOURCE_ITERATED_ALPHA);
	guTexCombineFunction(GR_TMU0, GR_TEXTURECOMBINE_DECAL);
	grTexMipMapMode(GR_TMU0, GR_MIPMAP_NEAREST, FXFALSE);
	grTexFilterMode(GR_TMU0, GR_TEXTUREFILTER_BILINEAR, GR_TEXTUREFILTER_BILINEAR);

	// Set the 3dfx color blending modes
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA, GR_BLEND_ONE, GR_BLEND_ZERO);
	guColorCombineFunction(GR_COLORCOMBINE_TEXTURE_ADD_ITRGB);

	// Send the 2 textures to the card.
	grTexDownloadMipMap(GR_TMU0, FXTexturePos, GR_MIPMAPLEVELMASK_BOTH, &FXTextureInfo);
	grTexDownloadMipMap(GR_TMU0, FXTexture2Pos, GR_MIPMAPLEVELMASK_BOTH, &FXTexture2Info);

}


// This function renderes the full-screen version of the effect
void CBlankerB::RenderSceneBig(void)
{
	// Draw background
	grTexSource(GR_TMU0, ScreenTexturePos, GR_MIPMAPLEVELMASK_BOTH, &ScreenTextureInfo);
	grDrawTriangle(&VertBig[0],&VertBig[1],&VertBig[2]);
	grDrawTriangle(&VertBig[2],&VertBig[1],&VertBig[3]);
}

// Renders the 256x256 version of the effect
void CBlankerB::RenderSceneSmall(void)
{
	// Calculate recusion offset
	double xofs=CST_Recurse_XOfs*cos(frame/CST_Recurse_XSpeed1);
	double yofs=CST_Recurse_YOfs*sin(frame/CST_Recurse_YSpeed1);
	double xofs2=CST_Recurse_XOfs*cos(frame/CST_Recurse_XSpeed2);
	double yofs2=CST_Recurse_YOfs*sin(frame/CST_Recurse_YSpeed2);

	// Calculate resursion Squish
	VertSml[0].x=CST_Recurse_XOfs*2.0f+(float)xofs;
	VertSml[0].y=CST_Recurse_YOfs*2.0f+(float)yofs;
	VertSml[1].x=256.0f-CST_Recurse_XOfs*2.0f-(float)xofs;
	VertSml[1].y=CST_Recurse_YOfs*2.0f+(float)yofs;
	VertSml[2].x=CST_Recurse_XOfs*2.0f+(float)xofs;
	VertSml[2].y=256.0f-CST_Recurse_YOfs*2.0f-(float)yofs;
	VertSml[3].x=256.0f-CST_Recurse_XOfs*2.0f-(float)xofs;
	VertSml[3].y=256.0f-CST_Recurse_YOfs*2.0f-(float)yofs;

	// Spin
	VertSml[0].x+=(float)xofs2;
	VertSml[0].y+=(float)yofs2;
	VertSml[1].x+=(float)xofs2;
	VertSml[1].y+=(float)yofs2;
	VertSml[2].x+=(float)xofs2;
	VertSml[2].y+=(float)yofs2;
	VertSml[3].x+=(float)xofs2;
	VertSml[3].y+=(float)yofs2;
					 
	// Draw background
	grTexSource(GR_TMU0, ScreenTexturePos, GR_MIPMAPLEVELMASK_BOTH, &ScreenTextureInfo);
	grDrawTriangle(&VertSml[0],&VertSml[1],&VertSml[2]);
	grDrawTriangle(&VertSml[2],&VertSml[1],&VertSml[3]);

	// Draw boxes
	double inc = 2.0*3.14/16.0;
	double oneeight = 2.0*3.14/8.0;
	double pos;
	double dist=90 + 45.0*cos(frame/CST_DistVarSpeed1);
	double offset=7.0*cos(frame/CST_XOfs_Speed);
	double offset2=7.0*cos(frame/CST_YOfs_Speed);
	BYTE Col1=32 + (int)(32.0*cos(frame/CST_ColorVarSpeed_R1));
	BYTE Col2=32 + (int)(32.0*cos(frame/CST_ColorVarSpeed_G1));
	BYTE Col3=32 + (int)(32.0*cos(frame/CST_ColorVarSpeed_B1));

	grTexSource(GR_TMU0, FXTexturePos, GR_MIPMAPLEVELMASK_BOTH, &FXTextureInfo);
	for (int i=0;i<16;i++)
	{
		pos = inc*i + offset;
						 
		VertBox[0].x = (float)(128 + dist * sin(pos + 3*oneeight)); 
		VertBox[1].x = (float)(128 + dist * sin(pos + oneeight)); 
		VertBox[0].y = (float)(128 + dist * cos(pos + 3*oneeight)); 
		VertBox[1].y = (float)(128 + dist * cos(pos + oneeight)); 
		
		VertBox[2].x = (float)(128 + (dist+200) * sin(pos + 2.5*oneeight)); 
		VertBox[3].x = (float)(128 + (dist+200) * sin(pos + 1.5*oneeight)); 
		VertBox[2].y = (float)(128 + (dist+200) * cos(pos + 2.5*oneeight)); 
		VertBox[3].y = (float)(128 + (dist+200) * cos(pos + 1.5*oneeight)); 

		VertBox[3].a = VertBox[2].a = VertBox[1].a = VertBox[0].a = (float)(128 + CST_AlphaVar1 * sin(frame/CST_AlphaVarSpeed1)); 
		VertBox[3].r = VertBox[2].r = VertBox[1].r = VertBox[0].r = Col1; 
		VertBox[3].g = VertBox[2].g = VertBox[1].g = VertBox[0].g = Col2; 
		VertBox[3].b = VertBox[2].b = VertBox[1].b = VertBox[0].b = Col3; 

		guDrawTriangleWithClip(&VertBox[0],&VertBox[1],&VertBox[2]);
		guDrawTriangleWithClip(&VertBox[2],&VertBox[1],&VertBox[3]);
	}
	offset=7.0*cos(frame/CST_XOfs_Speed);
	dist=90 + 45.0*cos(frame/CST_DistVarSpeed2);
	grTexSource(GR_TMU0, FXTexture2Pos, GR_MIPMAPLEVELMASK_BOTH, &FXTexture2Info);
	Col1=32 + (int)(32.0*cos(frame/CST_ColorVarSpeed_R2));
	Col2=32 + (int)(32.0*cos(frame/CST_ColorVarSpeed_G2));
	Col3=32 + (int)(32.0*cos(frame/CST_ColorVarSpeed_B2));
	for (i=0;i<16;i++)
	{
		pos = inc*i + offset;
						 
		VertBox[0].x = (float)(128 + dist * sin(pos + 3*oneeight)); 
		VertBox[1].x = (float)(128 + dist * sin(pos + oneeight)); 
		VertBox[0].y = (float)(128 + dist * cos(pos + 3*oneeight)); 
		VertBox[1].y = (float)(128 + dist * cos(pos + oneeight)); 
		
		VertBox[2].x = (float)(128 + (dist+200) * sin(pos + 2.5*oneeight)); 
		VertBox[3].x = (float)(128 + (dist+200) * sin(pos + 1.5*oneeight)); 
		VertBox[2].y = (float)(128 + (dist+200) * cos(pos + 2.5*oneeight)); 
		VertBox[3].y = (float)(128 + (dist+200) * cos(pos + 1.5*oneeight)); 

		VertBox[3].a = VertBox[2].a = VertBox[1].a = VertBox[0].a = (float)(64 + CST_AlphaVar2 * sin(frame/CST_AlphaVarSpeed2)); 
		VertBox[3].r = VertBox[2].r = VertBox[1].r = VertBox[0].r = Col3; 
		VertBox[3].g = VertBox[2].g = VertBox[1].g = VertBox[0].g = Col1; 
		VertBox[3].b = VertBox[2].b = VertBox[1].b = VertBox[0].b = Col2; 

		guDrawTriangleWithClip(&VertBox[0],&VertBox[1],&VertBox[2]);
		guDrawTriangleWithClip(&VertBox[2],&VertBox[1],&VertBox[3]);
	}
}


// This function renderes a full frame (small and big)
void CBlankerB::DoFrame(void)
{
		// Upload the screen texture to the card
		grTexDownloadMipMap(GR_TMU0, ScreenTexturePos, GR_MIPMAPLEVELMASK_BOTH, &ScreenTextureInfo);

		// Render small scene (every x frames)
		if ((frame%2)==0)
		{				   
			// Render the 256x256 version
			grBufferClear( 0, 0, GR_ZDEPTHVALUE_FARTHEST );
			RenderSceneSmall();

			// Grab the screen and modify it's values (scale, blur,...)
			grLfbReadRegion( GR_BUFFER_BACKBUFFER, 0, 0, 256, 256, 256*2, ScreenTexture);
		}

		// Re-Render Big Scene
		RenderSceneBig();

		// Swap the buffer
		grBufferSwap(0);

        frame++;
}

// Returns the current frame count
DWORD CBlankerB::GetFrameCount(void)
{
	return frame;
}
