// 3dfxswarm
// v1.0
// entry for the Operation 3dfx Screen Saver Contest
//
// by John Faulkenbury
// based on code written by Jeff Butterworth on 7/11/90


#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <time.h>
#include <iostream.h>
#include <math.h>

#include <glide.h>
#include "include.h"
#include "xswarm.h"

void main() {
	InitGraphics();
  Animate();
	CloseGraphics();
}

void Animate() {

	register int b;		// bee index
	GrVertex segs[BEES];
  short *x, *y, *z;		// bee positions x[time][bee#]
  short *xv, *yv, *zv;	// bee velocities xv[bee#]
  GrVertex wasp0, wasp1;
  int waspxv, waspyv, waspzv;
  int dx,dy,dz,distance;

  // Get the random number generator ready.
  srand( (unsigned)time( NULL ) );

  // Allocate memory
  x = (short *) malloc(sizeof(short) * bees * 3);
  y = (short *) malloc(sizeof(short) * bees * 3);
  z = (short *) malloc(sizeof(short) * bees * 3);
  xv = (short *) malloc(sizeof(short) * bees);
  yv = (short *) malloc(sizeof(short) * bees);
  zv = (short *) malloc(sizeof(short) * bees);

  // Initialize point positions, velocities, etc

	// wasp
  wasp0.x = (float)(BORDER + rand() % (640 - 2 * BORDER));
  wasp0.y = (float)(BORDER + rand() % (480 - 2 * BORDER));
  wasp0.z = (float)(BORDER + rand() % (300 - 2 * BORDER));

  wasp1.x = wasp0.x;
  wasp1.y = wasp0.y;
  wasp1.z = wasp0.z;
  waspxv = 0;
  waspyv = 0;
  waspzv = 0;

  // bees initial position
  for (b = 0 ; b < bees ; b++) {
    X(0,b) = rand() % 640;
    X(1,b) = X(0,b);
    Y(0,b) = rand() % 480;
    Y(1,b) = Y(0,b);
    Z(0,b) = rand() % 300;
    Z(1,b) = Z(0,b);
    xv[b] = RAND(7);
    yv[b] = RAND(7);
    zv[b] = RAND(7);
	}

//	yr_d=xr_d=zr_d=0;

	PresetTriangleInfo();

	while(!kbhit()) {
		// move current frame to last frame
		wasp1.x = wasp0.x;
		wasp1.y = wasp0.y;
		wasp1.z = wasp0.z;

		// accelerate
		waspxv += RAND(wasp_acc);
		waspyv += RAND(wasp_acc);
		waspzv += RAND(wasp_acc);

		// speed limit checks (warning! radar in use)
		if (waspxv > wasp_vel) waspxv = wasp_vel;
		if (waspxv < -wasp_vel) waspxv = -wasp_vel;
		if (waspyv > wasp_vel) waspyv = wasp_vel;
		if (waspyv < -wasp_vel) waspyv = -wasp_vel;
		if (waspzv > wasp_vel) waspzv = wasp_vel;
		if (waspzv < -wasp_vel) waspzv = -wasp_vel;

		// move
		wasp0.x = wasp1.x + waspxv;
		wasp0.y = wasp1.y + waspyv;
		wasp0.z = wasp1.z + waspzv;

		// bounce checks (heh)
		if ((wasp0.x < border) || (wasp0.x > 640.0f - border - 1.0f )) {
			waspxv = -waspxv;
			wasp0.x += waspxv;
		}
		if ((wasp0.y < border) || (wasp0.y > 480.0f - border - 1.0f )) {
			waspyv = -waspyv;
			wasp0.y += waspyv;
		}
		if ((wasp0.z < border) || (wasp0.z > 300.0f - border - 1.0f )) {
			waspzv = -waspzv;
			wasp0.z += waspzv;
		}

		// Don't let things settle down
		xv[rand() % bees] += RAND(3);
		yv[rand() % bees] += RAND(3);
		zv[rand() % bees] += RAND(3);


		for (b = 0 ; b < bees ; b++) {
			// Age the arrays
	    X(1,b) = X(0,b);
	    Y(1,b) = Y(0,b);
	    Z(1,b) = Z(0,b);

	    // Accelerate
	    dx = (int)(wasp1.x - X(1,b));
	    dy = (int)(wasp1.y - Y(1,b));
	    dz = (int)(wasp1.z - Z(1,b));
	    distance = abs(dx)+abs(dy); // just a quick approx.
	    if (distance == 0) distance = 1;
	    xv[b] += (dx*bee_acc)/distance;
	    yv[b] += (dy*bee_acc)/distance;
	    zv[b] += (dz*bee_acc)/distance;

	    // Speed Limit Checks
	    if (xv[b] > bee_vel) xv[b] = bee_vel;
	    if (xv[b] < -bee_vel) xv[b] = -bee_vel;
	    if (yv[b] > bee_vel) yv[b] = bee_vel;
	    if (yv[b] < -bee_vel) yv[b] = -bee_vel;
	    if (zv[b] > bee_vel) zv[b] = bee_vel;
	    if (zv[b] < -bee_vel) zv[b] = -bee_vel;

	    // Move
	    X(0,b) = X(1,b) + xv[b];
	    Y(0,b) = Y(1,b) + yv[b];
	    Z(0,b) = Z(1,b) + zv[b];

	    // Fill the segment lists
	    segs[b].x = X(0,b);
	    segs[b].y = Y(0,b);
	    segs[b].z = Z(0,b);
		}

		// clear the screen
		grBufferClear( 0x0, 0, GR_ZDEPTHVALUE_FARTHEST );
		
		// Wasp
		xpos=wasp0.x/1.0f-320.0f;
		ypos=wasp0.y/1.0f-240.0f;
		zpos=wasp0.z-420.0f;

		x_cos=waspzv/(float)sqrt(waspzv*waspzv+waspyv*waspyv);
		x_sin=waspyv/(float)sqrt(waspzv*waspzv+waspyv*waspyv);

		y_cos=waspxv/(float)sqrt(waspxv*waspxv+waspzv*waspzv);
		y_sin=waspzv/(float)sqrt(waspxv*waspxv+waspzv*waspzv);

		z_cos=waspxv/(float)sqrt(waspxv*waspxv+waspyv*waspyv);
		z_sin=waspyv/(float)sqrt(waspxv*waspxv+waspyv*waspyv);

		DrawWasp();

		// Bees
		for (b = 0 ; b < bees ; b++) {
			xpos=segs[b].x/1.0f-320.0f;
			ypos=segs[b].y/1.0f-240.0f;
			zpos=segs[b].z-420.0f-BORDER*2;

			x_cos=-zv[b]/(float)sqrt(zv[b]*zv[b]+yv[b]*yv[b]);
			x_sin=-yv[b]/(float)sqrt(zv[b]*zv[b]+yv[b]*yv[b]);

			y_cos=xv[b]/(float)sqrt(xv[b]*xv[b]+zv[b]*zv[b]);
			y_sin=-zv[b]/(float)sqrt(xv[b]*xv[b]+zv[b]*zv[b]);

			z_cos=-xv[b]/(float)sqrt(xv[b]*xv[b]+yv[b]*yv[b]);
			z_sin=-yv[b]/(float)sqrt(xv[b]*xv[b]+yv[b]*yv[b]);

			DrawBee();
		}		
		grBufferSwap( 1 );
		grBufferClear( 0x0, 0, GR_ZDEPTHVALUE_FARTHEST );
		grSstIdle();
	}
}
