// glide.c
//
// this contains all the glide specific calls

#include <assert.h>
#include <glide.h>

GrHwConfiguration hwconfig;

void InitGraphics() {
  GrScreenResolution_t resolution = GR_RESOLUTION_640x480;
  float scrWidth   = 640.0f;
  float scrHeight  = 480.0f;

  grGlideInit();
  assert( grSstQueryHardware( &hwconfig ) );
  grSstSelect( 0 );
  assert( grSstWinOpen( 0, resolution, GR_REFRESH_60Hz, GR_COLORFORMAT_RGBA, GR_ORIGIN_LOWER_LEFT, 2, 1 ) );
    
//  grColorCombine( GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_NONE, GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_NONE, FXFALSE );
  grColorCombine( GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_NONE, GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_NONE, FXFALSE );
	grCullMode(GR_CULL_NEGATIVE);
}

void CloseGraphics() {
	// Clean up and shut down
	grGlideShutdown();
}
