// 3d.c

#include <math.h>
#include <glide.h>
#include "include2.h"

void GetTriangle(int i) {
	point[0].x=beemodel[i][0][1]*2.0f;
	point[0].y=beemodel[i][0][0]*2.0f;
	point[0].z=beemodel[i][0][2]*2.0f;

	point[1].x=beemodel[i][1][1]*2.0f;
	point[1].y=beemodel[i][1][0]*2.0f;
	point[1].z=beemodel[i][1][2]*2.0f;
		
	point[2].x=beemodel[i][2][1]*2.0f;
	point[2].y=beemodel[i][2][0]*2.0f;
	point[2].z=beemodel[i][2][2]*2.0f;
}


// rotate X
void xrotate() {
	float rotmatrix[4][4];

	rotmatrix[1][0] = x_cos * wmatrix[1][0] + -x_sin * wmatrix[2][0];
	rotmatrix[1][1] = x_cos * wmatrix[1][1] + -x_sin * wmatrix[2][1];
	rotmatrix[1][2] = x_cos * wmatrix[1][2] + -x_sin * wmatrix[2][2];
	rotmatrix[2][0] = x_sin * wmatrix[1][0] + x_cos * wmatrix[2][0];
	rotmatrix[2][1] = x_sin * wmatrix[1][1] + x_cos * wmatrix[2][1];
	rotmatrix[2][2] = x_sin * wmatrix[1][2] + x_cos * wmatrix[2][2];

	wmatrix[1][0]=rotmatrix[1][0];
	wmatrix[1][1]=rotmatrix[1][1];
	wmatrix[1][2]=rotmatrix[1][2];
	wmatrix[2][0]=rotmatrix[2][0];
	wmatrix[2][1]=rotmatrix[2][1];
	wmatrix[2][2]=rotmatrix[2][2];
}

// y
void yrotate() {
	float rotmatrix[4][4];

	rotmatrix[0][0] = y_cos * wmatrix[0][0] + y_sin * wmatrix[2][0];
	rotmatrix[0][1] = y_cos * wmatrix[0][1] + y_sin * wmatrix[2][1];
	rotmatrix[0][2] = y_cos * wmatrix[0][2] + y_sin * wmatrix[2][2];
	rotmatrix[2][0] = -y_sin * wmatrix[0][0] + y_cos * wmatrix[2][0];
	rotmatrix[2][1] = -y_sin * wmatrix[0][1] + y_cos * wmatrix[2][1];
	rotmatrix[2][2] = -y_sin * wmatrix[0][2] + y_cos * wmatrix[2][2];

	wmatrix[0][0]=rotmatrix[0][0];
	wmatrix[0][1]=rotmatrix[0][1];
	wmatrix[0][2]=rotmatrix[0][2];
	wmatrix[2][0]=rotmatrix[2][0];
	wmatrix[2][1]=rotmatrix[2][1];
	wmatrix[2][2]=rotmatrix[2][2];
}

// z
void zrotate() {
	float rotmatrix[4][4];

	rotmatrix[0][0] = z_cos * wmatrix[0][0] + -z_sin * wmatrix[1][0];
	rotmatrix[0][1] = z_cos * wmatrix[0][1] + -z_sin * wmatrix[1][1];
	rotmatrix[0][2] = z_cos * wmatrix[0][2] + -z_sin * wmatrix[1][2];
	rotmatrix[1][0] = z_sin * wmatrix[0][0] + z_cos * wmatrix[1][0];
	rotmatrix[1][1] = z_sin * wmatrix[0][1] + z_cos * wmatrix[1][1];
	rotmatrix[1][2] = z_sin * wmatrix[0][2] + z_cos * wmatrix[1][2];

	wmatrix[0][0]=rotmatrix[0][0];
	wmatrix[0][1]=rotmatrix[0][1];
	wmatrix[0][2]=rotmatrix[0][2];
	wmatrix[1][0]=rotmatrix[1][0];
	wmatrix[1][1]=rotmatrix[1][1];
	wmatrix[1][2]=rotmatrix[1][2];
}

void TransformPoint(int j) {
	// put the point's values into a vector
	SVec[0]=point[j].x;
	SVec[1]=point[j].y;
	SVec[2]=point[j].z;
	SVec[3]=1.0f;
				
	xrotate();
	yrotate();
	zrotate();

	wmatrix[0][3]=xpos;
	wmatrix[1][3]=ypos;
	wmatrix[2][3]=zpos;

	// transform the point to world space
	for (a=0; a<4; a++) {
		DVec[a]=0.0f;
		for (b=0; b<4; b++)
			DVec[a] += wmatrix[a][b] * SVec[b];
	}

	// dump the result back into the point
	point[j].x=DVec[0];
	point[j].y=DVec[1];
	point[j].z=DVec[2];

	// reset the world matrix
	wmatrix[0][0]=1.0f; wmatrix[0][1]=0.0f; wmatrix[0][2]=0.0f;
	wmatrix[1][0]=0.0f; wmatrix[1][1]=1.0f; wmatrix[1][2]=0.0f;
	wmatrix[2][0]=0.0f; wmatrix[2][1]=0.0f; wmatrix[2][2]=1.0f;

	// project the points to the screen
	ppoint[j].x = ( (point[j].x / point[j].z * -320.0f ) + 320.0f) + SNAP;
	ppoint[j].y = ( (point[j].y / point[j].z * -320.0f ) + 240.0f) + SNAP;
}

void PresetTriangleInfo() {
	ppoint[0].a=255.0f;
	ppoint[1].a=255.0f;
	ppoint[2].a=255.0f;

	ppoint[0].oow=1.0f;
	ppoint[1].oow=1.0f;
	ppoint[2].oow=1.0f;

	ppoint[0].r=255.0f;
	ppoint[0].g=255.0f;
	ppoint[0].b=0.0f;

	ppoint[1].r=0.0f;
	ppoint[1].g=0.0f;
	ppoint[1].b=0.0f;

	ppoint[2].r=0.0f;
	ppoint[2].g=0.0f;
	ppoint[2].b=0.0f;
}


void DrawBee() {
		for(i=0;i<8;i++) {
			GetTriangle(i);
			for (j=0;j<3;j++)
				TransformPoint(j);
			grDrawTriangle(&ppoint[0], &ppoint[1], &ppoint[2]);
		}

}

void DrawWasp() {
	ppoint[0].r=255.0f;
	ppoint[0].g=40.0f;
	ppoint[0].b=0.0f;

	ppoint[1].r=0.0f;
	ppoint[1].g=0.0f;
	ppoint[1].b=0.0f;

	ppoint[2].r=0.0f;
	ppoint[2].g=0.0f;
	ppoint[2].b=0.0f;

		for(i=0;i<8;i++) {
			GetTriangle(i);
			for (j=0;j<3;j++)
				TransformPoint(j);
			grDrawTriangle(&ppoint[0], &ppoint[1], &ppoint[2]);
		}
	ppoint[0].r=255.0f;
	ppoint[0].g=255.0f;
	ppoint[0].b=0.0f;

	ppoint[1].r=0.0f;
	ppoint[1].g=0.0f;
	ppoint[1].b=0.0f;

	ppoint[2].r=0.0f;
	ppoint[2].g=0.0f;
	ppoint[2].b=0.0f;

}