/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/


#include <windows.h>
#include <glide.h>

#include "defines.h"
#include "win.h"
#include "defines.h"
#include "hw.h"
#include "mat.h"
#include "cam.h"

static HINSTANCE hInstance ;
static HWND hwnd ;

static char szAppName[] = "Voodoo Lights Screensaver Demo";

extern Float Time ;

static int ypos = 0;


static DEVMODE devmode ;
static DWORD dwCurrWidth, dwCurrHeight, dwCurrBPP ;

static void win_RestoreDisplay( void )
{
	devmode.dmSize = sizeof(DEVMODE);
	devmode.dmBitsPerPel = dwCurrBPP;
	devmode.dmPelsWidth = dwCurrWidth;
	devmode.dmPelsHeight = dwCurrHeight;
	devmode.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT ;
	ChangeDisplaySettings(& devmode, 0 ) ;
}
static void win_ResizeDisplay( void )
{

	HWND           hDesktop;
	HDC            hDCDesk;

	hDesktop = GetDesktopWindow() ;
	hDCDesk = GetDC( hDesktop ) ;
	
	dwCurrWidth = GetDeviceCaps( hDCDesk, HORZRES ) ;
	dwCurrHeight = GetDeviceCaps( hDCDesk, VERTRES ) ;
	dwCurrBPP = GetDeviceCaps( hDCDesk, BITSPIXEL);

	ReleaseDC( hDesktop, hDCDesk ) ;

	devmode.dmSize = sizeof(DEVMODE);
	devmode.dmPelsWidth = hw_ResX ;		
	devmode.dmPelsHeight = hw_ResY ; 
	devmode.dmBitsPerPel = 16 ;	
	devmode.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;
	ChangeDisplaySettings( & devmode, 0 ) ;
}

void win_printf(char *msg)
{
	HDC hdc = GetDC( hwnd ) ;
	TextOut( hdc, 0, ypos, msg, strlen( msg ) ) ;
	ypos = (ypos + 16) % (45*16);
	ReleaseDC( hwnd, hdc ) ;
}

static LRESULT CALLBACK win_EventHandler(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch (iMsg) {
		case WM_KILLFOCUS:
		case WM_SETFOCUS :
		case WM_MOUSEMOVE:
		case WM_CHAR:	
			if( Time > 2.0 ) PostQuitMessage( 0 ) ;
			return 0;
		case WM_DESTROY:
			PostQuitMessage( 0 );
			break ;
	}
    return( DefWindowProc(hwnd, iMsg, wParam, lParam) ) ;
}


static void win_DestroyWindow()
{
	hw_ShutdownHardware() ;
	DestroyWindow(hwnd) ;
	win_RestoreDisplay() ;
}

HWND win_StartWindow(HINSTANCE hInstance, int iCmdShow)
{
    HWND		w;
    WNDCLASSEX	wc;

    wc.cbSize        = sizeof( wc ) ;
    wc.style         = CS_HREDRAW | CS_VREDRAW ;
    wc.lpfnWndProc   = win_EventHandler ;
    wc.cbClsExtra    = 0 ;
    wc.cbWndExtra    = 0 ;
    wc.hInstance     = hInstance ;
    wc.hIcon         = LoadIcon(hInstance, IDI_APPLICATION) ;
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW) ;
    wc.hbrBackground = GetStockObject(DKGRAY_BRUSH) ;
    wc.lpszMenuName  = NULL ;
    wc.lpszClassName = szAppName ;
    wc.hIconSm       = LoadIcon(hInstance, IDI_APPLICATION) ;

    RegisterClassEx( & wc ) ;
    
    w = CreateWindowEx(
        WS_EX_DLGMODALFRAME,							
        szAppName,
        szAppName,
        WS_CAPTION,        
		0,
        0,
		hw_ResX,
        hw_ResY,
        NULL,
        NULL,
        hInstance,
        NULL );    
    ShowWindow( w, SW_SHOWMAXIMIZED );
    UpdateWindow( w );


	SetCapture( w ) ; // Falta um ReleaseCapture algures

	return(w);
}

void win_MessageBox( Bool Fatal, char *Title, char *Body )
{
	ShowCursor( True ) ;
	MessageBox(hInstance, Body, Title, MB_OK);
	win_DestroyWindow() ;
	if( Fatal ) exit(-1) ;
}	


static int win_PeekMessages( void )
{
	MSG msg;

	while (PeekMessage(& msg, NULL, 0, 0, PM_REMOVE)) {
		if (msg.message == WM_QUIT) 
			return msg.wParam ;
		TranslateMessage( & msg ) ;
		DispatchMessage( & msg ) ;
	}
	return 1 ;
}


int WINAPI WinMain(HINSTANCE hI, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{

	if( szCmdLine && szCmdLine[1] == 'p' ) return 0 ;

	hInstance = hI ;

	win_ResizeDisplay() ;

	hwnd = win_StartWindow(hInstance, iCmdShow);
	ShowCursor( False ) ;

	main_InitModule() ;

	while( win_PeekMessages() ) main_MainLoop() ;


	win_DestroyWindow() ;

	return 0 ;
}
