/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <glide.h>

#include "defines.h"

#include "tex.h"
#include "win.h"


extern char tex_path[] ;
 
GrMipMapId_t tex_InitTexture( char *name )
{
	GrMipMapId_t handle ;
	Gu3dfInfo info;
	char path[ 512 ] ;

	sprintf(path, "%s/%s", tex_path, name ) ;

	if ( gu3dfGetInfo( path, & info ) ) {
		if ( ( info.data = malloc( info.mem_required ) ) == 0 ) 
			win_MessageBox( 1, "Glide Error", "Not enough core memory." ) ;
	
		
		
		if ( !gu3dfLoad( path, & info ) ) 
			win_MessageBox( 1, "Glide Error", "Cannot load texture." ) ;


		handle = guTexAllocateMemory( GR_TMU0, GR_MIPMAPLEVELMASK_BOTH, 
                                  info.header.width, info.header.height,
                                  info.header.format,
                                  GR_MIPMAP_NEAREST,
                                  info.header.small_lod, info.header.large_lod,
                                  info.header.aspect_ratio,
                                  GR_TEXTURECLAMP_WRAP, GR_TEXTURECLAMP_WRAP,
                                  GR_TEXTUREFILTER_BILINEAR, GR_TEXTUREFILTER_BILINEAR,
                                  0.0,
                                  FXFALSE ) ;

		if ( handle == GR_NULL_MIPMAP_HANDLE )
			win_MessageBox( 1, "Glide Error", "Not enough tmu memory." ) ;

		guTexDownloadMipMap( handle, info.data, NULL ) ;

		return handle ;
	}
	else win_MessageBox( 1, "Glide Error", "Cannot find texture files." ) ;

}

void tex_SetTexSource(GrMipMapId_t src )
{
	guTexSource( src ) ;
}