/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/


#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <glide.h>
#include <windows.h>

#include "defines.h"
#include "mat.h"
#include "win.h"
#include "hw.h"
#include "rgb.h"
#include "cam.h"
#include "tex.h"
#include "cell.h"

Float dt ;

Float Time = 0.0 ;
static Float absTime ;

static XYZ from, at, up ;
static Float  FP, BP, focus ;
static Bool all_created = False ;

char tex_path[ 512 ] ;

static void main_InitCamera()
{

	from.x = 0.0 ;
	from.y = 0.0 ;
	from.z = -100.0 ;

	at.x = 0.0f ; at.y = 0.0f ; at.z = 0.0f ;
	up.x = 0.0f ; up.y = 1.0f ; up.z = 0.0f ;

	focus = 0.6 ;

	FP = 5.0 ;
	BP = 4000.0 ;

	cam_SetCamParameters( & from, & at, & up, focus, FP, BP ) ;
	cam_BuildCameraTransform() ;
}
 
void main_InitModule( void )
{
	time_t timer ;
	int ret ;

	if( ! GetEnvironmentVariable("VoodooLights_Texture_Path", tex_path, sizeof( tex_path ) ) )
		sprintf( tex_path, "./Textures") ;
	
	srand( time( & timer ) % RAND_MAX ) ;
	
	if( ! hw_InitHardware() ) {
		
		hw_ShutdownHardware() ;

		win_MessageBox( 1, "Glide Init Error", "Trouble with 3DFX Graphics hardware." ) ;
    }

	rgb_InitPalette() ;
	main_InitCamera() ;

	
	absTime = 0.001 * GetCurrentTime() ;

	main_InitCamera() ;
	cell_InitModule() ;	

	grGlideShamelessPlug( Time < 10.0 ) ;

}	

void main_MainLoop( void )
{	
	Cell **p ;


	dt = 0.001 *  GetCurrentTime() - absTime ;
	
	absTime += dt ;
	Time += dt ;

	if( cam_NewCamera() ) cam_BuildCameraTransform() ;

	grGlideShamelessPlug( Time < 10.0 && hw_VoodooChipset() ) ;

	grBufferSwap( 3 ) ;
	grColorMask( FXTRUE, FXFALSE ) ;
	grBufferClear( 0x0, 0, 0 );

	cell_MainLoop() ;



	while( grBufferNumPending() > 2 ) ;
}
