/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/


#include <stdlib.h>
#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "tex.h"
#include "cam.h"
#include "cell.h"
#include "cell_util.h"
#include "cell_tp1.h"
#include "cell_tp5.h"
#include "cell_tp7.h"

static Bool first_init = True ;
static GrMipMapId_t tp5_texture_src ;

void tp5_snap_pos_to_dad( Cell *c )
{
	Cell *dad = c->dad ;
	if( dad ) {
		XYZ s ;
		Float l ;
		mat_subv( & c->pos, & (c->dad)->pos, & s ) ;
		l = mat_direction( & s ) ;
		if( l < ZERO ) mat_randomDir( & s ) ;
		mat_combv( min( 2 * c->age, 8.0 ), & s, & dad->pos, & c->pos ) ;
	}
}

static void tp5_move_cell( Cell *c )
{
  mat_combv( dt, & c->vel, & c->pos, & c->pos ) ;
  mat_combv( dt, & c->acc, & c->vel, & c->vel ) ;
  
  tp5_snap_pos_to_dad( c ) ;
  cutl_limit_speed( c, c->max_speed ) ;
}

static void tp5_acc_cell(Cell *c) 
{
  int n ;
  Cell **p, *dad = c->dad ;
    
  mat_scalev( -0.08, & c->pos, & c->acc ) ;

  if( dad ) {
	XYZ d ;
	mat_subv( & dad->pos, & c->pos, & d ) ;
	mat_combv( 100.0 , & d, & c->acc, & c->acc ) ;
  }

 

  p = cell_get_cells_by_type( CellType1, & n ) ;
  cutl_closest_interaction( c, p, n, 20000.0, 1.0 ) ;
  cutl_closest_interaction( c, p, n, -90000.0, 2.0 ) ;
  
  p = cell_get_cells_by_type( CellType5, & n ) ;
  cutl_closest_interaction( c, p, n, -600000.0, 4.0 ) ;

}

static void tp5_reproduce_cell( Cell *c) 
{
	
	ctp7_Constructor( c ) ; 

	if( c->generation > 4 ) {
		Cell *q = c ;
		while( q->dad ) q = q->dad ;
		q->dad = c ;
	}
	else ctp5_Constructor( c ) ; 
	
	c->reproduce_cell = cell_menopause ;
}

void tp5_set_glide_state( void )
{
	if( first_init ) {
		first_init = False ;
		tp5_texture_src = tex_InitTexture("flare2.3df") ;
	}	
	guColorCombineFunction( GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB ) ;
	guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA );	
	grAlphaBlendFunction( GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO );
	tex_SetTexSource( tp5_texture_src ) ;
}

Cell *ctp5_Constructor( Cell *dad )
{
  Cell *c ;

  c = cell_Constructor( CellType5 ) ;

  c->dad = dad ;

  if( dad ) {
    c->pos.x = dad->pos.x + 1 * ( 1 - 2 * rnd()) ;
    c->pos.y = dad->pos.y + 1 * ( 1 - 2 * rnd()) ;
    c->pos.z = dad->pos.z + 1 * ( 1 - 2 * rnd()) ;
  } 
  else cutl_random_pos( 650.0, c ) ;

  if( dad ) {
	  c->adulthood = dad->adulthood ;
	  c->generation = dad->generation + 1 ;
  }
  else c->adulthood = 5.0 ;
 

  c->max_chld = 1 ;
  c->max_speed = 100.0 ;
  c->size = 7.0 ;

  c->color.r = 255.0 ;
  c->color.g = 110.0 ;
  c->color.b = 255.0 ;
  c->color.a = 255.0 ;

  c->sparkle = 1.0 ;

  c->move_cell = tp5_move_cell ;
  c->acc_cell = tp5_acc_cell ;
  c->reproduce_cell = tp5_reproduce_cell ;
 
  return c ;

}  
    







    

