/*------------------------------------------------------/
/														/
/	Copyright 1997, Srgio Durte <smd@di.fct.unl.pt>	/
/														/
/------------------------------------------------------*/

#include <stdlib.h>
#include <glide.h>

#include "defines.h"
#include "mat.h"
#include "rgb.h"
#include "tex.h"
#include "cam.h"
#include "cell.h"
#include "cell_util.h"
#include "cell_tp2.h"
#include "cell_tp3.h"


static Bool first_init = True ;
static GrMipMapId_t tp3_texture_src ;


static void tp3_move_cell( Cell *c )
{
	mat_combv( dt, & c->vel, & c->pos, & c->pos ) ;
	mat_combv( dt, & c->acc, & c->vel, & c->vel ) ;
	cutl_limit_speed( c, c->max_speed ) ;
	cutl_snap_pos_to_dad( c ) ;
}

static void tp3_reproduce_cell( Cell *c) 
{

	if( c->generation < 24 ) c->children[ c->n_chld++ ] = ctp3_Constructor( c ) ;
	
	c->reproduce_cell = cell_menopause ; // no h mais reproduo
}

void tp3_set_glide_state( void )
{
	if( first_init ) {
		first_init = False ;
		tp3_texture_src = tex_InitTexture("flare3.3df") ;
	}	

	tex_SetTexSource( tp3_texture_src ) ;
	grTexCombineFunction(GR_TMU0, GR_TEXTURECOMBINE_DECAL ) ;
	guColorCombineFunction( GR_COLORCOMBINE_TEXTURE_TIMES_ITRGB ) ;
	guAlphaSource( GR_ALPHASOURCE_ITERATED_ALPHA );	
	grAlphaBlendFunction( GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO );
}

Cell *ctp3_Constructor( Cell *dad )
{

  Cell *c = cell_Constructor( CellType3 ) ;

  c->max_speed = 90.0 ;

  c->dad = dad ;

  c->max_chld = 1 ;
  c->p_chld = 0.05 * rnd() + 0.05 ;
 
  if( dad ) {
	  cutl_random_pos( 1.0, c ) ;
	  mat_addv( & dad->pos, & c->pos, & c->pos ) ; 
	  
	  c->generation = dad->generation + 1 ;
	  c->adulthood = dad->adulthood ;
  }	else c->adulthood = 240.0 ; 

  if( dad && dad->type == CellType2 ) c->size = 18.0 ;
  else c->size = max( 6.0, dad->size - 1 ) ;
  c->size +=  2*max( 0, c->generation - 22 ) ;

  if( dad && c->generation > 2 ) c->color = dad->color ;
  else rgb_random_color( & c->color ) ;
   
  c->move_cell = tp3_move_cell ;
  c->reproduce_cell = tp3_reproduce_cell ;

  return c ;
}  
    







    

