#ifndef _CELL_H_
#define _CELL_H_

#define MaxChildren 4

typedef enum {
	ALIVE, DYING, DEAD
} CellStatus ;

typedef struct Cell {
  int type ;
  CellStatus status ;
  struct Cell *dad ;
  struct Cell *children[ MaxChildren] ;
  XYZ pos, vel, acc ;
  RGBA color ;

  XYZW lpos ;
 
  Float age ;
  Float adulthood ;
  Float p_chld ;
  Float max_speed ;
  Float size ;

  Float sparkle ;
  Float sparkle_range ;
  Float sparkle_min ;

  int n_chld, max_chld ;
  int generation ;

  void (*move_cell)( struct Cell * ) ;
  void (*acc_cell)( struct Cell *) ;
  
  void (*age_cell)(struct Cell *) ;
  void (*reproduce_cell)(struct Cell *) ;
  void (*display_cell)(struct Cell *) ;

  int index ; // para ajudar na destruio
} Cell ;

typedef void (*set_glide_state_proc)( void ) ;

extern Cell *cell_Constructor( int type ) ;

extern void cell_Destructor( Cell *c ) ;

extern Cell **cell_get_cells_by_type( int type, int *n) ;

extern void cell_menopause( Cell *c ) ;

extern void cell_InitModule( void ) ;

extern Float dt ;

#endif