/**********************************************************

        3DFX Screensaver Competition Entry #13
            by Paul Steffen
            <psteffen@concentric.net>
            <http://steffen.home.ml.org>

        Here's the source to my tiny starplane[?]
        saver.  No serious attempt at optimizing
        was attempted as the CPU does very little
        work, anyway.

        I dedicate this screensaver to Jeff
        Minter, who should rewrite Trip-O- Tron
        for 3DFX!

***********************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <glide.h>

static char mapfile[]="starmap.3df";
static float n=3.141592654/100;

GrMipMapId_t maphandle;
Gu3dfInfo TexInfo;
GrHwConfiguration hw;
GrVertex point1,point2,point3;
FxU32 framebuffer,TextureMemStart,TextureMemEnd;

float v[4],r[8],cn,f[2]={0,0.05};
int c,fade_in,error;


void
initGlide()
{
   grGlideInit();
   if (grSstQueryHardware(&hw))
   {
       grSstSelect(0);
       grSstWinOpen( 0,
                     GR_RESOLUTION_640x480,
                     GR_REFRESH_60Hz,
                     GR_COLORFORMAT_ABGR,
                     GR_ORIGIN_UPPER_LEFT,
                     GR_SMOOTHING_ENABLE,
                     2);
   } else {
       printf("Cannot initialize Voodoo chipset.\n");
       error++;
   }

    grRenderBuffer(GR_BUFFER_BACKBUFFER);
    grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);

// setup up color combine modes

    grColorCombine( GR_COMBINE_FUNCTION_LOCAL,
                    GR_COMBINE_FACTOR_NONE,
                    GR_COMBINE_LOCAL_ITERATED,
                    GR_COMBINE_OTHER_NONE,
                    FXFALSE);

    guColorCombineFunction(GR_COLORCOMBINE_DECAL_TEXTURE);  //  oh well...
    grTexCombineFunction(GR_TMU0, GR_TEXTURECOMBINE_DECAL); //  fix this l8r.

    grAlphaCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
                   GR_COMBINE_FACTOR_ONE,
                   GR_COMBINE_LOCAL_NONE,
                   GR_COMBINE_OTHER_CONSTANT,
                   FXFALSE);

    grAlphaBlendFunction( GR_BLEND_SRC_ALPHA,
                          GR_BLEND_ONE_MINUS_SRC_ALPHA,
                          GR_BLEND_ONE,
                          GR_BLEND_ZERO);

    grAlphaTestFunction(GR_CMP_ALWAYS);
    guAlphaSource(GR_ALPHASOURCE_ITERATED_ALPHA);



    if(!gu3dfGetInfo(mapfile, &TexInfo))
    {
        printf("Could not find %s image.\n",mapfile);
        grGlideShutdown();
        exit(-1);
    }
        TexInfo.data = malloc(TexInfo.mem_required);
        if(TexInfo.data==0)
        {
            printf("Not enough memory to load %s.\n", mapfile);
            grGlideShutdown();
            exit(-1);
        }
        gu3dfLoad(mapfile, &TexInfo);

        maphandle = guTexAllocateMemory(0, GR_MIPMAPLEVELMASK_BOTH,
                                    TexInfo.header.width,
                                    TexInfo.header.height,
                                    TexInfo.header.format,
                                    GR_MIPMAP_NEAREST_DITHER,
                                    TexInfo.header.small_lod,
                                    TexInfo.header.large_lod,
                                    TexInfo.header.aspect_ratio,
                                    GR_TEXTURECLAMP_WRAP,
                                    GR_TEXTURECLAMP_WRAP,
                                    GR_TEXTUREFILTER_BILINEAR,
                                    GR_TEXTUREFILTER_BILINEAR,
                                    0.f,
                                    FXFALSE);

    guTexDownloadMipMap(maphandle, TexInfo.data, &TexInfo.table.nccTable);
};

void
draw(float size, float x, float y, float rot, float alpha)
{

    float minpoint,maxpoint,st,ct;
    float stminx,stmaxx;
    float ctminx,ctmaxx;
    float stminy,stmaxy;
    float ctminy,ctmaxy;

    size *= sqrt(size);
    st=sin(rot);
    ct=cos(rot);
    minpoint=128-size;
    maxpoint=128+size;

    point1.a=alpha;
    point2.a=alpha;
    point3.a=alpha;

    point1.x=0; point1.y=0;
    point2.x=640; point2.y=0;
    point3.x=0; point3.y=480;

    r[0]=st*(maxpoint+x);
    r[1]=st*(maxpoint+y);
    r[2]=st*(minpoint+x);
    r[3]=st*(minpoint+y);
    r[4]=ct*(maxpoint+x);
    r[5]=ct*(maxpoint+y);
    r[6]=ct*(minpoint+x);
    r[7]=ct*(minpoint+y);

    point1.oow=1.0;
    point1.tmuvtx[0].sow=r[6]-r[3];
    point1.tmuvtx[0].tow=r[2]+r[7];

    point2.oow=1.0;
    point2.tmuvtx[0].sow=r[4]-r[3];
    point2.tmuvtx[0].tow=r[0]+r[7];

    point3.oow=1.0;
    point3.tmuvtx[0].sow=r[6]-r[1];
    point3.tmuvtx[0].tow=r[2]+r[5];

    grDrawTriangle(&point1,&point2,&point3);

    point1.x=640; point1.y=0;
    point2.x=640; point2.y=480;
    point3.x=0; point3.y=480;

    point1.oow=1.0;
    point1.tmuvtx[0].sow=r[4]-r[3];
    point1.tmuvtx[0].tow=r[0]+r[7];

    point2.oow=1.0;
    point2.tmuvtx[0].sow=r[4]-r[1];
    point2.tmuvtx[0].tow=r[0]+r[5];

    point3.oow=1.0;
    point3.tmuvtx[0].sow=r[6]-r[1];
    point3.tmuvtx[0].tow=r[2]+r[5];

    grDrawTriangle(&point1,&point2,&point3);
}

void
update()
{
    c--;

    cn=c*n;

    v[0] = 50+(sin(cn*.3)*cos(cn*.5))*100;
    v[1] = c+(sin(cn*.7)*cos(cn*.6))*512;
    v[2] = c+(cos(cn*.3)*sin(cn))*512;
    v[3] = sin(cn*.5)+cos(cn*.6);

    if(fade_in)
    {
        f[0] += f[1];
        if (f[0]>1.0)
        {
            f[0]=1.0;
            fade_in=-1;
        }
    }



    guTexSource(maphandle);
    draw( v[0]+50, v[1]*.50, v[2]*.50, v[3],  100*f[0]  );
    draw( v[0]+25, v[1]*.25, v[2]*.25, v[3],  60*f[0]   );
    draw( v[0],    v[1],     v[2],     v[3],  40*f[0]   );
    grBufferSwap(2);
}


int
main(int argc, char *argv[])
{
    printf("3DFX Screensaver Competition Entry #13\n");
    printf("written by Paul G. Steffen\n");
    printf("<psteffen@concentric.net>\n");

    initGlide();
    if (!error)
        exit;
    fade_in=1;
    while(!kbhit())
    {
        update();
    }
    getchar();
    grGlideShutdown();
}


