/*
 *  Calculates a weighted average between x1 and x2.
 */
static float bezSplit(float mu, float x1, float x2)
{
   return ((1.0-mu) * x1) + (mu * x2);
}



/* 
 *  Calculates a point on a bezier curve.
 */
static float bezVal(float mu, float *coor)
{
   float work[4];
   int i; 
   int j;

   for (i=0; i<4; i++) 
     work[i] = coor[i*3];

   for (j=0; j<3; j++)
     for (i=0; i<3-j; i++)
       work[i] = bezSplit(mu, work[i], work[i+1]);

   return work[0];
}



/*
 * de Casteljau bezier calc's (basically successive tweening)
 */
void calcSpline(float points[12], int npts, float *x, float *y, float *z)
{
  int i;
  float denom;

  for (i=0; i<npts; i++)
  {
    denom = i / (float)(npts-1);
    x[i] = bezVal(denom, points);
    y[i] = bezVal(denom, points+1);
    z[i] = bezVal(denom, points+2);
  }
}

#define NUMSTEP 256

static float lastones[] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
static int curpos = 1;
static float xpts[NUMSTEP], ypts[NUMSTEP], zpts[NUMSTEP];

void moveCamera()
{
  int j;
  
  obs[0] = xpts[NUMSTEP-curpos];
  obs[1] = ypts[NUMSTEP-curpos];
  obs[2] = ypts[NUMSTEP-curpos];

  curpos--;

  if (curpos == 0)
  {
    for (j=0;j<3;j++)
      lastones[j] = lastones[j+9];
    for (j=3;j<12;j+=3)
    {
      lastones[j] = rnd() * 4.0 - 2.0;
      lastones[j+1] = rnd() * 4.0 + .5;
      lastones[j+2] = rnd() * 4.0 - 2.0;
    }
    calcSpline(&lastones[0], NUMSTEP, xpts, ypts, zpts);
    curpos=NUMSTEP;    
  }

}

