/*
 *  Calculates a weighted average between x1 and x2.
 */
static float bezSplit(float mu, float x1, float x2)
{
   return ((1.0-mu) * x1) + (mu * x2);
}



/* 
 *  Calculates a point on a bezier curve.
 */
static float bezVal(float mu, int *coor)
{
   float work[4];
   int i; 
   int j;

   for (i=0; i<4; i++) 
     work[i] = coor[i*3];

   for (j=0; j<3; j++)
     for (i=0; i<3-j; i++)
       work[i] = bezSplit(mu, work[i], work[i+1]);

   return work[0];
}



/*
 * de Casteljau bezier calc's (basically successive tweening)
 */
void calcSpline(int points[12], int npts, float *x, float *y, float *z)
{
  int i;
  float denom;

  for (i=0; i<npts; i++)
  {
    denom = i / (float)(npts-1);
    x[i] = bezVal(denom, points);
    y[i] = bezVal(denom, points+1);
    z[i] = bezVal(denom, points+2);
  }
}



float lastones[] = {0.0, 0.0, 0.0, 0,0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
int curpos = 1;

void moveCamera()
{
  float xpts[64], ypts[64], zpts[64];

  pos[0] = xpts[curpos];
  pos[1] = ypts[curpos];
  pos[2] = zpts[curpos];

  curpos--;

  if (curpos == 0)
  {
    for (int j=0;j<9;j++)
      lastones[j] = lastones[j+3];
    newones[9] = rnd();
    newones[10] = rnd();
    newones[11] = rnd();
    calcSpline(lastones, 64, xpts, ypts, zpts);
    curpos=64;    
  }

}

