#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <conio.h>
#include <time.h>
#include "dbird.h"
#include <GL/glut.h>
#include "image.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#define AUDIO
extern "C"
{
#include "amp.h"

#include "audio.h"
#include "formats.h"
#include "getbits.h"
#include "huffman.h"
#include "layer3.h"
#include "transform.h"
}

#define max(a, b)  (((a) > (b)) ? (a) : (b))  

#define boolean int
#define false 0
#define true !false
#define null NULL

#define SCR_WIDTH 640
#define SCR_HEIGHT 480

#ifndef M_PI
#define M_PI 3.1415926535
#endif

#define FRAME 50
#define DIMP 20.0
#define DIMTP 16.0

#define NUMTREE 50
#define TREEINR 2.5
#define TREEOUTR 8.0

static float treepos[NUMTREE][3];

static float fogcolor[4]={1.0,1.0,1.0,1.0};
static float blu[3]={0.0,0.2,1.0};
static float blu2[3]={0.0,1.0,1.0};

static float q[4][3]={
  {-DIMP,0.0,-DIMP},
  {DIMP,0.0,-DIMP},
  {DIMP,0.0,DIMP},
  {-DIMP,0.0,DIMP}
};

static float qt[4][2]={
  {-DIMTP,-DIMTP},
  {DIMTP,-DIMTP},
  {DIMTP,DIMTP},
  {-DIMTP,DIMTP}
};

static unsigned int groundid;
static unsigned int treeid;
static unsigned int bfid;

static float obs[3]={2.0,1.0,0.0};
static float dir[3]={0.0,0.0,0.0};
static float v=-.01;
static float alpha=-90.0;
static float beta=90.0;

#define SCR_WIDTH 640
#define SCR_HEIGHT 480



// returns a rand in [0.0..1.0]
float rnd(void)
{
  return(((float)rand())/RAND_MAX);
}

class Vec
{
public:
  float x;
  float y;
  float z;

  Vec()
  {
    zero();
  }

  Vec(float _x, float _y, float _z)
  {
    x = _x; y = _y, z = _z;
  }

  ~Vec()
  {
  }

  inline void zero()
  {
    x = 0.; y = 0.; z = 0.;
  }

  inline void add(Vec v)
  {
    x += v.x;
    y += v.y;
    z += v.z;
  }

  inline void add(Vec *v)
  {
    x += v->x;
    y += v->y;
    z += v->z;
  }

  inline Vec diff(Vec v)
  {
    Vec r;
    r.x = x - v.x;
    r.y = y - v.y;
    r.z = z - v.z;
    return r;
  }

  inline void sdiv(double s)
  {
    x /= s;
    y /= s;
    z /= s;
  }

  inline void smul(double s)
  {
    x *= s;
    y *= s;
    z *= s;
  }

  inline void rshift(int i)
  {
    x = ((int)x) >> i;
    y = ((int)y) >> i;
    z = ((int)z) >> i;
  }

  inline void lshift(int i)
  {
    x = ((int)x) << i;
    y = ((int)y) << i;
    z = ((int)z) << i;
  }

  inline void limit(float f1)
  {
    float f2 = max(abs(x), abs(y));
    f2 = max(f2, abs(z));
    if (f2 <= f1) return;
    float f3 = f1 / f2;
    smul(f3);
  }

  inline void setmag(float f1)
  {
    float f2 = max(abs(x), abs(y));
    f2 = max(f2, abs(z));
    float f3 = f1 / f2;
    smul(f3);
  }

  inline float rdist(Vec vec)
  {
    float f1 = x - vec.x;
    float f2 = y - vec.y;
    float f3 = z - vec.z;
    float f4 = max(abs(f1), abs(f2));
    f4 = max(f4, abs(f3));
    return f4;
  }
};


class Boid
{
public: // you'll note how well I perform proper encapsulation.
  Vec pos;
  Vec vel;
  int wing_level;
  boolean upstroke;
  boolean perching;
  int perch_timer;

  Boid()
  {
    upstroke = false;
    perching = false;
    pos.x = (float)(rnd() * (SCR_WIDTH << 4) - (SCR_WIDTH << 3));
    pos.y = (float)(rnd() * (SCR_HEIGHT << 4) - (SCR_HEIGHT << 3));
    pos.z = (float)(rnd() * 2000.0 + 2000.0);
    vel.x = (float)(rnd() * 26.0 - 13.0);
    vel.y = (float)(rnd() * 26.0 - 13.0);
    vel.z = (float)(rnd() * 26.0 - 13.0);
    wing_level = (int)(rnd() * 200.0 - 100.0);
  }

  void move(int length, Boid *aboid, Vec posVec, Vec velVec)
  {
    if (perching)
    {
      if (perch_timer > 0)
      {
        perch_timer--;
        return;
      }
      perching = false;
    }
    Vec centre = perceive_centre(posVec, length);
    Vec dif = centre.diff(pos);
    dif.rshift(5);
    Vec avVel = av_vel(velVec, length);
    Vec velDiff = avVel.diff(vel);
    velDiff.rshift(5);
    Vec chillOut = chill_out(length, aboid);
    chillOut.rshift(3);
    vel.add(dif);
    vel.add(velDiff);
    vel.add(chillOut);
    vel.limit((float)100.0);
    pos.add(vel);
    if (upstroke)
    {
      if (wing_level >= 100)
        upstroke = false;
      else
        wing_level += 40;
    }
    else if (wing_level <= -100)
      upstroke = true;
    else
      wing_level -= 10;
    if (pos.x < -1500.0)
      vel.x += 5.0;
    if (pos.x > 1500.0)
      vel.x -= 5.0;
    if (pos.y < -1200.0)
      vel.y += 5.0;
    if (pos.y > 800.0)
      vel.y -= 5.0;
    if (pos.y > 1000.0)
    {
      pos.y = (float)1000.0;
      perching = true;
      perch_timer = (int)(rnd() * 20.0) + 30;
      wing_level = 60;
      vel.y = 0.0F;
    }
    if (pos.z < 1000.0)
      vel.z += 5.0;
    if (pos.z > 3000.0)
      vel.z -= 5.0;
  }

  Vec perceive_centre(Vec vec1, int i)
  {
    Vec vec2;
    vec2 = vec1.diff(pos);
    vec2.sdiv((float)(i - 1));
    return vec2;
  }

  Vec av_vel(Vec vec1, int i)
  {
    Vec vec2;
    vec2 = vec1.diff(vel);
    vec2.sdiv((float)(i - 1));
    return vec2;
  }

  Vec chill_out(int length, Boid *aboid)
  {
    Vec vec1;
    Vec vec2;
    for (int i = 0; i < length; i++)
    {
      if (&aboid[i] != this && pos.rdist(aboid[i].pos) <= 100.0)
      {
        vec1 = pos.diff(aboid[i].pos);
        vec2.add(vec1);
      }
    }
    return vec2;
  }

};

Boid *boids;
int numboids;

#include "cam.h"

static void drawshadow(const Vec &pos, const Vec &vel)
{ 
  float x = pos.x / 1000.0;
  float y = pos.y / 1000.0;
  float z = pos.z / 1000.0;

  z -= 3;
  y -= 1;
  y = -y;
    
  Vec head;
  head.x = vel.x;
  head.y = vel.y;
  head.z = vel.z;
  head.setmag(.1);

  glColor3f(0.0, 0.0, 0.0);

  glPushMatrix();
  glTranslatef(x, 0, z);

  glEnable(GL_AUTO_NORMAL);
  glEnable(GL_NORMALIZE);


  glBegin(GL_TRIANGLES);

  glVertex3f(0, 0.01, 0);
  glVertex3f(head.x, 0.01, head.z);
  glVertex3f(head.x/2+.1, 0.01, head.z);

  glVertex3f(0, 0.01, 0);
  glVertex3f(head.x, 0.01, head.z);
  glVertex3f(head.x/2 -.1, 0.01, head.z);

  glEnd();

  glPopMatrix();
}
 
static void drawbird(const Vec &pos, const Vec &vel, int winglevel)
{
  float x = pos.x / 1000.0;
  float y = pos.y / 1000.0;
  float z = pos.z / 1000.0;

  z -= 3;
  y -= 1;
  y = -y;

/*
  glPushMatrix();
  glLoadIdentity();
	glTranslatef(x, y, z);

  //glutSolidTeapot(.5);
  DLbirddrawer();
  //display();
	//glCallList(DL_bird1);
  glPopMatrix();
*/

  Vec head;
  head.x = vel.x;
  head.y = vel.y;
  head.z = vel.z;
  head.setmag(.2);
  
  glPushMatrix();
  // use winglevel to decide orientation of two wing triangles
  glTranslatef(x, y, z);

  //glPolygonMode(GL_FRONT, GL_LINE);
  
  glEnable(GL_AUTO_NORMAL);
  glEnable(GL_NORMALIZE);


  glBegin(GL_QUADS);

	glTexCoord2f(0.0,0.0);
  glVertex3f(0, 0, 0);

	glTexCoord2f(1.0,0.0);
  glVertex3f(head.x, head.y, head.z);

	glTexCoord2f(1.0,1.0);
  glVertex3f(head.x+.2, head.y/2 + ((float)winglevel)/500.0, head.z);

	glTexCoord2f(0.0,1.0);
  glVertex3f(0.2, ((float)winglevel)/500.0, 0);



	glTexCoord2f(0.0,0.0);
  glVertex3f(0, 0, 0);

	glTexCoord2f(1.0,0.0);
  glVertex3f(head.x, head.y, head.z);

	glTexCoord2f(1.0,1.0);
  glVertex3f(head.x -.2, head.y/2 + ((float)winglevel)/500.0, head.z);

	glTexCoord2f(0.0,1.0);
  glVertex3f(-.2, ((float)winglevel)/500.0, 0);

 glEnd();

 glPopMatrix();

 //glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
 /*
    glColor3f(1.0, 0.0, 0.0);

    glBegin(GL_TRIANGLES);
    glVertex3f(0, 0, 0);
    glVertex3f(head.x, head.y, head.z);
    glVertex3f(head.x/2 + .4, head.y/2 + ((float)winglevel)/500.0, head.z/2);
    glEnd();

    glBegin(GL_TRIANGLES);
    glVertex3f(0, 0, 0);
    glVertex3f(head.x, head.y, head.z);
    glVertex3f(head.x/2 - .4, head.y/2 + ((float)winglevel)/500.0, head.z/2);
    glEnd();*/
 /* 
    glBegin(GL_QUADS);
    glTexCoord2f(0.0,0.0);
    glVertex3f(x-.15,y+0.0,z);

    glTexCoord2f(1.0,0.0);
    glVertex3f(x+.15,y+0.0,z);

    glTexCoord2f(1.0,1.0);
    glVertex3f(x+.15,y+.30,z);

    glTexCoord2f(0.0,1.0);
    glVertex3f(x-.15,y+.30,z);


    glTexCoord2f(0.0,0.0);
    glVertex3f(x,y+0.0,z-.15);

    glTexCoord2f(1.0,0.0);
    glVertex3f(x,y+0.0,z+.15);

    glTexCoord2f(1.0,1.0);
    glVertex3f(x,y+.30,z+.15);

    glTexCoord2f(0.0,1.0);
    glVertex3f(x,y+.30,z-.15);
    glEnd();*/
}

static void drawtree(float x, float y, float z)
{
  glBegin(GL_QUADS);
  glTexCoord2f(0.0,0.0);
  glVertex3f(x-0.5,y+0.0,z);

  glTexCoord2f(1.0,0.0);
  glVertex3f(x+0.5,y+0.0,z);

  glTexCoord2f(1.0,1.0);
  glVertex3f(x+0.5,y+3.0,z);

  glTexCoord2f(0.0,1.0);
  glVertex3f(x-0.5,y+3.0,z);


  glTexCoord2f(0.0,0.0);
  glVertex3f(x,y+0.0,z-0.5);

  glTexCoord2f(1.0,0.0);
  glVertex3f(x,y+0.0,z+0.5);

  glTexCoord2f(1.0,1.0);
  glVertex3f(x,y+3.0,z+0.5);

  glTexCoord2f(0.0,1.0);
  glVertex3f(x,y+3.0,z-0.5);
  glEnd();

}

static void calcposobs(void)
{
  dir[0]=sin(alpha*M_PI/180.0);
  dir[2]=cos(alpha*M_PI/180.0)*sin(beta*M_PI/180.0);
  dir[1]=cos(beta*M_PI/180.0);

  //obs[0]+=v*dir[0];
  //obs[1]+=v*dir[1];
  //obs[2]+=v*dir[2];
}

static void printstring(void *font, char *string)
{
  int len,i;

  len=(int)strlen(string);
  for(i=0;i<len;i++)
    glutBitmapCharacter(font,string[i]);
}

static void reshape(int width, int height)
{
  glViewport(0,0,(GLint)width,(GLint)height);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(70.0,width/(float)height,0.1,30.0);

  glMatrixMode(GL_MODELVIEW);
}

static void key(unsigned char key, int x, int y)
{
  // if there's a key we're done
  exit(0);
}

static void movebirds()
{
  int i;
  Vec posVec, velVec;

  posVec.zero();
  velVec.zero();
  for (i = 0; i < numboids; i++)
  {
    posVec.add(boids[i].pos);
    velVec.add(boids[i].vel);
  }
  for (i = 0; i < numboids; i++)
  {
    boids[i].move(numboids, boids, posVec, velVec);
  }

}


static void drawbirds(void)
{
  static int count=0;
  static char frbuf[80];
  int j;
  float fr;


  movebirds();

  glEnable(GL_DEPTH_TEST);

  //if(fog)
  glEnable(GL_FOG);
  // else
  //   glDisable(GL_FOG);

  glDepthMask(GL_TRUE);
  glClearColor(1.0,1.0,1.0,1.0);
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

  glPushMatrix();
  //calcposobs();
  /*dir[0] = dir[1] = dir[2] = 0.0;
  for (j=0;j<numboids;j++)
  {
    dir[0] += boids[j].pos.x;
    dir[1] += boids[j].pos.y;
    dir[2] += boids[j].pos.z;
  }
  dir[0] /= (float)numboids;
  dir[1] /= (float)numboids;
  dir[2] /= (float)numboids;*/
  gluLookAt(obs[0],obs[1],obs[2],
      //dir[0],dir[1],dir[2],
      boids[0].pos.x / 1000.0, -((boids[0].pos.y / 1000.0) - 1), boids[0].pos.z / 1000.0 - 3,
      0.0,1.0,0.0);

  glColor4f(1.0,1.0,1.0,1.0);

  glEnable(GL_TEXTURE_2D);

  glBindTexture(GL_TEXTURE_2D,groundid);
  glBegin(GL_QUADS);
  glTexCoord2fv(qt[0]);
  glVertex3fv(q[0]);
  glTexCoord2fv(qt[1]);
  glVertex3fv(q[1]);
  glTexCoord2fv(qt[2]);
  glVertex3fv(q[2]);
  glTexCoord2fv(qt[3]);
  glVertex3fv(q[3]);
  glEnd();

  glEnable(GL_ALPHA_TEST);
  glAlphaFunc(GL_GEQUAL,0.9);

  glBindTexture(GL_TEXTURE_2D,treeid);
  for(j=0;j<NUMTREE;j++)
    drawtree(treepos[j][0],treepos[j][1],treepos[j][2]);

  glBindTexture(GL_TEXTURE_2D,bfid);
  for(j=0;j<numboids;j++)
    drawbird(boids[j].pos, boids[j].vel, boids[j].wing_level);




  glDisable(GL_TEXTURE_2D);
  
  for(j=0;j<numboids;j++)
    drawshadow(boids[j].pos, boids[j].vel);

  glDepthMask(GL_FALSE);
  glDisable(GL_ALPHA_TEST);

 glDisable(GL_TEXTURE_2D);
  glDisable(GL_ALPHA_TEST);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_FOG);

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(-0.5,639.5,-0.5,479.5,-1.0,1.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  //drawspline();

  glColor3f(1.0,0.0,0.0);
  glRasterPos2i(10,10);
  printstring(GLUT_BITMAP_HELVETICA_18,frbuf);
  glRasterPos2i(475,470);
  printstring(GLUT_BITMAP_HELVETICA_10,"flutterbys by scottg@iname.com");

  reshape(SCR_WIDTH, SCR_HEIGHT);
  glPopMatrix();

  glutSwapBuffers();

  moveCamera();

  count++;
}

static void inittextures(void)
{
  IMAGE *img;
  GLenum gluerr;
  GLubyte tex[128][128][4];
  int x,y;

  glGenTextures(1,&groundid);
  glBindTexture(GL_TEXTURE_2D,groundid);

  if(!(img=ImageLoad("s128.rgb"))) {
    fprintf(stderr,"Error reading a texture.\n");
    exit(-1);
  }

  glPixelStorei(GL_UNPACK_ALIGNMENT,4);
  if((gluerr=(GLenum)gluBuild2DMipmaps(GL_TEXTURE_2D, 3, img->sizeX, img->sizeY, GL_RGB,
      GL_UNSIGNED_BYTE, (GLvoid *)(img->data)))) {
    fprintf(stderr,"GLULib%s\n",gluErrorString(gluerr));
    exit(-1);
  }

  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);

  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST_MIPMAP_LINEAR);
  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

  glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_DECAL);

  glGenTextures(1,&treeid);
  glBindTexture(GL_TEXTURE_2D,treeid);

  if(!(img=RawLoad("tree.raw")))
  {
    fprintf(stderr,"Error reading a texture.\n");
    exit(-1);
  }

  for(y=0;y<128;y++)
    for(x=0;x<128;x++)
    {
      tex[x][y][0]=img->data[(y+x*128)*3];
      tex[x][y][1]=img->data[(y+x*128)*3+1];
      tex[x][y][2]=img->data[(y+x*128)*3+2];
      if((tex[x][y][0]==tex[x][y][1]) && (tex[x][y][1]==tex[x][y][2]) && (tex[x][y][2]==255))
        tex[x][y][3]=0;
      else
        tex[x][y][3]=255;
    }

  if((gluerr=(GLenum)gluBuild2DMipmaps(GL_TEXTURE_2D, 4, 128, 128, GL_RGBA,
      GL_UNSIGNED_BYTE, (GLvoid *)(tex)))) {
    fprintf(stderr,"GLULib%s\n",gluErrorString(gluerr));
    exit(-1);
  }

  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);

  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST_MIPMAP_LINEAR);
  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

  glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);

  glGenTextures(1,&bfid);
  glBindTexture(GL_TEXTURE_2D,bfid);

  if(!(img=RawLoad("bfly.raw")))
  {
    fprintf(stderr,"Error reading a texture.\n");
    exit(-1);
  }

  for(y=0;y<128;y++)
    for(x=0;x<128;x++)
    {
      tex[x][y][0]=img->data[(y+x*128)*3];
      tex[x][y][1]=img->data[(y+x*128)*3+1];
      tex[x][y][2]=img->data[(y+x*128)*3+2];
      if((tex[x][y][0]==tex[x][y][1]) && (tex[x][y][1]==tex[x][y][2]) && (tex[x][y][2]==255))
        tex[x][y][3]=0;
      else
        tex[x][y][3]=255;
    }

  if((gluerr=(GLenum)gluBuild2DMipmaps(GL_TEXTURE_2D, 4, 128, 128, GL_RGBA,
      GL_UNSIGNED_BYTE, (GLvoid *)(tex)))) {
    fprintf(stderr,"GLULib%s\n",gluErrorString(gluerr));
    exit(-1);
  }

  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);

  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST_MIPMAP_LINEAR);
  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

  glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
}

static void inittree(void)
{
  int i;
  float dist;

  for(i=0;i<NUMTREE;i++)
    do {
      treepos[i][0]=rnd()*TREEOUTR*2.0-TREEOUTR;
      treepos[i][1]=0.0;
      treepos[i][2]=rnd()*TREEOUTR*2.0-TREEOUTR;
      dist=sqrt(treepos[i][0]*treepos[i][0]+treepos[i][2]*treepos[i][2]);
    } while((dist<TREEINR) || (dist>TREEOUTR));
}


  int __inline
processHeader(struct AUDIO_HEADER *header, int cnt)
{
  int g;

  /* getbits funcs expect first four bytes after BUFFER_SIZE have same contents
   * as the first four bytes of the buffer. fillbfr() normally takes care of
   * this when it hits the end of the buffer, but not this first time
   */
  if (cnt==1) memcpy(&buffer[BUFFER_SIZE],buffer,4);	/* XXX WHAT!!! */

  if ((g=gethdr(header))!=0) {
    if (g != GETHDR_ERR) {
      /*warn(" this is a file in MPEG 2.5 format, which is not defined\n");
        warn(" by ISO/MPEG. It is \"a special Fraunhofer format\".\n");
        warn(" amp does not support this format. sorry.\n");*/
    } else {
      /* here we should check whether it was an EOF or a sync err. later.
       */	
      if (A_FORMAT_WAVE) wav_end(header);

      /* this is the message we'll print once we check for sync errs
       * warn(" amp encountered a synchronization error\n");
       * warn(" sorry.\n");
       */
    }
    return(1);
  }

  /* crc is read just to get out of the way.
   */
  if (header->protection_bit==0) getcrc();

  return(0);
}


  int
decodeMPEG(char *inFileStr, char *outFileStr)
{
  struct AUDIO_HEADER header;
  int cnt,err=0;

  if (strcmp(inFileStr,"-")==0)
    in_file=stdin;
  else {
    if ((in_file=fopen(inFileStr,"rb"))==NULL) {
      //warn("Could not open file: %s\n",inFileStr);
      return(1);
    }
  }

  if (outFileStr) {
    if (strcmp(outFileStr,"-")==0)
      out_file=stdout;
    else
      if ((out_file=fopen(outFileStr,"wb"))==NULL) {
        //warn("Could not write to file: %s\n",outFileStr);
        return(1);
      }
    //msg("Converting: %s\n",inFileStr);
  }

  //if (A_AUDIO_PLAY)
  //	msg("Playing: %s\n",inFileStr);

  append=data=nch=0;																	/* initialize globals */

  if (A_FORMAT_WAVE) wav_begin();

  for (cnt=0;;cnt++) {																				/* _the_ loop */
    if (processHeader(&header,cnt))
      break;

    if (!cnt && A_AUDIO_PLAY) { /* setup the audio when we have the frame info */
      /* audioOpen(frequency, stereo, volume) */
      if (AUDIO_BUFFER_SIZE==0)
        audioOpen(t_sampling_frequency[header.ID][header.sampling_frequency],
            (header.mode!=3),
            A_SET_VOLUME);
      else
        audioBufferOpen(t_sampling_frequency[header.ID][header.sampling_frequency],
            (header.mode!=3),
            A_SET_VOLUME);
    }

    if (layer3_frame(&header,cnt)) {
      //warn(" error. blip.\n");
      err=1;
      break;
    } 
  }
  fclose(in_file);
  if (A_AUDIO_PLAY)
    if (AUDIO_BUFFER_SIZE!=0)
      audioBufferClose();
    else
      audioClose();
  else
    fclose(out_file);

  //msg("\n");
  return(err);
}


void main(int ac, char **av)
{
  // so there's no console opened
  //  fclose(stdout);
  //  fclose(stderr);

  // premultiply dewindowing tables.  Should go away
  //premultiply();

  // init imdct tables
  //imdct_init();

  // MUST BE THREADED OFF!
  //decodeMPEG("birds.mp3",0);

  glutInitDisplayMode(GLUT_RGB|GLUT_DEPTH|GLUT_DOUBLE);
  glutInitWindowSize(SCR_WIDTH, SCR_HEIGHT); 

  if (glutCreateWindow("Boids") == GL_FALSE)
  {
    printf("Error opening a window.\n");
    exit(-1);
  }

  //create_display_list();
  numboids = 40;
  boids = new Boid[numboids];


  reshape(SCR_WIDTH, SCR_HEIGHT);
  inittextures();

  //  initspline();

  glShadeModel(GL_FLAT);
  glEnable(GL_DEPTH_TEST);


  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

  glEnable(GL_FOG);
  glFogi(GL_FOG_MODE,GL_EXP);
  glFogfv(GL_FOG_COLOR,fogcolor);
  glFogf(GL_FOG_DENSITY,0.1);
  glHint(GL_FOG_HINT,GL_NICEST);

  inittree();

  glutKeyboardFunc(key);
  glutDisplayFunc(drawbirds);
  glutIdleFunc(drawbirds);
  glutReshapeFunc(reshape);
  glutMainLoop();

}
