#include <math.h>
#include <malloc.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#include <conio.h>

#include <pr.h>
#include <prsound.h>

/* Egerter Software 3Dfx ScreenSaver
   Copyright 1997 Egerter Software

   Written by Chris Egerter, July 1997

   Requirements:
     Pentium microprocessor
     3Dfx compatible card
     DirectX for DirectInput and DirectSound (Windows version only)
   

   To compile this, you need:

     DOS version:
       Power Render 2.31, WGT 5.1, SEAL 1.03, Watcom C/C++

     Win32 version:
       Power Render 2.31, SEAL 1.03, Watcom C/C++ or MSVC

   Free versions of Power Render, WGT, and SEAL are available from
   http://www.egerter.com, but you'll have to buy a compiler :)


   Other notes:
     If you experience stuttering sound under Windows, make sure your sound
     driver is DirectSound compatible and you have the latest drivers.
     If that doesn't work, turn off the sound! :)
     
*/



#if defined (MSGLIDE) || defined (WTGLIDE)
 #include <glide.h>
 #include <pr3dfx.h>
 #include "winutil.h"
#else
 #ifdef __3DFX__
  #include <pr3dfx.h>
  #include <glide.h>
 #endif
#endif

#include <prgui.h>

/* Switches */
PR_DWORD nomusic = 0;
PR_DWORD nowav = 0;
PR_DWORD nosound = 0;


/* ---------------------------------------------------------------------
   Devices and Viewports
   --------------------------------------------------------------------- */
PR_DWORD     device;
PR_DWORD     current_mode;          /* Current video mode */
PR_DWORD     vwidth;                /* Viewport size */
PR_DWORD     vheight;
PR_VIEWPORT  viewport;              /* Our viewport structure */


/* ---------------------------------------------------------------------
   Lights and Cameras
   --------------------------------------------------------------------- */
PR_CAMERA *  camera;                /* One camera */
PR_LIGHTLIST JetLights;             /* We only use 1 light that follows
                                       the camera */
PR_LIGHTLIST HeadLights;             
PR_LIGHTLIST BumpLights;             
                                     

/* ---------------------------------------------------------------------
   Sound Effects and Music
   --------------------------------------------------------------------- */
PR_DWORD WAVrocket;
PR_DWORD WAVrocket2;
PR_DWORD WAVambient;
PR_3DSOUND *rocket;
PR_3DSOUND *rocket2;
PR_3DSOUND *ambient;


/* ---------------------------------------------------------------------
   Objects and Entities
   --------------------------------------------------------------------- */
/* Scene 1 */
PR_OBJECT *jet_object;
PR_ENTITY *jet_arena;
PR_ENTITY *dummy_ent;           /* Dummy entity used for 3D sound */
PR_ENTITY *dummy_ent2;          /* Dummy entity used for 3D sound */
PR_ENTITY *dummy_ent3;          /* Dummy entity used for 3D sound */

/* Scene 2 */
PR_OBJECT *bump_object;         /* Room definition */
PR_ENTITY *bump_room;
PR_OBJECT *campathobj;          
PR_ENTITY *campath;             /* Camera path entity */

/* Scene 3 */
PR_OBJECT *logo_object;         /* Room definition */
PR_ENTITY *logo_room;


/* ---------------------------------------------------------------------
   Bump Map Stuff 
   --------------------------------------------------------------------- */
void UpdateBump (void);
void InitializeBump (void);
void CalcLightSource (unsigned char *light);
void BumpLight (unsigned char *dest, PR_DWORD lx, PR_DWORD ly,
                unsigned char *light, PR_DWORD half);

extern GrMipMapId_t *PR_TextureHandles;
PR_DWORD bumpmap;
#define XLIGHT 256
#define YLIGHT 256
#define XMLIGHT 255
#define YMLIGHT 255
#define XHLIGHT 127
#define YHLIGHT 127
PR_DWORD bumphalf = 1;
block bump_dest;
unsigned char *bumpx;
unsigned char *bumpy;
unsigned char *lightsource;
color bumppal[256];
PR_REAL bump_angle = 0, bump_angle2 = 0;


/* ---------------------------------------------------------------------
   Frame Rate Control  
   --------------------------------------------------------------------- */
PR_DWORD ticks;                 /* Total number of ticks passed */
PR_DWORD updates;               /* Total number of updates */
PR_DWORD framerate;             /* Resulting frame rate (updates/ticks/tickrate) */
PR_DWORD show_frame_rate = 0;

PR_DWORD sky_color;
PR_DWORD quit_saver = 0;
PR_DWORD frame = 0;
PR_DWORD pathframe = 0;


/* ---------------------------------------------------------------------
   Only 3Dfx is supported
   --------------------------------------------------------------------- */
void InitializeDevices (void)
{
  device = PR_Detect3Dfx ();
  PR_Initialize3Dfx ();
  atexit (PR_Shutdown3Dfx);


  /* And allocate room for data */
  PR_AllocMaterials (128);
  PR_AllocTextures (64);
  PR_AllocShadeTables (16);
}


/* ---------------------------------------------------------------------
   Load the song and wav files
   --------------------------------------------------------------------- */
void InitializeAudio (void)
{
  /* initialize audio library */
  PRSND_Initialize ();
  PRSND_AllocSounds (3);

  /* open audio device */
  PRSND_OpenAudio (AUDIO_DEVICE_MAPPER,
                   AUDIO_FORMAT_16BITS | AUDIO_FORMAT_STEREO,
                   22050);

  if (!nomusic)
    PRSND_LoadSong ("saver.s3m");

  PRSND_InitializeVoices (3);

  if (!nomusic)
    {
     PRSND_PlaySong ();
     PRSND_SetSongVolume (52);
    }

  /* load module and waveform file */
  if (!nowav)
    {
     WAVrocket = PRSND_LoadSound ("ship.wav");
     WAVrocket2 = PRSND_LoadSound ("ship2.wav");
     WAVambient = PRSND_LoadSound ("wind.wav");

     PRSND_SetLoopStart (WAVrocket, 0);
     PRSND_SetLoopEnd (WAVrocket, PRSND_GetLength (WAVrocket));
     PRSND_SetLoopMode (WAVrocket, 1);

     PRSND_SetLoopStart (WAVrocket2, 0);
     PRSND_SetLoopEnd (WAVrocket2, PRSND_GetLength (WAVrocket2));
     PRSND_SetLoopMode (WAVrocket2, 1);

     PRSND_SetLoopStart (WAVambient, 0);
     PRSND_SetLoopEnd (WAVambient, PRSND_GetLength (WAVambient));
     PRSND_SetLoopMode (WAVambient, 1);

     rocket = PRSND_Alloc3DSound ();
     rocket2 = PRSND_Alloc3DSound ();
     ambient = PRSND_Alloc3DSound ();
    }
}


/* ---------------------------------------------------------------------
   Set up the 3D sounds
   --------------------------------------------------------------------- */
void InitializeWAV (void)
{
  /* play the waveform through a voice */
  if (!nowav)
    {
     PRSND_Play3DSound (rocket, WAVrocket);
     PRSND_Set3DSoundVolume (rocket, 64);
     PRSND_Set3DSoundVolumeMode (rocket, SOUND_3D_VOLUME);
     PRSND_Set3DSoundVolumeFactor (rocket, 5000);
     PRSND_Set3DSoundPanning (rocket, 128);
     PRSND_Set3DSoundPanningMode (rocket, SOUND_3D_PANNING);
     PRSND_Set3DSoundPanningFactor (rocket, 1000);
     PRSND_Set3DSoundShiftMode (rocket, SOUND_DOPPLER_ON);
     PRSND_Set3DSoundShiftFactor (rocket, 0.005);
     PRSND_Set3DSoundShiftSlide (rocket, 50);
     PRSND_Set3DSoundCoordinate (rocket, 0, 0, 0, dummy_ent);
     PRSND_Update3DSound (rocket);

     /* play the waveform through a voice */
     PRSND_Play3DSound (rocket2, WAVrocket2);
     PRSND_Set3DSoundVolume (rocket2, 64);
     PRSND_Set3DSoundVolumeMode (rocket2, SOUND_3D_VOLUME);
     PRSND_Set3DSoundVolumeFactor (rocket2, 5000);
     PRSND_Set3DSoundPanning (rocket2, 128);
     PRSND_Set3DSoundPanningMode (rocket2, SOUND_3D_PANNING);
     PRSND_Set3DSoundPanningFactor (rocket2, 1000);
     PRSND_Set3DSoundShiftMode (rocket2, SOUND_DOPPLER_ON);
     PRSND_Set3DSoundShiftFactor (rocket2, 0.005);
     PRSND_Set3DSoundShiftSlide (rocket2, 50);
     PRSND_Set3DSoundCoordinate (rocket2, 0, 0, 0, dummy_ent2);
     PRSND_Update3DSound (rocket2);

     /* play the waveform through a voice */
     PRSND_Play3DSound (ambient, WAVambient);
     PRSND_Set3DSoundVolume (ambient, 64);
     PRSND_Set3DSoundVolumeMode (ambient, SOUND_3D_VOLUME);
     PRSND_Set3DSoundVolumeFactor (ambient, 5000);
     PRSND_Set3DSoundPanning (ambient, 128);
     PRSND_Set3DSoundPanningMode (ambient, SOUND_3D_PANNING);
     PRSND_Set3DSoundPanningFactor (ambient, 1000);
     PRSND_Set3DSoundShiftMode (ambient, SOUND_DOPPLER_ON);
     PRSND_Set3DSoundShiftFactor (ambient, 0.005);
     PRSND_Set3DSoundShiftSlide (ambient, 50);
     PRSND_Set3DSoundCoordinate (ambient, 0, 0, 0, dummy_ent3);
     PRSND_Update3DSound (ambient);
 
     PRSND_UpdateVoices ();
    }
}

/* ---------------------------------------------------------------------
   Turn off and free the 3D sounds
   --------------------------------------------------------------------- */
void FreeWAV (void)
{
  if (!nowav)
    {
     /* Ask for a stop request */
     PRSND_3DSoundList[ambient->soundnum]->active = SOUND_STOP_PLAYING;
     PRSND_3DSoundList[rocket->soundnum]->active  = SOUND_STOP_PLAYING;
     PRSND_3DSoundList[rocket2->soundnum]->active = SOUND_STOP_PLAYING;

     /* Process the requests */
     PRSND_UpdateVoices ();
    }
}


/* ---------------------------------------------------------------------
   Initialize the video mode to 640x480
   --------------------------------------------------------------------- */
void InitializeVideo (void)
{
  vwidth = 640;
  vheight = 480;
  PR_SetMode (vwidth, vheight, 60);

  PR_OpenViewport (&viewport, 0, 0, vwidth-1, vheight-1, VIEW_PLAIN);

  PR_SetViewport (&viewport);
  PRGFX_Clip (active_viewport.topx,
              active_viewport.topy,
              active_viewport.bottomx,
              active_viewport.bottomy);
}


/* ---------------------------------------------------------------------
   Make one light which will follow the camera 
   --------------------------------------------------------------------- */
void InitializeJetLights (void)
{
  /* Initialize the lights */
  PR_AllocLights (&JetLights, 1);       /* Jet scene light */

  PR_SetLightOn (&JetLights, 0);
  PR_SetLightType (&JetLights, 0, DIRECTIONAL_LIGHT);
  PR_SetLightStrength (&JetLights, 0, 1.0);
  PR_SetLightColor (&JetLights, 0, 1.0, 1.0, 1.0);
  /* Position doesn't matter because we set it to the camera location every frame */

  JetLights.NumLights = 1;     /* This sets how many lights are actually used */
}


/* ---------------------------------------------------------------------
   Initialize Bump lights (3 colored ones)
   --------------------------------------------------------------------- */
void InitializeBumpLights (void)
{
  PR_AllocLights (&BumpLights, 3);
  PR_SetLightPosition (&BumpLights, 0, 0, 0, 400);
  PR_SetLightOn (&BumpLights, 0);
  PR_SetLightType (&BumpLights, 0, DIRECTIONAL_LIGHT);
  PR_SetLightColor (&BumpLights, 0, 1.0, 1.0, 1.0);
  PR_SetLightStrength (&BumpLights, 0, 1.0);

  PR_SetLightPosition (&BumpLights, 1, 0, 500, 400);
  PR_SetLightOn (&BumpLights, 1);
  PR_SetLightType (&BumpLights, 1, DIRECTIONAL_LIGHT);
  PR_SetLightColor (&BumpLights, 1, 0.0, 0.0, 1.0);
  PR_SetLightStrength (&BumpLights, 1, 1.0);

  PR_SetLightPosition (&BumpLights, 2, -500, 200, 400);
  PR_SetLightOn (&BumpLights, 2);
  PR_SetLightType (&BumpLights, 2, DIRECTIONAL_LIGHT);
  PR_SetLightColor (&BumpLights, 2, 0.0, 1.0, 0.0);
  PR_SetLightStrength (&BumpLights, 2, 1.0);
  BumpLights.NumLights = 3;     /* This sets how many lights are actually used */
}

/* ---------------------------------------------------------------------
   Loads the jet scene and makes dummy entities for 3D sounds
   --------------------------------------------------------------------- */
void LoadJetScene (void)
{
PR_ENTITY *dum;

  /* Preload some textures with different formats */
  PR_SetTextureFormat (TEXTURE_RGB_332);
  PR_LoadTexture ("green.pcx");
  PR_LoadTexture ("purpmet.pcx");
  PR_LoadTexture ("metal.pcx");
  PR_SetTextureFormat (TEXTURE_XRAY);
  PR_LoadTexture ("tower.pcx");
  PR_SetTextureFormat (TEXTURE_RGB_565);

  jet_object = PR_LoadPRO ("jet.pro", LOAD_NORMAL);
  jet_object->segment_list[48].num_faces = 0;  /* prevent rendering the dummy object */
  jet_arena = PR_CreateEntity (jet_object, "Jet Arena");
  PR_ScaleEntityAbs (jet_arena, 1, 1, 1);

  /* The following are dummy entities that have 3D sounds attached to
     them.  This is necessary because the 3D sounds must be
     associated with an entity instead of a segment. */

  dum = jet_arena;
  dummy_ent = PR_CreateEntity (jet_object, "dummy");
  PR_PositionEntity (dummy_ent, dum->segment_orientation[45].location.x,
                                dum->segment_orientation[45].location.y,
                                dum->segment_orientation[45].location.z);

  dummy_ent2 = PR_CreateEntity (jet_object, "dummy2");
  PR_PositionEntity (dummy_ent2, dum->segment_orientation[47].location.x,
                                 dum->segment_orientation[47].location.y,
                                 dum->segment_orientation[47].location.z);

  dummy_ent3 = PR_CreateEntity (jet_object, "dummy3");
  PR_PositionEntity (dummy_ent3, dum->segment_orientation[8].location.x,
                                 dum->segment_orientation[8].location.y,
                                 dum->segment_orientation[8].location.z);
  InitializeJetLights ();
}


/* ---------------------------------------------------------------------
   Loads the bump mapped scene 
   --------------------------------------------------------------------- */
void LoadBumpScene (void)
{
  InitializeBump ();

  bump_object = PR_LoadPRO ("head.pro", LOAD_NORMAL);
  bump_room = PR_CreateEntity (bump_object, "Bump Room");
  PR_ScaleEntityAbs (bump_room, 1, 1, 1);

  campathobj = PR_LoadPRO ("headpath.pro", LOAD_NORMAL);
  campath = PR_CreateEntity (campathobj, "Path");
  PR_ScaleEntityAbs (campath, 1, 1, 1);

  InitializeBumpLights ();
}


/* ---------------------------------------------------------------------
   Loads the 3Dfx logo scene 
   --------------------------------------------------------------------- */
void LoadLogoScene (void)
{
  logo_object = PR_LoadPRO ("3dlogo.pro", LOAD_NORMAL);
  logo_room = PR_CreateEntity (logo_object, "Logo Room");
  PR_ScaleEntityAbs (logo_room, 1, 1, 1);
  PR_SetTextureFormat (TEXTURE_NORMAL);
}



/* ---------------------------------------------------------------------
   Timer Interrupt 
   --------------------------------------------------------------------- */
void timerproc (void)
{
  ticks++;
  AUpdateAudio ();
}                


/* ---------------------------------------------------------------------
   Get user input
   --------------------------------------------------------------------- */
void UserInput (void)
{
PR_DWORD dummy = 0;

  /* Keyboard input */

  if (kbdon[KEY_F1])            /* Pause */
    {
     APauseModule ();           /* SEAL commands */

     while (kbdon[KEY_F1])     
       { 
        dummy++;
        #ifdef WIN32
          UpdateMessages ();
        #endif
       }           /* Wait for user to release key */


     while (!kbdon[KEY_F1])     
       { 
        dummy++;
        #ifdef WIN32
          UpdateMessages ();
        #endif
       }           /* Wait for user to hit key */

     AResumeModule ();
    }

}








/* ---------------------------------------------------------------------
   Calculates the light source map
   --------------------------------------------------------------------- */
void CalcLightSource (unsigned char *light)
{
PR_DWORD i,j;
PR_REAL  dist, tx, ty;

  for (i = 0; i < XLIGHT; i++)
    for (j = 0; j < YLIGHT; j++)
    {
      tx = i - XHLIGHT;
      ty = j - YHLIGHT;
      dist = sqrt(tx*tx + ty*ty);
      if (dist < 160)
        light[i*XLIGHT+j] = (63 - (dist*0.4)) + 1;
      else
        light[i*XLIGHT+j] = 1;
      if (light[i*XLIGHT+j] < 1)
        light[i*XLIGHT+j] = 1;
    }
}



/* ---------------------------------------------------------------------
   Precalculates the x and y offsets
   --------------------------------------------------------------------- */
void PrecalcBump (unsigned char *bump)
{
PR_DWORD x, y;
PR_DWORD middle;
PR_DWORD top;
PR_DWORD bottom;
PR_DWORD left;
PR_DWORD right;
PR_DWORD dx, dy;

  memset (bumpx, 0, 256*256);
  memset (bumpy, 0, 256*256);

  for (x = 1; x < 255; x++)
   for (y = 1; y < 255; y++)
     {

      middle = bump[y*256 + x];
      left   = ((int)bump[y*256 + x - 1] - middle);
      right  = ((int)bump[y*256 + x + 1] - middle);
      top    = ((int)bump[y*256 + x - 256] - middle);
      bottom = ((int)bump[y*256 + x + 256] - middle);
      dx  = (left - right) >> 1;
      dy  = (top - bottom) >> 1;

      bumpx[y*256 + x] = dx;
      bumpy[y*256 + x] = dy;
     }
}



/* ---------------------------------------------------------------------
   Draw the bump bitmap
   --------------------------------------------------------------------- */
void BumpLight (unsigned char *dest, PR_DWORD lx, PR_DWORD ly,
                unsigned char *light, PR_DWORD half)
{
unsigned char *blutx, *bluty;

int lx1, ly1, lx2, ly2;
int dx, dy;
int sofs;
int slx, sly, x, y;
int tlx, tly;

  lx1 = lx - 127;
  ly1 = ly - 127;
  lx2 = lx + 127;
  ly2 = ly + 127;
  slx = lx1;
  sly = ly1;
  if (lx1 < 1)   { slx = lx1; lx1 = 1; }
  if (lx1 > 254) return;
  if (ly1 < 1)   { sly = ly1; ly1 = 1; }
  if (ly1 > 254) return;

  lx1 = 0;
  lx2 = 256;

  if (half)
    {
     ly1 = 128;
     ly2 = 256;
    }
  else
    {
     ly1 = 0;
     ly2 = 128;
    }


  if (lx2 > 254) lx2 = 254;
  if (lx2 < 1)   return;
  if (ly2 > 254) ly2 = 254;
  if (ly2 < 1)   return;

  y = ly1;
  sofs = ly1 * 256;

  while (y < ly2)
  {
    x = lx1;
    sofs += lx1;
    tlx = x - slx;
    tly = y - sly;

    blutx = &bumpx[sofs];
    bluty = &bumpy[sofs];

    while (x++ < lx2)
    {
      dx = *(blutx++);
      dy = *(bluty++);

      *(dest + sofs++) =
         light[(((tly+dy) & YMLIGHT) << 8)+(((tlx++)+dx) & XMLIGHT)];
    }
    tly++;
    sofs += (256-lx2);
    y++;
  }
}


/* ---------------------------------------------------------------------
   Initialize the Bump data
   --------------------------------------------------------------------- */
void InitializeBump (void)
{
  lightsource = malloc (XLIGHT*YLIGHT);
  bumpx = malloc (256 * 256);
  bumpy = malloc (256 * 256);

  PR_Settings.LoadPalette = 1;
  PR_SetTextureFormat (TEXTURE_P_8);
  bumpmap = PR_LoadTexture ("bumpmap.pcx");
  PR_SetTextureFormat (TEXTURE_NORMAL);

  CalcLightSource (lightsource);
  PrecalcBump (PR_WorldTextures[bumpmap].image + 4);
  bump_angle = 0;
  bump_angle2 = 0;
}




/* ---------------------------------------------------------------------
   Moves the lightsource and draws the bump map
   The image is drawn in 2 parts, so the texture is updated every other
   frame.
   --------------------------------------------------------------------- */
void UpdateBump (void)
{
PR_REAL lightx, lightz;
PR_DWORD x, y;
GrMipMapId_t temptex;

  lightx = (sin(bump_angle + bump_angle2)*100);
  lightz = (cos(2*bump_angle + sin(bump_angle2))*80);
  x = 127 + lightx;
  y = 127 + lightz;

  bumphalf = !bumphalf;
  if (bumphalf)  /* Top half */
    {
     BumpLight (PR_WorldTextures[bumpmap].image + 4, x, y, lightsource, bumphalf);
    }
  else
    {
     BumpLight (PR_WorldTextures[bumpmap].image + 4, x, y, lightsource, bumphalf);

     memcpy (&temptex,  &PR_TextureHandles[bumpmap], sizeof (GrMipMapId_t));
     guTexDownloadMipMap (temptex,
                         (void *)(PR_WorldTextures[bumpmap].image + 4),
                          NULL);

     bump_angle += 3.141592 / 256.0 * 3;
     bump_angle2 += 0.01;
    }
}



/* ---------------------------------------------------------------------
   --------------------------------------------------------------------- */
void InitializePowerRender (void)
{
  PRGUI_SetUserPath ();
  PRGUI_GoStartPath ();

  PR_Initialize (5);  /* Don't need to worry about number of polys with 3Dfx */

  InitializeDevices ();

  PR_AllocLights (&scenelights, 6);     /* Master scene light list */

  InitializeVideo ();

  PR_SetTextureFormat (TEXTURE_XRAY);
  PR_Settings.HardwareMipmaps = MIPMAP_ALL_LEVELS;
  PRGFX_SetTextBackground (PRGFX_MakeColor (0,0,0));
  PRGFX_SetTextTransparent (TEXTFGBG);
  sky_color = PRGFX_MakeColor (0, 0, 0);

  gui_font = NULL;
  PRGFX_SetTextForeground (PRGFX_MakeColor (0,63,63));
  PRGUI_printf (0, 0, "Egerter Software 3Dfx ScreenSaver");
  PRGUI_printf (0, 10, "Version 1.0");
  PRGFX_SetTextForeground (PRGFX_MakeColor (63,63,63));
  PRGUI_printf (0, 30, "Initializing...");


  /* Initialize the camera */
  camera = PR_AllocCamera ();
  PR_InitializeCamera (camera);
  PR_SetCameraMode (camera, CAMFLAG_AIM_TARGET);

  /* Initialize the input devices */
  installkbd ();
  winittimer ();
  wstarttimer (timerproc, TICKS(60));
}


void DisplayFrameRate (void)
{
  /* Calculate the frame rate */
  if (ticks > 60)
    {
     framerate = updates;
     ticks = 0;
     updates = 0;
    }
  else
    updates++; 

  if (show_frame_rate)
    PRGUI_printf (10, 10, "%i", framerate);
}



void JetLoop (void)
{
PR_DWORD animation_finished = 0;

  frame = 0;
  camera->fov = (1.0 / 3.0) * 3.1415;

  while ((!kbdon[KEY_ESC]) && (!animation_finished))
    {
     #ifdef WIN32
      UpdateMessages ();
     #endif
	  
     UserInput ();
     PR_NewFrame ();                         /* Begin a new frame */

     PRGFX_SetColor (sky_color);
     PR_OpenScreen (PR_BACKBUFFER);

     PRGFX_ClearScreen ();

     PR_PositionCameraSource (camera, jet_arena->segment_orientation[48].location.x,
                                      jet_arena->segment_orientation[48].location.y,
                                      jet_arena->segment_orientation[48].location.z);
     PR_PositionCameraTarget (camera, jet_arena->segment_orientation[45].location.x,
                                      jet_arena->segment_orientation[45].location.y,
                                      jet_arena->segment_orientation[45].location.z);

     if (!nowav)
       {
        PRSND_SetOrigin (camera->source.x, camera->source.y, camera->source.z);
        PR_PositionEntity (dummy_ent, jet_arena->segment_orientation[45].location.x,
                                      jet_arena->segment_orientation[45].location.y,
                                      jet_arena->segment_orientation[45].location.z);
        PR_PositionEntity (dummy_ent2,jet_arena->segment_orientation[47].location.x,
                                      jet_arena->segment_orientation[47].location.y,
                                      jet_arena->segment_orientation[47].location.z);
       }

     PR_SetLightPosition (&JetLights, 0,
                          camera->source.x,
                          camera->source.y,
                          camera->source.z);
     PR_AddLightsToScene (&JetLights);

     PR_SetActiveCamera (camera);

     if (!nowav)
       {
        PRSND_Update3DSound (rocket);
        PRSND_Update3DSound (rocket2);
        PRSND_Update3DSound (ambient);
        PRSND_UpdateVoices ();
       }

     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

     if (jet_arena->shape->num_frames > 0)
       {
        frame++;
        if (frame >= jet_arena->shape->num_frames-1)
          animation_finished = 1;
        PR_AnimateEntity (jet_arena, frame);
       }

     PR_TransformEntity (jet_arena);
     PR_RenderEntity (jet_arena);

     DisplayFrameRate ();

     PR_Flip (1);
    }

  if (kbdon[KEY_ESC])
    quit_saver = 1;
}


void BumpLoop (void)
{
PR_DWORD animation_finished = 0;

  frame = 0;
  pathframe = 0;
  camera->fov = (2.0 / 3.0) * 3.1415;

  UpdateBump ();        /* Draw the top of the bump image */
  UpdateBump ();        /* Draw the bottom of the bump image and download the texture */

  while ((!kbdon[KEY_ESC]) && (!animation_finished))
    {
     #ifdef WIN32
      UpdateMessages ();
     #endif
	  
     UserInput ();
     PR_NewFrame ();                         /* Begin a new frame */

     UpdateBump ();

     PRGFX_SetColor (sky_color);
     PR_OpenScreen (PR_BACKBUFFER);

     PRGFX_ClearScreen ();

     PR_PositionCameraSource (camera, campath->segment_orientation[0].location.x,
                                      campath->segment_orientation[0].location.y,
                                      campath->segment_orientation[0].location.z);
     PR_PositionCameraTarget (camera, bump_room->segment_orientation[3].location.x,
                                      bump_room->segment_orientation[3].location.y,
                                      bump_room->segment_orientation[3].location.z);

     PR_SetLightPosition (&BumpLights, 0,
                          camera->source.x,
                          camera->source.y,
                          camera->source.z);
     PR_AddLightsToScene (&BumpLights);

     PR_SetActiveCamera (camera);

     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

     frame++;
     if (frame >= bump_room->shape->num_frames)
       frame = 0;
     PR_AnimateEntity (bump_room, frame);

     pathframe++;
     if (pathframe >= campath->shape->num_frames)
       {
        animation_finished = 1;
        pathframe = 0;
       }
     PR_AnimateEntity (campath, pathframe);

     PR_TransformEntity (bump_room);
     PR_RenderEntity (bump_room);

     DisplayFrameRate ();

     PR_Flip (1);
    }

  if (kbdon[KEY_ESC])
    quit_saver = 1;
}


void LogoLoop (void)
{
PR_DWORD animation_finished = 0;

  frame = 0;
  camera->fov = (1.8 / 3.0) * 3.1415;

  while ((!kbdon[KEY_ESC]) && (!animation_finished))
    {
     #ifdef WIN32
      UpdateMessages ();
     #endif
	  
     UserInput ();
     PR_NewFrame ();                         /* Begin a new frame */

     PRGFX_SetColor (sky_color);
     PR_OpenScreen (PR_BACKBUFFER);

     PRGFX_ClearScreen ();

     PR_PositionCameraSource (camera, logo_room->segment_orientation[5].location.x,
                                      logo_room->segment_orientation[5].location.y,
                                      logo_room->segment_orientation[5].location.z);
     PR_PositionCameraTarget (camera, logo_room->segment_orientation[8].location.x,
                                      logo_room->segment_orientation[8].location.y,
                                      logo_room->segment_orientation[8].location.z);

     PR_SetLightPosition (&JetLights, 0,
                          camera->source.x,
                          camera->source.y,
                          camera->source.z);
     PR_AddLightsToScene (&JetLights);

     PR_SetActiveCamera (camera);

     PRGFX_Clip (active_viewport.topx,
                 active_viewport.topy,
                 active_viewport.bottomx,
                 active_viewport.bottomy);

     if (logo_room->shape->num_frames > 0)
       {
        frame++;
        if (frame >= logo_room->shape->num_frames-1)
          animation_finished = 1;
        PR_AnimateEntity (logo_room, frame);
       }

     PR_TransformEntity (logo_room);
     PR_RenderEntity (logo_room);

     DisplayFrameRate ();

     PR_Flip (1);
    }

  if (kbdon[KEY_ESC])
    quit_saver = 1;
}





/* ---------------------------------------------------------------------- */
/* Main program */
/* ---------------------------------------------------------------------- */
void main (int argc, char *argv[])
{
PR_DWORD argnum;

  argnum = 1;
  while (argnum < argc)
    {
     if (!strcmp (argv[argnum], "-nomusic"))
       nomusic = 1;
     if (!strcmp (argv[argnum], "-nowav"))
       nowav = 1;
     if (!strcmp (argv[argnum], "-fps"))
       show_frame_rate = 1;

     if (
        (!strcmp (argv[argnum], "/?")) ||
        (!strcmp (argv[argnum], "?")) ||
        (!strcmp (argv[argnum], "-?")) ||
        (!strcmp (argv[argnum], "help")) ||
        (!strcmp (argv[argnum], "-c")))
       PR_FatalError ("Egerter Software 3Dfx ScreenSaver  v1.0\n"
                      "Copyright 1997 Egerter Software\n\n"
                      "Command Line switches: \n"
                      "/?       - Displays this help screen\n"
                      "-nomusic - Turns off the music\n"
                      "-nowav   - Turns off the 3D jet sounds\n"
                      "-fps     - Display the frame rate\n", "Egerter Software 3Dfx ScreenSaver");

     argnum++;
    }

  if (nomusic & nowav)
    nosound = 1;


  PRGUI_InitPath (argv[0]);
  InitializePowerRender ();

  PRGUI_GoUserPath ();
  setlib ("es_saver.pkg");

  PRGUI_printf (0, 40, "Loading Jet Scene...");
  LoadJetScene ();
  PRGUI_printf (0, 50, "Loading Bump Scene...");
  LoadBumpScene ();
  PRGUI_printf (0, 60, "Loading Logo Scene...");
  LoadLogoScene ();

  if (!nosound)
    {
     PRGUI_printf (0, 70, "Initializing Audio...");
     InitializeAudio ();
    }

  do {
    InitializeWAV ();
    JetLoop ();
    FreeWAV ();

    if (!quit_saver)
      BumpLoop ();

    if (!quit_saver)
      LogoLoop ();
  } while (!quit_saver);

  uninstallkbd ();
  wstoptimer ();
  wdonetimer ();

  if (!nomusic)
    PRSND_StopSong ();
  FreeWAV ();

  if (!nosound)
    {
     PRSND_CloseVoices ();
     PRSND_DeleteAllSounds ();
     PRSND_CloseAudio ();
    }

#if !defined (MSGLIDE) && !defined (WTGLIDE)
  wsetmode (3);
#endif
}




