PROGRESS VERSION 8.2A RELEASE NOTES, 

Table of Contents

1. Installation
   1.1 Can't share installed product on network
   1.2 Entering PROGRESS product control codes with
       multi-language keyboard settings
   1.3 Uninstall does not always remove program
       group name
   1.4 Microsoft Windows Explorer causes installation
       DDEML errors
   1.5 Registry font entries are not updated by install
2. 8.1 to 8.2A Conversion
   2.1 Dump and load use
   2.2 Menu-bar line doesn't appear
3. Character Client
   3.1 New 32-bit character client product availability
   3.2 Character client requires -cpinternal
       <display code page>
4. Code Pages
   4.1 Changes to the default stream code page
5. Data Administration
   5.1 The quoter.exe and dbf.exe locations must be in
       PATH
6. Database
   6.1 Attempt to connect in single user mode gets
       error 1720
7. DataServers
   7.1 GPF while deleting object(CurrentDb())
8. DBUTIL
   8.1 CRC check error 1147: can't restore Windows
       NT 3.51
9. Digital UNIX Issues
   9.1 DataServers on Digital UNIX
   9.2 PROBUILD on Digital UNIX
   9.3 Changes to HLC library functions
   9.4 Changes to ESQL/C functionality
   9.5 Re-tuning Digital UNIX system
   9.6 Stripping image modules to improve performance
10. DLLs
   10.1 DLL output parameter misinterpreted
11. Documentation
   11.1 FUNCTION statement
   11.2 OUTPUT TO note should start from 1
   11.3 Editor and Fill-in widget methods and attributes
   11.4 Missing FRAME attributes and methods
   11.5 User-defined functions
   11.6 PROGRESS Embedded SQL Guide
12. Font Issues
   12.1 Default font change may cause errors
   12.2 Specifying a font for PROGRESS file property
        sheets
13. OCXs
   13.1 Unsupported Controls
   13.2 Obtaining the Windows 95 Service Packs
   13.3 OCX samples require controls be installed
   13.4 OCX Databinding
   13.5 Maximum number of controls
   13.6 MSDBCombo control shipped with Visual Basic
        Version 4 causes access violation
   13.7 Processing events of MS Form Controls
   13.8 Miscellaneous ActiveX Controls
   13.9 CSCombo font problems
   13.10 Change Style 1 to 2 - breaks design box
   13.11 Special editors for properties not displayed
   13.12 Design time rendering inconsistent
   13.13 Using Crescent time controls with      
         Windows NT 3.51 Service Pack 5
   13.14 StatusBar control
   13.15 Under Windows 95 RichText causes GPF
   13.16 Wang control does not close down properly
   13.17 AddSoft control About properties hangs the UIB
   13.18 BackColor palette improperly mapped
14. OI Drivers
   14.1 Starting OI drivers requires PROGRESS.INI file
15. Microsoft Excel
   15.1 SaveAs() method
   15.2 Using a Hyperlinks object
16. PROAPBK
   16.1 Parameters must be on the same line
   16.2 -Mms not limiting the number of AppServers
17. PROBUILD
   17.1 Putting reference to $PROLOAD in link
   17.2 PROBUILD mprosrv failing
   17.3 Warnings of locally defined symbol
   17.4 Section type warnings on NEC and Siemens
        Nixdorf systems
   17.5 Executable warnings on NEC and Siemens     
        Nixdorf systems
18. PROSHUT
   18.1 PROSHUT list and disconnect qualifiers
19. PROUTIL
   19.1 Binary dump and -index
20. SmartObjects
   20.1 Browser truncates dates
   20.2 GUI .r-code stops character SmartObject layouts
21. TRANMAN2
   21.1 List Files of Type
22. User Interface Builder
   22.1 UIB will hang if character Run Window closed

---------------------------------------------------------------------
1. Installation

1.1 Can't share installed product on network

Starting with Version 8.2A, PROGRESS follows the Microsoft Windows
32-bit application standard.  Due to the complex configuration which 
the install program performs on the installing PC, PROGRESS can no 
longer be shared from a network installation.
---------------------------------------------------------------------
1.2 Entering PROGRESS product control codes with 				
     multi-language keyboard settings

In Windows 95 and Windows NT 4.0, if you cannot change the keyboard 
to English (in order to enter the PROGRESS product control codes) by 
clicking on the language option on the task bar, then you can change 
the language by using the appropriate keystrokes for your 
configuration to change language.  For example, Left Alt+Shift or 
Ctrl+Shift (left or right Ctrl).

Also, you can go to the Control Panel, select Keyboard, then the 
Language tab.   Highlight English and choose "Set as Default."  Then 
re-run the install.  When the install is finished, you can change 
back to the native language.
---------------------------------------------------------------------
1.3 Uninstall does not always remove program 					
    group name

During uninstall of PROGRESS on Japanese or Korean Windows 95, the 
program group may not be removed.  If this occurs, you should remove
it manually.
---------------------------------------------------------------------
1.4 Microsoft Windows Explorer causes installation 			
    DDEML errors

If you run the Setup program using the RUN command from the Start 
Menu make sure the Windows Explorer is not running or you may get 
DDEML errors from Setup.
---------------------------------------------------------------------
1.5 Registry font entries are not updated by install

On Windows 95, if the Version 8.2A DBE Supplement is installed after 
the main PROGRESS install, the font entries in the registry may be 
incorrect.

To correct the registry, look in the $DLC/prolang directory 
appropriate for your language.  If the directory contains a 
PROGRESS.INI file, use the ini2reg.exe utility to install the 
contents of the PROGRESS.INI to the registry.  The ini2reg utility 
is installed into $DLC\bin and can be run from the Windows run 
command or from a DOS prompt.
---------------------------------------------------------------------
2. 8.1 to 8.2A Conversion

2.1 Dump and load use	

Upon connecting to your database, If you receive the error message:

Invalid block size 512 in database <dbname>

you will need to dump and load that database.  This error message is 
generated because you had a database created with our 16-bit product.  
On Windows 95 and Windows NT, Version 8.2A is a 32-bit only product.
---------------------------------------------------------------------
2.2 Menu-bar line doesn't appear

On Windows 95 and Windows NT 4.0, the appearance of a menu-bar in 
versions of PROGRESS prior to 8.2A differs in some cases from its 
appearance in Version 8.2A.  In versions prior to 8.2A, a thin, black 
line is sometimes present along the bottom edge of the menu-bar.  
This line is never present in Version 8.2A on Windows 95 or Windows 
NT 4.0.  This behavior is consistent with the updated Windows 95 
interface.
---------------------------------------------------------------------
3. Character Client

3. 1 New 32-bit character client product availability

Version 8.2A supports a 32-bit character client on the Windows 95 and 
Windows NT platforms.  This client has full Version 8 character widget 
support, including the updatable browse.  In addition, the Windows 
character client supports access to dynamic link libraries (DLLs), 
dynamic data exchange (DDE), and ActiveX Automation (with Automation 
Servers that do not require Window handles from the controller).  
To order the 32-bit character client, contact your local sales office,
as this product is not automatically shipped when you upgrade from 
Version 8.1.

Note:  This client is not double-byte enabled.
------------------------------------------------------------------------------------------------
3.2 Character client requires -cpinternal <display code page>

The "insert" string (or its translation from PROMSGS) will not display 
properly if the -cpinternal code page setting is different from the 
code page used by the display, even if -cpterm or -cpstream is set 
correctly.  The workaround is to ensure that -cpinternal and the 
display use the same code page values.
------------------------------------------------------------------------------------------------
4. Code Pages

4.1 Changes to the default stream code page

The startup.pf files have been updated so that now -cpstream will be 
set to the same value as -cpinternal.  This has generally bee true for 
UNIX environments, but for Windows environments -cpstream would have 
been set to the DOS code page.  With the advent of Windows 95 and 
Windows NT 4.0, and fewer DOS-based tools being used, it makes more 
sense to produce files that use the Microsoft Windows code pages.  
This is what the .pf files are not set to use for -cpstream.

However, it is important to note that text files that you import, or 
even .p, .i, or .w files that you use, may have been based on DOS 
code pages.  If so you can either convert these files to the Microsoft
Windows code page or change the -cpstream setting to your DOS code 
page value.  Refer to the PROGRESS Internationalization Guide for 
information on converting the code page of text files.
------------------------------------------------------------------------------------------------
5. Data Administration

5.1 The quoter.exe and dbf.exe locations must be in PATH

You need to include quoter.exe in a directory on your PATH 
environment variable that is set in the autoexec.bat file in order 
to run the following functions from the Windows Data Administration 
menu.

Admin->Import Data->DIF
Admin->Import Data->SYLK
Admin->Import Data->Delimited Text
Admin->Import Data->Fixed-Length
Utilities->Editor for Parameter Files
Utilities->Quoter Functions

You need to include dbf.exe in a directory on your PATH that is set 
in the autoexec.bat file in order to run the following functions from 
the Windows Data Administration menu.

Admin->Import Data->dBASE Definitions
Admin->Import Data->dBASE File Contents

You will see the following error if PROGRESS cannot find the 
executable file in your PATH, where <filename> will be a temporary 
filename.

** "<file-name>" was not found.  (293)

Note, these changes will only apply when running DOS applications.
------------------------------------------------------------------------------------------------
6. Database


6.1 Attempt to connect in single user mode gets	error 1720
If you attempt to connect to a database in single user mode on Windows
NT or Windows 95, and omit the -1 option on the startup command or
icon properties, you will get the following error.

Unable to attach shared memory <shmname>, error 123.  (1720)

This error indicates that there is no database server active for the 
specified database.  To resolve this error, add the -1 option to the 
startup command or icon properties, or start a database server your 
license permits.

Normally the error message you would expect to receive is:

There is no server for database <dbname>.  (1423)
------------------------------------------------------------------------------------------------
7. DataServers

7.1 GPF while deleting object(CurrentDb())
This GPF from Microsoft Access is a bug in Access itself.  If objects 
are created or accessed and not released before Quit is called on the 
Access Application, Quit will cause a GPF.  This has been fixed in 
the Office 97 version of Access.   A workaround is to call 
"Release Object" on any com-handle obtained from Access before 
calling Quit.
------------------------------------------------------------------------------------------------
8. DBUTIL

8.1 CRC check error 1147: can't restore Windows NT 3.51

If you try doing a restore from Tape on Windows NT 3.51 and receive 
the following error:

CRC check error reading backup block # (1147).
SYSTEM ERROR: Read of \\.\\Tape0 failed, errno=1104 (1052)

Load Windows NT 3.51 Service Pack 5.  If you already have Service 
Pack 5 loaded, reinstall it.  Sometimes adding a device driver requires 
the re-installing of a Service Pack.
------------------------------------------------------------------------------------------------
9. Digital UNIX Issues

9.1 DataServers on Digital UNIX

The Oracle DataServer is the only DataServer currently supported on 
this platform.
------------------------------------------------------------------------------------------------
9.2 PROBUILD on Digital UNIX

When probuilding images, LDOPT must be set as follows:

	LDOPT="-T 12000000 -D 18000000"
------------------------------------------------------------------------------------------------
9.3 Changes to HLC library functions

Due to the architecture difference of an Alpha processor (64-bit vs. 
32-bit), the HLC library functions have the following changes:

   int prordi( char *, int, int *pvar, int *)

        pvar: change from 'long' to 'int'.
		The output parameter points to an int where prordi() 
		returns the value of the specified INTEGER variable.

   int prordr( char *, int, int *pvar, int *)
 
        pvar: change from 'long' to 'int'
		The output parameter points to an int where prordr() 
		returns the value of the specified RECID variable.

   int prowti( char *, int, int var, int)
 
         var:  change from 'long' to 'int'.
		The input parameter contains the integer value for 
		the specified INTEGER field.

   int prowtr( char *, int, int var, int)

        var:  change from 'long' to 'int'.
		The input parameter contains the integer value for 
		the specified RECID field.

   int prowtbi(char *, int, int, int var, int)

        var:  change from 'long' to 'int'.
		The input parameter contains the integer value for 
		the specified INTEGER field.

   int prowtbr(char *, int, int, int var, int)

        var:  change from 'long' to 'int'.
		The input parameter contains the integer value for 
		the specified RECID field.

   int prordbi(char *, int, int, int *pvar, int *)

        pvar: change from 'long' to 'int'.
		The output parameter points to an int where 
		prordbi() returns the value of the specified 
		INTEGER field.

   int prordbr(char *,int ,int ,int *pvar,int *)

        pvar: change from 'long' to 'int'
		The output parameter points to an int where prordbr() 
		returns the value of the specified RECID field.
------------------------------------------------------------------------------------------------
9.4 Changes to ESQL/C functionality

ESQL/C functionality has the following changes:

1 - The variable SQLCODE should be declared as C data type 'int' 
    instead of 'long'.
	
        Example:
                  int SQLCODE;  /* change 'long' to 'int' */
			
2 - Within ESQL declaration section, variables should be declared 
    as C data type 'int' instead of 'long'.
 
        Example:

            EXEC SQL BEGIN DECLARE SECTION:
                char name[30];
                int  custnum, maxcred, hicustnum;  
		/* change 'long' to 'int' */
                .....
            EXEC SQL END DECLARE SECTION;
------------------------------------------------------------------------------------------------
9.5 Re-tuning Digital UNIX system

Due to more system resources used in this release on Digital UNIX, 
system managers are expected to re-tune their systems to maintain 
adequate performance on PROGRESS.  Please refer to the PROGRESS 
System Administration Guide.
------------------------------------------------------------------------------------------------
9.6 Stripping image modules to improve performance

The size of the executable images can be reduced by stripping the image 
modules, and the performance will also be improved.  To strip the 
image, use the following command:

	strip <image_module_name>

Because the strip command removes symbols from the executable 
images, we recommend that customers should also keep the 
non-stripped images for debugging purposes.
------------------------------------------------------------------------------------------------
10. DLLs

10.1 DLL output parameter misinterpreted

If you have defined an external DLL procedure to use an output 
parameter of type UNSIGNED-SHORT, PROGRESS may misinterpret the value 
of the output parameter after the DLL procedure returns.

This will occur only if you are passing a PROGRESS integer to the DLL 
procedure, and that integer was set to a negative number before the 
DLL was called.

A workaround for this issue is to set the variable you are using as an 
output parameter to a non-negative value prior to executing the DLL 
procedure.
------------------------------------------------------------------------------------------------
11. Documentation

11.1 FUNCTION statement

The PROGRESS Language Reference Manual, Volume 1, has a mistake 
in the description of the declaration of a temp-table parameter.  The 
syntax should read: 
   [INPUT | OUTPUT | INPUT-OUTPUT] TABLE FOR temp-table-name
The manual is missing the word "FOR".
------------------------------------------------------------------------------------------------
11.2 OUTPUT TO note should start from 1

In the PROGRESS Language Reference Manual, in the entry for the 
OUTPUT TO statement, in the NOTES section, in the note for OUTPUT 
TO PRINTER, a list appears with two items numbered 15 and 16.  The 
two items should be numbered 1 and 2.
------------------------------------------------------------------------------------------------
11.3 Editor and Fill-in widget methods and attributes

The following information was omitted from the PROGRESS Language 
Reference Manual.

The following new methods and attributes are supported by the editor 
and fill-in widgets.

Clipboard methods and attributes:
EDIT-COPY() method - copies the currently selected text in an editor or 
                     fill-in widget to the Clipboard.
EDIT-CUT() method - copies the currently selected text in an editor or 
                    fill-in widget to the Clipboard, and then deletes 
		    the selected text.
EDIT-CLEAR() method - deletes the selected text.
EDIT-PASTE() method - pastes the contents of the Clipboard into the 
                      editor or fill-in widget at the current cursor 
                      position, if the Clipboard contains text data.

For the above 4 methods, there are no parameters.  Also, the method 
returns TRUE if successful and FALSE otherwise.

EDIT-CAN-PASTE attribute - returns TRUE if the Clipboard contains data 
which can be pasted into the editor or fill-in, otherwise it returns 
FALSE.

Applications may still use the CLIPBOARD handle to perform these 
operations, however, using these new methods will ensure that the new 
UNDO capability of the editor works properly.

The above methods and attributes are supported on Windows only, 
graphical mode only.

NO-BOX option:
The Editor widget supports a new option on the VIEW-AS phrase, 
NO-BOX, which indicates that the editor should be displayed without a 
border.  By default the editor is displayed with a border.

A new editor attribute, BOX, returns TRUE if the editor is displayed 
with a border, otherwise it returns FALSE.  The BOX attribute must be 
set before the editor is realized.

The NO-BOX option and BOX attribute have no effect on the size of the 
editor.

This attribute is supported on Windows only, graphical mode only.
------------------------------------------------------------------------------------------------
11.4 Missing FRAME attributes and methods

The PROGRESS Language Reference Manual, Pocket PROGRESS, 
and On-line Help are all missing the tab-order attributes and methods 
for the FRAME Widget entry.  These include, at least:

Attributes:

   NEXT-TAB-ITEM
   PREV-TAB-ITEM
   TAB-POSITION

Methods:

   MOVE-AFTER-TAB-ITEM()
   MOVE-BEFORE-TAB-ITEM()

The reference entry for each of these attributes and methods DOES 
indicate that it applies to Frame.  These are used to establish tab 
order for the child frames of a frame family, as described in Chapter 
24, "Interface Design" of the PROGRESS Programming Handbook.
------------------------------------------------------------------------------------------------
11.5 User-defined functions

In the PROGRESS Programming Handbook, in the chapter on block 
properties, in the section on user-defined functions, the section 
should note that user-defined functions follow the same rules of 
scope and visibility that internal procedures follow.
------------------------------------------------------------------------------------------------
11.6 PROGRESS Embedded SQL Guide

Please note the following changes to page 3-17 of the PROGRESS 
Embedded SQL Guide and Reference, Section 3.5.2:
    
     Substitute esql32.dll for every reference to esql01.dll 
     Substitute esql32.lib for every reference to esql01.lib
          
For the example in Figure 3-6 labeled: Linking a Windows Small Client, 
substitute the entire entry with the following:

inventory.obj 

%DLC%/probuild/esqlc/esql32.lib 
/NOLOGO 
/OUT:inventory.exe 
/MAP:inventory.map 
libcmt.lib 
kernel32.lib 
shell32.lib 
user32.lib 
comdlg32.lib 
gdi32.lib 
advapi32.lib 
comctl32.lib 
winspool.lib 
netapi32.lib 
wsock32.lib
------------------------------------------------------------------------------------------------
12. Font Issues

12.1 Default font change may cause errors

Prior to Version 8.2A, PROGRESS's default font was the SYSTEM font.  
This means that the PPU used to layout screens were based entirely on 
this font.   Beginning with Version 8.2A, PROGRESS uses the MS Sans 
Serif, 8 point font as the default font in the United States, to be 
compatible with Microsoft's style guidelines for Windows 95.  The 
default font was also changed appropriately for other countries.

Code which was written using the SYSTEM font as the default font may 
not compile properly when used with 8.2A with its new default font 
setting.  This is because the PPU dimensions have changed and it may 
affect your screen layout.  Errors such as:

4028 (<widget> will not fit in frame <frame>), and
4041 (<widget> does not fit in parent <parentid>)

may occur during compile or when you load the file into the UIB.  To 
continue using the changed font, you need to adjust the layout of the 
screen.

If you do not wish to adjust the layouts of your procedures, you may 
revert the default font of PROGRESS back to the SYSTEM font by 
removing the DefaultFont setting from the Startup key in the Windows 
Registry.

To remove or re-add this registry entry, following these steps:

1 - Run the Registry Editor program (on Windows 95: regedit.exe, 
    on Windows NT: regedt32.exe)
2 - Select the HKEY_CURRENT_USER window.
3 - Navigate to SOFTWARE, then PSC, then PROGRESS, then 8.2A, 
     then Startup
4 - To return to the SYSTEM font, highlight the DefaultFont value and 
     press the Delete key.  To return to the MS Sans Serif font, select 
     Edit/Add Value from  the menu and enter "DefaultFont" for the 
     Value Name, press OK and type "MS Sans Serif, size=8" for the 
     string value     and press OK.
5 - Close the Registry Editor and restart PROGRESS.

Also note that in Version 8.2A, the default fixed font is set to 
Courier New 8 point in the United States.  The default fixed font was 
also changed appropriately for other countries.  It previously 
defaulted to the FIXEDSYS font.  If you want to revert or re-add this 
value, follow the same steps as for DefaultFont, but use the key 
"DefaultFixedFont" instead of "DefaultFont".
------------------------------------------------------------------------------------------------
12.2 Specifying a font for PROGRESS file property sheets

If you access the Property Sheet for a PROGRESS file from the Windows 
Explorer, and text on the Property Sheet does not display in the 
character set required, you can specify a different font by modifying 
the default value of the HKEY_LOCAL_MACHINE\Software\PSC\ProShell\Font
key in the Windows registry.
------------------------------------------------------------------------------------------------
13. OCXs

13.1 Unsupported Controls

The following controls are not supported:

MSDataCombo shipped with Visual Basic Version 4 - DBLIST32.OCX.  
The MSDataCombo control shipped with Visual Basic Version 5 
is supported.
Mh3Doption - MHOPT32.OCX
MH Splitter - MHSPLT32.OCX
Sheridan SSDBEnhanced Data control - SSDATA32.OCX
Sheridan FormFX control - SSFORM32.OCX
------------------------------------------------------------------------------------------------
13.2 Obtaining the Windows 95 Service Packs

To download the correct Service Packs you should go to the Microsoft 
website.
------------------------------------------------------------------------------------------------
13.3 OCX samples require controls be installed

OCX sample applications shipped with PROGRESS 8.2A require controls 
to be independently installed and registered on the machine running the 
sample application in order to run the application in the UIB.  

If the controls are not installed, the application will fail to run.  
The application can be loaded into the Procedure Editor and the source 
code is available for review.

Note:  The example application e-ocx1.w runs with the CSSpin control 
that comes installed with PROGRESS.
------------------------------------------------------------------------------------------------
13.4 OCX Databinding

Version 8.2A currently does not support OCX Databinding, so any data 
aware OCX objects cannot be fully utilized.
------------------------------------------------------------------------------------------------
13.5 Maximum number of controls

Adding the maximum number of controls on a PROGRESS window 
generates the following error:

"Attempt to expand record beyond the maximum allowed size." (444)

This error is displayed when adding an estimated 150 controls onto one 
PROGRESS window.
------------------------------------------------------------------------------------------------
13.6 MSDBCombo control shipped with Visual Basic Version 4 causes 
     access violation

Currently Microsoft's MSDBCombo does not work well in PROGRESS, 
and may cause PROGRESS to GPF with an access violation.  This may 
occur under Windows 95, Windows NT 3.51 Service Pack 5 and NT 4.0.

The version of MSDBCombo that comes with Visual Basic 4.0 is not 
supported by the PROGRESS container.  You must use the 
MSDBCombo control that ships with Visual Basic 5.0.
------------------------------------------------------------------------------------------------
13.7 Processing events of MS Form Controls

Controls from Microsoft's FM20.DLL are not supported in Version 8.2A.  
These controls do not support proper quick activation.
------------------------------------------------------------------------------------------------
13.8 Miscellaneous ActiveX Controls

Microsoft Multimedia Control requires sufficient space on the 
PROGRESS window in order to be successfully created.  The 
PROGRESS window will not automatically accommodate it.

MicroHelp Mh3dKeyState Control may not display a property page at 
design time in the PROGRESS window.

Microsoft RichText Box Control for Visual Basic Version 4 is not 
supported under Windows NT 3.51 Service Pack 5 and PROGRESS 
Version 8.2A.
------------------------------------------------------------------------------------------------
13.9 CSCombo font problems

CSComboBox control on Windows NT 3.51 has font display problems at 
design time.  To obtain the correct font, use the Property Editor to 
set the font or set this at run time.
------------------------------------------------------------------------------------------------
13.10 Change Style 1 to 2 - breaks design box

When the Style property in the CSComboBox is set to 1 and the control 
itself is resized to accommodate the list display, and then run, and 
then Style is reset to 2, the FONT is reset to the size of the frame.
The work around is to TAB away from the control, and then TAB back.
------------------------------------------------------------------------------------------------
13.11 Special editors for properties not displayed

Properties that have Custom Editors such as the Text Property of the 
CSComboBox control, are not displayed at design time.
------------------------------------------------------------------------------------------------
13.12 Design time rendering inconsistent

Some controls do not render properly at design time.  This condition 
has been noted with the Microhelp Dice Control, Microhelp 3D Directory 
Control, and Microhelp 3D Drive Control.  The control may appear 
intermittently or not at all in design mode.  All controls appear 
properly at run time.
------------------------------------------------------------------------------------------------
13.13 Using Crescent time controls with	Windows NT 3.51 Service Pack 5

Crescent QuickPack controls must be version 4.2 or greater for Windows 
NT 3.51 Service Pack 5.  Earlier versions of QuickPack are not 
supported.
------------------------------------------------------------------------------------------------
13.14 StatusBar control

Running the StatusBar control in PROGRESS may cause the application 
to GPF under Windows NT 3.51 Service Pack 5.
------------------------------------------------------------------------------------------------
13.15 Under Windows 95 RichText causes GPF

Running the RichText control with PROGRESS under Windows 95 may 
cause a GPF.  The RichText control shipped with Visual Basic 5.0 works 
properly on all platforms.
------------------------------------------------------------------------------------------------
13.16 Wang control does not close down properly

The Wang Image management controls that ship with Windows NT do 
not appear to close down properly when the Wang server is released.  
This is only seen in the debugger when the server attempts to release 
memory that has already been released.

The Image Management controls supplied with Visual Basic 5.0 do not 
exhibit this problem.
------------------------------------------------------------------------------------------------
13.17 AddSoft control About properties hangs the UIB

The Addsoft Schedule OCX's About Box will disable mouse input at 
design time.  If the About Box is brought up during design time, the 
system loses all mouse input.  The user can still close the About Box 
via the keyboard (return), and navigate with keyboard commands.  Once 
the About Box is closed, the system will return to normal.  The About 
Box works properly at run time.
------------------------------------------------------------------------------------------------
13.18 BackColor palette improperly mapped

You may see this kind of behavior when running in 256 color mode.  
Colors in a control's color selection dialog may not match the actual 
control when it's rendered.  This is an artifact of Window's palette 
management under 256 color mode.  By changing the mode to 65K or 
higher color mode, the problem will go away.
------------------------------------------------------------------------------------------------
14. OI Drivers

14.1 Starting OI drivers requires PROGRESS.INI file

When you are trying to start an oidriver (woidrvr or oidrvr32) for 
Windows platforms, you must have a PROGRESS.INI file in either your 
local directory, your Windows directory, or in a directory listed in 
your PATH.  If you do not have a PROGRESS.INI file, the oidriver will 
silently fail.  You will not get an error message.

If you find that the woidrvr or oidrvr32 silently fails with no 
messages in the PROOIDRV.LG file, create a PROGRESS.INI file in the 
correct directory.  The file need only be present.
------------------------------------------------------------------------------------------------
15. Microsoft Excel

15.1 SaveAs() method

The SaveAs() method of Workbooks Class generates an error:

   "Error 0x80020009 in Get/Setting com-handle property SaveAs
    Unable to get the SaveAs property of Workbook Class"
    Method works only if the second parameter is set to 
    xlWorkBookNormal(-4143)

The work around for this issue is to specify the second parameter as:
<Workbook Object>:FileFormat

Thus Excel always will save the file in the format that is defined for
the currently used WorkBook.
------------------------------------------------------------------------------------------------
15.2 Using a Hyperlinks object

If a Hyperlinks object is referenced in a 4GL procedure that connects 
to MS Excel Automation Server, then this object is released, quitting 
Excel and releasing the Excel Application object doesn't release Excel.
It stays as an active process until the PROGRESS session ends.
------------------------------------------------------------------------------------------------
16. PROAPBK

16.1 Parameters must be on the same line

Using -pf on the PROAPBK command line will only work if the 
parameters in the .pf file are on one line.  If they are on separate 
lines the broker will not start properly.
------------------------------------------------------------------------------------------------
16.2 -Mms not limiting the number of AppServers

When -Mms is used without -Ms (or -Ms 0) then the Broker kicks off an 
unlimited number of Application Servers.  This can be resolved by using 
the -Ms with a value greater than 0 (for example, proapbk -S <service> 
-Ms 1 -Mms 5).
------------------------------------------------------------------------------------------------
17. PROBUILD

17.1 Putting reference to $PROLOAD in link

If you use PROBUILD to build client or utility executables, the full 
pathname to the library files must be specified.  For example:  if DLC
is set to d:\users\install\dlc then you must edit your prowin32.lnk 
file from :
   $PROLOAD/ax/comobj.lib
   $PROLOAD/ax/varditem.lib
to :
   d:\users\install\dlc\probuild\ax\comobj.lib
   d:\users\install\dlc\probuild\ax\varditem.lib

to avoid LINK errors.  These are the only two entries you should need 
to edit.
------------------------------------------------------------------------------------------------
17.2 PROBUILD mprosrv failing

If you use PROBUILD to build console executables, /ENTRY gets set to 
"WinMainCTRStartup" and should be set to "mainCTRStartup".

/SUBSYSTEM gets set to "windows, 4.0" and should be set to 
"console, 4.0".
------------------------------------------------------------------------------------------------
17.3 Warnings of locally defined symbol

These are normal messages from the linker indicating that the 
msvcrt.dll will be needed in order to run the executable, since the 
routines mentioned are being imported from there, as opposed to being 
statically linked from libcmt.lib.
------------------------------------------------------------------------------------------------
17.4 Section type warnings on NEC and Siemens Nixdorf systems

While running 'ld' scripts generated as a result of PROBUILD on the 
NEC or Siemens Nixdorf systems, you may see the following warning:

ld:  ./4gl/tstset.o:  warning:  unknown section type 0x7000000d 
ignored section ".options"

You can ignore these messages.  A warning of this kind indicates 
that the object module was built on a system different from the system 
where the ld script is run.
------------------------------------------------------------------------------------------------
17.5 Executable warnings on NEC and Siemens Nixdorf systems

When you run a PROGRESS executable on an NEC or Siemens Nixdorf 
system, you may receive the following message in the message area:

sigaction returns 22 for signal <nn>

where nn is a number between 32 and 65.

You can ignore these messages.  These messages indicate that the 
executable was built on a system where the NSIG value was 65.  On 
Siemens Nixdorf, NSIG has a value of 32.  On NEC, the NSIG value is 35.
------------------------------------------------------------------------------------------------
18. PROSHUT

18.1 PROSHUT list and disconnect qualifiers

There are two new features which are not in the documentation.

PROSHUT dbname -C list
Lists all of the users connected to the database.  The list is 
printed out to the screen without any page breaks.

PROSHUT dbname -C disconnect <usernum>
Allows you to initiate a disconnect for the specified user.  This is 
similar to option "1" of the PROSHUT screen.

You can use these two features to write scripts to manage 
disconnecting users.   For example:

	proshut dbname -C disconnect `proshut dbname -C list \
| grep "mike" | awk '{ print $1 }'`

This would initiate a disconnect on the user "mike."
------------------------------------------------------------------------------------------------
19. PROUTIL

19.1 Binary dump and -index

If you specify a specific index to the binary dump command 
(using the -index parameter), and the specified index is not defined 
on the table you are attempting to dump, PROUTIL will not complain and
 use the index to dump the data.  The result of this is that you will 
have a different table dumped instead of the one specified.
------------------------------------------------------------------------------------------------
20. SmartObjects

20.1 Browser truncates dates

When a browse column contains a date field, the date is truncated by 1 
character.   There are 2 possible workarounds: 
1 - Pad the label with blanks to make the field wide enough.
2 - Use the WIDTH attribute on the column to specify the proper 
    column width.   

The second workaround requires that the Freeform query feature be 
used as the UIB doesn't allow the column width to be specified in the 
column editor.
------------------------------------------------------------------------------------------------
20.2 GUI .r-code stops character SmartObject layouts

When you run a character layout .w file that contains SmartObjects, 
the character session generates the following error and fails to 
correctly display the SmartObjects contained in the layout.

  Program <program-name> was compiled under another incompatible 
  display  environment.  Cannot run without recompile.  (4438)

The UIB by default compiles and generates .r code for SmartObjects 
when they are saved (File->Save).  The Character Run session from the 
UIB inadvertently tries to run these .r files, since they are in the 
PROPATH along with the .w(source) versions of the files.  That's why 
the invalid .r code error displays.

To fix this, delete the .r code files for the associated SmartObjects 
and run the character layout .w file.
------------------------------------------------------------------------------------------------
21. TRANMAN2

21.1 List Files of Type

When adding the files using "*.", the List Files of Type correctly 
adds only those files with no extensions.  When importing files 
TRANMAN2 uses the operating system's definition of "*.", but when the 
browser is populated, it uses PROGRESS's MATCHES function which 
treats "*." differently.
------------------------------------------------------------------------------------------------
22. User Interface Builder

22.1 UIB will hang if character Run Window closed

When you double-click on the Control Menu, select Close from the 
Control Menu or click the close button on the NT Console client window, 
PROGRESS does not respond to the End Task request.  Instead, you 
should terminate your PROGRESS application using the method 
available through the application or by pressing the PROGRESS Endkey 
(ESC or F4).
------------------------------------------------------------------------------------------------

