/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.util;

import java.awt.Component;
import java.awt.Container;
import symantec.itools.lang.OS;

public final class ZOrderUtils {
    private static boolean m_IsFirstDrawnOverSecond;

    private ZOrderUtils() {
    }

    public static boolean isFirstDrawnOverSecond() {
        return m_IsFirstDrawnOverSecond;
    }

    public static boolean isSecondDrawnOverFirst() {
        return !m_IsFirstDrawnOverSecond;
    }

    public static void reverseContainersZOrder(Container container) {
        Component[] components = container.getComponents();
        container.removeAll();
        int numComponents = components.length;
        int i = components.length - 1;
        while (i >= 0) {
            Component component = components[i];
            container.add(component);
            if (component instanceof Container) {
                ZOrderUtils.reverseContainersZOrder((Container)component);
            }
            --i;
        }
    }

    public static boolean assumeZOrder(Container container, boolean assumedFirstDrawnOverSecond) {
        if (assumedFirstDrawnOverSecond != ZOrderUtils.isFirstDrawnOverSecond()) {
            return false;
        }
        ZOrderUtils.reverseContainersZOrder(container);
        return true;
    }

    static {
        String OSName = System.getProperty("os.name");
        if (OSName.startsWith("S") || OSName.startsWith("Kona") || OSName.startsWith("AIX") || OSName.startsWith("OSF")) {
            m_IsFirstDrawnOverSecond = true;
        } else {
            boolean javaVendorIsNetscape = System.getProperty("java.vendor").startsWith("Netscape");
            m_IsFirstDrawnOverSecond = OS.isWindows() && javaVendorIsNetscape && System.getProperty("java.version").equals("1.02") ? true : OS.isMacintosh() && javaVendorIsNetscape;
        }
    }
}

