/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.multimedia.Animator;
import symantec.itools.multimedia.AnimatorImage;

public class MovingAnimation
extends Animator
implements Runnable {
    protected transient int loopslot = 0;
    protected int shiftOffset = 10;
    private transient int curXOffset = 0;
    private VetoableChangeSupport vetos;
    private PropertyChangeSupport changes;

    public MovingAnimation() {
        this.forever = true;
        this.vetos = new VetoableChangeSupport(this);
        this.changes = new PropertyChangeSupport(this);
    }

    public void setShiftOffset(int newShiftOffset) throws PropertyVetoException {
        if (this.shiftOffset != newShiftOffset) {
            Integer oldShiftOffsetInt = new Integer(this.shiftOffset);
            Integer newShiftOffsetInt = new Integer(newShiftOffset);
            this.vetos.fireVetoableChange("ShiftOffset", oldShiftOffsetInt, newShiftOffsetInt);
            this.shiftOffset = newShiftOffset;
            this.changes.firePropertyChange("ShiftOffset", oldShiftOffsetInt, newShiftOffsetInt);
        }
    }

    public int getShiftOffset() {
        return this.shiftOffset;
    }

    public void run() {
        Thread.currentThread().setPriority(4);
        Dimension d = this.size();
        int imageCount = this.images.size();
        if (imageCount > 1) {
            if (this.shiftOffset < 0) {
                this.curXOffset = d.width - this.maxWidth;
            }
            int count = 0;
            while (true) {
                d = this.size();
                if (++this.loopslot >= imageCount) {
                    if (++count > this.numLoops && !this.forever) break;
                    this.loopslot = 0;
                    this.curXOffset += this.shiftOffset;
                    if (this.curXOffset < 0) {
                        this.curXOffset = d.width - this.maxWidth;
                    } else if (this.curXOffset + this.maxWidth > d.width) {
                        this.curXOffset = 0;
                    }
                }
                this.repaint();
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0x38) != 0 && this.images != null && this.loopslot < this.images.size() && ((AnimatorImage)this.images.elementAt((int)this.loopslot)).image == img) {
            this.repaint(100L);
        }
        return (flags & 0x60) == 0;
    }

    public void paint(Graphics g) {
        Image img;
        if (this.images != null && this.loopslot < this.images.size() && (img = ((AnimatorImage)this.images.elementAt((int)this.loopslot)).image) != null) {
            g.drawImage(img, this.curXOffset, 0, this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }
}

