/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import symantec.itools.awt.BorderPanel;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class ToolBarPanel
extends BorderPanel {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected int orientation;
    private Veto veto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ToolBarPanel() {
        this.padleft = 0;
        this.padright = 0;
        this.padtop = 0;
        this.padbottom = 0;
        this.ixPad = 4;
        this.iyPadTop = 4;
        this.iyPadBottom = 3;
        super.setLayout(new FlowLayout(0, 0, 0));
        try {
            this.setBevelStyle(1);
            this.setOrientation(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public ToolBarPanel(int bevelStyle, int orientationType) {
        this();
        try {
            this.setBevelStyle(bevelStyle);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.setOrientation(orientationType);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void setOrientation(int orientationType) throws PropertyVetoException {
        if (this.orientation != orientationType) {
            Integer oldValue = new Integer(this.orientation);
            Integer newValue = new Integer(orientationType);
            this.vetos.fireVetoableChange("Orientation", oldValue, newValue);
            this.orientation = orientationType;
            FlowLayout temp = (FlowLayout)this.panel.getLayout();
            if (this.orientation == 0) {
                temp.setAlignment(0);
            } else if (this.orientation == 1) {
                temp.setAlignment(1);
            }
            this.panel.setLayout(temp);
            if (this.getComponentCount() > 0) {
                this.setSize(this.getPreferredSize());
                this.validate();
            }
            this.changes.firePropertyChange("Orientation", oldValue, newValue);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setLayout(LayoutManager lm) {
    }

    public synchronized Dimension getPreferredSize() {
        Dimension s = new Dimension(0, 0);
        switch (this.orientation) {
            case 0: {
                s = super.getPreferredSize();
                break;
            }
            case 1: {
                Component[] list = this.getComponents();
                int i = 0;
                while (i < list.length) {
                    Dimension cs = list[i].getSize();
                    s.height += cs.height;
                    s.width = Math.max(s.width, cs.width);
                    ++i;
                }
                s.width += this.padleft + this.padright + this.ixPad * 2 + 1;
                s.height += this.getLabelTopMargin() + this.padbottom + this.iyPadTop + this.iyPadBottom + 1;
                break;
            }
        }
        if (s.width == 0) {
            s.width = 50;
        }
        if (s.height == 0) {
            s.height = 50;
        }
        return s;
    }

    public boolean isValidOrientation(int orientationType) {
        switch (orientationType) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.veto == null) {
            this.veto = new Veto();
            this.addOrientationListener(this.veto);
        }
    }

    public synchronized void removeNotify() {
        if (this.veto != null) {
            this.removeOrientationListener(this.veto);
            this.veto = null;
        }
        super.removeNotify();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void addOrientationListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("Orientation", listener);
    }

    public void removeOrientationListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("Orientation", listener);
    }

    public void addOrientationListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("Orientation", listener);
    }

    public void removeOrientationListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("Orientation", listener);
    }

    class Veto
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!ToolBarPanel.this.isValidOrientation(i)) {
                throw new PropertyVetoException("Invalid Orientation: " + i, e);
            }
        }

        Veto() {
            ToolBarPanel.this = ToolBarPanel.this;
        }
    }
}

