/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.shape;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class Line
extends Component {
    protected boolean slopeType = false;
    protected int lineThickness = 1;
    protected Polygon poly;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public void setPositiveSlope(boolean type) throws PropertyVetoException {
        if (this.slopeType != type) {
            Boolean oldValue = new Boolean(this.slopeType);
            Boolean newValue = new Boolean(type);
            this.vetos.fireVetoableChange("PositiveSlope", oldValue, newValue);
            this.slopeType = type;
            this.repaint();
            this.changes.firePropertyChange("PositiveSlope", oldValue, newValue);
        }
    }

    public boolean isPositiveSlope() {
        return this.slopeType;
    }

    public void setLineThickness(int thickness) throws PropertyVetoException {
        if (this.lineThickness != thickness) {
            Integer oldValue = new Integer(this.lineThickness);
            Integer newValue = new Integer(thickness);
            this.vetos.fireVetoableChange("LineThickness", oldValue, newValue);
            this.lineThickness = thickness;
            this.repaint();
            this.changes.firePropertyChange("LineThickness", oldValue, newValue);
        }
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    public Dimension getPreferredSize() {
        Dimension dim = this.size();
        Dimension min = this.getMinimumSize();
        return new Dimension(Math.max(dim.width, min.width), Math.max(dim.height, min.height));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public boolean contains(int x, int y) {
        double y2;
        double x2;
        double y1;
        double x1;
        if (!super.contains(x, y)) {
            return false;
        }
        if (this.lineThickness > 1) {
            return this.poly != null ? this.poly.contains(x, y) : false;
        }
        double i = 0.0;
        Dimension s = this.getSize();
        if (this.slopeType) {
            x1 = s.width;
            y1 = 0.0;
            x2 = 0.0;
            y2 = s.height;
        } else {
            x1 = s.width;
            y1 = s.height;
            x2 = 0.0;
            y2 = 0.0;
        }
        if (s.width > s.height) {
            double calc = Math.abs((y1 - y2) * ((double)x - x2) / (x1 - x2) + y2);
            return Math.abs((double)y - calc) < 0.7000000000000001;
        }
        double calc = Math.abs((x1 - x2) * ((double)y - y2) / (y1 - y2) + x2);
        return Math.abs((double)x - calc) < 0.7000000000000001;
    }

    public void paint(Graphics g) {
        int y2;
        int x2;
        int y1;
        int x1;
        boolean i = false;
        Dimension s = this.getSize();
        if (this.slopeType) {
            x1 = s.width;
            y1 = 0;
            x2 = 0;
            y2 = s.height;
        } else {
            x1 = s.width;
            y1 = s.height;
            x2 = 0;
            y2 = 0;
        }
        g.setColor(this.getForeground());
        if (this.lineThickness > 1) {
            int B2y;
            int A2x;
            int B1y;
            int A1x;
            double w = this.lineThickness / 2;
            double theta = 3.1416 - (1.5708 + Math.abs(Math.atan((double)(y1 - y2) / (double)(x1 - x2))));
            double a = Math.abs(w * Math.cos(theta));
            double b = Math.abs(w * Math.sin(theta));
            if (this.slopeType) {
                A1x = (int)((double)x1 - a - a);
                B1y = (int)((double)y1 + b + b);
                A2x = (int)((double)x2 + a + a);
                B2y = (int)((double)y2 - b - b);
            } else {
                A1x = (int)((double)x1 - a - a);
                B1y = (int)((double)y1 - b - b);
                A2x = (int)((double)x2 + a + a);
                B2y = (int)((double)y2 + b + b);
            }
            this.poly = new Polygon();
            this.poly.addPoint(A1x, y1);
            this.poly.addPoint(x1, B1y);
            this.poly.addPoint(A2x, y2);
            this.poly.addPoint(x2, B2y);
            g.fillPolygon(this.poly);
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }
}

