/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.RGBImageFilter;
import symantec.itools.util.GeneralUtils;

public class LightenFilter
extends RGBImageFilter {
    protected double percent;

    public LightenFilter() {
        this(0.5);
    }

    public LightenFilter(double percent) {
        this.canFilterIndexColorModel = true;
        try {
            this.setPercent(percent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("LightenFilter: Invalid parameter value passed to constructor:");
            System.err.println("     " + percent + " is not a valid percentage value. It should be <= 1 && >= 0");
            System.err.println("     Defaulting to 0.50.");
            try {
                this.setPercent(0.5);
            }
            catch (IllegalArgumentException illegalArgumentException2) {}
        }
    }

    public void setPercent(double percent) throws IllegalArgumentException {
        GeneralUtils.checkValidPercent(percent);
        this.percent = percent;
    }

    public double getPercent() {
        return this.percent;
    }

    public int filterRGB(int x, int y, int rgb) {
        DirectColorModel cm = (DirectColorModel)ColorModel.getRGBdefault();
        int alpha = cm.getAlpha(rgb);
        int red = cm.getRed(rgb);
        int green = cm.getGreen(rgb);
        int blue = cm.getBlue(rgb);
        red += (int)((double)(255 - red) * this.percent);
        green += (int)((double)(255 - green) * this.percent);
        blue += (int)((double)(255 - blue) * this.percent);
        return (alpha <<= 24) | (red <<= 16) | (green <<= 8) | blue;
    }
}

