/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Image;
import java.io.Serializable;
import symantec.itools.awt.TreeView;

public class TreeNode
implements Serializable {
    TreeNode sibling;
    TreeNode child;
    TreeNode parent;
    String text;
    transient Image collapsedImage;
    transient Image expandedImage;
    int numberOfChildren;
    Object dataObject;
    TreeView treeView;
    int depth = -1;
    boolean isExpanded = false;

    public TreeNode() {
    }

    public TreeNode(String text) {
        this(text, null, null, null);
    }

    public TreeNode(String text, Image collapsedImage, Image expandedImage) {
        this(text, collapsedImage, expandedImage, null);
    }

    public TreeNode(String text, TreeView treeView) {
        this(text, null, null, treeView);
    }

    public TreeNode(String text, Image collapsedImage, Image expandedImage, TreeView treeView) {
        this.text = text;
        this.sibling = null;
        this.child = null;
        this.collapsedImage = collapsedImage;
        this.expandedImage = expandedImage;
        this.numberOfChildren = 0;
        this.dataObject = null;
        this.treeView = treeView;
    }

    void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public boolean isExpandable() {
        return this.child != null;
    }

    public void expand() {
        if (this.isExpandable()) {
            this.isExpanded = true;
            if (this.treeView != null) {
                this.treeView.triggerRedraw();
            }
        }
    }

    public void collapse() {
        this.isExpanded = false;
        if (this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public void toggle() {
        if (this.isExpanded) {
            this.collapse();
        } else if (this.isExpandable()) {
            this.expand();
        }
    }

    public Image getImage() {
        return this.isExpanded && this.expandedImage != null ? this.expandedImage : this.collapsedImage;
    }

    public void setExpandedImage(Image image) {
        this.expandedImage = image;
        if (this.isExpanded() && this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public void setCollapsedImage(Image image) {
        this.collapsedImage = image;
        if (!this.isExpanded() && this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String s) {
        this.text = new String(s);
        if (this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object theObject) {
        this.dataObject = theObject;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChild() {
        return this.child;
    }

    public TreeNode getSibling() {
        return this.sibling;
    }
}

