/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import symantec.itools.awt.SliderTick;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public abstract class Slider
extends Canvas {
    public static final int TICK_LEFT = 0;
    public static final int TICK_RIGHT = 1;
    public static final int TICK_BOTTOM = 0;
    public static final int TICK_TOP = 1;
    public static final int TICK_BOTH = 2;
    public static final int TICK_NONE = 3;
    protected int width;
    protected int height = 50;
    protected Dimension cachedSize;
    protected boolean forceCallDoReshape = false;
    protected int style = 2;
    protected int freq = 1;
    protected int min = 1;
    protected int max = 10;
    protected int prevPos = 0;
    protected int curPos = 0;
    protected boolean showBorder = true;
    protected ActionListener actionListener;
    protected String actionCommand = "Slider Moved";
    protected transient SliderTick[] tick = null;
    protected static final int BORDER_X = 15;
    protected static final int BORDER_Y = 10;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    protected Slider() {
    }

    public void setTickStyle(int style) throws PropertyVetoException {
        if (this.style != style) {
            Integer oldValue = new Integer(this.style);
            Integer newValue = new Integer(style);
            this.vetos.fireVetoableChange("tickStyle", oldValue, newValue);
            this.style = style;
            this.changes.firePropertyChange("tickStyle", oldValue, newValue);
            this.forceCallDoReshape = true;
        }
    }

    public int getTickStyle() {
        return this.style;
    }

    public void setMinValue(int min) throws PropertyVetoException {
        if (this.min != min) {
            Integer oldValue = new Integer(this.min);
            Integer newValue = new Integer(min);
            this.vetos.fireVetoableChange("minValue", oldValue, newValue);
            this.min = min;
            this.changes.firePropertyChange("minValue", oldValue, newValue);
            this.forceCallDoReshape = true;
            this.repaint();
        }
    }

    public int getMinValue() {
        return this.min;
    }

    public void setMaxValue(int max) throws PropertyVetoException {
        if (this.max != max) {
            Integer oldValue = new Integer(this.max);
            Integer newValue = new Integer(max);
            this.vetos.fireVetoableChange("maxValue", oldValue, newValue);
            this.max = max;
            this.changes.firePropertyChange("maxValue", oldValue, newValue);
            this.forceCallDoReshape = true;
            this.repaint();
        }
    }

    public int getMaxValue() {
        return this.max;
    }

    public void setTickFreq(int freq) throws PropertyVetoException {
        if (this.freq != freq) {
            if (freq >= this.max) {
                freq = this.max - 1;
            }
            Integer oldValue = new Integer(this.freq);
            Integer newValue = new Integer(freq);
            this.vetos.fireVetoableChange("tickFreq", oldValue, newValue);
            int pos = this.curPos * this.freq + this.min;
            this.freq = freq;
            this.doMove((pos - this.min) / this.freq, false);
            this.changes.firePropertyChange("tickFreq", oldValue, newValue);
            this.forceCallDoReshape = true;
            this.repaint();
        }
    }

    public int getTickFreq() {
        return this.freq;
    }

    public void setValue(int pos) throws PropertyVetoException {
        Integer oldValue = new Integer(this.curPos * this.freq + this.min);
        Integer newValue = new Integer(pos);
        this.vetos.fireVetoableChange("value", oldValue, newValue);
        if (pos < this.getMinValue()) {
            pos = this.getMinValue();
        } else if (pos > this.getMaxValue()) {
            pos = this.getMaxValue();
        }
        this.doMove((pos - this.min) / this.freq, false);
        this.changes.firePropertyChange("value", oldValue, newValue);
        this.forceCallDoReshape = true;
        this.repaint();
    }

    public int getValue() {
        return this.curPos * this.freq + this.min;
    }

    public void setShowBorder(boolean f) throws PropertyVetoException {
        if (this.showBorder != f) {
            Boolean oldValue = new Boolean(this.showBorder);
            Boolean newValue = new Boolean(f);
            this.vetos.fireVetoableChange("showBorder", oldValue, newValue);
            this.showBorder = f;
            this.changes.firePropertyChange("showBorder", oldValue, newValue);
            this.repaint();
        }
    }

    public boolean getShowBorder() {
        return this.isShowBorder();
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setActionCommand(String command) throws PropertyVetoException {
        String oldValue = this.actionCommand;
        this.vetos.fireVetoableChange("actionCommand", oldValue, command);
        this.actionCommand = command;
        this.changes.firePropertyChange("actionCommand", oldValue, command);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected abstract void do_reshape(int var1, int var2);

    protected void doMove(int pos, boolean forcePost) {
        if (this.tick == null) {
            this.prevPos = this.curPos = pos;
            return;
        }
        if (pos >= this.tick.length) {
            pos = this.tick.length - 1;
        }
        if (pos != this.curPos || forcePost) {
            this.prevPos = this.curPos;
            this.curPos = pos;
            Graphics g = this.getGraphics();
            this.paint(g);
            if (g != null) {
                g.dispose();
            }
            g = null;
            this.sourceActionEvent();
        }
    }

    public void paint(Graphics g) {
        boolean callDoReshape = false;
        Dimension currentSize = this.getSize();
        if (!GeneralUtils.objectsEqual(this.cachedSize, currentSize)) {
            this.cachedSize = currentSize;
            this.width = this.cachedSize.width;
            this.height = this.cachedSize.height;
            callDoReshape = true;
        }
        if (this.forceCallDoReshape || callDoReshape) {
            this.do_reshape(this.width, this.height);
            this.forceCallDoReshape = false;
        }
    }

    protected void moveThumb(int i, boolean forcePost) {
        if (this.tick.length > 1) {
            int dist = this.tick[1].c - this.tick[0].c;
            if (dist == 0) {
                return;
            }
            int newPos = (i - this.tick[0].c) / dist;
            if (newPos < 0) {
                newPos = 0;
            }
            if ((i - this.tick[0].c) % dist > dist / 2) {
                ++newPos;
            }
            this.doMove(newPos, forcePost);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    protected void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }
}

